/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.evictor;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.EnvironmentStatsInternal;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.utilint.DaemonThread;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LevelOrderedINMap;
import com.sleepycat.je.utilint.Tracer;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Evictor
extends DaemonThread {
    private static final boolean DEBUG = false;
    private EnvironmentImpl envImpl;
    private Level detailedTraceLevel;
    private volatile boolean active;
    private IN nextNode;
    private long evictorMaxMem;
    private int nodeScanPercentage;
    private int evictionBatchPercentage;
    private long requiredEvictBytes;
    private INGenerationComparator inGenerationComparator = new INGenerationComparator();
    private NumberFormat formatter;
    private int nEvictPasses = 0;
    private long nNodesSelected = 0L;
    private long nNodesSelectedThisRun;
    private int nNodesScanned = 0;
    private int nNodesScannedThisRun;
    private long nNodesEvicted = 0L;
    private long nNodesEvictedThisRun;
    private long nBINsStripped = 0L;
    private long nBINsStrippedThisRun;
    private EvictProfile evictProfile;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sleepycat$je$evictor$Evictor;

    public Evictor(EnvironmentImpl envImpl, String name, int nodeScanPercentage, int evictionBatchPercentage) throws DatabaseException {
        super(0L, name, envImpl);
        this.envImpl = envImpl;
        this.nextNode = null;
        this.nodeScanPercentage = nodeScanPercentage;
        this.evictionBatchPercentage = evictionBatchPercentage;
        this.setName("Evictor Thread");
        this.detailedTraceLevel = Tracer.parseLevel(envImpl, EnvironmentParams.JE_LOGGING_LEVEL_EVICTOR);
        this.evictProfile = new EvictProfile();
        this.formatter = NumberFormat.getNumberInstance();
        this.active = false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<Evictor name=\"").append(this.name).append("\"/>");
        return sb.toString();
    }

    public void addToQueue(Object o) throws DatabaseException {
        throw new DatabaseException("Evictor.addToQueue should never be called.");
    }

    public void loadStats(StatsConfig config, EnvironmentStatsInternal stat) throws DatabaseException {
        stat.setNEvictPasses(this.nEvictPasses);
        stat.setNNodesSelected(this.nNodesSelected);
        stat.setNNodesScanned(this.nNodesScanned);
        stat.setNNodesExplicitlyEvicted(this.nNodesEvicted);
        stat.setNBINsStripped(this.nBINsStripped);
        if (config.getClear()) {
            this.nEvictPasses = 0;
            this.nNodesSelected = 0L;
            this.nNodesScanned = 0;
            this.nNodesEvicted = 0L;
            this.nBINsStripped = 0L;
        }
    }

    private void accumulateStats() {
        this.nNodesScanned += this.nNodesScannedThisRun;
        this.nNodesSelected += this.nNodesSelectedThisRun;
        this.nNodesEvicted += this.nNodesEvictedThisRun;
        this.nBINsStripped += this.nBINsStrippedThisRun;
    }

    public void clearEnv() {
        this.envImpl = null;
    }

    protected int nDeadlockRetries() throws DatabaseException {
        return this.envImpl.getConfigManager().getInt(EnvironmentParams.EVICTOR_RETRY);
    }

    public void alert() {
        if (!this.active) {
            this.wakeup();
        }
    }

    public synchronized void onWakeup() throws DatabaseException {
        if (this.envImpl.isClosed()) {
            return;
        }
        this.doEvict(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doEvict(boolean force) throws DatabaseException {
        this.active = true;
        if (!this.isRunnable(force)) {
            return;
        }
        INList inList = this.envImpl.getInMemoryINs();
        inList.latchMajor();
        this.nNodesSelectedThisRun = 0L;
        this.nNodesEvictedThisRun = 0L;
        this.nNodesScannedThisRun = 0;
        this.nBINsStrippedThisRun = 0L;
        ++this.nEvictPasses;
        int nBatchSets = 0;
        if (!$assertionsDisabled && !this.evictProfile.clear()) {
            throw new AssertionError();
        }
        boolean finished = false;
        int inListStartSize = inList.getSize();
        try {
            long evictBytes = 0L;
            int maxVisitedNodes = inListStartSize * 2;
            while (evictBytes < this.requiredEvictBytes && this.nNodesScannedThisRun <= inListStartSize) {
                SortedSet targetNodes = this.selectINSet(inList);
                if (targetNodes == null) break;
                evictBytes = this.evict(inList, targetNodes, evictBytes);
                if (!$assertionsDisabled && ++nBatchSets >= 1000) {
                    throw new AssertionError();
                }
            }
            finished = true;
        }
        finally {
            inList.releaseMajorLatch();
            this.accumulateStats();
            Tracer.trace(this.detailedTraceLevel, this.envImpl, "Evictor: pass=" + this.nEvictPasses + " finished=" + finished + " requiredEvictBytes=" + this.formatter.format(this.requiredEvictBytes) + " inListSize=" + inListStartSize + " nNodesScanned=" + this.nNodesScannedThisRun + " nNodesSelected=" + this.nNodesSelectedThisRun + " nEvicted=" + this.nNodesEvictedThisRun + " nLNStripped=" + this.nBINsStrippedThisRun + " nBatchSets=" + nBatchSets);
            this.active = false;
        }
        if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
            throw new AssertionError((Object)("latches held = " + Latch.countLatchesHeld()));
        }
    }

    boolean isRunnable(boolean force) throws DatabaseException {
        Logger logger;
        boolean doRun = false;
        MemoryBudget mb = this.envImpl.getMemoryBudget();
        long currentUsage = mb.getCacheMemoryUsage();
        long maxMem = mb.getTreeBudget();
        if (force) {
            doRun = true;
        } else {
            boolean bl = doRun = currentUsage - maxMem > 0L;
        }
        if (doRun) {
            int floor = this.envImpl.getConfigManager().getInt(EnvironmentParams.EVICTOR_USEMEM_FLOOR);
            long floorBytes = maxMem * (long)floor / 100L;
            this.requiredEvictBytes = currentUsage - floorBytes;
        }
        if ((logger = this.envImpl.getLogger()).isLoggable(this.detailedTraceLevel)) {
            Runtime r = Runtime.getRuntime();
            long totalBytes = r.totalMemory();
            long freeBytes = r.freeMemory();
            long usedBytes = r.totalMemory() - r.freeMemory();
            Tracer.trace(this.detailedTraceLevel, this.envImpl, " doRun=" + doRun + " JEusedBytes=" + this.formatter.format(currentUsage) + " requiredEvict=" + this.formatter.format(this.requiredEvictBytes) + " JVMtotalBytes= " + this.formatter.format(totalBytes) + " JVMfreeBytes= " + this.formatter.format(freeBytes) + " JVMusedBytes= " + this.formatter.format(usedBytes));
        }
        return doRun;
    }

    public SortedSet selectINSet(INList inList) throws DatabaseException {
        int inListTotalSize = inList.getSize();
        long batchNodes = inListTotalSize * this.nodeScanPercentage / 100;
        if (batchNodes == 0L) {
            batchNodes = 1L;
        }
        this.nNodesScannedThisRun = (int)((long)this.nNodesScannedThisRun + batchNodes);
        long nodesToEvict = batchNodes * (long)this.evictionBatchPercentage / 100L;
        if (nodesToEvict == 0L) {
            nodesToEvict = 1L;
        }
        if (this.nextNode == null && inListTotalSize > 0) {
            this.nextNode = inList.first();
        }
        if (this.nextNode == null) {
            return null;
        }
        TreeSet<IN> targetNodes = new TreeSet<IN>(this.inGenerationComparator);
        long currentMax = Long.MAX_VALUE;
        SortedSet tailSet = inList.tailSet(this.nextNode);
        Iterator iter = tailSet.iterator();
        int i = 0;
        while ((long)i < batchNodes) {
            if (iter.hasNext()) {
                IN in = (IN)iter.next();
                DatabaseImpl db = in.getDatabase();
                if (db == null || db.getIsDeleted()) {
                    iter.remove();
                } else if (!db.getId().equals(DbTree.ID_DB_ID) && in.isEvictable()) {
                    long inGen = in.getGeneration();
                    if ((long)targetNodes.size() < nodesToEvict) {
                        targetNodes.add(in);
                    } else {
                        currentMax = ((IN)targetNodes.last()).getGeneration();
                        if (inGen < currentMax) {
                            targetNodes.remove(targetNodes.last());
                            targetNodes.add(in);
                            currentMax = ((IN)targetNodes.last()).getGeneration();
                        }
                    }
                }
            } else {
                this.nextNode = inList.first();
                tailSet = inList.tailSet(this.nextNode);
                iter = tailSet.iterator();
            }
            ++i;
        }
        this.nextNode = iter.hasNext() ? (IN)iter.next() : inList.first();
        this.nNodesSelectedThisRun += (long)targetNodes.size();
        return targetNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long evict(INList inList, SortedSet targetNodes, long alreadyEvicted) throws DatabaseException {
        Iterator iter = targetNodes.iterator();
        long currentEvictBytes = alreadyEvicted;
        boolean envIsReadOnly = this.envImpl.isReadOnly();
        LevelOrderedINMap evictTargets = new LevelOrderedINMap();
        while (iter.hasNext() && currentEvictBytes < this.requiredEvictBytes) {
            IN target = (IN)iter.next();
            boolean addToTargetSet = true;
            if (target instanceof BIN) {
                Object var15_14;
                target.latch();
                try {
                    long evictBytes = ((BIN)target).evictLNs();
                    if (evictBytes > 0L) {
                        addToTargetSet = false;
                        ++this.nBINsStrippedThisRun;
                        currentEvictBytes += evictBytes;
                    }
                    var15_14 = null;
                }
                catch (Throwable throwable) {
                    var15_14 = null;
                    target.releaseLatch();
                    throw throwable;
                }
                target.releaseLatch();
                {
                }
            }
            if (!addToTargetSet) continue;
            evictTargets.putIN(target);
        }
        LogManager logManager = this.envImpl.getLogManager();
        while (evictTargets.size() > 0 && currentEvictBytes < this.requiredEvictBytes) {
            Integer currentLevel = (Integer)evictTargets.firstKey();
            Set inSet = (Set)evictTargets.remove(currentLevel);
            iter = inSet.iterator();
            while (iter.hasNext() && currentEvictBytes < this.requiredEvictBytes) {
                Object var17_18;
                IN child = (IN)iter.next();
                child.latch();
                try {
                    if (child.isEvictable()) {
                        Tree tree = child.getDatabase().getTree();
                        SearchResult result = tree.getParentINForChildIN(child, true);
                        if (result.exactParentFound) {
                            currentEvictBytes += this.evictIN(child, result.parent, inList, targetNodes, logManager, envIsReadOnly);
                        }
                    } else {
                        child.releaseLatch();
                    }
                    var17_18 = null;
                    if (!child.getLatch().isOwner()) continue;
                }
                catch (Throwable throwable) {
                    var17_18 = null;
                    if (child.getLatch().isOwner()) {
                        child.releaseLatch();
                    }
                    throw throwable;
                }
                child.releaseLatch();
                {
                }
            }
        }
        return currentEvictBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long evictIN(IN child, IN parent, INList inlist, SortedSet targetNodes, LogManager logManager, boolean envIsReadOnly) throws DatabaseException {
        long evictBytes = 0L;
        try {
            IN renewedChild;
            if (!$assertionsDisabled && !parent.getLatch().isOwner()) {
                throw new AssertionError();
            }
            Key childKey = parent.getChildKey(child);
            int index = parent.findEntry(childKey, false, true);
            long oldGenerationCount = child.getGeneration();
            if (index >= 0 && (renewedChild = (IN)parent.getEntry(index).getTarget()) != null && renewedChild.getGeneration() <= oldGenerationCount) {
                renewedChild.latch();
                try {
                    if (renewedChild.isEvictable()) {
                        DbLsn renewedChildLsn = null;
                        if (renewedChild.getDirty()) {
                            if (!envIsReadOnly) {
                                renewedChildLsn = renewedChild.log(logManager);
                            }
                        } else {
                            renewedChildLsn = parent.getEntry(index).getLsn();
                        }
                        if (renewedChildLsn != null) {
                            inlist.removeLatchAlreadyHeld(renewedChild);
                            targetNodes.remove(renewedChild);
                            evictBytes = renewedChild.getInMemorySize();
                            parent.updateEntry(index, null, renewedChildLsn);
                            ++this.nNodesEvictedThisRun;
                            if (!$assertionsDisabled && !this.evictProfile.count(renewedChild)) {
                                throw new AssertionError();
                            }
                        }
                    }
                    Object var16_13 = null;
                }
                catch (Throwable throwable) {
                    Object var16_14 = null;
                    renewedChild.releaseLatch();
                    throw throwable;
                }
                renewedChild.releaseLatch();
                {
                }
            }
            Object var18_16 = null;
        }
        catch (Throwable throwable) {
            Object var18_17 = null;
            parent.releaseLatch();
            throw throwable;
        }
        parent.releaseLatch();
        return evictBytes;
    }

    private void dumpSortedSet(SortedSet ins) {
        if (ins != null) {
            Iterator iter = ins.iterator();
            while (iter.hasNext()) {
                IN theIN = (IN)iter.next();
                System.out.print(" " + theIN.shortClassName() + " " + theIN.getLevel() + "/" + theIN.getDatabase().getId() + "/" + theIN.getNodeId() + "/" + theIN.getGeneration());
            }
            System.out.println("");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sleepycat$je$evictor$Evictor == null ? (class$com$sleepycat$je$evictor$Evictor = Evictor.class$("com.sleepycat.je.evictor.Evictor")) : class$com$sleepycat$je$evictor$Evictor).desiredAssertionStatus();
    }

    public static class EvictProfile {
        private HashMap evictCounts = new HashMap();
        private int nEvictedBINs = 0;

        boolean count(IN target) {
            Long key;
            Integer count;
            if (target instanceof BIN) {
                ++this.nEvictedBINs;
            }
            if ((count = (Integer)this.evictCounts.get(key = new Long(target.getNodeId()))) == null) {
                this.evictCounts.put(key, new Integer(1));
            } else {
                this.evictCounts.put(key, new Integer(1 + count));
            }
            return true;
        }

        boolean dump(StringBuffer sb) {
            Iterator iter = this.evictCounts.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Long nodeId = (Long)entry.getKey();
                Integer count = (Integer)entry.getValue();
                sb.append(" nid=").append(nodeId).append(" / ").append(count);
            }
            sb.append("nEvictedBIN=").append(this.nEvictedBINs);
            return true;
        }

        public boolean clear() {
            this.evictCounts.clear();
            this.nEvictedBINs = 0;
            return true;
        }

        public int getNEvictedBINs() {
            return this.nEvictedBINs;
        }
    }

    private static class INGenerationComparator
    implements Comparator {
        private INGenerationComparator() {
        }

        public int compare(Object o1, Object o2) {
            long gen2;
            if (!(o1 instanceof IN) || !(o1 instanceof IN)) {
                throw new IllegalArgumentException("INGenerationComparator.compare received non-IN arg.");
            }
            long gen1 = ((IN)o1).getGeneration();
            if (gen1 < (gen2 = ((IN)o2).getGeneration())) {
                return -1;
            }
            if (gen1 > gen2) {
                return 1;
            }
            return 0;
        }
    }
}

