/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.TruncateResult;
import com.sleepycat.je.incomp.INCompressor;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.NameLN;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.AutoTxn;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DbLsn;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class DbTree
implements LoggableObject,
LogReadable {
    public static final DatabaseId ID_DB_ID;
    public static final DatabaseId NAME_DB_ID;
    public static final String ID_DB_NAME = "_jeIdMap";
    public static final String NAME_DB_NAME = "_jeNameMap";
    public static final String UTILIZATION_DB_NAME = "_jeUtilization";
    private static final String[] RESERVED_DB_NAMES;
    private int lastAllocatedDbId;
    private DatabaseImpl idDatabase;
    private DatabaseImpl nameDatabase;
    private EnvironmentImpl envImpl;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sleepycat$je$dbi$DbTree;

    public DbTree() throws DatabaseException {
        this.envImpl = null;
        this.idDatabase = new DatabaseImpl();
        this.nameDatabase = new DatabaseImpl();
    }

    public DbTree(EnvironmentImpl env) throws DatabaseException {
        this.envImpl = env;
        this.idDatabase = new DatabaseImpl(ID_DB_NAME, new DatabaseId(0), env, new DatabaseConfig());
        this.nameDatabase = new DatabaseImpl(NAME_DB_NAME, new DatabaseId(1), env, new DatabaseConfig());
        this.lastAllocatedDbId = 1;
    }

    public synchronized int getLastDbId() {
        return this.lastAllocatedDbId;
    }

    private synchronized int getNextDbId() {
        return ++this.lastAllocatedDbId;
    }

    public synchronized void setLastDbId(int maxDbId) {
        this.lastAllocatedDbId = maxDbId;
    }

    void setEnvironmentImpl(EnvironmentImpl envImpl) throws DatabaseException {
        this.envImpl = envImpl;
        this.idDatabase.setEnvironmentImpl(envImpl);
        this.nameDatabase.setEnvironmentImpl(envImpl);
    }

    public synchronized DatabaseImpl createDb(Locker locker, String databaseName, DatabaseConfig dbConfig, Database databaseHandle) throws DatabaseException {
        DatabaseId newId = new DatabaseId(this.getNextDbId());
        DatabaseImpl newDb = new DatabaseImpl(databaseName, newId, this.envImpl, dbConfig);
        CursorImpl idCursor = null;
        CursorImpl nameCursor = null;
        boolean operationOk = false;
        Locker autoTxn = null;
        try {
            nameCursor = new CursorImpl(this.nameDatabase, locker);
            NameLN nameLN = new NameLN(newId);
            nameCursor.putLN(new Key(databaseName.getBytes("UTF-8")), nameLN, false);
            if (databaseHandle != null) {
                locker.addToHandleMaps(new Long(nameLN.getNodeId()), databaseHandle);
            }
            autoTxn = new AutoTxn(this.envImpl, new TransactionConfig());
            idCursor = new CursorImpl(this.idDatabase, autoTxn);
            idCursor.putLN(new Key(newId.getBytes()), new MapLN(newDb), false);
            operationOk = true;
        }
        catch (UnsupportedEncodingException UEE) {
            throw new DatabaseException(UEE);
        }
        finally {
            if (idCursor != null) {
                idCursor.close();
            }
            if (nameCursor != null) {
                nameCursor.close();
            }
            if (autoTxn != null) {
                autoTxn.operationEnd(operationOk);
            }
        }
        return newDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyDbRoot(DatabaseImpl db) throws DatabaseException {
        if (db.getId().equals(ID_DB_ID) || db.getId().equals(NAME_DB_ID)) {
            this.envImpl.logMapTreeRoot();
        } else {
            boolean operationOk;
            AutoTxn locker;
            block8: {
                locker = new AutoTxn(this.envImpl, new TransactionConfig());
                CursorImpl cursor = new CursorImpl(this.idDatabase, locker);
                operationOk = false;
                try {
                    DatabaseEntry keyDbt = new DatabaseEntry(db.getId().getBytes());
                    MapLN mapLN = null;
                    try {
                        boolean searchOk;
                        boolean bl = searchOk = (cursor.searchAndPosition(keyDbt, new DatabaseEntry(), CursorImpl.SearchMode.SET, LockMode.RMW) & 1) != 0;
                        if (!$assertionsDisabled && !searchOk) {
                            throw new AssertionError((Object)("can't find database " + db.getId()));
                        }
                        mapLN = (MapLN)cursor.getCurrentLNAlreadyLatched(LockMode.DEFAULT);
                        Object var9_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        cursor.releaseBINs();
                        throw throwable;
                    }
                    cursor.releaseBINs();
                    RewriteMapLN writeMapLN = new RewriteMapLN(cursor);
                    mapLN.getDatabase().getTree().withRootLatched(writeMapLN);
                    operationOk = true;
                    Object var11_12 = null;
                    if (cursor == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    if (cursor != null) {
                        cursor.close();
                    }
                    ((Locker)locker).operationEnd(operationOk);
                    throw throwable;
                }
                cursor.close();
            }
            ((Locker)locker).operationEnd(operationOk);
            {
            }
        }
    }

    boolean dbRename(Locker locker, String databaseName, String newName) throws DatabaseException {
        boolean bl;
        CursorImpl nameCursor;
        DatabaseImpl db;
        block7: {
            boolean found;
            db = this.getDb(locker, databaseName, null);
            if (db == null) {
                throw new DatabaseNotFoundException("Attempted to rename non-existent database " + databaseName);
            }
            nameCursor = new CursorImpl(this.nameDatabase, locker);
            DatabaseEntry keyDbt = new DatabaseEntry(databaseName.getBytes("UTF-8"));
            boolean bl2 = found = (nameCursor.searchAndPosition(keyDbt, null, CursorImpl.SearchMode.SET, null) & 1) != 0;
            if (found) break block7;
            boolean bl3 = false;
            Object var11_11 = null;
            nameCursor.releaseBIN();
            nameCursor.close();
            return bl3;
        }
        try {
            nameCursor.getCurrentLNAlreadyLatched(LockMode.RMW);
            int handleCount = db.getReferringHandleCount();
            if (handleCount > 0) {
                throw new DatabaseException("Can't rename database " + databaseName + "," + handleCount + " open Dbs exist");
            }
            nameCursor.delete();
            nameCursor.putLN(new Key(newName.getBytes("UTF-8")), new NameLN(db.getId()), false);
            bl = true;
            Object var11_12 = null;
        }
        catch (UnsupportedEncodingException UEE) {
            try {
                throw new DatabaseException(UEE);
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                nameCursor.releaseBIN();
                nameCursor.close();
                throw throwable;
            }
        }
        nameCursor.releaseBIN();
        nameCursor.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dbRemove(Locker locker, String databaseName) throws DatabaseException {
        CursorImpl nameCursor;
        block9: {
            block8: {
                DatabaseImpl db = this.getDb(locker, databaseName, null);
                if (db == null) {
                    throw new DatabaseNotFoundException("Attempted to remove non-existent database " + databaseName);
                }
                nameCursor = new CursorImpl(this.nameDatabase, locker);
                try {
                    try {
                        boolean found;
                        DatabaseEntry keyDbt = new DatabaseEntry(databaseName.getBytes("UTF-8"));
                        boolean bl = found = (nameCursor.searchAndPosition(keyDbt, null, CursorImpl.SearchMode.SET, null) & 1) != 0;
                        if (!found) {
                            Object var9_8 = null;
                            break block8;
                        }
                        nameCursor.getCurrentLNAlreadyLatched(LockMode.RMW);
                        int handleCount = db.getReferringHandleCount();
                        if (handleCount > 0) {
                            throw new DatabaseException("Can't remove database " + databaseName + "," + handleCount + " open Dbs exist");
                        }
                        nameCursor.delete();
                        db.recordObsoleteNodes();
                        locker.setIsDeletedAtCommit(db);
                        break block9;
                    }
                    catch (UnsupportedEncodingException UEE) {
                        throw new DatabaseException(UEE);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    nameCursor.releaseBIN();
                    nameCursor.close();
                    throw throwable;
                }
            }
            nameCursor.releaseBIN();
            nameCursor.close();
            return;
        }
        Object var9_9 = null;
        nameCursor.releaseBIN();
        nameCursor.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    TruncateResult truncate(Locker locker, DatabaseImpl oldDatabase) throws DatabaseException {
        TruncateResult truncateResult;
        CursorImpl nameCursor = new CursorImpl(this.nameDatabase, locker);
        try {
            try {
                boolean found;
                String databaseName = this.getDbName(oldDatabase.getId());
                DatabaseEntry keyDbt = new DatabaseEntry(databaseName.getBytes("UTF-8"));
                boolean bl = found = (nameCursor.searchAndPosition(keyDbt, null, CursorImpl.SearchMode.SET, null) & 1) != 0;
                if (!found) {
                    throw new DatabaseException("Database " + databaseName + " not found in map tree");
                }
                NameLN nameLN = (NameLN)nameCursor.getCurrentLNAlreadyLatched(LockMode.RMW);
                int handleCount = oldDatabase.getReferringHandleCount();
                if (handleCount > 1) {
                    throw new DatabaseException("Can't truncate database " + databaseName + "," + handleCount + " open databases exist");
                }
                DatabaseId newId = new DatabaseId(this.getNextDbId());
                DatabaseImpl newDb = (DatabaseImpl)oldDatabase.clone();
                newDb.setId(newId);
                newDb.setTree(new Tree(newDb));
                CursorImpl idCursor = null;
                try {
                    idCursor = new CursorImpl(this.idDatabase, locker);
                    idCursor.putLN(new Key(newId.getBytes()), new MapLN(newDb), false);
                    Object var13_14 = null;
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    idCursor.close();
                    throw throwable;
                }
                idCursor.close();
                nameLN.setId(newDb.getId());
                int recordCount = oldDatabase.recordObsoleteNodes();
                locker.setIsDeletedAtCommit(oldDatabase);
                DatabaseEntry dataDbt = new DatabaseEntry(new byte[0]);
                nameCursor.putCurrent(dataDbt, null, null);
                truncateResult = new TruncateResult(newDb, recordCount);
                Object var16_19 = null;
            }
            catch (CloneNotSupportedException CNSE) {
                throw new DatabaseException(CNSE);
            }
            catch (UnsupportedEncodingException UEE) {
                throw new DatabaseException(UEE);
            }
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            nameCursor.releaseBIN();
            nameCursor.close();
            throw throwable;
        }
        nameCursor.releaseBIN();
        nameCursor.close();
        return truncateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatabaseImpl getDb(Locker nameLocker, String databaseName, Database databaseHandle) throws DatabaseException {
        DatabaseImpl databaseImpl;
        BasicLocker locker;
        block12: {
            block11: {
                locker = null;
                try {
                    try {
                        DatabaseId id;
                        block10: {
                            CursorImpl nameCursor = null;
                            id = null;
                            try {
                                boolean found;
                                nameCursor = new CursorImpl(this.nameDatabase, nameLocker, true, null);
                                DatabaseEntry keyDbt = new DatabaseEntry(databaseName.getBytes("UTF-8"));
                                boolean bl = found = (nameCursor.searchAndPosition(keyDbt, null, CursorImpl.SearchMode.SET, null) & 1) != 0;
                                if (found) {
                                    NameLN nameLN = (NameLN)nameCursor.getCurrentLNAlreadyLatched(LockMode.DEFAULT);
                                    id = nameLN.getId();
                                    if (databaseHandle != null) {
                                        nameLocker.addToHandleMaps(new Long(nameLN.getNodeId()), databaseHandle);
                                    }
                                }
                                Object var11_11 = null;
                                if (nameCursor == null) break block10;
                            }
                            catch (Throwable throwable) {
                                Object var11_12 = null;
                                if (nameCursor == null) throw throwable;
                                nameCursor.releaseBIN();
                                nameCursor.close();
                                throw throwable;
                            }
                            nameCursor.releaseBIN();
                            nameCursor.close();
                        }
                        locker = new BasicLocker(this.envImpl);
                        if (id == null) {
                            databaseImpl = null;
                            Object var13_14 = null;
                            if (locker == null) return databaseImpl;
                            break block11;
                        }
                        databaseImpl = this.getDb(locker, id);
                        break block12;
                    }
                    catch (UnsupportedEncodingException UEE) {
                        throw new DatabaseException(UEE);
                    }
                }
                catch (Throwable throwable) {
                    Object var13_16 = null;
                    if (locker == null) throw throwable;
                    locker.operationEnd();
                    throw throwable;
                }
            }
            locker.operationEnd();
            return databaseImpl;
        }
        Object var13_15 = null;
        if (locker == null) return databaseImpl;
        locker.operationEnd();
        return databaseImpl;
    }

    public DatabaseImpl getDb(DatabaseId dbId) throws DatabaseException {
        return this.getDb(dbId, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseImpl getDb(DatabaseId dbId, long lockTimeout) throws DatabaseException {
        DatabaseImpl databaseImpl;
        block3: {
            BasicLocker locker = null;
            try {
                locker = new BasicLocker(this.envImpl);
                if (lockTimeout >= 0L) {
                    locker.setLockTimeout(lockTimeout);
                }
                databaseImpl = this.getDb(locker, dbId);
                Object var7_5 = null;
                if (locker == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var7_6 = null;
                    if (locker == null) break block4;
                    locker.operationEnd();
                }
                throw throwable;
            }
            locker.operationEnd();
        }
        return databaseImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseImpl getDb(Locker locker, DatabaseId dbId) throws DatabaseException {
        CursorImpl idCursor;
        block5: {
            DatabaseImpl databaseImpl;
            if (dbId.equals(this.idDatabase.getId())) {
                return this.idDatabase;
            }
            if (dbId.equals(this.nameDatabase.getId())) {
                return this.nameDatabase;
            }
            idCursor = null;
            try {
                boolean found;
                idCursor = new CursorImpl(this.idDatabase, locker);
                DatabaseEntry keyDbt = new DatabaseEntry(dbId.getBytes());
                boolean bl = found = (idCursor.searchAndPosition(keyDbt, new DatabaseEntry(), CursorImpl.SearchMode.SET, null) & 1) != 0;
                if (!found) break block5;
                MapLN mapLN = (MapLN)idCursor.getCurrentLNAlreadyLatched(LockMode.DEFAULT);
                databaseImpl = mapLN.getDatabase();
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                idCursor.releaseBIN();
                idCursor.close();
                throw throwable;
            }
            idCursor.releaseBIN();
            idCursor.close();
            return databaseImpl;
        }
        DatabaseImpl databaseImpl = null;
        Object var9_10 = null;
        idCursor.releaseBIN();
        idCursor.close();
        return databaseImpl;
    }

    public void rebuildINListMapDb() throws DatabaseException {
        this.idDatabase.getTree().rebuildINList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(VerifyConfig config, PrintStream out) throws DatabaseException {
        boolean ret = true;
        if (!this.idDatabase.verify(config, out)) {
            ret = false;
        }
        if (!this.nameDatabase.verify(config, out)) {
            ret = false;
        }
        INCompressor iNCompressor = this.envImpl.getINCompressor();
        synchronized (iNCompressor) {
            BasicLocker locker = null;
            CursorImpl cursor = null;
            try {
                locker = new BasicLocker(this.envImpl);
                cursor = new CursorImpl(this.idDatabase, locker);
                cursor.positionFirstOrLast(true, null);
                MapLN mapLN = (MapLN)cursor.getCurrentLNAlreadyLatched(LockMode.DEFAULT);
                DatabaseEntry keyDbt = new DatabaseEntry();
                DatabaseEntry dataDbt = new DatabaseEntry();
                while (mapLN != null) {
                    OperationStatus status;
                    if (!mapLN.getDatabase().verify(config, out)) {
                        ret = false;
                    }
                    if ((status = cursor.getNext(keyDbt, dataDbt, LockMode.DEFAULT, true, false)) != OperationStatus.SUCCESS) {
                        break;
                    }
                    mapLN = (MapLN)cursor.getCurrentLN();
                }
            }
            catch (DatabaseException e) {
                out.println("Verification error" + e.getMessage());
                ret = false;
            }
            finally {
                if (cursor != null) {
                    cursor.releaseBINs();
                    cursor.close();
                }
                if (locker != null) {
                    ((Locker)locker).operationEnd();
                }
            }
        }
        return ret;
    }

    public String getDbName(DatabaseId id) throws DatabaseException {
        if (id.equals(ID_DB_ID)) {
            return ID_DB_NAME;
        }
        if (id.equals(NAME_DB_ID)) {
            return NAME_DB_NAME;
        }
        BasicLocker locker = null;
        CursorImpl cursor = null;
        try {
            locker = new BasicLocker(this.envImpl);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setDirtyRead(true);
            cursor = new CursorImpl(this.nameDatabase, locker, true, cursorConfig);
            DatabaseEntry keyDbt = new DatabaseEntry();
            DatabaseEntry dataDbt = new DatabaseEntry();
            String name = null;
            if (cursor.positionFirstOrLast(true, null)) {
                OperationStatus status;
                cursor.getCurrentAlreadyLatched(keyDbt, dataDbt, LockMode.DEFAULT, true);
                do {
                    NameLN nameLN;
                    if (!(nameLN = (NameLN)cursor.getCurrentLN()).getId().equals(id)) continue;
                    name = new String(keyDbt.getData(), "UTF-8");
                    break;
                } while ((status = cursor.getNext(keyDbt, dataDbt, LockMode.DEFAULT, true, false)) == OperationStatus.SUCCESS);
            }
            String string = name;
            return string;
        }
        catch (UnsupportedEncodingException UEE) {
            throw new DatabaseException(UEE);
        }
        finally {
            if (cursor != null) {
                cursor.releaseBINs();
                cursor.close();
            }
            if (locker != null) {
                ((Locker)locker).operationEnd();
            }
        }
    }

    public List getDbNames() throws DatabaseException {
        ArrayList<String> nameList = new ArrayList<String>();
        BasicLocker locker = null;
        CursorImpl cursor = null;
        try {
            locker = new BasicLocker(this.envImpl);
            cursor = new CursorImpl(this.nameDatabase, locker);
            DatabaseEntry keyDbt = new DatabaseEntry();
            DatabaseEntry dataDbt = new DatabaseEntry();
            if (cursor.positionFirstOrLast(true, null)) {
                OperationStatus status;
                cursor.getCurrentAlreadyLatched(keyDbt, dataDbt, LockMode.DEFAULT, true);
                do {
                    String name;
                    if (this.isReservedDbName(name = new String(keyDbt.getData(), "UTF-8"))) continue;
                    nameList.add(name);
                } while ((status = cursor.getNext(keyDbt, dataDbt, LockMode.DEFAULT, true, false)) == OperationStatus.SUCCESS);
            }
            ArrayList<String> arrayList = nameList;
            return arrayList;
        }
        catch (UnsupportedEncodingException UEE) {
            throw new DatabaseException(UEE);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (locker != null) {
                ((Locker)locker).operationEnd();
            }
        }
    }

    public boolean isReservedDbName(String name) {
        int i = 0;
        while (i < RESERVED_DB_NAMES.length) {
            if (RESERVED_DB_NAMES[i].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getHighestLevel() throws DatabaseException {
        RootLevel getLevel = new RootLevel(this.idDatabase);
        this.idDatabase.getTree().withRootLatched(getLevel);
        int idHighLevel = getLevel.getRootLevel();
        getLevel = new RootLevel(this.nameDatabase);
        this.nameDatabase.getTree().withRootLatched(getLevel);
        int nameHighLevel = getLevel.getRootLevel();
        return nameHighLevel > idHighLevel ? nameHighLevel : idHighLevel;
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_ROOT;
    }

    public boolean marshallOutsideWriteLatch() {
        return true;
    }

    public int getLogSize() {
        return LogUtils.getIntLogSize() + this.idDatabase.getLogSize() + this.nameDatabase.getLogSize();
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeInt(logBuffer, this.lastAllocatedDbId);
        this.idDatabase.writeToLog(logBuffer);
        this.nameDatabase.writeToLog(logBuffer);
    }

    public void postLogWork(DbLsn justLoggedLsn) throws DatabaseException {
    }

    public void readFromLog(ByteBuffer itemBuffer) throws LogException {
        this.lastAllocatedDbId = LogUtils.readInt(itemBuffer);
        this.idDatabase.readFromLog(itemBuffer);
        this.nameDatabase.readFromLog(itemBuffer);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<dbtree lastId = \"");
        sb.append(this.lastAllocatedDbId);
        sb.append("\">");
        sb.append("<idDb>");
        this.idDatabase.dumpLog(sb, verbose);
        sb.append("</idDb><nameDb>");
        this.nameDatabase.dumpLog(sb, verbose);
        sb.append("</nameDb>");
        sb.append("</dbtree>");
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }

    String dumpString(int nSpaces) {
        StringBuffer self = new StringBuffer();
        self.append(TreeUtils.indent(nSpaces));
        self.append("<dbTree lastDbId =\"");
        self.append(this.lastAllocatedDbId);
        self.append("\">");
        self.append('\n');
        self.append(this.idDatabase.dumpString(nSpaces + 1));
        self.append('\n');
        self.append(this.nameDatabase.dumpString(nSpaces + 1));
        self.append('\n');
        self.append("</dbtree>");
        return self.toString();
    }

    public String toString() {
        return this.dumpString(0);
    }

    public void dump() throws DatabaseException {
        this.idDatabase.getTree().dump();
        this.nameDatabase.getTree().dump();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sleepycat$je$dbi$DbTree == null ? (class$com$sleepycat$je$dbi$DbTree = DbTree.class$("com.sleepycat.je.dbi.DbTree")) : class$com$sleepycat$je$dbi$DbTree).desiredAssertionStatus();
        ID_DB_ID = new DatabaseId(0);
        NAME_DB_ID = new DatabaseId(1);
        RESERVED_DB_NAMES = new String[]{ID_DB_NAME, NAME_DB_NAME, UTILIZATION_DB_NAME};
    }

    private class RootLevel
    implements WithRootLatched {
        private DatabaseImpl db;
        private int rootLevel;

        RootLevel(DatabaseImpl db) {
            this.db = db;
            this.rootLevel = 0;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            IN rootIN = (IN)root.fetchTarget(this.db, null);
            this.rootLevel = rootIN.getLevel();
            return null;
        }

        int getRootLevel() {
            return this.rootLevel;
        }
    }

    private class RewriteMapLN
    implements WithRootLatched {
        private CursorImpl cursor;

        RewriteMapLN(CursorImpl cursor) {
            this.cursor = cursor;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            DatabaseEntry dataDbt = new DatabaseEntry(new byte[0]);
            this.cursor.putCurrent(dataDbt, null, null);
            return null;
        }
    }
}

