/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseStats;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LogWritable;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeInfo;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.txn.ThreadLocker;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.Tracer;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public class DatabaseImpl
implements LogWritable,
LogReadable,
Cloneable {
    private DatabaseId id;
    private Tree tree;
    private EnvironmentImpl envImpl;
    private boolean duplicatesAllowed;
    private boolean transactional;
    private Set referringHandles;
    private boolean isDeleted;
    private TrackedFileSummary[] deletedTrackingInfo;
    private DatabaseStats stats;
    private Comparator btreeComparator = null;
    private Comparator duplicateComparator = null;
    private int binDeltaPercent;
    private int binMaxDeltas;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sleepycat$je$dbi$DatabaseImpl;

    public DatabaseImpl(String dbName, DatabaseId id, EnvironmentImpl envImpl, DatabaseConfig dbConfig) throws DatabaseException {
        this.id = id;
        this.envImpl = envImpl;
        this.btreeComparator = dbConfig.getBtreeComparator();
        this.duplicateComparator = dbConfig.getDuplicateComparator();
        this.duplicatesAllowed = dbConfig.getSortedDuplicates();
        this.transactional = dbConfig.getTransactional();
        this.isDeleted = false;
        this.tree = new Tree(this);
        this.referringHandles = Collections.synchronizedSet(new HashSet());
        DbConfigManager configMgr = envImpl.getConfigManager();
        this.binDeltaPercent = configMgr.getInt(EnvironmentParams.BIN_DELTA_PERCENT);
        this.binMaxDeltas = configMgr.getInt(EnvironmentParams.BIN_MAX_DELTAS);
    }

    public DatabaseImpl() throws DatabaseException {
        this.id = new DatabaseId();
        this.envImpl = null;
        this.isDeleted = false;
        this.tree = new Tree();
        this.referringHandles = Collections.synchronizedSet(new HashSet());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Tree getTree() {
        return this.tree;
    }

    void setTree(Tree tree) {
        this.tree = tree;
    }

    public DatabaseId getId() {
        return this.id;
    }

    void setId(DatabaseId id) {
        this.id = id;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public boolean getSortedDuplicates() {
        return this.duplicatesAllowed;
    }

    public void setDuplicateComparator(Comparator duplicateComparator) {
        this.duplicateComparator = duplicateComparator;
    }

    public void setBtreeComparator(Comparator btreeComparator) {
        this.btreeComparator = btreeComparator;
    }

    public Comparator getBtreeComparator() {
        return this.btreeComparator;
    }

    public Comparator getDuplicateComparator() {
        return this.duplicateComparator;
    }

    public void setEnvironmentImpl(EnvironmentImpl envImpl) throws DatabaseException {
        this.envImpl = envImpl;
        this.binDeltaPercent = envImpl.getConfigManager().getInt(EnvironmentParams.BIN_DELTA_PERCENT);
        this.binMaxDeltas = envImpl.getConfigManager().getInt(EnvironmentParams.BIN_MAX_DELTAS);
        this.tree.setDatabase(this);
    }

    public EnvironmentImpl getDbEnvironment() {
        return this.envImpl;
    }

    public boolean hasOpenHandles() {
        return this.referringHandles.size() > 0;
    }

    public void addReferringHandle(Database db) {
        this.referringHandles.add(db);
    }

    public void removeReferringHandle(Database db) {
        this.referringHandles.remove(db);
    }

    synchronized int getReferringHandleCount() {
        return this.referringHandles.size();
    }

    public String getName() throws DatabaseException {
        return this.envImpl.getDbMapTree().getDbName(this.id);
    }

    public boolean getIsDeleted() {
        return this.isDeleted;
    }

    public void deleteAndReleaseINs() throws DatabaseException {
        this.isDeleted = true;
        this.envImpl.getInMemoryINs().clearDb(this);
        this.envImpl.getLogManager().countObsoleteNodes(this.deletedTrackingInfo);
        this.deletedTrackingInfo = null;
    }

    public void checkIsDeleted(String operation) throws DatabaseException {
        if (this.isDeleted) {
            throw new DatabaseException("Attempt to " + operation + " a deleted database");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int recordObsoleteNodes() throws DatabaseException {
        int count;
        UtilizationTracker tracker;
        block5: {
            tracker = new UtilizationTracker(this.envImpl);
            ThreadLocker locker = new ThreadLocker(this.envImpl);
            Cursor cursor = null;
            count = 0;
            try {
                cursor = DbInternal.newCursor(this, locker, null);
                DatabaseEntry foundData = new DatabaseEntry();
                DatabaseEntry key = new DatabaseEntry();
                OperationStatus status = DbInternal.position(cursor, key, foundData, LockMode.DIRTY_READ, true);
                while (true) {
                    if (status != OperationStatus.SUCCESS) {
                        Object var11_10 = null;
                        if (cursor == null) break block5;
                        break;
                    }
                    ++count;
                    CursorImpl impl = DbInternal.getCursorImpl(cursor);
                    DbLsn lsn = impl.getBIN().getEntry(impl.getIndex()).getLsn();
                    tracker.countObsoleteNode(lsn, null, true);
                    status = DbInternal.retrieveNext(cursor, key, foundData, LockMode.DIRTY_READ, GetMode.NEXT);
                }
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (cursor != null) {
                    cursor.close();
                }
                throw throwable;
            }
            cursor.close();
        }
        this.deletedTrackingInfo = tracker.getTrackedFiles();
        return count;
    }

    public DatabaseStats stat(StatsConfig config) throws DatabaseException {
        if (!config.getFast()) {
            this.stats = new DatabaseStats();
            if (this.tree == null) {
                return this.stats;
            }
            TreeInfo info = this.tree.verify(new VerifyConfig());
            this.stats.setInCount(info.getINCount());
            this.stats.setLnCount(info.getLNCount());
            this.stats.setBinCount(info.getBINCount());
            this.stats.setDeletedLNCount(info.getDeletedLNCount());
            this.stats.setDupCountLNCount(info.getDupCountLNCount());
            this.stats.setMaxDepth(info.getMaxDepth());
        }
        if (this.stats == null) {
            this.stats = new DatabaseStats();
        }
        return this.stats;
    }

    public void preload(long maxBytes) throws DatabaseException {
        IN next = this.tree.getFirstNode();
        if (next == null) {
            return;
        }
        next.releaseLatch();
        if (maxBytes == 0L) {
            maxBytes = this.envImpl.getMemoryBudget().getTreeBudget();
        }
        while (next != null) {
            if ((next = this.tree.getNextBin((BIN)next, null)) == null) break;
            next.releaseLatch();
            if (this.envImpl.getMemoryBudget().getCacheMemoryUsage() > maxBytes) break;
        }
        if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
            throw new AssertionError();
        }
    }

    public boolean verify(VerifyConfig config, PrintStream out) throws DatabaseException {
        boolean ret;
        block5: {
            ret = true;
            if (this.tree == null) {
                return ret;
            }
            try {
                TreeInfo info = this.tree.verify(config);
                if (config.getPrintInfo()) {
                    out.println();
                    out.println("<DbStat name=\"" + this.getName() + "\">");
                    out.println(info);
                    out.println(info.dumpNodes(20));
                }
                if (config.getPrintInfo()) {
                    out.println("</DbStat>");
                }
            }
            catch (DatabaseException e) {
                out.println("Verification saw exception: " + Tracer.getStackTrace(e));
                Tracer.trace(this.envImpl, "DatabaseImpl", "verify", "", e);
                ret = false;
                if (!config.getPropagateExceptions()) break block5;
                throw e;
            }
        }
        return ret;
    }

    public String dumpString(int nSpaces) {
        StringBuffer sb = new StringBuffer();
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("<database id=\"");
        sb.append(this.id.toString());
        sb.append("\"");
        if (this.btreeComparator != null) {
            sb.append(" btc=\"");
            sb.append(DatabaseImpl.serializeComparator(this.btreeComparator));
            sb.append("\"");
        }
        if (this.duplicateComparator != null) {
            sb.append(" dupc=\"");
            sb.append(DatabaseImpl.serializeComparator(this.duplicateComparator));
            sb.append("\"");
        }
        sb.append("/>");
        return sb.toString();
    }

    public int getLogSize() {
        return this.id.getLogSize() + this.tree.getLogSize() + LogUtils.getBooleanLogSize() + LogUtils.getStringLogSize(DatabaseImpl.serializeComparator(this.btreeComparator)) + LogUtils.getStringLogSize(DatabaseImpl.serializeComparator(this.duplicateComparator));
    }

    public void writeToLog(ByteBuffer logBuffer) {
        this.id.writeToLog(logBuffer);
        this.tree.writeToLog(logBuffer);
        LogUtils.writeBoolean(logBuffer, this.duplicatesAllowed);
        LogUtils.writeString(logBuffer, DatabaseImpl.serializeComparator(this.btreeComparator));
        LogUtils.writeString(logBuffer, DatabaseImpl.serializeComparator(this.duplicateComparator));
    }

    public void readFromLog(ByteBuffer itemBuffer) throws LogException {
        this.id.readFromLog(itemBuffer);
        this.tree.readFromLog(itemBuffer);
        this.duplicatesAllowed = LogUtils.readBoolean(itemBuffer);
        String btreeComparatorName = LogUtils.readString(itemBuffer);
        String duplicateComparatorName = LogUtils.readString(itemBuffer);
        try {
            if (btreeComparatorName.length() != 0) {
                Class<?> btreeComparatorClass = Class.forName(btreeComparatorName);
                this.btreeComparator = DatabaseImpl.instantiateComparator(btreeComparatorClass, "Btree");
            }
            if (duplicateComparatorName.length() != 0) {
                Class<?> duplicateComparatorClass = Class.forName(duplicateComparatorName);
                this.duplicateComparator = DatabaseImpl.instantiateComparator(duplicateComparatorClass, "Duplicate");
            }
        }
        catch (ClassNotFoundException CNFE) {
            throw new LogException("couldn't instantiate class comparator", CNFE);
        }
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<database>");
        this.id.dumpLog(sb, verbose);
        this.tree.dumpLog(sb, verbose);
        sb.append("<dupsort v=\"").append(this.duplicatesAllowed);
        sb.append("\"/>");
        sb.append("<btcf name=\"");
        sb.append(DatabaseImpl.serializeComparator(this.btreeComparator));
        sb.append("\"/>");
        sb.append("<dupcf name=\"");
        sb.append(DatabaseImpl.serializeComparator(this.duplicateComparator));
        sb.append("\"/>");
        sb.append("</database>");
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }

    public static String serializeComparator(Comparator comparator) {
        if (comparator != null) {
            return comparator.getClass().getName();
        }
        return "";
    }

    public static Comparator instantiateComparator(Class comparator, String comparatorType) throws LogException {
        if (comparator == null) {
            return null;
        }
        Object ret = null;
        try {
            return (Comparator)comparator.newInstance();
        }
        catch (InstantiationException IE) {
            throw new LogException("Exception while trying to load " + comparatorType + " Comparator class: " + IE);
        }
        catch (IllegalAccessException IAE) {
            throw new LogException("Exception while trying to load " + comparatorType + " Comparator class: " + IAE);
        }
    }

    public int getBinDeltaPercent() {
        return this.binDeltaPercent;
    }

    public int getBinMaxDeltas() {
        return this.binMaxDeltas;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sleepycat$je$dbi$DatabaseImpl == null ? (class$com$sleepycat$je$dbi$DatabaseImpl = DatabaseImpl.class$("com.sleepycat.je.dbi.DatabaseImpl")) : class$com$sleepycat$je$dbi$DatabaseImpl).desiredAssertionStatus();
    }
}

