/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchNotHeldException;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DBINReference;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.DupCountLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.ThreadLocker;
import com.sleepycat.je.utilint.DbLsn;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CursorImpl
implements Cloneable {
    private static final boolean DEBUG = false;
    private static final byte CURSOR_NOT_INITIALIZED = 1;
    private static final byte CURSOR_INITIALIZED = 2;
    private static final byte CURSOR_CLOSED = 3;
    private static final String TRACE_DELETE = "delete";
    private static final String TRACE_MOD = "Mod:";
    private volatile BIN bin;
    private volatile int index;
    private volatile DBIN dupBin;
    private volatile int dupIndex;
    private BIN targetBin;
    private int targetIndex;
    private Key dupKey;
    private DatabaseImpl database;
    private boolean dirtyReadDefault;
    private Locker locker;
    private boolean releaseLocksOnClose;
    private byte status;
    public static final int FOUND = 1;
    public static final int EXACT = 2;
    public static final int EXACT_DATA = 4;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sleepycat$je$dbi$CursorImpl;
    static /* synthetic */ Class class$com$sleepycat$je$txn$BasicLocker;

    public CursorImpl(DatabaseImpl database, Locker locker, boolean retainNonTxnLocks, CursorConfig cursorConfig) throws DatabaseException {
        this.init(database, locker, retainNonTxnLocks, cursorConfig != null ? cursorConfig.getDirtyRead() : false);
    }

    public CursorImpl(DatabaseImpl database, Locker locker) throws DatabaseException {
        this.init(database, locker, true, false);
    }

    private void init(DatabaseImpl database, Locker locker, boolean retainNonTxnLocks, boolean configDirtyRead) throws DatabaseException {
        this.bin = null;
        this.index = -1;
        this.dupBin = null;
        this.dupIndex = -1;
        if (!$assertionsDisabled && retainNonTxnLocks && locker instanceof ThreadLocker) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !retainNonTxnLocks && locker.getClass() == (class$com$sleepycat$je$txn$BasicLocker == null ? (class$com$sleepycat$je$txn$BasicLocker = CursorImpl.class$("com.sleepycat.je.txn.BasicLocker")) : class$com$sleepycat$je$txn$BasicLocker)) {
            throw new AssertionError();
        }
        this.releaseLocksOnClose = !retainNonTxnLocks && !locker.isTransactional();
        this.database = database;
        this.locker = locker;
        this.locker.registerCursor(this);
        this.dirtyReadDefault = configDirtyRead || locker.isDirtyReadDefault();
        this.status = 1;
    }

    public CursorImpl cloneCursor() throws DatabaseException {
        try {
            CursorImpl ret = (CursorImpl)super.clone();
            if (this.releaseLocksOnClose) {
                ret.locker = this.locker.newInstance();
            }
            ret.locker.registerCursor(ret);
            return ret;
        }
        catch (CloneNotSupportedException cannotOccur) {
            return null;
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int idx) {
        this.index = idx;
    }

    public BIN getBIN() {
        return this.bin;
    }

    public void setBIN(BIN newBin) {
        this.bin = newBin;
    }

    public int getDupIndex() {
        return this.dupIndex;
    }

    public void setDupIndex(int dupIdx) {
        this.dupIndex = dupIdx;
    }

    public DBIN getDupBIN() {
        return this.dupBin;
    }

    public void setDupBIN(DBIN newDupBin) {
        this.dupBin = newDupBin;
    }

    private boolean setTargetBin() {
        this.targetBin = null;
        this.targetIndex = 0;
        boolean isDup = this.dupBin != null;
        this.dupKey = null;
        if (isDup) {
            this.targetBin = this.dupBin;
            this.targetIndex = this.dupIndex;
            this.dupKey = this.dupBin.getDupKey();
        } else {
            this.targetBin = this.bin;
            this.targetIndex = this.index;
        }
        return isDup;
    }

    public void latchBIN() throws DatabaseException {
        while (this.bin != null) {
            BIN waitingOn = this.bin;
            waitingOn.latch();
            if (this.bin == waitingOn) {
                return;
            }
            waitingOn.releaseLatch();
        }
    }

    public void releaseBIN() throws LatchNotHeldException {
        if (this.bin != null && this.bin.getLatch().isOwner()) {
            this.bin.releaseLatch();
        }
    }

    public void latchBINs() throws DatabaseException {
        this.latchBIN();
        this.latchDBIN();
    }

    public void releaseBINs() throws LatchNotHeldException {
        this.releaseBIN();
        this.releaseDBIN();
    }

    public void latchDBIN() throws DatabaseException {
        while (this.dupBin != null) {
            DBIN waitingOn = this.dupBin;
            waitingOn.latch();
            if (this.dupBin == waitingOn) {
                return;
            }
            waitingOn.releaseLatch();
        }
    }

    public void releaseDBIN() throws LatchNotHeldException {
        if (this.dupBin != null && this.dupBin.getLatch().isOwner()) {
            this.dupBin.releaseLatch();
        }
    }

    public Locker getLocker() {
        return this.locker;
    }

    public void addCursor(BIN bin) {
        if (bin != null) {
            if (!$assertionsDisabled && !bin.getLatch().isOwner()) {
                throw new AssertionError();
            }
            bin.addCursor(this);
        }
    }

    public void addCursor() {
        if (this.dupBin != null) {
            this.addCursor(this.dupBin);
        }
        if (this.bin != null) {
            this.addCursor(this.bin);
        }
    }

    public void updateBin(BIN bin, int index) {
        this.setDupIndex(-1);
        this.setDupBIN(null);
        this.setIndex(index);
        this.setBIN(bin);
        this.addCursor(bin);
    }

    public void updateDBin(DBIN dupBin, int dupIndex) {
        this.setDupIndex(dupIndex);
        this.setDupBIN(dupBin);
        this.addCursor(dupBin);
    }

    private void removeCursor() throws DatabaseException {
        this.removeCursorBin(this.bin);
        this.removeCursorBin(this.dupBin);
    }

    private void removeCursorBin(BIN aBin) throws DatabaseException {
        if (aBin != null) {
            aBin.latch();
            aBin.removeCursor(this);
            aBin.releaseLatch();
        }
    }

    public void dumpTree() throws DatabaseException {
        this.database.getTree().dump();
    }

    public boolean isClosed() {
        return this.status == 3;
    }

    public boolean isNotInitialized() {
        return this.status == 1;
    }

    public void reset() throws DatabaseException {
        this.removeCursor();
        if (this.releaseLocksOnClose) {
            this.locker.operationEnd();
        }
        this.bin = null;
        this.index = -1;
        this.dupBin = null;
        this.dupIndex = -1;
        this.status = 1;
    }

    public void close() throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(false)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        this.removeCursor();
        this.locker.unRegisterCursor(this);
        if (this.releaseLocksOnClose) {
            this.locker.operationEnd();
        }
        this.status = (byte)3;
    }

    public int count() throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(true)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        boolean duplicatesAllowed = this.database.getSortedDuplicates();
        if (!duplicatesAllowed) {
            return 1;
        }
        if (this.bin == null) {
            return 0;
        }
        this.latchBIN();
        if (this.bin.getNEntries() <= this.index) {
            this.releaseBIN();
            return 0;
        }
        ChildReference entry = this.bin.getEntry(this.index);
        int dupRootCount = 1;
        Node n = entry.fetchTarget(this.database, this.bin);
        if (n.containsDuplicates()) {
            DIN dupRoot = (DIN)n;
            dupRoot.latch();
            this.releaseBIN();
            DupCountLN dupCountLN = (DupCountLN)dupRoot.getDupCountLNRef().fetchTarget(this.database, dupRoot);
            dupRoot.releaseLatch();
            this.locker.readLock(dupCountLN);
            dupRootCount = dupCountLN.getDupCount();
        } else {
            this.releaseBIN();
        }
        return dupRootCount;
    }

    public OperationStatus delete() throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(true)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        boolean isDup = this.setTargetBin();
        if (this.targetBin == null) {
            return OperationStatus.KEYEMPTY;
        }
        ChildReference entry = this.targetBin.getEntry(this.targetIndex);
        if (entry.isKnownDeleted()) {
            this.releaseBINs();
            return OperationStatus.KEYEMPTY;
        }
        LN ln = (LN)entry.fetchTarget(this.database, this.targetBin);
        this.releaseBINs();
        LockResult lockResult = this.locker.writeLock(ln, this.database);
        LockGrantType lockStatus = lockResult.getLockGrant();
        if (ln.isDeleted()) {
            this.revertLock(this.locker, ln, lockStatus);
            return OperationStatus.KEYEMPTY;
        }
        DIN dupRoot = null;
        if (isDup) {
            this.latchBIN();
            dupRoot = (DIN)this.bin.getEntry(this.index).fetchTarget(this.database, this.bin);
            dupRoot.latch();
            this.latchDBIN();
        } else {
            this.latchBINs();
        }
        this.setTargetBin();
        entry = this.targetBin.getEntry(this.targetIndex);
        DbLsn oldLsn = entry.getLsn();
        Key lnKey = entry.getKey();
        Key idKey = this.targetBin.getIdentifierKey();
        long nodeId = this.targetBin.getNodeId();
        lockResult.setAbortLsn(oldLsn, entry.isKnownDeleted());
        long oldLNSize = ln.getMemorySizeIncludedByParent();
        DbLsn newLsn = ln.delete(this.database, lnKey, this.dupKey, oldLsn, this.locker);
        long newLNSize = ln.getMemorySizeIncludedByParent();
        if (isDup) {
            this.targetBin.updateEntry(this.targetIndex, newLsn);
            this.targetBin.updateMemorySize(oldLNSize, newLNSize);
            this.releaseBINs();
            ChildReference dupCountRef = dupRoot.getDupCountLNRef();
            DupCountLN dcl = (DupCountLN)dupCountRef.fetchTarget(this.database, dupRoot);
            dupRoot.releaseLatch();
            LockResult dclGrantAndInfo = this.locker.writeLock(dcl, this.database);
            LockGrantType dclLockStatus = dclGrantAndInfo.getLockGrant();
            this.latchBIN();
            dupRoot = (DIN)this.bin.getEntry(this.index).fetchTarget(this.database, this.bin);
            dupRoot.latch();
            this.releaseBIN();
            dupCountRef = dupRoot.getDupCountLNRef();
            DbLsn oldDclLsn = dupCountRef.getLsn();
            dclGrantAndInfo.setAbortLsn(oldDclLsn, dupCountRef.isKnownDeleted());
            dcl.decDupCount();
            EnvironmentImpl envImpl = this.database.getDbEnvironment();
            DbLsn dupCountLsn = dcl.log(envImpl, this.database.getId(), this.dupKey, oldDclLsn, this.locker);
            dupRoot.updateDupCountLNRef(dupCountLsn);
            dupRoot.releaseLatch();
            this.locker.addDeleteInfo(new DBINReference(nodeId, this.database.getId(), idKey, this.dupKey));
        } else {
            this.targetBin.updateEntry(this.targetIndex, newLsn);
            this.targetBin.updateMemorySize(oldLNSize, newLNSize);
            this.releaseBINs();
            this.locker.addDeleteInfo(new BINReference(nodeId, this.database.getId(), idKey));
        }
        this.trace(Level.FINER, TRACE_DELETE, this.targetBin, ln, this.targetIndex, oldLsn, newLsn);
        return OperationStatus.SUCCESS;
    }

    public CursorImpl dup(boolean samePosition) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(false)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        CursorImpl ret = this.cloneCursor();
        if (!samePosition) {
            ret.bin = null;
            ret.index = -1;
            ret.dupBin = null;
            ret.dupIndex = -1;
            ret.status = 1;
        } else {
            this.latchBINs();
            ret.addCursor();
            this.releaseBINs();
        }
        return ret;
    }

    public OperationStatus putLN(Key key, LN ln, boolean allowDuplicates) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(false)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
            throw new AssertionError();
        }
        LockResult lockResult = null;
        lockResult = this.locker.writeLock(ln, this.database);
        LockGrantType lockStatus = lockResult.getLockGrant();
        if (this.database.getTree().insert(ln, key, allowDuplicates, this, lockResult)) {
            this.status = (byte)2;
            return OperationStatus.SUCCESS;
        }
        this.locker.releaseLock(ln);
        return OperationStatus.KEYEXIST;
    }

    public OperationStatus put(DatabaseEntry key, DatabaseEntry data, DatabaseEntry foundData) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(false)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        LN ln = new LN(data);
        OperationStatus result = this.putLN(new Key(key), ln, this.database.getSortedDuplicates());
        if (result == OperationStatus.KEYEXIST) {
            this.status = (byte)2;
            result = this.putCurrent(data, null, foundData);
        }
        return result;
    }

    public OperationStatus putNoOverwrite(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(false)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        LN ln = new LN(data);
        return this.putLN(new Key(key), ln, false);
    }

    public OperationStatus putNoDupData(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(false)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        if (!this.database.getSortedDuplicates()) {
            throw new DatabaseException("putNoDupData() called, but database is not configured for duplicate data.");
        }
        LN ln = new LN(data);
        return this.putLN(new Key(key), ln, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus putCurrent(DatabaseEntry data, DatabaseEntry foundKey, DatabaseEntry foundData) throws DatabaseException {
        byte[] newData;
        byte[] foundKeyBytes;
        byte[] foundDataBytes;
        Comparator userComparisonFcn;
        Key lnKey;
        LN ln;
        ChildReference entry;
        boolean isDup;
        block18: {
            OperationStatus operationStatus;
            if (!$assertionsDisabled && !this.assertCursorState(true)) {
                throw new AssertionError((Object)this.dumpToString(true));
            }
            if (foundKey != null) {
                foundKey.setData(null);
            }
            if (foundData != null) {
                foundData.setData(null);
            }
            if (this.bin == null) {
                return OperationStatus.KEYEMPTY;
            }
            this.latchBINs();
            isDup = this.setTargetBin();
            try {
                entry = this.targetBin.getEntry(this.targetIndex);
                ln = (LN)entry.fetchTarget(this.database, this.targetBin);
                lnKey = entry.getKey();
                userComparisonFcn = this.targetBin.getKeyComparator();
                this.releaseBINs();
                if (!entry.isKnownDeleted() && !ln.isDeleted()) break block18;
                operationStatus = OperationStatus.NOTFOUND;
                Object var23_11 = null;
            }
            catch (Throwable throwable) {
                Object var23_13 = null;
                this.releaseBINs();
                throw throwable;
            }
            this.releaseBINs();
            return operationStatus;
        }
        LockResult lockResult = this.locker.writeLock(ln, this.database);
        LockGrantType lockStatus = lockResult.getLockGrant();
        if (isDup) {
            foundDataBytes = lnKey.getKey();
            foundKeyBytes = this.targetBin.getDupKey().getKey();
        } else {
            foundDataBytes = ln.getData();
            foundKeyBytes = lnKey.getKey();
        }
        if (data.getPartial()) {
            int slicelen;
            int dlen = data.getPartialLength();
            int doff = data.getPartialOffset();
            int origlen = foundDataBytes != null ? foundDataBytes.length : 0;
            int oldlen = doff + dlen > origlen ? doff + dlen : origlen;
            int len = oldlen - dlen + data.getSize();
            newData = new byte[len];
            int pos = 0;
            int n = slicelen = doff < origlen ? doff : origlen;
            if (slicelen > 0) {
                System.arraycopy(foundDataBytes, 0, newData, pos, slicelen);
            }
            slicelen = data.getSize();
            System.arraycopy(data.getData(), data.getOffset(), newData, pos += doff, slicelen);
            pos += slicelen;
            slicelen = origlen - (doff + dlen);
            if (slicelen > 0) {
                System.arraycopy(foundDataBytes, doff + dlen, newData, pos, slicelen);
            }
        } else {
            int len = data.getSize();
            newData = new byte[len];
            System.arraycopy(data.getData(), data.getOffset(), newData, 0, len);
        }
        if (this.database.getSortedDuplicates()) {
            boolean keysEqual = false;
            if (foundDataBytes != null) {
                boolean bl = userComparisonFcn == null ? Key.compareByteArray(foundDataBytes, newData) == 0 : (keysEqual = userComparisonFcn.compare(foundDataBytes, newData) == 0);
            }
            if (!keysEqual) {
                this.revertLock(this.locker, ln, lockStatus);
                throw new DatabaseException("Can't replace a duplicate with different data.");
            }
        }
        if (foundData != null) {
            this.setDbt(foundData, foundDataBytes);
        }
        if (foundKey != null) {
            this.setDbt(foundKey, foundKeyBytes);
        }
        this.latchBINs();
        this.setTargetBin();
        entry = this.targetBin.getEntry(this.targetIndex);
        DbLsn oldLsn = entry.getLsn();
        lockResult.setAbortLsn(oldLsn, entry.isKnownDeleted());
        long oldLNSize = ln.getMemorySizeIncludedByParent();
        Key newKey = isDup ? this.targetBin.getDupKey() : lnKey;
        DbLsn newLsn = ln.modify(newData, this.database, newKey, oldLsn, this.locker);
        long newLNSize = ln.getMemorySizeIncludedByParent();
        this.targetBin.updateEntry(this.targetIndex, newLsn);
        this.targetBin.updateMemorySize(oldLNSize, newLNSize);
        this.releaseBINs();
        this.trace(Level.FINER, TRACE_MOD, this.targetBin, ln, this.targetIndex, oldLsn, newLsn);
        this.status = (byte)2;
        OperationStatus operationStatus = OperationStatus.SUCCESS;
        Object var23_12 = null;
        this.releaseBINs();
        return operationStatus;
    }

    public OperationStatus getCurrent(DatabaseEntry foundKey, DatabaseEntry foundData, LockMode lockMode) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(true)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        if (this.bin == null) {
            return OperationStatus.KEYEMPTY;
        }
        if (this.dupBin == null) {
            this.latchBIN();
        } else {
            this.latchDBIN();
        }
        return this.getCurrentAlreadyLatched(foundKey, foundData, lockMode, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getCurrentAlreadyLatched(DatabaseEntry foundKey, DatabaseEntry foundData, LockMode lockMode, boolean first) throws DatabaseException {
        OperationStatus operationStatus;
        if (!$assertionsDisabled && !this.assertCursorState(true)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        try {
            operationStatus = this.fetchCurrent(foundKey, foundData, lockMode, first);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.releaseBINs();
            throw throwable;
        }
        this.releaseBINs();
        return operationStatus;
    }

    LN getCurrentLN() throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(true)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        if (this.bin == null) {
            return null;
        }
        this.latchBIN();
        return this.getCurrentLNAlreadyLatched(LockMode.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LN getCurrentLNAlreadyLatched(LockMode lockMode) throws DatabaseException {
        LockResult lockResult;
        LN ln;
        ChildReference entry;
        block9: {
            block8: {
                block7: {
                    LN lN;
                    try {
                        if (!$assertionsDisabled && !this.assertCursorState(true)) {
                            throw new AssertionError((Object)this.dumpToString(true));
                        }
                        if (this.bin != null) break block7;
                        lN = null;
                        Object var7_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        this.releaseBIN();
                        throw throwable;
                    }
                    this.releaseBIN();
                    return lN;
                }
                entry = this.bin.getEntry(this.index);
                if (!entry.isKnownDeleted()) break block8;
                this.releaseBIN();
                LN lN = null;
                Object var7_5 = null;
                this.releaseBIN();
                return lN;
            }
            ln = (LN)entry.fetchTarget(this.database, this.bin);
            this.addCursor(this.bin);
            this.releaseBIN();
            lockResult = this.getReadLock(ln, lockMode);
            if (!ln.isDeleted()) break block9;
            this.revertLock(this.locker, ln, lockResult.getLockGrant());
            LN lN = null;
            Object var7_6 = null;
            this.releaseBIN();
            return lN;
        }
        if (lockMode == LockMode.RMW) {
            this.latchBIN();
            entry = this.bin.getEntry(this.index);
            DbLsn oldLsn = entry.getLsn();
            lockResult.setAbortLsn(oldLsn, entry.isKnownDeleted());
            this.releaseBIN();
        }
        LN lN = ln;
        Object var7_7 = null;
        this.releaseBIN();
        return lN;
    }

    /*
     * Unable to fully structure code
     */
    public OperationStatus getNext(DatabaseEntry foundKey, DatabaseEntry foundData, LockMode lockMode, boolean forward, boolean alreadyLatched) throws DatabaseException {
        if (CursorImpl.$assertionsDisabled || this.assertCursorState(true)) ** GOTO lbl29
        throw new AssertionError((Object)this.dumpToString(true));
lbl-1000:
        // 1 sources

        {
            if (this.dupBin != null) {
                if (this.getNextDuplicate(foundKey, foundData, lockMode, forward, alreadyLatched) == OperationStatus.SUCCESS) {
                    return OperationStatus.SUCCESS;
                }
                this.removeCursorBin(this.dupBin);
                alreadyLatched = false;
                this.dupBin = null;
                this.dupIndex = -1;
                continue;
            }
            if (!alreadyLatched) {
                this.latchBIN();
            } else {
                alreadyLatched = false;
            }
            if (forward && ++this.index < this.bin.getNEntries() || !forward && --this.index > -1) {
                ret = this.getCurrentAlreadyLatched(foundKey, foundData, lockMode, forward);
                if (ret != OperationStatus.SUCCESS) continue;
                return OperationStatus.SUCCESS;
            }
            this.releaseBIN();
            newBin = forward != false ? this.database.getTree().getNextBin(this.bin, null) : this.database.getTree().getPrevBin(this.bin, null);
            if (newBin == null) {
                return OperationStatus.NOTFOUND;
            }
            this.index = forward != false ? -1 : newBin.getNEntries();
            this.addCursor(newBin);
            oldBin = this.bin;
            this.bin = newBin;
            newBin.releaseLatch();
            this.removeCursorBin(oldBin);
lbl29:
            // 4 sources

            ** while (this.bin != null)
        }
lbl30:
        // 1 sources

        return OperationStatus.NOTFOUND;
    }

    public OperationStatus getNextNoDup(DatabaseEntry foundKey, DatabaseEntry foundData, LockMode lockMode, boolean forward) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(true)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        if (this.dupBin != null) {
            this.removeCursorBin(this.dupBin);
            this.dupBin = null;
            this.dupIndex = -1;
        }
        return this.getNext(foundKey, foundData, lockMode, forward, false);
    }

    /*
     * Unable to fully structure code
     */
    public OperationStatus getNextDuplicate(DatabaseEntry foundKey, DatabaseEntry foundData, LockMode lockMode, boolean forward, boolean alreadyLatched) throws DatabaseException {
        if (CursorImpl.$assertionsDisabled || this.assertCursorState(true)) ** GOTO lbl35
        throw new AssertionError((Object)this.dumpToString(true));
lbl-1000:
        // 1 sources

        {
            if (!alreadyLatched) {
                this.latchDBIN();
            } else {
                alreadyLatched = false;
            }
            if (forward && ++this.dupIndex < this.dupBin.getNEntries() || !forward && --this.dupIndex > -1) {
                ret = OperationStatus.SUCCESS;
                if (foundKey != null) {
                    ret = this.fetchCurrent(foundKey, foundData, lockMode, forward);
                } else {
                    this.releaseDBIN();
                }
                if (ret != OperationStatus.SUCCESS) continue;
                return ret;
            }
            this.releaseDBIN();
            this.latchBIN();
            if (this.index < 0) {
                this.releaseBIN();
                return OperationStatus.NOTFOUND;
            }
            duplicateRoot = (DIN)this.bin.getEntry(this.index).fetchTarget(this.database, this.bin);
            this.releaseBIN();
            if (!CursorImpl.$assertionsDisabled && Latch.countLatchesHeld() != 0) {
                throw new AssertionError();
            }
            newDupBin = forward != false ? (DBIN)this.database.getTree().getNextBin(this.dupBin, duplicateRoot) : (DBIN)this.database.getTree().getPrevBin(this.dupBin, duplicateRoot);
            if (newDupBin == null) {
                return OperationStatus.NOTFOUND;
            }
            this.dupIndex = forward != false ? -1 : newDupBin.getNEntries();
            this.addCursor(newDupBin);
            oldDupBin = this.dupBin;
            this.dupBin = newDupBin;
            this.releaseDBIN();
            this.removeCursorBin(oldDupBin);
            if (!CursorImpl.$assertionsDisabled && Latch.countLatchesHeld() != 0) {
                throw new AssertionError();
            }
lbl35:
            // 4 sources

            ** while (this.dupBin != null)
        }
lbl36:
        // 1 sources

        return OperationStatus.NOTFOUND;
    }

    public boolean positionFirstOrLast(boolean first, DIN duplicateRoot) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(false)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        IN in = null;
        boolean found = false;
        try {
            if (duplicateRoot == null) {
                this.removeCursorBin(this.bin);
                in = first ? this.database.getTree().getFirstNode() : this.database.getTree().getLastNode();
                if (in != null) {
                    if (in.getNEntries() > 0) {
                        if (!(in instanceof BIN)) {
                            throw new DatabaseException("getFirst/LastNode didn't return a BIN");
                        }
                        this.dupBin = null;
                        this.dupIndex = -1;
                        this.bin = (BIN)in;
                        this.index = first ? 0 : this.bin.getNEntries() - 1;
                        this.addCursor(this.bin);
                        ChildReference ref = in.getEntry(this.index);
                        if (ref.isKnownDeleted()) {
                            found = true;
                        } else {
                            Node n = ref.fetchTarget(this.database, in);
                            if (n.containsDuplicates()) {
                                DIN dupRoot = (DIN)n;
                                dupRoot.latch();
                                in.releaseLatch();
                                in = null;
                                found = this.positionFirstOrLast(first, dupRoot);
                            } else {
                                found = true;
                            }
                        }
                    } else {
                        in.releaseLatch();
                    }
                }
            } else {
                this.removeCursorBin(this.dupBin);
                in = first ? this.database.getTree().getFirstNode(duplicateRoot) : this.database.getTree().getLastNode(duplicateRoot);
                if (in != null) {
                    if (!$assertionsDisabled && !(in instanceof DBIN)) {
                        throw new AssertionError();
                    }
                    this.dupBin = (DBIN)in;
                    this.dupIndex = first ? 0 : this.dupBin.getNEntries() - 1;
                    this.addCursor(this.dupBin);
                    found = true;
                }
            }
            this.status = (byte)2;
            return found;
        }
        catch (DatabaseException e) {
            if (in != null) {
                in.releaseLatch();
            }
            throw e;
        }
    }

    public int searchAndPosition(DatabaseEntry matchKey, DatabaseEntry matchData, SearchMode searchMode, LockMode lockMode) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(false)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        this.removeCursorBin(this.bin);
        this.bin = null;
        boolean foundSomething = false;
        boolean foundExact = false;
        boolean foundExactData = false;
        boolean exactSearch = searchMode == SearchMode.SET || searchMode == SearchMode.BOTH;
        try {
            Key key = new Key(matchKey);
            this.bin = (BIN)this.database.getTree().search(key, Tree.SearchType.NORMAL, -1L, false);
            if (this.bin != null) {
                this.addCursor(this.bin);
                this.index = this.bin.findEntry(key, true, exactSearch);
                foundSomething = !exactSearch;
                this.dupBin = null;
                this.dupIndex = -1;
                if (this.index >= 0) {
                    if ((this.index & 0x10000) != 0) {
                        foundExact = true;
                    }
                    this.index &= 0xFFFEFFFF;
                    ChildReference ref = this.bin.getEntry(this.index);
                    if (!ref.isKnownDeleted()) {
                        Node n = ref.fetchTarget(this.database, this.bin);
                        boolean containsDuplicates = n.containsDuplicates();
                        if (searchMode == SearchMode.BOTH || searchMode == SearchMode.BOTH_RANGE) {
                            int searchResult = this.searchAndPositionBoth(containsDuplicates, n, matchData, exactSearch, lockMode, ref);
                            foundSomething = (searchResult & 1) != 0;
                            foundExactData = (searchResult & 2) != 0;
                        } else {
                            foundSomething = true;
                            if (!containsDuplicates && exactSearch) {
                                this.releaseBIN();
                                LN ln = (LN)n;
                                DbLsn oldLsn = ref.getLsn();
                                LockResult lockResult = this.getReadLock(ln, lockMode);
                                this.latchBIN();
                                if (ln.isDeleted()) {
                                    foundSomething = false;
                                    this.revertLock(this.locker, ln, lockResult.getLockGrant());
                                }
                                ref = this.bin.getEntry(this.index);
                                lockResult.setAbortLsn(ref.getLsn(), ref.isKnownDeleted());
                            }
                        }
                    }
                }
            }
            this.status = (byte)2;
            return (foundSomething ? 1 : 0) | (foundExact ? 2 : 0) | (foundExactData ? 4 : 0);
        }
        catch (DatabaseException e) {
            this.releaseBIN();
            throw e;
        }
    }

    private int searchAndPositionBoth(boolean containsDuplicates, Node n, DatabaseEntry matchData, boolean exactSearch, LockMode lockMode, ChildReference ref) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(false)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        boolean found = false;
        boolean exact = false;
        Key data = new Key(matchData);
        if (matchData == null) {
            throw new IllegalArgumentException("null data passed to Tree.search().");
        }
        if (containsDuplicates) {
            DIN duplicateRoot = (DIN)n;
            duplicateRoot.latch();
            this.releaseBIN();
            this.dupBin = (DBIN)this.database.getTree().searchSubTree(duplicateRoot, data, Tree.SearchType.NORMAL, -1L, false);
            if (this.dupBin != null) {
                this.addCursor(this.dupBin);
                this.dupIndex = this.dupBin.findEntry(data, true, exactSearch);
                if (this.dupIndex >= 0) {
                    if ((this.dupIndex & 0x10000) != 0) {
                        exact = true;
                    }
                    this.dupIndex &= 0xFFFEFFFF;
                    found = true;
                } else {
                    this.dupIndex = -1;
                    found = !exactSearch;
                }
            }
        } else {
            LN ln = (LN)n;
            this.releaseBIN();
            DbLsn oldLsn = ref.getLsn();
            LockResult lockResult = this.getReadLock(ln, lockMode);
            this.latchBIN();
            if (ln.isDeleted()) {
                found = false;
                this.revertLock(this.locker, ln, lockResult.getLockGrant());
            } else {
                ref = this.bin.getEntry(this.index);
                lockResult.setAbortLsn(ref.getLsn(), ref.isKnownDeleted());
                this.dupBin = null;
                this.dupIndex = -1;
                int cmp = Key.compareByteArray(ln.getData(), data.getKey());
                found = exactSearch ? cmp == 0 : cmp >= 0;
                exact = cmp == 0;
            }
        }
        return (found ? 1 : 0) | (exact ? 2 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus fetchCurrent(DatabaseEntry foundKey, DatabaseEntry foundData, LockMode lockMode, boolean first) throws DatabaseException {
        LN ln;
        ChildReference entry;
        boolean duplicateFetch;
        block19: {
            DbLsn oldLsn;
            LockResult lockResult;
            Node n;
            block18: {
                OperationStatus operationStatus;
                duplicateFetch = this.setTargetBin();
                if (this.targetBin == null) {
                    return OperationStatus.NOTFOUND;
                }
                entry = this.targetBin.getEntry(this.targetIndex);
                if (entry == null || entry.isKnownDeleted()) {
                    if (this.targetBin.getLatch().isOwner()) {
                        this.targetBin.releaseLatch();
                    }
                    return OperationStatus.KEYEMPTY;
                }
                this.addCursor(this.targetBin);
                n = entry.fetchTarget(this.database, this.targetBin);
                if (n.containsDuplicates()) {
                    if (!$assertionsDisabled && duplicateFetch) {
                        throw new AssertionError();
                    }
                    DIN duplicateRoot = (DIN)n;
                    duplicateRoot.latch();
                    this.targetBin.releaseLatch();
                    if (this.positionFirstOrLast(first, duplicateRoot)) {
                        return this.fetchCurrent(foundKey, foundData, lockMode, first);
                    }
                    return OperationStatus.NOTFOUND;
                }
                ln = (LN)n;
                this.releaseBINs();
                lockResult = this.getReadLock(ln, lockMode);
                this.latchBINs();
                try {
                    duplicateFetch = this.setTargetBin();
                    entry = this.targetBin.getEntry(this.targetIndex);
                    oldLsn = entry.getLsn();
                    if (lockMode == LockMode.RMW) {
                        lockResult.setAbortLsn(oldLsn, entry.isKnownDeleted());
                    }
                    if (entry != null && !entry.isKnownDeleted()) break block18;
                    this.targetBin.releaseLatch();
                    operationStatus = OperationStatus.KEYEMPTY;
                    Object var13_15 = null;
                }
                catch (Throwable throwable) {
                    Object var13_18 = null;
                    this.releaseBINs();
                    throw throwable;
                }
                this.releaseBINs();
                return operationStatus;
            }
            if (!entry.getLsn().equals(oldLsn) || entry.getTarget() != n) {
                ln = (LN)entry.fetchTarget(this.database, this.targetBin);
            }
            if (!ln.isDeleted()) break block19;
            this.revertLock(this.locker, ln, lockResult.getLockGrant());
            OperationStatus operationStatus = OperationStatus.KEYEMPTY;
            Object var13_16 = null;
            this.releaseBINs();
            return operationStatus;
        }
        if (duplicateFetch) {
            if (foundData != null) {
                this.setDbt(foundData, entry.getKey().getKey());
            }
            if (foundKey != null) {
                this.setDbt(foundKey, this.targetBin.getDupKey().getKey());
            }
        } else {
            if (foundData != null) {
                this.setDbt(foundData, ln.getData());
            }
            if (foundKey != null) {
                this.setDbt(foundKey, entry.getKey().getKey());
            }
        }
        OperationStatus operationStatus = OperationStatus.SUCCESS;
        Object var13_17 = null;
        this.releaseBINs();
        return operationStatus;
    }

    private void setDbt(DatabaseEntry data, byte[] bytes) throws DatabaseException {
        if (bytes != null) {
            int len;
            boolean partial = data.getPartial();
            int off = partial ? data.getPartialOffset() : 0;
            int n = len = partial ? data.getPartialLength() : bytes.length;
            if (off + len > bytes.length) {
                len = off > bytes.length ? 0 : bytes.length - off;
            }
            byte[] newdata = new byte[len];
            System.arraycopy(bytes, off, newdata, 0, len);
            data.setData(newdata);
            data.setOffset(0);
            data.setSize(len);
        } else {
            data.setData(null);
            data.setOffset(0);
            data.setSize(0);
        }
    }

    private void verifyCursor(BIN bin) throws DatabaseException {
        if (!bin.getCursorSet().contains(this)) {
            throw new DatabaseException("BIN cursorSet is inconsistent.");
        }
    }

    private boolean assertCursorState(boolean mustBeInitialized) {
        try {
            this.checkCursorState(mustBeInitialized);
            return true;
        }
        catch (DatabaseException e) {
            return false;
        }
    }

    public void checkCursorState(boolean mustBeInitialized) throws DatabaseException {
        if (this.status == 2) {
            return;
        }
        if (this.status == 1) {
            if (mustBeInitialized) {
                throw new DatabaseException("Cursor Not Initialized.");
            }
        } else {
            if (this.status == 3) {
                throw new DatabaseException("Cursor has been closed.");
            }
            throw new DatabaseException("Unknown cursor status: " + this.status);
        }
    }

    private LockResult getReadLock(LN ln, LockMode lockMode) throws DatabaseException {
        if (lockMode == null || lockMode == LockMode.DEFAULT) {
            if (!this.dirtyReadDefault) {
                LockGrantType lockGrant = this.locker.readLock(ln);
                return new LockResult(lockGrant, null);
            }
        } else if (lockMode == LockMode.RMW) {
            return this.locker.writeLock(ln, this.database);
        }
        return new LockResult(LockGrantType.NONE_NEEDED, null);
    }

    public boolean isDirtyReadMode(LockMode lockMode) {
        if (lockMode == null || lockMode == LockMode.DEFAULT) {
            return this.dirtyReadDefault;
        }
        return lockMode != LockMode.RMW;
    }

    private void revertLock(Locker locker, LN ln, LockGrantType lockStatus) throws DatabaseException {
        if (lockStatus == LockGrantType.NEW || lockStatus == LockGrantType.WAIT_NEW) {
            locker.releaseLock(ln);
        } else if (lockStatus == LockGrantType.PROMOTION || lockStatus == LockGrantType.WAIT_PROMOTION) {
            locker.demoteLock(ln.getNodeId());
        }
    }

    public void checkEnv() throws RunRecoveryException {
        this.database.getDbEnvironment().checkIfInvalid();
    }

    public void dump(boolean verbose) {
        System.out.println(this.dumpToString(verbose));
    }

    public void dump() {
        System.out.println(this.dumpToString(true));
    }

    private String statusToString(byte status) {
        switch (status) {
            case 1: {
                return "CURSOR_NOT_INITIALIZED";
            }
            case 2: {
                return "CURSOR_INITIALIZED";
            }
            case 3: {
                return "CURSOR_CLOSED";
            }
        }
        return "UNKNOWN (" + Byte.toString(status) + ")";
    }

    public String dumpToString(boolean verbose) {
        StringBuffer sb = new StringBuffer();
        sb.append("<Cursor idx=\"").append(this.index).append("\"");
        if (this.dupBin != null) {
            sb.append(" dupIdx=\"").append(this.dupIndex).append("\"");
        }
        sb.append(" status=\"").append(this.statusToString(this.status)).append("\"");
        sb.append(">\n");
        if (verbose) {
            sb.append(this.bin == null ? "" : this.bin.dumpString(2, true));
            sb.append(this.dupBin == null ? "" : this.dupBin.dumpString(2, true));
        }
        sb.append("\n</Cursor>");
        return sb.toString();
    }

    public LockStats getLockStats() throws DatabaseException {
        return this.locker.collectStats(new LockStats());
    }

    private void trace(Level level, String changeType, BIN theBin, LN ln, int lnIndex, DbLsn oldLsn, DbLsn newLsn) {
        Logger logger = this.database.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(changeType);
            sb.append(" bin=");
            sb.append(theBin.getNodeId());
            sb.append(" ln=");
            sb.append(ln.getNodeId());
            sb.append(" lnIdx=");
            sb.append(lnIndex);
            sb.append(" oldLnLsn=");
            sb.append(oldLsn.getNoFormatString());
            sb.append(" newLnLsn=");
            sb.append(newLsn.getNoFormatString());
            logger.log(level, sb.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sleepycat$je$dbi$CursorImpl == null ? (class$com$sleepycat$je$dbi$CursorImpl = CursorImpl.class$("com.sleepycat.je.dbi.CursorImpl")) : class$com$sleepycat$je$dbi$CursorImpl).desiredAssertionStatus();
    }

    public static class SearchMode {
        public static final SearchMode SET = new SearchMode();
        public static final SearchMode BOTH = new SearchMode();
        public static final SearchMode SET_RANGE = new SearchMode();
        public static final SearchMode BOTH_RANGE = new SearchMode();
    }
}

