/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.config;

import com.sleepycat.je.config.ConfigParam;

public class LongConfigParam
extends ConfigParam {
    private static final String DEBUG_NAME = (class$com$sleepycat$je$config$LongConfigParam == null ? (class$com$sleepycat$je$config$LongConfigParam = LongConfigParam.class$("com.sleepycat.je.config.LongConfigParam")) : class$com$sleepycat$je$config$LongConfigParam).getName();
    private Long min;
    private Long max;
    private Long defaultLongValue;
    static /* synthetic */ Class class$com$sleepycat$je$config$LongConfigParam;

    LongConfigParam(String configName, Long minVal, Long maxVal, Long defaultValue, boolean mutable, String description) {
        super(configName, defaultValue.toString(), mutable, description);
        this.defaultLongValue = defaultValue;
        this.min = minVal;
        this.max = maxVal;
    }

    private void validate(Long value) throws IllegalArgumentException {
        if (value != null) {
            if (this.min != null && value.compareTo(this.min) < 0) {
                throw new IllegalArgumentException(DEBUG_NAME + ":" + " param " + this.name + " doesn't validate, " + value + " is less than min of " + this.min);
            }
            if (this.max != null && value.compareTo(this.max) > 0) {
                throw new IllegalArgumentException(DEBUG_NAME + ":" + " param " + this.name + " doesn't validate, " + value + " is greater than max " + " of " + this.max);
            }
        }
    }

    public void validateValue(String value) throws IllegalArgumentException {
        try {
            this.validate(new Long(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(DEBUG_NAME + ": " + value + " not valid value for " + this.name);
        }
    }

    public String getExtraDescription() {
        StringBuffer minMaxDesc = new StringBuffer();
        if (this.min != null) {
            minMaxDesc.append("# minimum = ").append(this.min);
        }
        if (this.max != null) {
            if (this.min != null) {
                minMaxDesc.append("\n");
            }
            minMaxDesc.append("# maximum = ").append(this.max);
        }
        return minMaxDesc.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

