/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.tree.FileSummaryLN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.txn.AutoTxn;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DbLsn;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class UtilizationProfile {
    private EnvironmentImpl env;
    private UtilizationTracker tracker;
    private DatabaseImpl fileSummaryDb;
    private SortedMap fileSummaryMap;
    private boolean cachePopulated;
    private long totalLogSize;
    private int minUtilization;
    private int minAge;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sleepycat$je$cleaner$UtilizationProfile;

    public UtilizationProfile(EnvironmentImpl env, UtilizationTracker tracker) throws DatabaseException {
        this.env = env;
        this.tracker = tracker;
        this.fileSummaryMap = new TreeMap();
        this.minAge = env.getConfigManager().getInt(EnvironmentParams.CLEANER_MIN_AGE);
        this.minUtilization = env.getConfigManager().getInt(EnvironmentParams.CLEANER_MIN_UTILIZATION);
    }

    synchronized Long getBestFileForCleaning(Long excludeFile, boolean aggressive) throws DatabaseException {
        this.populateCache();
        if (this.fileSummaryMap.size() == 0) {
            return null;
        }
        DbLsn firstActiveLsn = this.env.getCheckpointer().getFirstActiveLsn();
        if (firstActiveLsn == null) {
            return null;
        }
        Iterator iter = this.fileSummaryMap.keySet().iterator();
        Long bestFile = null;
        int bestUtilization = 101;
        long totalSize = 0L;
        long totalObsoleteSize = 0L;
        while (iter.hasNext()) {
            Long file = (Long)iter.next();
            long fileNum = file;
            FileSummary summary = (FileSummary)this.fileSummaryMap.get(file);
            summary = this.addTrackedSummary(summary, fileNum);
            int obsoleteSize = summary.getObsoleteSize();
            totalObsoleteSize += (long)obsoleteSize;
            totalSize += (long)summary.totalSize;
            if (firstActiveLsn.getFileNumber() - fileNum < (long)this.minAge || file.equals(excludeFile)) continue;
            int thisUtilization = UtilizationProfile.utilization(obsoleteSize, summary.totalSize);
            if (bestFile != null && thisUtilization >= bestUtilization) continue;
            bestFile = file;
            bestUtilization = thisUtilization;
        }
        int totalUtilization = UtilizationProfile.utilization(totalObsoleteSize, totalSize);
        if (aggressive || totalUtilization < this.minUtilization) {
            return bestFile;
        }
        return null;
    }

    public static int utilization(long obsoleteSize, long totalSize) {
        if (totalSize != 0L) {
            return (int)((totalSize - obsoleteSize) * 100L / totalSize);
        }
        return 0;
    }

    private FileSummary addTrackedSummary(FileSummary summary, long fileNum) {
        TrackedFileSummary trackedSummary = this.tracker.getTrackedFile(fileNum);
        if (trackedSummary != null) {
            FileSummary totals = new FileSummary();
            totals.add(summary);
            totals.add(trackedSummary);
            summary = totals;
        }
        return summary;
    }

    public long getTotalLogSize(boolean calcIfNecessary) throws DatabaseException {
        if (calcIfNecessary) {
            this.populateCache();
        }
        if (this.cachePopulated) {
            return this.totalLogSize + this.tracker.getLogSizeDelta();
        }
        return -1L;
    }

    public synchronized SortedMap getFileSummaryMap() throws DatabaseException {
        this.populateCache();
        return new TreeMap(this.fileSummaryMap);
    }

    public synchronized void clearCache() {
        this.fileSummaryMap = new TreeMap();
        this.cachePopulated = false;
        this.totalLogSize = 0L;
    }

    private synchronized void populateCache() throws DatabaseException {
        if (!this.cachePopulated) {
            FileManager fileManager = this.env.getFileManager();
            Long[] nums = fileManager.getAllFileNumbers();
            int i = 0;
            while (i < nums.length) {
                this.getFileSummary(nums[i]);
                ++i;
            }
            this.cachePopulated = true;
        }
    }

    public synchronized void cacheFileSummary(long fileNum, FileSummary summary) {
        FileSummary oldSummary = this.fileSummaryMap.put(new Long(fileNum), summary);
        if (oldSummary != null) {
            this.totalLogSize -= (long)oldSummary.totalSize;
        }
        this.totalLogSize += (long)summary.totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void removeFile(Long fileNum) throws DatabaseException {
        FileSummary oldSummary = (FileSummary)this.fileSummaryMap.remove(fileNum);
        if (oldSummary != null) {
            this.totalLogSize -= (long)oldSummary.totalSize;
        }
        boolean opened = this.openFileSummaryDatabase();
        if (!$assertionsDisabled && !opened) {
            throw new AssertionError();
        }
        BasicLocker locker = null;
        CursorImpl cursor = null;
        try {
            locker = new BasicLocker(this.env);
            cursor = new CursorImpl(this.fileSummaryDb, locker);
            byte[] keyBytes = FileSummaryLN.fileNumberToBytes(fileNum);
            DatabaseEntry keyEntry = new DatabaseEntry(keyBytes);
            int result = cursor.searchAndPosition(keyEntry, new DatabaseEntry(), CursorImpl.SearchMode.SET, null);
            if ((result & 1) != 0) {
                cursor.delete();
            }
        }
        finally {
            if (cursor != null) {
                cursor.releaseBINs();
                cursor.close();
            }
            if (locker != null) {
                ((Locker)locker).operationEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized FileSummary getFileSummary(Long fileNum) throws DatabaseException {
        FileSummary summary = (FileSummary)this.fileSummaryMap.get(fileNum);
        if (summary != null) {
            return summary;
        }
        if (!this.openFileSummaryDatabase()) {
            return null;
        }
        BasicLocker locker = null;
        CursorImpl cursor = null;
        try {
            locker = new BasicLocker(this.env);
            cursor = new CursorImpl(this.fileSummaryDb, locker);
            byte[] keyBytes = FileSummaryLN.fileNumberToBytes(fileNum);
            DatabaseEntry keyEntry = new DatabaseEntry(keyBytes);
            int result = cursor.searchAndPosition(keyEntry, new DatabaseEntry(), CursorImpl.SearchMode.SET, null);
            if ((result & 1) != 0) {
                FileSummaryLN ln = (FileSummaryLN)cursor.getCurrentLNAlreadyLatched(LockMode.DEFAULT);
                summary = ln.getBaseSummary();
                this.cacheFileSummary(fileNum, summary);
                FileSummary fileSummary = summary;
                return fileSummary;
            }
            FileSummary fileSummary = null;
            return fileSummary;
        }
        finally {
            if (cursor != null) {
                cursor.releaseBINs();
                cursor.close();
            }
            if (locker != null) {
                ((Locker)locker).operationEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized FileSummary putFileSummary(TrackedFileSummary trackedSummary) throws DatabaseException {
        FileSummary fileSummary;
        if (this.env.isReadOnly()) {
            throw new DatabaseException("Cannot write file summary in a read-only environment");
        }
        if (trackedSummary.isEmpty()) {
            return null;
        }
        boolean opened = this.openFileSummaryDatabase();
        if (!$assertionsDisabled && !opened) {
            throw new AssertionError();
        }
        long fileNum = trackedSummary.getFileNumber();
        Long fileNumLong = new Long(fileNum);
        byte[] keyBytes = FileSummaryLN.fileNumberToBytes(fileNum);
        int oldTotalSize = 0;
        FileSummary oldSummary = (FileSummary)this.fileSummaryMap.get(fileNumLong);
        if (oldSummary != null) {
            oldTotalSize = oldSummary.totalSize;
        }
        BasicLocker locker = null;
        CursorImpl cursor = null;
        try {
            FileSummaryLN ln;
            block15: {
                locker = new BasicLocker(this.env);
                ln = null;
                try {
                    cursor = new CursorImpl(this.fileSummaryDb, locker);
                    DatabaseEntry keyEntry = new DatabaseEntry(keyBytes);
                    int result = cursor.searchAndPosition(keyEntry, new DatabaseEntry(), CursorImpl.SearchMode.SET, null);
                    if ((result & 1) != 0) {
                        ln = (FileSummaryLN)cursor.getCurrentLNAlreadyLatched(LockMode.DEFAULT);
                        ln.setTrackedSummary(trackedSummary);
                        DatabaseEntry dataDbt = new DatabaseEntry(new byte[0]);
                        cursor.putCurrent(dataDbt, null, null);
                    }
                }
                finally {
                    if (cursor != null) {
                        cursor.releaseBINs();
                        cursor.close();
                        cursor = null;
                    }
                }
                if (ln == null) {
                    try {
                        cursor = new CursorImpl(this.fileSummaryDb, locker);
                        ln = new FileSummaryLN(new FileSummary());
                        ln.setTrackedSummary(trackedSummary);
                        cursor.releaseBINs();
                        cursor.putLN(new Key(keyBytes), ln, false);
                        fileSummary = null;
                        if (cursor == null) break block15;
                    }
                    catch (Throwable throwable) {
                        Object var17_16 = null;
                        if (cursor == null) throw throwable;
                        cursor.close();
                        cursor = null;
                        throw throwable;
                    }
                    cursor.close();
                    cursor = null;
                }
            }
            FileSummary summary = ln.getBaseSummary();
            this.fileSummaryMap.put(fileNumLong, summary);
            this.totalLogSize -= (long)oldTotalSize;
            this.totalLogSize += (long)summary.totalSize;
            fileSummary = summary;
            Object var19_19 = null;
            if (locker == null) return fileSummary;
        }
        catch (Throwable throwable) {
            Object var19_20 = null;
            if (locker == null) throw throwable;
            ((Locker)locker).operationEnd();
            throw throwable;
        }
        ((Locker)locker).operationEnd();
        return fileSummary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean openFileSummaryDatabase() throws DatabaseException {
        boolean bl;
        boolean operationOk;
        AutoTxn autoTxn;
        block6: {
            boolean bl2;
            block5: {
                if (this.fileSummaryDb != null) {
                    return true;
                }
                DbTree dbTree = this.env.getDbMapTree();
                autoTxn = null;
                operationOk = false;
                try {
                    autoTxn = new AutoTxn(this.env, new TransactionConfig());
                    DatabaseImpl db = dbTree.getDb(autoTxn, "_jeUtilization", null);
                    if (db == null) {
                        if (this.env.isReadOnly()) {
                            bl2 = false;
                            Object var7_7 = null;
                            if (autoTxn == null) return bl2;
                            break block5;
                        }
                        db = dbTree.createDb(autoTxn, "_jeUtilization", new DatabaseConfig(), null);
                    }
                    this.fileSummaryDb = db;
                    operationOk = true;
                    bl = true;
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (autoTxn == null) throw throwable;
                    ((Locker)autoTxn).operationEnd(operationOk);
                    throw throwable;
                }
            }
            ((Locker)autoTxn).operationEnd(operationOk);
            return bl2;
        }
        Object var7_8 = null;
        if (autoTxn == null) return bl;
        ((Locker)autoTxn).operationEnd(operationOk);
        return bl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sleepycat$je$cleaner$UtilizationProfile == null ? (class$com$sleepycat$je$cleaner$UtilizationProfile = UtilizationProfile.class$("com.sleepycat.je.cleaner.UtilizationProfile")) : class$com$sleepycat$je$cleaner$UtilizationProfile).desiredAssertionStatus();
    }
}

