/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.FileRetryInfo;
import com.sleepycat.je.cleaner.FileSelector;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.cleaner.UtilizationSelector;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.EnvironmentStatsInternal;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.CleanerFileReader;
import com.sleepycat.je.log.LogFileNotFoundException;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.recovery.Checkpointer;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DaemonThread;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.PropUtil;
import com.sleepycat.je.utilint.Tracer;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Cleaner
extends DaemonThread {
    private static final String CLEAN_IN = "CleanIN:";
    private static final String CLEAN_LN = "CleanLN:";
    private static final String CLEAN_DELTA = "CleanDelta:";
    private EnvironmentImpl env;
    private long lockTimeout;
    private int nCleanerRuns = 0;
    private int nINsCleaned = 0;
    private int nINsMigrated = 0;
    private int nLNsCleaned = 0;
    private int nLNsDead = 0;
    private int nLNsLocked = 0;
    private int nLNsMigrated = 0;
    private int nDeltasCleaned = 0;
    private int nINsCleanedThisRun = 0;
    private int nINsMigratedThisRun = 0;
    private int nLNsCleanedThisRun = 0;
    private int nLNsDeadThisRun = 0;
    private int nLNsLockedThisRun = 0;
    private int nLNsMigratedThisRun = 0;
    private int nDeltasCleanedThisRun = 0;
    private int nEntriesReadThisRun;
    private boolean expunge = false;
    private long maxDiskSpace;
    private long diskSpaceTolerance;
    private FileSelector fileSelector;
    private UtilizationProfile profile;
    private Level detailedTraceLevel;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sleepycat$je$cleaner$Cleaner;

    public Cleaner(EnvironmentImpl env, long waitTime, String name, UtilizationProfile profile) throws DatabaseException {
        super(waitTime, name, env);
        this.env = env;
        this.profile = profile;
        this.setName("Cleaner Thread");
        this.maxDiskSpace = env.getConfigManager().getLong(EnvironmentParams.MAX_DISK_SPACE);
        this.lockTimeout = PropUtil.microsToMillis(env.getConfigManager().getLong(EnvironmentParams.CLEANER_LOCK_TIMEOUT));
        this.expunge = env.getConfigManager().getBoolean(EnvironmentParams.CLEANER_REMOVE);
        int diskTolerancePct = env.getConfigManager().getInt(EnvironmentParams.CLEANER_DISK_SPACE_TOLERANCE);
        this.diskSpaceTolerance = this.maxDiskSpace * (long)diskTolerancePct / 100L;
        this.fileSelector = new UtilizationSelector(env, profile);
        this.detailedTraceLevel = Tracer.parseLevel(env, EnvironmentParams.JE_LOGGING_LEVEL_CLEANER);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<Cleaner name=\"").append(this.name).append("\"/>");
        return sb.toString();
    }

    public void addToQueue(Object o) throws DatabaseException {
        throw new DatabaseException("Cleaner.addToQueue should never be called.");
    }

    public void loadStats(StatsConfig config, EnvironmentStatsInternal stat) throws DatabaseException {
        stat.setNCleanerRuns(this.nCleanerRuns);
        stat.setNINsCleaned(this.nINsCleaned);
        stat.setNINsMigrated(this.nINsMigrated);
        stat.setNLNsCleaned(this.nLNsCleaned);
        stat.setNLNsDead(this.nLNsDead);
        stat.setNLNsLocked(this.nLNsLocked);
        stat.setNLNsMigrated(this.nLNsMigrated);
        stat.setNDeltasCleaned(this.nDeltasCleaned);
        if (config.getClear()) {
            this.nCleanerRuns = 0;
            this.nINsCleaned = 0;
            this.nINsMigrated = 0;
            this.nLNsCleaned = 0;
            this.nLNsDead = 0;
            this.nLNsLocked = 0;
            this.nLNsMigrated = 0;
            this.nDeltasCleaned = 0;
        }
    }

    public void clearEnv() {
        this.env = null;
    }

    protected int nDeadlockRetries() throws DatabaseException {
        return this.env.getConfigManager().getInt(EnvironmentParams.CLEANER_DEADLOCK_RETRY);
    }

    private boolean interruptCleaning() {
        return false;
    }

    public void onWakeup() throws DatabaseException {
        this.doClean(true, true, false);
    }

    public synchronized int doClean(boolean invokedFromDaemon, boolean cleanMultipleFiles, boolean forceAggressive) throws DatabaseException {
        FileRetryInfo fileRetryInfo;
        if (this.env.isClosed()) {
            return 0;
        }
        int nFilesCleaned = 0;
        while (!this.isShutdownRequested() && (fileRetryInfo = this.fileSelector.getFileToClean(forceAggressive || this.isNearDiskBudget(true))) != null && this.env.getFileManager().lockEnvironment(false, true)) {
            boolean canDeleteFile;
            Long fileNum;
            boolean finished;
            block15: {
                this.resetPerRunCounters();
                finished = false;
                fileNum = null;
                long fileNumValue = 0L;
                canDeleteFile = false;
                try {
                    DbLsn startLsn;
                    DbConfigManager cm;
                    int readBufferSize;
                    CleanerFileReader cleanerFileReader;
                    ++this.nCleanerRuns;
                    if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
                        throw new AssertionError();
                    }
                    fileNum = fileRetryInfo.getFileNumber();
                    fileNumValue = fileNum;
                    Tracer.trace(Level.INFO, this.env, "CleanerRun " + this.nCleanerRuns + " on file " + (fileNum == null ? "none" : "0x" + Long.toHexString(fileNumValue)) + " begins");
                    boolean anyProgress = false;
                    DbLsn[] pendingLsns = fileRetryInfo.getPendingLsns();
                    if (pendingLsns != null && this.processPending(pendingLsns, fileRetryInfo)) {
                        anyProgress = true;
                    }
                    if (!fileRetryInfo.isFileFullyProcessed() && this.processFile(cleanerFileReader = new CleanerFileReader(this.env, readBufferSize = (cm = this.env.getConfigManager()).getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE), startLsn = fileRetryInfo.getFirstUnprocessedLsn(), fileNum), fileRetryInfo)) {
                        anyProgress = true;
                    }
                    if (anyProgress || fileRetryInfo.canFileBeDeleted()) {
                        Checkpointer checkpointer = this.env.getCheckpointer();
                        if (checkpointer != null) {
                            CheckpointConfig config = new CheckpointConfig();
                            config.setForce(true);
                            checkpointer.doCheckpoint(config, false, true, "cleaner");
                        } else {
                            throw new DatabaseException("checkpointer not found, but cleaner is running");
                        }
                    }
                    if (fileRetryInfo.canFileBeDeleted()) {
                        if (this.expunge) {
                            this.env.getFileManager().deleteFile(fileNumValue);
                        } else {
                            this.env.getFileManager().renameFile(fileNumValue, ".del");
                        }
                        this.profile.removeFile(fileNum);
                        canDeleteFile = true;
                        ++nFilesCleaned;
                    }
                    this.accumulatePerRunCounters();
                    finished = true;
                    if (cleanMultipleFiles) break block15;
                    fileRetryInfo.endProcessing(canDeleteFile);
                }
                catch (IOException IOE) {
                    try {
                        Tracer.trace(this.env, "Cleaner", "doClean", "", IOE);
                        throw new DatabaseException(IOE);
                    }
                    catch (Throwable throwable) {
                        fileRetryInfo.endProcessing(canDeleteFile);
                        this.env.getFileManager().releaseExclusiveLock();
                        Tracer.trace(Level.SEVERE, this.env, "CleanerRun " + this.nCleanerRuns + " on file " + (fileNum == null ? "none" : "0x" + Long.toHexString(fileNum)) + " invokedFromDaemon=" + invokedFromDaemon + " finished=" + finished + " canDelete=" + canDeleteFile + " nEntriesRead=" + this.nEntriesReadThisRun + " nINsCleaned=" + this.nINsCleanedThisRun + " nINsMigrated=" + this.nINsMigratedThisRun + " nLNsCleaned=" + this.nLNsCleanedThisRun + " nLNsDead=" + this.nLNsDeadThisRun + " nLNsMigrated=" + this.nLNsMigratedThisRun + " nLNsLocked=" + this.nLNsLockedThisRun + " nDeltasCleaned= " + this.nDeltasCleanedThisRun);
                        throw throwable;
                    }
                }
                this.env.getFileManager().releaseExclusiveLock();
                Tracer.trace(Level.SEVERE, this.env, "CleanerRun " + this.nCleanerRuns + " on file " + (fileNum == null ? "none" : "0x" + Long.toHexString(fileNum)) + " invokedFromDaemon=" + invokedFromDaemon + " finished=" + finished + " canDelete=" + canDeleteFile + " nEntriesRead=" + this.nEntriesReadThisRun + " nINsCleaned=" + this.nINsCleanedThisRun + " nINsMigrated=" + this.nINsMigratedThisRun + " nLNsCleaned=" + this.nLNsCleanedThisRun + " nLNsDead=" + this.nLNsDeadThisRun + " nLNsMigrated=" + this.nLNsMigratedThisRun + " nLNsLocked=" + this.nLNsLockedThisRun + " nDeltasCleaned= " + this.nDeltasCleanedThisRun);
                break;
            }
            fileRetryInfo.endProcessing(canDeleteFile);
            this.env.getFileManager().releaseExclusiveLock();
            Tracer.trace(Level.SEVERE, this.env, "CleanerRun " + this.nCleanerRuns + " on file " + (fileNum == null ? "none" : "0x" + Long.toHexString(fileNum)) + " invokedFromDaemon=" + invokedFromDaemon + " finished=" + finished + " canDelete=" + canDeleteFile + " nEntriesRead=" + this.nEntriesReadThisRun + " nINsCleaned=" + this.nINsCleanedThisRun + " nINsMigrated=" + this.nINsMigratedThisRun + " nLNsCleaned=" + this.nLNsCleanedThisRun + " nLNsDead=" + this.nLNsDeadThisRun + " nLNsMigrated=" + this.nLNsMigratedThisRun + " nLNsLocked=" + this.nLNsLockedThisRun + " nDeltasCleaned= " + this.nDeltasCleanedThisRun);
        }
        return nFilesCleaned;
    }

    public boolean isNearDiskBudget(boolean calcIfNecessary) throws DatabaseException {
        long size = this.profile.getTotalLogSize(calcIfNecessary);
        return size < 0L || this.maxDiskSpace < size || this.maxDiskSpace - size <= this.diskSpaceTolerance;
    }

    private boolean processPending(DbLsn[] pendingLsns, FileRetryInfo fileRetryInfo) throws DatabaseException, IOException {
        DbTree dbMapTree = this.env.getDbMapTree();
        TreeLocation location = new TreeLocation();
        LogManager logManager = this.env.getLogManager();
        boolean anyProgress = false;
        int i = 0;
        while (i < pendingLsns.length) {
            DbLsn lsn = pendingLsns[i];
            if (this.interruptCleaning()) break;
            LogEntry entry = logManager.getLogEntry(lsn);
            if (entry instanceof LNLogEntry) {
                LNLogEntry lnEntry = (LNLogEntry)entry;
                LN targetLN = lnEntry.getLN();
                long nodeId = targetLN.getNodeId();
                DatabaseId dbId = lnEntry.getDbId();
                Key key = lnEntry.getKey();
                Key dupKey = lnEntry.getDupKey();
                DatabaseImpl db = dbMapTree.getDb(dbId, this.lockTimeout);
                if (this.processLN(targetLN, db, key, dupKey, lsn, location)) {
                    fileRetryInfo.setObsoleteLN(lsn, nodeId);
                    anyProgress = true;
                }
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)entry.getClass().getName());
            }
            ++i;
        }
        return anyProgress;
    }

    private boolean processFile(CleanerFileReader reader, FileRetryInfo fileRetryInfo) throws DatabaseException, IOException {
        DbTree dbMapTree = this.env.getDbMapTree();
        TreeLocation location = new TreeLocation();
        boolean anyProgress = false;
        boolean interrupted = false;
        while (reader.readNextEntry()) {
            DbLsn lsn = reader.getLastLsn();
            fileRetryInfo.setFirstUnprocessedLsn(lsn);
            if (this.interruptCleaning()) {
                interrupted = true;
                break;
            }
            if (reader.isLN()) {
                LN targetLN = reader.getLN();
                long nodeId = targetLN.getNodeId();
                if (fileRetryInfo.isObsoleteLN(lsn, nodeId)) continue;
                DatabaseId dbId = reader.getDatabaseId();
                Key key = reader.getKey();
                Key dupKey = reader.getDupTreeKey();
                DatabaseImpl db = dbMapTree.getDb(dbId, this.lockTimeout);
                if (this.processLN(targetLN, db, key, dupKey, lsn, location)) {
                    fileRetryInfo.setObsoleteLN(lsn, nodeId);
                    anyProgress = true;
                    continue;
                }
                fileRetryInfo.setPendingLN(lsn, nodeId);
                continue;
            }
            if (reader.isIN()) {
                IN targetIN = reader.getIN();
                DatabaseId dbId = reader.getDatabaseId();
                DatabaseImpl db = dbMapTree.getDb(dbId, this.lockTimeout);
                targetIN.setDatabase(db);
                this.processIN(targetIN, db, lsn);
                anyProgress = true;
                continue;
            }
            if (reader.isRoot()) {
                this.env.rewriteMapTreeRoot(lsn);
                anyProgress = true;
                continue;
            }
            if (!reader.isDelta()) continue;
            DatabaseId dbId = reader.getDatabaseId();
            DatabaseImpl db = dbMapTree.getDb(dbId, this.lockTimeout);
            this.processDelta(reader, db, lsn);
            anyProgress = true;
        }
        if (!interrupted) {
            fileRetryInfo.setFileFullyProcessed();
        }
        this.nEntriesReadThisRun = reader.getNumRead();
        return anyProgress;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processLN(LN lnClone, DatabaseImpl db, Key key, Key dupKey, DbLsn logLsn, TreeLocation location) throws DatabaseException {
        boolean bl;
        boolean insPinned;
        DIN parentDIN;
        BasicLocker locker;
        boolean completed;
        boolean migrated;
        boolean obsolete;
        block34: {
            boolean bl2;
            block32: {
                boolean bl3;
                block31: {
                    obsolete = false;
                    migrated = false;
                    completed = false;
                    locker = null;
                    parentDIN = null;
                    insPinned = false;
                    try {
                        if (db == null || db.getIsDeleted()) {
                            obsolete = true;
                            completed = true;
                            boolean bl4 = true;
                            return bl4;
                        }
                        boolean cleaned = true;
                        ++this.nLNsCleanedThisRun;
                        Tree tree = db.getTree();
                        if (!$assertionsDisabled && tree == null) {
                            throw new AssertionError();
                        }
                        boolean found = tree.getParentBINForChildLN(location, key, dupKey, lnClone, false, false, false);
                        boolean lnIsDupCountLN = lnClone.containsDuplicates();
                        if (!found) {
                            obsolete = true;
                            ++this.nLNsDeadThisRun;
                            completed = true;
                            boolean bl5 = cleaned;
                            return bl5;
                        }
                        ChildReference ref = null;
                        IN lnParent = null;
                        if (lnIsDupCountLN) {
                            parentDIN = (DIN)location.bin.getEntry(location.index).fetchTarget(db, location.bin);
                            parentDIN.latch();
                            ref = parentDIN.getDupCountLNRef();
                            lnParent = parentDIN;
                        } else {
                            ref = location.bin.getEntry(location.index);
                            lnParent = location.bin;
                        }
                        if (ref.isKnownDeleted()) {
                            ++this.nLNsDeadThisRun;
                            obsolete = true;
                            completed = true;
                            bl3 = cleaned;
                            this.unPinAndRelease(parentDIN, insPinned);
                            break block31;
                        }
                        LN lnInTree = (LN)ref.fetchTarget(db, lnParent);
                        insPinned = true;
                        if (lnIsDupCountLN) {
                            parentDIN.setEvictionProhibited(true);
                            parentDIN.releaseLatch();
                        }
                        location.bin.setEvictionProhibited(true);
                        location.bin.releaseLatch();
                        locker = new BasicLocker(this.env);
                        locker.setLockTimeout(this.lockTimeout);
                        LockGrantType lock = locker.nonBlockingReadLock(lnInTree);
                        if (lock == LockGrantType.DENIED) {
                            DbLsn abortLsn = locker.getOwnerAbortLsn(lnInTree.getNodeId());
                            if (abortLsn != null && abortLsn != DbLsn.NULL_LSN && abortLsn.compareTo(logLsn) > 0) {
                                ++this.nLNsDeadThisRun;
                                obsolete = true;
                            } else {
                                ++this.nLNsLockedThisRun;
                                cleaned = false;
                            }
                            completed = true;
                            bl2 = cleaned;
                            this.unPinAndRelease(parentDIN, insPinned);
                            break block32;
                        }
                        location.bin.latch();
                        location.bin.setEvictionProhibited(false);
                        ChildReference newRef = null;
                        if (lnIsDupCountLN) {
                            parentDIN = (DIN)location.bin.getEntry(location.index).fetchTarget(db, location.bin);
                            parentDIN.latch();
                            newRef = parentDIN.getDupCountLNRef();
                            parentDIN.setEvictionProhibited(false);
                        } else {
                            newRef = location.bin.getEntry(location.index);
                        }
                        insPinned = false;
                        if (newRef.getTarget() == lnInTree) {
                            if (newRef.getLsn().equals(logLsn)) {
                                DbLsn newLNLsn = this.migrateLN(lnInTree, db, key, logLsn, locker);
                                if (lnIsDupCountLN) {
                                    parentDIN.updateDupCountLNRef(newLNLsn);
                                } else {
                                    location.bin.updateEntry(location.index, newLNLsn);
                                }
                                migrated = true;
                            } else {
                                ++this.nLNsDeadThisRun;
                                obsolete = true;
                            }
                        } else {
                            cleaned = false;
                        }
                        completed = true;
                        bl = cleaned;
                        this.unPinAndRelease(parentDIN, insPinned);
                        break block34;
                    }
                    catch (DatabaseException DBE) {
                        DBE.printStackTrace();
                        Tracer.trace(this.env, "com.sleepycat.je.cleaner.Cleaner", "processLN", "Exception thrown: ", DBE);
                        throw DBE;
                    }
                }
                this.unPinAndRelease(location.bin, insPinned);
                if (locker != null) {
                    locker.operationEnd();
                }
                this.trace(this.detailedTraceLevel, CLEAN_LN, lnClone, logLsn, completed, obsolete, migrated);
                return bl3;
            }
            this.unPinAndRelease(location.bin, insPinned);
            if (locker != null) {
                locker.operationEnd();
            }
            this.trace(this.detailedTraceLevel, CLEAN_LN, lnClone, logLsn, completed, obsolete, migrated);
            return bl2;
        }
        this.unPinAndRelease(location.bin, insPinned);
        if (locker != null) {
            locker.operationEnd();
        }
        this.trace(this.detailedTraceLevel, CLEAN_LN, lnClone, logLsn, completed, obsolete, migrated);
        return bl;
        finally {
            this.unPinAndRelease(parentDIN, insPinned);
            this.unPinAndRelease(location.bin, insPinned);
            if (locker != null) {
                locker.operationEnd();
            }
            this.trace(this.detailedTraceLevel, CLEAN_LN, lnClone, logLsn, completed, obsolete, migrated);
        }
    }

    private void unPinAndRelease(IN in, boolean isPinned) throws DatabaseException {
        if (in != null) {
            if (isPinned) {
                if (!in.getLatch().isOwner()) {
                    in.latch();
                }
                in.setEvictionProhibited(false);
                in.releaseLatch();
            } else if (in.getLatch().isOwner()) {
                in.releaseLatch();
            }
        }
    }

    private DbLsn migrateLN(LN ln, DatabaseImpl db, Key key, DbLsn oldLsn, Locker locker) throws DatabaseException {
        DbLsn newLsn = ln.log(this.env, db.getId(), key, oldLsn, locker);
        ++this.nLNsMigratedThisRun;
        return newLsn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIN(IN inClone, DatabaseImpl db, DbLsn lsn) throws DatabaseException {
        boolean obsolete = false;
        boolean dirtied = false;
        boolean completed = false;
        try {
            if (db == null || db.getIsDeleted()) {
                obsolete = true;
                completed = true;
                Object var10_7 = null;
                this.trace(this.detailedTraceLevel, CLEAN_IN, inClone, lsn, completed, obsolete, dirtied);
                return;
            }
            Tree tree = db.getTree();
            if (!$assertionsDisabled && tree == null) {
                throw new AssertionError();
            }
            IN inInTree = this.findINInTree(tree, db, inClone, lsn);
            if (inInTree == null) {
                ++this.nINsCleanedThisRun;
                obsolete = true;
            } else {
                ++this.nINsMigratedThisRun;
                inInTree.setDirty(true);
                inInTree.releaseLatch();
                dirtied = true;
            }
            completed = true;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.trace(this.detailedTraceLevel, CLEAN_IN, inClone, lsn, completed, obsolete, dirtied);
            throw throwable;
        }
        Object var10_8 = null;
        this.trace(this.detailedTraceLevel, CLEAN_IN, inClone, lsn, completed, obsolete, dirtied);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN findINInTree(Tree tree, DatabaseImpl db, IN inClone, DbLsn lsn) throws DatabaseException {
        IN iN;
        block10: {
            ChildReference ref;
            SearchResult result;
            block8: {
                IN iN2;
                block9: {
                    block6: {
                        IN iN3;
                        block7: {
                            if (inClone.isDbRoot()) {
                                IN rootIN = this.isRoot(tree, db, inClone, lsn);
                                if (rootIN == null) {
                                    return null;
                                }
                                return rootIN;
                            }
                            inClone.latch();
                            result = null;
                            try {
                                result = tree.getParentINForChildIN(inClone, true);
                                if (result.exactParentFound) break block6;
                                iN3 = null;
                                Object var11_9 = null;
                                if (result == null || !result.exactParentFound) break block7;
                            }
                            catch (Throwable throwable) {
                                block11: {
                                    Object var11_12 = null;
                                    if (result == null || !result.exactParentFound) break block11;
                                    result.parent.releaseLatch();
                                }
                                throw throwable;
                            }
                            result.parent.releaseLatch();
                        }
                        return iN3;
                    }
                    ref = result.parent.getEntry(result.index);
                    int compareVal = ref.getLsn().compareTo(lsn);
                    if (compareVal <= 0) break block8;
                    iN2 = null;
                    Object var11_10 = null;
                    if (result == null || !result.exactParentFound) break block9;
                    result.parent.releaseLatch();
                }
                return iN2;
            }
            IN in = (IN)ref.fetchTarget(db, result.parent);
            in.latch();
            iN = in;
            Object var11_11 = null;
            if (result == null || !result.exactParentFound) break block10;
            result.parent.releaseLatch();
        }
        return iN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDelta(CleanerFileReader cleanerReader, DatabaseImpl db, DbLsn lsn) throws DatabaseException {
        boolean obsolete = false;
        boolean dirtied = false;
        boolean completed = false;
        IN owningBIN = null;
        try {
            if (db == null || db.getIsDeleted()) {
                obsolete = true;
                completed = true;
                ++this.nDeltasCleanedThisRun;
                Object var11_8 = null;
                this.trace(this.detailedTraceLevel, CLEAN_DELTA, owningBIN, lsn, completed, obsolete, dirtied);
                return;
            }
            IN reconstructed = null;
            try {
                reconstructed = cleanerReader.getReconstructedIN();
            }
            catch (LogFileNotFoundException e) {
                obsolete = true;
                completed = true;
                ++this.nDeltasCleanedThisRun;
                Object var11_9 = null;
                this.trace(this.detailedTraceLevel, CLEAN_DELTA, owningBIN, lsn, completed, obsolete, dirtied);
                return;
            }
            if (reconstructed == null) {
                obsolete = true;
            } else {
                Tree tree = db.getTree();
                if (!$assertionsDisabled && tree == null) {
                    throw new AssertionError();
                }
                owningBIN = this.findDeltaInTree(tree, db, reconstructed, lsn);
                if (owningBIN == null) {
                    obsolete = true;
                } else {
                    ++this.nINsMigratedThisRun;
                    owningBIN.setDirty(true);
                    owningBIN.releaseLatch();
                    dirtied = true;
                }
            }
            ++this.nDeltasCleanedThisRun;
            completed = true;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.trace(this.detailedTraceLevel, CLEAN_DELTA, owningBIN, lsn, completed, obsolete, dirtied);
            throw throwable;
        }
        Object var11_10 = null;
        this.trace(this.detailedTraceLevel, CLEAN_DELTA, owningBIN, lsn, completed, obsolete, dirtied);
    }

    private IN findDeltaInTree(Tree tree, DatabaseImpl db, IN reconstructed, DbLsn lsn) throws DatabaseException {
        reconstructed.latch();
        SearchResult result = tree.getParentINForChildIN(reconstructed, true);
        if (!result.exactParentFound) {
            return null;
        }
        BIN binInTree = (BIN)result.parent.getEntry(result.index).fetchTarget(db, result.parent);
        binInTree.latch();
        result.parent.releaseLatch();
        DbLsn lastDeltaLsn = binInTree.getLastDeltaVersion();
        if (lastDeltaLsn != null && lastDeltaLsn.compareTo(lsn) <= 0) {
            return binInTree;
        }
        binInTree.releaseLatch();
        return null;
    }

    private IN isRoot(Tree tree, DatabaseImpl db, IN inClone, DbLsn lsn) throws DatabaseException {
        RootDoWork rdw = new RootDoWork(db, inClone, lsn);
        return tree.withRootLatched(rdw);
    }

    private void resetPerRunCounters() {
        this.nINsCleanedThisRun = 0;
        this.nINsMigratedThisRun = 0;
        this.nLNsCleanedThisRun = 0;
        this.nLNsDeadThisRun = 0;
        this.nLNsMigratedThisRun = 0;
        this.nLNsLockedThisRun = 0;
        this.nDeltasCleanedThisRun = 0;
        this.nEntriesReadThisRun = 0;
    }

    private void accumulatePerRunCounters() {
        this.nINsCleaned += this.nINsCleanedThisRun;
        this.nINsMigrated += this.nINsMigratedThisRun;
        this.nLNsCleaned += this.nLNsCleanedThisRun;
        this.nLNsDead += this.nLNsDeadThisRun;
        this.nLNsMigrated += this.nLNsMigratedThisRun;
        this.nLNsLocked += this.nLNsLockedThisRun;
        this.nDeltasCleaned += this.nDeltasCleanedThisRun;
    }

    private void trace(Level level, String action, Node node, DbLsn logLsn, boolean completed, boolean obsolete, boolean dirtiedMigrated) {
        Logger logger = this.env.getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(action);
            if (node != null) {
                sb.append(" node=");
                sb.append(node.getNodeId());
            }
            sb.append(" logLsn=");
            sb.append(logLsn.getNoFormatString());
            sb.append(" complete=").append(completed);
            sb.append(" obsolete=").append(obsolete);
            sb.append(" dirtiedOrMigrated=").append(dirtiedMigrated);
            logger.log(level, sb.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sleepycat$je$cleaner$Cleaner == null ? (class$com$sleepycat$je$cleaner$Cleaner = Cleaner.class$("com.sleepycat.je.cleaner.Cleaner")) : class$com$sleepycat$je$cleaner$Cleaner).desiredAssertionStatus();
    }

    private class RootDoWork
    implements WithRootLatched {
        private DatabaseImpl db;
        private IN inClone;
        private DbLsn lsn;

        RootDoWork(DatabaseImpl db, IN inClone, DbLsn lsn) {
            this.db = db;
            this.inClone = inClone;
            this.lsn = lsn;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            if (root == null || ((IN)root.fetchTarget(this.db, null)).getNodeId() != this.inClone.getNodeId()) {
                return null;
            }
            if (root.getLsn().compareTo(this.lsn) <= 0) {
                IN rootIN = (IN)root.fetchTarget(this.db, null);
                rootIN.latch();
                return rootIN;
            }
            return null;
        }
    }
}

