/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseUtil;
import com.sleepycat.je.Environment;
import com.sleepycat.je.ForeignKeyDeleteAction;
import com.sleepycat.je.ForeignKeyNullifier;
import com.sleepycat.je.ForeignKeyTrigger;
import com.sleepycat.je.JoinConfig;
import com.sleepycat.je.JoinCursor;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryCursor;
import com.sleepycat.je.SecondaryKeyCreator;
import com.sleepycat.je.SecondaryTrigger;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.dbi.PutMode;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.Tracer;
import java.util.logging.Level;

public class SecondaryDatabase
extends Database {
    private Database primaryDb;
    private SecondaryConfig secondaryConfig;
    private SecondaryTrigger secondaryTrigger;
    private ForeignKeyTrigger foreignKeyTrigger;

    SecondaryDatabase(Environment env, SecondaryConfig secConfig, Database primaryDatabase) throws DatabaseException {
        super(env);
        DatabaseUtil.checkForNullParam(primaryDatabase, "primaryDatabase");
        primaryDatabase.checkRequiredDbState(Database.OPEN, "Can't use as primary:");
        if (primaryDatabase.configuration.getSortedDuplicates()) {
            throw new IllegalArgumentException("Duplicates must not be allowed for a primary database: " + primaryDatabase.getDatabaseName());
        }
        if (env.getEnvironmentImpl() != primaryDatabase.getEnvironment().getEnvironmentImpl()) {
            throw new IllegalArgumentException("Primary and secondary databases must be in the same environment.");
        }
        if (!primaryDatabase.configuration.getReadOnly() && secConfig.getKeyCreator() == null) {
            throw new NullPointerException("secConfig and secConfig.getKeyCreator() may be null only if the primary database is read-only");
        }
        if (secConfig.getForeignKeyDatabase() != null && secConfig.getForeignKeyDeleteAction() == ForeignKeyDeleteAction.NULLIFY && secConfig.getForeignKeyNullifier() == null) {
            throw new IllegalArgumentException("ForeignKeyNullifier must be non-null when  ForeignKeyDeleteAction is NULLIFY.");
        }
        this.primaryDb = primaryDatabase;
        this.secondaryTrigger = new SecondaryTrigger(this);
        if (secConfig.getForeignKeyDatabase() != null) {
            this.foreignKeyTrigger = new ForeignKeyTrigger(this);
        }
    }

    void initNew(Environment env, Locker locker, String databaseName, DatabaseConfig dbConfig) throws DatabaseException {
        super.initNew(env, locker, databaseName, dbConfig);
        this.init(locker);
    }

    void initExisting(Environment env, Locker locker, DatabaseImpl database, DatabaseConfig dbConfig) throws DatabaseException {
        super.initExisting(env, locker, database, dbConfig);
        this.init(locker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Locker locker) throws DatabaseException {
        Tracer.trace(Level.FINEST, this.envHandle.getEnvironmentImpl(), "SecondaryDatabase open: name=" + this.getDatabaseName() + " primary=" + this.primaryDb.getDatabaseName());
        this.secondaryConfig = (SecondaryConfig)this.configuration;
        this.primaryDb.addTrigger(this.secondaryTrigger, false);
        Database foreignDb = this.secondaryConfig.getForeignKeyDatabase();
        if (foreignDb != null) {
            foreignDb.addTrigger(this.foreignKeyTrigger, true);
        }
        if (this.secondaryConfig.getAllowPopulate()) {
            Cursor secCursor = null;
            Cursor priCursor = null;
            try {
                secCursor = new Cursor((Database)this, locker, null);
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry data = new DatabaseEntry();
                OperationStatus status = secCursor.position(key, data, LockMode.DEFAULT, true);
                if (status == OperationStatus.NOTFOUND) {
                    priCursor = new Cursor(this.primaryDb, locker, null);
                    status = priCursor.position(key, data, LockMode.DEFAULT, true);
                    while (status == OperationStatus.SUCCESS) {
                        this.updateSecondary(locker, secCursor, key, null, data);
                        status = priCursor.retrieveNext(key, data, LockMode.DEFAULT, GetMode.NEXT);
                    }
                }
            }
            finally {
                if (secCursor != null) {
                    secCursor.close();
                }
                if (priCursor != null) {
                    priCursor.close();
                }
            }
        }
    }

    public synchronized void close() throws DatabaseException {
        Database foreignDb;
        if (this.primaryDb != null && this.secondaryTrigger != null) {
            this.primaryDb.removeTrigger(this.secondaryTrigger);
        }
        if ((foreignDb = this.secondaryConfig.getForeignKeyDatabase()) != null && this.foreignKeyTrigger != null) {
            foreignDb.removeTrigger(this.foreignKeyTrigger);
        }
        super.close();
    }

    void clearPrimary() {
        this.primaryDb = null;
        this.secondaryTrigger = null;
    }

    void clearForeignKeyTrigger() {
        this.foreignKeyTrigger = null;
    }

    public Database getPrimaryDatabase() throws DatabaseException {
        return this.primaryDb;
    }

    public SecondaryConfig getSecondaryConfig() throws DatabaseException {
        return (SecondaryConfig)this.getConfig();
    }

    public SecondaryCursor openSecondaryCursor(Transaction txn, CursorConfig cursorConfig) throws DatabaseException {
        return (SecondaryCursor)this.openCursor(txn, cursorConfig);
    }

    Cursor newDbcInstance(Transaction txn, CursorConfig cursorConfig) throws DatabaseException {
        return new SecondaryCursor(this, txn, cursorConfig, this.secondaryConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus delete(Transaction txn, DatabaseEntry key) throws DatabaseException {
        this.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", true);
        this.checkRequiredDbState(Database.OPEN, "Can't call SecondaryDatabase.delete:");
        this.trace(Level.FINEST, "SecondaryDatabase.delete", txn, key, null, null);
        Locker locker = null;
        Cursor cursor = null;
        OperationStatus commitStatus = OperationStatus.NOTFOUND;
        try {
            locker = DatabaseUtil.getWritableLocker(this.envHandle, txn, this.isTransactional());
            cursor = new Cursor((Database)this, locker, null);
            DatabaseEntry pKey = new DatabaseEntry();
            OperationStatus searchStatus = cursor.search(key, pKey, LockMode.RMW, CursorImpl.SearchMode.SET);
            if (searchStatus == OperationStatus.SUCCESS) {
                commitStatus = this.primaryDb.deleteInternal(locker, pKey);
            }
            OperationStatus operationStatus = commitStatus;
            return operationStatus;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (locker != null) {
                locker.operationEnd(commitStatus);
            }
        }
    }

    public OperationStatus get(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.get(txn, key, new DatabaseEntry(), data, lockMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus get(Transaction txn, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        OperationStatus operationStatus;
        block2: {
            this.checkEnv();
            DatabaseUtil.checkForNullDbt(key, "key", true);
            DatabaseUtil.checkForNullDbt(pKey, "pKey", false);
            DatabaseUtil.checkForNullDbt(data, "data", false);
            this.checkRequiredDbState(Database.OPEN, "Can't call SecondaryDatabase.get:");
            this.trace(Level.FINEST, "SecondaryDatabase.get", txn, key, null, lockMode);
            SecondaryCursor cursor = null;
            try {
                cursor = new SecondaryCursor(this, txn, CursorConfig.DEFAULT, this.secondaryConfig);
                operationStatus = cursor.search(key, pKey, data, lockMode, CursorImpl.SearchMode.SET);
                Object var9_8 = null;
                if (cursor == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var9_9 = null;
                    if (cursor == null) break block3;
                    cursor.close();
                }
                throw throwable;
            }
            cursor.close();
        }
        return operationStatus;
    }

    public OperationStatus getSearchBoth(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        throw SecondaryDatabase.notAllowedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getSearchBoth(Transaction txn, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        OperationStatus operationStatus;
        block2: {
            this.checkEnv();
            DatabaseUtil.checkForNullDbt(key, "key", true);
            DatabaseUtil.checkForNullDbt(pKey, "pKey", true);
            DatabaseUtil.checkForNullDbt(data, "data", true);
            this.checkRequiredDbState(Database.OPEN, "Can't call SecondaryDatabase.getSearchBoth:");
            this.trace(Level.FINEST, "SecondaryDatabase.getSearchBoth", txn, key, data, lockMode);
            SecondaryCursor cursor = null;
            try {
                cursor = new SecondaryCursor(this, txn, CursorConfig.DEFAULT, this.secondaryConfig);
                operationStatus = cursor.search(key, pKey, data, lockMode, CursorImpl.SearchMode.BOTH);
                Object var9_8 = null;
                if (cursor == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var9_9 = null;
                    if (cursor == null) break block3;
                    cursor.close();
                }
                throw throwable;
            }
            cursor.close();
        }
        return operationStatus;
    }

    public OperationStatus put(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        throw SecondaryDatabase.notAllowedException();
    }

    public OperationStatus putNoOverwrite(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        throw SecondaryDatabase.notAllowedException();
    }

    public OperationStatus putNoDupData(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        throw SecondaryDatabase.notAllowedException();
    }

    public JoinCursor join(Cursor[] cursors, JoinConfig config) throws DatabaseException {
        throw SecondaryDatabase.notAllowedException();
    }

    public int truncate(Transaction txn, boolean countRecords) throws DatabaseException {
        throw SecondaryDatabase.notAllowedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void updateSecondary(Locker locker, Cursor cursor, DatabaseEntry priKey, DatabaseEntry oldData, DatabaseEntry newData) throws DatabaseException {
        boolean localCursor;
        SecondaryKeyCreator keyCreator = this.secondaryConfig.getKeyCreator();
        DatabaseEntry oldSecKey = null;
        if (oldData != null && !keyCreator.createSecondaryKey(this, priKey, oldData, oldSecKey = new DatabaseEntry())) {
            oldSecKey = null;
        }
        DatabaseEntry newSecKey = null;
        if (newData != null && !keyCreator.createSecondaryKey(this, priKey, newData, newSecKey = new DatabaseEntry())) {
            newSecKey = null;
        }
        if (oldSecKey == null || oldSecKey.dataEquals(newSecKey)) {
            if (newSecKey == null) return;
            if (newSecKey.dataEquals(oldSecKey)) return;
        }
        boolean bl = localCursor = cursor == null;
        if (localCursor) {
            cursor = new Cursor((Database)this, locker, null);
        }
        try {
            if (newSecKey != null) {
                OperationStatus status;
                DatabaseEntry tmpData;
                block18: {
                    Database foreignDb = this.secondaryConfig.getForeignKeyDatabase();
                    if (foreignDb != null) {
                        Cursor foreignCursor = null;
                        try {
                            foreignCursor = new Cursor(foreignDb, locker, null);
                            tmpData = new DatabaseEntry();
                            OperationStatus status2 = foreignCursor.search(newSecKey, tmpData, LockMode.DEFAULT, CursorImpl.SearchMode.SET);
                            if (status2 != OperationStatus.SUCCESS) {
                                throw new DatabaseException("Secondary " + this.getDatabaseName() + " foreign key not allowed: it is not" + " present in the foreign database");
                            }
                            Object var15_14 = null;
                            if (foreignCursor == null) break block18;
                        }
                        catch (Throwable throwable) {
                            Object var15_15 = null;
                            if (foreignCursor == null) throw throwable;
                            foreignCursor.close();
                            throw throwable;
                        }
                        foreignCursor.close();
                    }
                }
                if (this.getConfig().getSortedDuplicates()) {
                    status = cursor.putInternal(newSecKey, priKey, PutMode.NODUP);
                } else {
                    tmpData = new DatabaseEntry();
                    status = cursor.search(newSecKey, tmpData, LockMode.DEFAULT, CursorImpl.SearchMode.SET);
                    if (status == OperationStatus.SUCCESS) {
                        status = OperationStatus.KEYEXIST;
                    } else if (status == OperationStatus.NOTFOUND) {
                        status = cursor.putInternal(newSecKey, priKey, PutMode.NOOVERWRITE);
                    }
                }
                if (status != OperationStatus.SUCCESS) {
                    throw new DatabaseException("Could not insert secondary key in " + this.getDatabaseName() + ' ' + status);
                }
            }
            if (oldSecKey != null) {
                OperationStatus status = cursor.search(oldSecKey, priKey, LockMode.DEFAULT, CursorImpl.SearchMode.BOTH);
                if (status != OperationStatus.SUCCESS) throw new DatabaseException("Secondary " + this.getDatabaseName() + " is corrupt: the primary record contains a key" + " that is not present in the secondary");
                cursor.deleteInternal();
            }
            Object var17_17 = null;
            if (!localCursor) return;
            if (cursor == null) return;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            if (!localCursor) throw throwable;
            if (cursor == null) throw throwable;
            cursor.close();
            throw throwable;
        }
        cursor.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void onForeignKeyDelete(Locker locker, DatabaseEntry secKey) throws DatabaseException {
        Cursor priCursor;
        OperationStatus status;
        DatabaseEntry priKey;
        block10: {
            priKey = new DatabaseEntry();
            Cursor cursor = null;
            try {
                cursor = new Cursor((Database)this, locker, null);
                status = cursor.search(secKey, priKey, LockMode.DEFAULT, CursorImpl.SearchMode.SET);
                Object var7_6 = null;
                if (cursor == null) break block10;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (cursor == null) throw throwable;
                cursor.close();
                throw throwable;
            }
            cursor.close();
        }
        if (status != OperationStatus.SUCCESS) {
            return;
        }
        ForeignKeyDeleteAction deleteAction = this.secondaryConfig.getForeignKeyDeleteAction();
        if (deleteAction == ForeignKeyDeleteAction.ABORT) {
            throw new DatabaseException("Secondary " + this.getDatabaseName() + " refers to a foreign" + " key that has been deleted (ForeignKeyDeleteAction.ABORT)");
        }
        if (deleteAction == ForeignKeyDeleteAction.CASCADE) {
            priCursor = null;
            try {
                DatabaseEntry data = new DatabaseEntry();
                priCursor = new Cursor(this.primaryDb, locker, null);
                status = priCursor.search(priKey, data, LockMode.RMW, CursorImpl.SearchMode.SET);
                if (status != OperationStatus.SUCCESS) throw this.secondaryCorruptException();
                priCursor.delete();
                Object var10_12 = null;
                if (priCursor == null) return;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (priCursor == null) throw throwable;
                priCursor.close();
                throw throwable;
            }
            priCursor.close();
            return;
        }
        if (deleteAction != ForeignKeyDeleteAction.NULLIFY) throw new IllegalStateException();
        priCursor = null;
        try {
            DatabaseEntry data = new DatabaseEntry();
            priCursor = new Cursor(this.primaryDb, locker, null);
            status = priCursor.search(priKey, data, LockMode.RMW, CursorImpl.SearchMode.SET);
            if (status != OperationStatus.SUCCESS) throw this.secondaryCorruptException();
            ForeignKeyNullifier nullifier = this.secondaryConfig.getForeignKeyNullifier();
            if (nullifier.nullifyForeignKey(this, data)) {
                priCursor.putCurrent(data);
            }
            Object var12_16 = null;
            if (priCursor == null) return;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (priCursor == null) throw throwable;
            priCursor.close();
            throw throwable;
        }
        priCursor.close();
    }

    DatabaseException secondaryCorruptException() throws DatabaseException {
        throw new DatabaseException("Secondary " + this.getDatabaseName() + " is corrupt: it refers" + " to a missing key in the primary database");
    }

    static UnsupportedOperationException notAllowedException() {
        throw new UnsupportedOperationException("Operation not allowed on a secondary");
    }
}

