/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseImpl;
import java.util.Comparator;

public class DatabaseConfig
implements Cloneable {
    static DatabaseConfig DEFAULT = new DatabaseConfig();
    private boolean allowCreate = false;
    private boolean exclusiveCreate = false;
    private boolean transactional = false;
    private boolean readOnly = false;
    private boolean duplicatesAllowed = false;
    private Comparator btreeComparator = null;
    private Comparator duplicateComparator = null;
    private boolean overrideBtreeComparator = false;
    private boolean overrideDupComparator = false;
    private boolean useExistingConfig = false;

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean getAllowCreate() {
        return this.allowCreate;
    }

    public void setExclusiveCreate(boolean exclusiveCreate) {
        this.exclusiveCreate = exclusiveCreate;
    }

    public boolean getExclusiveCreate() {
        return this.exclusiveCreate;
    }

    public void setSortedDuplicates(boolean duplicatesAllowed) {
        this.duplicatesAllowed = duplicatesAllowed;
    }

    public boolean getSortedDuplicates() {
        return this.duplicatesAllowed;
    }

    public void setTransactional(boolean transactional) throws IllegalArgumentException {
        this.transactional = transactional;
    }

    public boolean getTransactional() throws IllegalArgumentException {
        return this.transactional;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setBtreeComparator(Class btreeComparator) {
        this.btreeComparator = this.validateComparator(btreeComparator, "Btree");
    }

    public Comparator getBtreeComparator() {
        return this.btreeComparator;
    }

    public void setOverrideBtreeComparator(boolean override) {
        this.overrideBtreeComparator = override;
    }

    public boolean getOverrideBtreeComparator() {
        return this.overrideBtreeComparator;
    }

    public void setDuplicateComparator(Class duplicateComparator) {
        this.duplicateComparator = this.validateComparator(duplicateComparator, "Duplicate");
    }

    public Comparator getDuplicateComparator() {
        return this.duplicateComparator;
    }

    public void setOverrideDuplicateComparator(boolean override) {
        this.overrideDupComparator = override;
    }

    public boolean getOverrideDuplicateComparator() {
        return this.overrideDupComparator;
    }

    void setUseExistingConfig(boolean useExistingConfig) {
        this.useExistingConfig = useExistingConfig;
    }

    boolean getUseExistingConfig() {
        return this.useExistingConfig;
    }

    DatabaseConfig cloneConfig() {
        try {
            return (DatabaseConfig)super.clone();
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    private Comparator validateComparator(Class comparator, String type) throws IllegalArgumentException {
        if (comparator == null) {
            return null;
        }
        try {
            Comparator ret = DatabaseImpl.instantiateComparator(comparator, type);
            if (ret instanceof Comparator) {
                return ret;
            }
            throw new IllegalArgumentException(comparator.getName() + " is is not valid as a " + type + " comparator because it does not " + " implement java.util.Comparator.");
        }
        catch (DatabaseException e) {
            throw new IllegalArgumentException(type + " comparator is not valid: " + e.getMessage() + "\nPerhaps you have not implemented a zero-parameter " + "constructor for the comparator or the comparator class " + "cannot be found.");
        }
    }
}

