/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.KeyRangeException;
import com.sleepycat.collections.PrimaryKeyAssigner;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredEntrySet;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.collections.StoredKeySet;
import com.sleepycat.collections.StoredSortedEntrySet;
import com.sleepycat.collections.StoredSortedKeySet;
import com.sleepycat.collections.StoredSortedValueSet;
import com.sleepycat.collections.StoredValueSet;
import com.sleepycat.je.Database;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StoredMap
extends StoredContainer
implements Map {
    private StoredKeySet keySet;
    private StoredEntrySet entrySet;
    private StoredValueSet valueSet;

    public StoredMap(Database database, EntryBinding keyBinding, EntryBinding valueBinding, boolean writeAllowed) {
        super(new DataView(database, keyBinding, valueBinding, null, writeAllowed, null));
    }

    public StoredMap(Database database, EntryBinding keyBinding, EntryBinding valueBinding, PrimaryKeyAssigner keyAssigner) {
        super(new DataView(database, keyBinding, valueBinding, null, true, keyAssigner));
    }

    protected Object clone() throws CloneNotSupportedException {
        StoredMap other = (StoredMap)super.clone();
        other.keySet = null;
        other.entrySet = null;
        other.valueSet = null;
        return other;
    }

    public StoredMap(Database database, EntryBinding keyBinding, EntityBinding valueEntityBinding, boolean writeAllowed) {
        super(new DataView(database, keyBinding, null, valueEntityBinding, writeAllowed, null));
    }

    public StoredMap(Database database, EntryBinding keyBinding, EntityBinding valueEntityBinding, PrimaryKeyAssigner keyAssigner) {
        super(new DataView(database, keyBinding, null, valueEntityBinding, true, keyAssigner));
    }

    StoredMap(DataView view) {
        super(view);
    }

    public Object get(Object key) {
        return super.get(key);
    }

    public Object put(Object key, Object value) {
        return super.put(key, value);
    }

    public Object append(Object value) {
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            Object[] key = new Object[1];
            this.view.append(value, key, null);
            this.commitAutoCommit(doAutoCommit);
            return key[0];
        }
        catch (Exception e) {
            throw this.handleException(e, doAutoCommit);
        }
    }

    public Object remove(Object key) {
        Object[] oldVal = new Object[1];
        this.removeKey(key, oldVal);
        return oldVal[0];
    }

    public boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    public void putAll(Map map) {
        boolean doAutoCommit = this.beginAutoCommit();
        Iterator entries = null;
        try {
            entries = map.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                this.put(entry.getKey(), entry.getValue());
            }
            StoredIterator.close(entries);
            this.commitAutoCommit(doAutoCommit);
        }
        catch (Exception e) {
            StoredIterator.close(entries);
            throw this.handleException(e, doAutoCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        if (this.keySet == null) {
            StoredMap storedMap = this;
            synchronized (storedMap) {
                if (this.keySet == null) {
                    DataView newView = this.view.keySetView();
                    this.keySet = this.isOrdered() ? new StoredSortedKeySet(newView) : new StoredKeySet(newView);
                }
            }
        }
        return this.keySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        if (this.entrySet == null) {
            StoredMap storedMap = this;
            synchronized (storedMap) {
                if (this.entrySet == null) {
                    this.entrySet = this.isOrdered() ? new StoredSortedEntrySet(this.view) : new StoredEntrySet(this.view);
                }
            }
        }
        return this.entrySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection values() {
        if (this.valueSet == null) {
            StoredMap storedMap = this;
            synchronized (storedMap) {
                if (this.valueSet == null) {
                    DataView newView = this.view.valueSetView();
                    this.valueSet = this.isOrdered() && newView.canDeriveKeyFromValue() ? new StoredSortedValueSet(newView) : new StoredValueSet(newView);
                }
            }
        }
        return this.valueSet;
    }

    public Collection duplicates(Object key) {
        try {
            DataView newView = this.view.valueSetView(key);
            return new StoredValueSet(newView, true);
        }
        catch (KeyRangeException e) {
            return Collections.EMPTY_SET;
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof Map) {
            return this.entrySet().equals(((Map)other).entrySet());
        }
        return false;
    }

    public String toString() {
        return this.entrySet().toString();
    }
}

