/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.CurrentTransaction;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.util.RuntimeExceptionWrapper;

public abstract class StoredContainer
implements Cloneable {
    DataView view;

    StoredContainer(DataView view) {
        this.view = view;
    }

    public final boolean isWriteAllowed() {
        return this.view.writeAllowed;
    }

    public final boolean isDirtyReadAllowed() {
        return this.view.dirtyReadAllowed;
    }

    public final boolean isDirtyRead() {
        return this.view.dirtyReadEnabled;
    }

    public final boolean isTransactional() {
        return this.view.transactional;
    }

    final StoredContainer dirtyReadClone() {
        if (!this.isDirtyReadAllowed()) {
            return this;
        }
        try {
            StoredContainer cont = (StoredContainer)this.clone();
            cont.view = cont.view.dirtyReadView(true);
            return cont;
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    public final boolean areDuplicatesAllowed() {
        return this.view.dupsAllowed;
    }

    public final boolean areDuplicatesOrdered() {
        return this.view.dupsOrdered;
    }

    public final boolean areKeysRenumbered() {
        return this.view.keysRenumbered;
    }

    public final boolean isOrdered() {
        return this.view.ordered;
    }

    public final boolean isSecondary() {
        return this.view.isSecondary();
    }

    public int size() {
        throw new UnsupportedOperationException("collection size not available");
    }

    public boolean isEmpty() {
        try {
            return this.view.isEmpty();
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    public void clear() {
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            this.view.clear();
            this.commitAutoCommit(doAutoCommit);
        }
        catch (Exception e) {
            throw this.handleException(e, doAutoCommit);
        }
    }

    Object get(Object key) {
        DataCursor cursor;
        block5: {
            cursor = null;
            cursor = new DataCursor(this.view, false);
            if (OperationStatus.SUCCESS != cursor.getSearchKey(key, null, false)) break block5;
            Object object = cursor.getCurrentValue();
            Object var5_6 = null;
            this.closeCursor(cursor);
            return object;
        }
        try {
            Object var3_4 = null;
            Object var5_7 = null;
            this.closeCursor(cursor);
            return var3_4;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.closeCursor(cursor);
                throw throwable;
            }
        }
    }

    Object put(Object key, Object value) {
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            cursor = new DataCursor(this.view, true);
            Object[] oldValue = new Object[1];
            cursor.put(key, value, oldValue, false);
            this.closeCursor(cursor);
            this.commitAutoCommit(doAutoCommit);
            return oldValue[0];
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    final boolean removeKey(Object key, Object[] oldVal) {
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            cursor = new DataCursor(this.view, true);
            boolean found = false;
            OperationStatus status = cursor.getSearchKey(key, null, true);
            while (status == OperationStatus.SUCCESS) {
                cursor.delete();
                found = true;
                if (oldVal != null && oldVal[0] == null) {
                    oldVal[0] = cursor.getCurrentValue();
                }
                status = cursor.getNextDup(true);
            }
            this.closeCursor(cursor);
            this.commitAutoCommit(doAutoCommit);
            return found;
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    boolean containsKey(Object key) {
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this.view, false);
            boolean bl = OperationStatus.SUCCESS == cursor.getSearchKey(key, null, false);
            Object var5_5 = null;
            this.closeCursor(cursor);
            return bl;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.closeCursor(cursor);
                throw throwable;
            }
        }
    }

    final boolean removeValue(Object value) {
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            cursor = new DataCursor(this.view, true);
            OperationStatus status = cursor.find(value, true);
            if (status == OperationStatus.SUCCESS) {
                cursor.delete();
            }
            this.closeCursor(cursor);
            this.commitAutoCommit(doAutoCommit);
            return status == OperationStatus.SUCCESS;
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    boolean containsValue(Object value) {
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this.view, false);
            OperationStatus status = cursor.find(value, true);
            boolean bl = status == OperationStatus.SUCCESS;
            Object var6_6 = null;
            this.closeCursor(cursor);
            return bl;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.closeCursor(cursor);
                throw throwable;
            }
        }
    }

    final void closeCursor(DataCursor cursor) {
        if (cursor != null) {
            try {
                cursor.close();
            }
            catch (Exception e) {
                throw StoredContainer.convertException(e);
            }
        }
    }

    final boolean beginAutoCommit() {
        if (this.view.transactional) {
            try {
                CurrentTransaction currentTxn = this.view.getCurrentTxn();
                if (currentTxn.getTransaction() == null) {
                    currentTxn.beginTransaction(null);
                    return true;
                }
            }
            catch (DatabaseException e) {
                throw new RuntimeExceptionWrapper(e);
            }
        }
        return false;
    }

    final void commitAutoCommit(boolean doAutoCommit) throws DatabaseException {
        if (doAutoCommit) {
            this.view.getCurrentTxn().commitTransaction();
        }
    }

    final RuntimeException handleException(Exception e, boolean doAutoCommit) {
        block2: {
            if (!doAutoCommit) break block2;
            try {
                this.view.getCurrentTxn().abortTransaction();
            }
            catch (DatabaseException ignored) {}
        }
        return StoredContainer.convertException(e);
    }

    static RuntimeException convertException(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeExceptionWrapper(e);
    }
}

