/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.util.FastOutputStream;
import com.sleepycat.util.UtfOps;

public class TupleOutput
extends FastOutputStream {
    static final int NULL_STRING_UTF_VALUE = -1;

    public TupleOutput() {
    }

    public TupleOutput(byte[] buffer) {
        super(buffer);
    }

    public final TupleOutput writeBytes(String val) {
        this.writeBytes(val.toCharArray());
        return this;
    }

    public final TupleOutput writeChars(String val) {
        this.writeChars(val.toCharArray());
        return this;
    }

    public final TupleOutput writeString(String val) {
        if (val != null) {
            this.writeString(val.toCharArray());
        } else {
            this.writeFast(-1);
        }
        this.writeFast(0);
        return this;
    }

    public final TupleOutput writeChar(int val) {
        this.writeFast((byte)(val >>> 8));
        this.writeFast((byte)val);
        return this;
    }

    public final TupleOutput writeBoolean(boolean val) {
        this.writeFast(val ? 1 : 0);
        return this;
    }

    public final TupleOutput writeByte(int val) {
        byte b = (byte)val;
        b = b < 0 ? (byte)(b & 0x7F) : (byte)(b | 0xFFFFFF80);
        this.writeUnsignedByte(b);
        return this;
    }

    public final TupleOutput writeShort(int val) {
        short s = (short)val;
        s = s < 0 ? (short)(s & Short.MAX_VALUE) : (short)(s | Short.MIN_VALUE);
        this.writeUnsignedShort(s);
        return this;
    }

    public final TupleOutput writeInt(int val) {
        val = val < 0 ? (val &= Integer.MAX_VALUE) : (val |= Integer.MIN_VALUE);
        this.writeUnsignedInt(val);
        return this;
    }

    public final TupleOutput writeLong(long val) {
        val = val < 0L ? (val &= Long.MAX_VALUE) : (val |= Long.MIN_VALUE);
        this.writeUnsignedLong(val);
        return this;
    }

    public final TupleOutput writeFloat(float val) {
        this.writeUnsignedInt(Float.floatToIntBits(val));
        return this;
    }

    public final TupleOutput writeDouble(double val) {
        this.writeUnsignedLong(Double.doubleToLongBits(val));
        return this;
    }

    public final TupleOutput writeBytes(char[] chars) {
        int i = 0;
        while (i < chars.length) {
            this.writeFast((byte)chars[i]);
            ++i;
        }
        return this;
    }

    public final TupleOutput writeChars(char[] chars) {
        int i = 0;
        while (i < chars.length) {
            this.writeFast((byte)(chars[i] >>> 8));
            this.writeFast((byte)chars[i]);
            ++i;
        }
        return this;
    }

    public final TupleOutput writeString(char[] chars) {
        if (chars.length == 0) {
            return this;
        }
        int utfLength = UtfOps.getByteLength(chars);
        this.makeSpace(utfLength);
        UtfOps.charsToBytes(chars, 0, this.getBufferBytes(), this.getBufferLength(), chars.length);
        this.addSize(utfLength);
        return this;
    }

    public final TupleOutput writeUnsignedByte(int val) {
        this.writeFast(val);
        return this;
    }

    public final TupleOutput writeUnsignedShort(int val) {
        this.writeFast((byte)(val >>> 8));
        this.writeFast((byte)val);
        return this;
    }

    public final TupleOutput writeUnsignedInt(long val) {
        this.writeFast((byte)(val >>> 24));
        this.writeFast((byte)(val >>> 16));
        this.writeFast((byte)(val >>> 8));
        this.writeFast((byte)val);
        return this;
    }

    private final TupleOutput writeUnsignedLong(long val) {
        this.writeFast((byte)(val >>> 56));
        this.writeFast((byte)(val >>> 48));
        this.writeFast((byte)(val >>> 40));
        this.writeFast((byte)(val >>> 32));
        this.writeFast((byte)(val >>> 24));
        this.writeFast((byte)(val >>> 16));
        this.writeFast((byte)(val >>> 8));
        this.writeFast((byte)val);
        return this;
    }
}

