/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.util.FastInputStream;
import com.sleepycat.util.UtfOps;

public class TupleInput
extends FastInputStream {
    public TupleInput(byte[] buffer) {
        super(buffer);
    }

    public TupleInput(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public TupleInput(TupleOutput output) {
        super(output.getBufferBytes(), output.getBufferOffset(), output.getBufferLength());
    }

    public final String readString() throws IndexOutOfBoundsException, IllegalArgumentException {
        byte[] buf = this.getBufferBytes();
        int off = this.getBufferOffset();
        if (this.available() >= 2 && buf[off] == -1 && buf[off + 1] == 0) {
            this.skip(2L);
            return null;
        }
        int byteLen = UtfOps.getZeroTerminatedByteLength(buf, off);
        this.skip(byteLen + 1);
        return UtfOps.bytesToString(buf, off, byteLen);
    }

    public final char readChar() throws IndexOutOfBoundsException {
        return (char)this.readUnsignedShort();
    }

    public final boolean readBoolean() throws IndexOutOfBoundsException {
        int c = this.readFast();
        if (c < 0) {
            throw new IndexOutOfBoundsException();
        }
        return c != 0;
    }

    public final byte readByte() throws IndexOutOfBoundsException {
        byte val = (byte)this.readUnsignedByte();
        val = val < 0 ? (byte)(val & 0x7F) : (byte)(val | 0xFFFFFF80);
        return val;
    }

    public final short readShort() throws IndexOutOfBoundsException {
        short val = (short)this.readUnsignedShort();
        val = val < 0 ? (short)(val & Short.MAX_VALUE) : (short)(val | Short.MIN_VALUE);
        return val;
    }

    public final int readInt() throws IndexOutOfBoundsException {
        int val = (int)this.readUnsignedInt();
        val = val < 0 ? (val &= Integer.MAX_VALUE) : (val |= Integer.MIN_VALUE);
        return val;
    }

    public final long readLong() throws IndexOutOfBoundsException {
        long val = this.readUnsignedLong();
        val = val < 0L ? (val &= Long.MAX_VALUE) : (val |= Long.MIN_VALUE);
        return val;
    }

    public final float readFloat() throws IndexOutOfBoundsException {
        return Float.intBitsToFloat((int)this.readUnsignedInt());
    }

    public final double readDouble() throws IndexOutOfBoundsException {
        return Double.longBitsToDouble(this.readUnsignedLong());
    }

    public final int readUnsignedByte() throws IndexOutOfBoundsException {
        int c = this.readFast();
        if (c < 0) {
            throw new IndexOutOfBoundsException();
        }
        return c;
    }

    public final int readUnsignedShort() throws IndexOutOfBoundsException {
        int c2;
        int c1 = this.readFast();
        if ((c1 | (c2 = this.readFast())) < 0) {
            throw new IndexOutOfBoundsException();
        }
        return c1 << 8 | c2;
    }

    public final long readUnsignedInt() throws IndexOutOfBoundsException {
        long c4;
        long c3;
        long c2;
        long c1 = this.readFast();
        if ((c1 | (c2 = (long)this.readFast()) | (c3 = (long)this.readFast()) | (c4 = (long)this.readFast())) < 0L) {
            throw new IndexOutOfBoundsException();
        }
        return c1 << 24 | c2 << 16 | c3 << 8 | c4;
    }

    private final long readUnsignedLong() throws IndexOutOfBoundsException {
        long c8;
        long c7;
        long c6;
        long c5;
        long c4;
        long c3;
        long c2;
        long c1 = this.readFast();
        if ((c1 | (c2 = (long)this.readFast()) | (c3 = (long)this.readFast()) | (c4 = (long)this.readFast()) | (c5 = (long)this.readFast()) | (c6 = (long)this.readFast()) | (c7 = (long)this.readFast()) | (c8 = (long)this.readFast())) < 0L) {
            throw new IndexOutOfBoundsException();
        }
        return c1 << 56 | c2 << 48 | c3 << 40 | c4 << 32 | c5 << 24 | c6 << 16 | c7 << 8 | c8;
    }

    public final String readBytes(int length) throws IndexOutOfBoundsException {
        StringBuffer buf = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            int c = this.readFast();
            if (c < 0) {
                throw new IndexOutOfBoundsException();
            }
            buf.append((char)c);
            ++i;
        }
        return buf.toString();
    }

    public final String readChars(int length) throws IndexOutOfBoundsException {
        StringBuffer buf = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            buf.append(this.readChar());
            ++i;
        }
        return buf.toString();
    }

    public final void readBytes(char[] chars) throws IndexOutOfBoundsException {
        int i = 0;
        while (i < chars.length) {
            int c = this.readFast();
            if (c < 0) {
                throw new IndexOutOfBoundsException();
            }
            chars[i] = (char)c;
            ++i;
        }
    }

    public final void readChars(char[] chars) throws IndexOutOfBoundsException {
        int i = 0;
        while (i < chars.length) {
            chars[i] = this.readChar();
            ++i;
        }
    }

    public final String readString(int length) throws IndexOutOfBoundsException, IllegalArgumentException {
        char[] chars = new char[length];
        this.readString(chars);
        return new String(chars);
    }

    public final void readString(char[] chars) throws IndexOutOfBoundsException, IllegalArgumentException {
        byte[] buf = this.getBufferBytes();
        this.off = UtfOps.bytesToChars(buf, this.off, chars, 0, chars.length, false);
    }
}

