/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.client.config;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.client.config.CompressionClientConfigDsl;
import aws.smithy.kotlin.runtime.compression.CompressionAlgorithm;
import aws.smithy.kotlin.runtime.compression.Gzip;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0003H\u0007R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Laws/smithy/kotlin/runtime/client/config/RequestCompressionConfig;", "", "builder", "Laws/smithy/kotlin/runtime/client/config/RequestCompressionConfig$Builder;", "<init>", "(Laws/smithy/kotlin/runtime/client/config/RequestCompressionConfig$Builder;)V", "compressionAlgorithms", "", "Laws/smithy/kotlin/runtime/compression/CompressionAlgorithm;", "getCompressionAlgorithms", "()Ljava/util/List;", "disableRequestCompression", "", "getDisableRequestCompression", "()Z", "requestMinCompressionSizeBytes", "", "getRequestMinCompressionSizeBytes", "()J", "toBuilder", "Companion", "Builder", "smithy-client"})
public final class RequestCompressionConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<CompressionAlgorithm> compressionAlgorithms;
    private final boolean disableRequestCompression;
    private final long requestMinCompressionSizeBytes;

    @InternalApi
    public RequestCompressionConfig(@NotNull Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.compressionAlgorithms = builder.getCompressionAlgorithms();
        Boolean bl = builder.getDisableRequestCompression();
        this.disableRequestCompression = bl != null ? bl : false;
        Long l = builder.getRequestMinCompressionSizeBytes();
        this.requestMinCompressionSizeBytes = l != null ? l : 10240L;
    }

    @NotNull
    public final List<CompressionAlgorithm> getCompressionAlgorithms() {
        return this.compressionAlgorithms;
    }

    public final boolean getDisableRequestCompression() {
        return this.disableRequestCompression;
    }

    public final long getRequestMinCompressionSizeBytes() {
        return this.requestMinCompressionSizeBytes;
    }

    @InternalApi
    @NotNull
    public final Builder toBuilder() {
        Builder builder;
        Builder $this$toBuilder_u24lambda_u240 = builder = new Builder();
        boolean bl = false;
        $this$toBuilder_u24lambda_u240.setCompressionAlgorithms(CollectionsKt.toMutableList((Collection)this.compressionAlgorithms));
        $this$toBuilder_u24lambda_u240.setDisableRequestCompression(this.disableRequestCompression);
        $this$toBuilder_u24lambda_u240.setRequestMinCompressionSizeBytes(this.requestMinCompressionSizeBytes);
        return builder;
    }

    @CompressionClientConfigDsl
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0019"}, d2={"Laws/smithy/kotlin/runtime/client/config/RequestCompressionConfig$Builder;", "", "<init>", "()V", "compressionAlgorithms", "", "Laws/smithy/kotlin/runtime/compression/CompressionAlgorithm;", "getCompressionAlgorithms", "()Ljava/util/List;", "setCompressionAlgorithms", "(Ljava/util/List;)V", "disableRequestCompression", "", "getDisableRequestCompression", "()Ljava/lang/Boolean;", "setDisableRequestCompression", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "requestMinCompressionSizeBytes", "", "getRequestMinCompressionSizeBytes", "()Ljava/lang/Long;", "setRequestMinCompressionSizeBytes", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "smithy-client"})
    public static final class Builder {
        @NotNull
        private List<CompressionAlgorithm> compressionAlgorithms;
        @Nullable
        private Boolean disableRequestCompression;
        @Nullable
        private Long requestMinCompressionSizeBytes;

        @InternalApi
        public Builder() {
            Object[] objectArray = new CompressionAlgorithm[]{new Gzip()};
            this.compressionAlgorithms = CollectionsKt.mutableListOf((Object[])objectArray);
        }

        @NotNull
        public final List<CompressionAlgorithm> getCompressionAlgorithms() {
            return this.compressionAlgorithms;
        }

        public final void setCompressionAlgorithms(@NotNull List<CompressionAlgorithm> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.compressionAlgorithms = list;
        }

        @Nullable
        public final Boolean getDisableRequestCompression() {
            return this.disableRequestCompression;
        }

        public final void setDisableRequestCompression(@Nullable Boolean bl) {
            this.disableRequestCompression = bl;
        }

        @Nullable
        public final Long getRequestMinCompressionSizeBytes() {
            return this.requestMinCompressionSizeBytes;
        }

        public final void setRequestMinCompressionSizeBytes(@Nullable Long l) {
            this.requestMinCompressionSizeBytes = l;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0004\u001a\u00020\u00052\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\nH\u0086\n\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u000b"}, d2={"Laws/smithy/kotlin/runtime/client/config/RequestCompressionConfig$Companion;", "", "<init>", "()V", "invoke", "Laws/smithy/kotlin/runtime/client/config/RequestCompressionConfig;", "block", "Lkotlin/Function1;", "Laws/smithy/kotlin/runtime/client/config/RequestCompressionConfig$Builder;", "", "Lkotlin/ExtensionFunctionType;", "smithy-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RequestCompressionConfig invoke(@NotNull Function1<? super Builder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$invoke = false;
            Builder builder = new Builder();
            block.invoke((Object)builder);
            return new RequestCompressionConfig(builder);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

