/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http;

import aws.smithy.kotlin.runtime.http.content.ByteArrayContent;
import aws.smithy.kotlin.runtime.io.SdkByteReadChannel;
import aws.smithy.kotlin.runtime.io.SdkSource;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00132\u00020\u0001:\u0005\u000f\u0010\u0011\u0012\u0013B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002R\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\f\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u0082\u0001\u0004\u0014\u0015\u0016\u0017\u00a8\u0006\u0018"}, d2={"Laws/smithy/kotlin/runtime/http/HttpBody;", "", "<init>", "()V", "contentLength", "", "getContentLength", "()Ljava/lang/Long;", "Ljava/lang/Long;", "isOneShot", "", "()Z", "isDuplex", "equals", "other", "Empty", "Bytes", "SourceContent", "ChannelContent", "Companion", "Laws/smithy/kotlin/runtime/http/HttpBody$Bytes;", "Laws/smithy/kotlin/runtime/http/HttpBody$ChannelContent;", "Laws/smithy/kotlin/runtime/http/HttpBody$Empty;", "Laws/smithy/kotlin/runtime/http/HttpBody$SourceContent;", "http"})
public abstract class HttpBody {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Long contentLength;
    private final boolean isOneShot;
    private final boolean isDuplex;

    private HttpBody() {
        this.isOneShot = true;
    }

    @Nullable
    public Long getContentLength() {
        return this.contentLength;
    }

    public boolean isOneShot() {
        return this.isOneShot;
    }

    public boolean isDuplex() {
        return this.isDuplex;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof HttpBody && Intrinsics.areEqual((Object)((HttpBody)other).getContentLength(), (Object)this.getContentLength()) && ((HttpBody)other).isOneShot() == this.isOneShot() && ((HttpBody)other).isDuplex() == this.isDuplex();
    }

    public /* synthetic */ HttpBody(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH&R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\t"}, d2={"Laws/smithy/kotlin/runtime/http/HttpBody$Bytes;", "Laws/smithy/kotlin/runtime/http/HttpBody;", "<init>", "()V", "isOneShot", "", "()Z", "bytes", "", "http"})
    public static abstract class Bytes
    extends HttpBody {
        private final boolean isOneShot;

        public Bytes() {
            super(null);
        }

        @Override
        public final boolean isOneShot() {
            return this.isOneShot;
        }

        @NotNull
        public abstract byte[] bytes();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Laws/smithy/kotlin/runtime/http/HttpBody$ChannelContent;", "Laws/smithy/kotlin/runtime/http/HttpBody;", "<init>", "()V", "readFrom", "Laws/smithy/kotlin/runtime/io/SdkByteReadChannel;", "http"})
    public static abstract class ChannelContent
    extends HttpBody {
        public ChannelContent() {
            super(null);
        }

        @NotNull
        public abstract SdkByteReadChannel readFrom();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Laws/smithy/kotlin/runtime/http/HttpBody$Companion;", "", "<init>", "()V", "fromBytes", "Laws/smithy/kotlin/runtime/http/HttpBody;", "bytes", "", "http"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HttpBody fromBytes(@NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            return new ByteArrayContent(bytes);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Laws/smithy/kotlin/runtime/http/HttpBody$Empty;", "Laws/smithy/kotlin/runtime/http/HttpBody;", "<init>", "()V", "isOneShot", "", "()Z", "contentLength", "", "getContentLength", "()Ljava/lang/Long;", "equals", "other", "", "http"})
    public static final class Empty
    extends HttpBody {
        @NotNull
        public static final Empty INSTANCE = new Empty();
        private static final boolean isOneShot;
        private static final long contentLength;

        private Empty() {
            super(null);
        }

        @Override
        public final boolean isOneShot() {
            return isOneShot;
        }

        @Override
        @NotNull
        public Long getContentLength() {
            return contentLength;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable Object other) {
            if (!(other instanceof HttpBody)) return false;
            Long l = ((HttpBody)other).getContentLength();
            long l2 = this.getContentLength();
            if (l == null) return false;
            if (l != l2) return false;
            return true;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Laws/smithy/kotlin/runtime/http/HttpBody$SourceContent;", "Laws/smithy/kotlin/runtime/http/HttpBody;", "<init>", "()V", "readFrom", "Laws/smithy/kotlin/runtime/io/SdkSource;", "http"})
    public static abstract class SourceContent
    extends HttpBody {
        public SourceContent() {
            super(null);
        }

        @NotNull
        public abstract SdkSource readFrom();
    }
}

