/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.util;

import aws.smithy.kotlin.runtime.ClientException;
import aws.smithy.kotlin.runtime.InternalApi;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0005\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u001a*\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u0005*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u0002\u001a*\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u0005*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u0002\u001a\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u001a\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\"\u000e\u0010\f\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"splitHeaderListValues", "", "", "value", "readNextQuoted", "Lkotlin/Pair;", "", "startIdx", "delim", "", "readNextUnquoted", "splitHttpDateHeaderListValues", "QUOTABLE_HEADER_VALUE_CHARS", "quoteHeaderValue", "http"})
@SourceDebugExtension(value={"SMAP\nHeaderLists.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeaderLists.kt\naws/smithy/kotlin/runtime/http/util/HeaderListsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,135:1\n1#2:136\n1104#3,3:137\n1088#3,2:140\n*S KotlinDebug\n*F\n+ 1 HeaderLists.kt\naws/smithy/kotlin/runtime/http/util/HeaderListsKt\n*L\n92#1:137,3\n129#1:140,2\n*E\n"})
public final class HeaderListsKt {
    @NotNull
    private static final String QUOTABLE_HEADER_VALUE_CHARS = "\",()";

    @InternalApi
    @NotNull
    public static final List<String> splitHeaderListValues(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        List results = new ArrayList();
        int currIdx = 0;
        block4: while (currIdx < value.length()) {
            Pair pair;
            switch (value.charAt(currIdx)) {
                case '\t': 
                case ' ': {
                    ++currIdx;
                    continue block4;
                }
                case '\"': {
                    pair = HeaderListsKt.readNextQuoted$default(value, currIdx, '\u0000', 2, null);
                    break;
                }
                default: {
                    pair = HeaderListsKt.readNextUnquoted$default(value, currIdx, '\u0000', 2, null);
                }
            }
            Pair next = pair;
            currIdx = ((Number)next.getFirst()).intValue();
            results.add(next.getSecond());
        }
        return results;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Pair<Integer, String> readNextQuoted(String $this$readNextQuoted, int startIdx, char delim) {
        int endIdx;
        if (!(startIdx + 1 < $this$readNextQuoted.length())) {
            boolean $i$a$-check-HeaderListsKt$readNextQuoted$32 = false;
            String $i$a$-check-HeaderListsKt$readNextQuoted$32 = "unbalanced quoted header value";
            throw new IllegalStateException($i$a$-check-HeaderListsKt$readNextQuoted$32.toString());
        }
        block4: for (endIdx = startIdx + 1; endIdx < $this$readNextQuoted.length(); ++endIdx) {
            switch ($this$readNextQuoted.charAt(endIdx)) {
                case '\\': {
                    ++endIdx;
                    break;
                }
                case '\"': {
                    break block4;
                }
            }
        }
        String string = $this$readNextQuoted.substring(startIdx + 1, endIdx);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String next = string;
        if (!(endIdx < $this$readNextQuoted.length() && $this$readNextQuoted.charAt(endIdx) == '\"')) {
            boolean bl = false;
            String string2 = "missing end quote around quoted header value: `" + next + '`';
            throw new IllegalStateException(string2.toString());
        }
        ++endIdx;
        while (endIdx < $this$readNextQuoted.length()) {
            char c = $this$readNextQuoted.charAt(endIdx);
            if (c == ' ' || c == '\t') {
                ++endIdx;
                continue;
            }
            if (c != delim) {
                throw new IllegalStateException(("Unexpected char `" + $this$readNextQuoted.charAt(endIdx) + "` between header values. Previous header: `" + next + '`').toString());
            }
            ++endIdx;
            break;
        }
        String unescaped = StringsKt.replace$default((String)StringsKt.replace$default((String)next, (String)"\\\"", (String)"\"", (boolean)false, (int)4, null), (String)"\\\\", (String)"\\", (boolean)false, (int)4, null);
        return new Pair((Object)endIdx, (Object)unescaped);
    }

    static /* synthetic */ Pair readNextQuoted$default(String string, int n, char c, int n2, Object object) {
        if ((n2 & 2) != 0) {
            c = (char)44;
        }
        return HeaderListsKt.readNextQuoted(string, n, c);
    }

    private static final Pair<Integer, String> readNextUnquoted(String $this$readNextUnquoted, int startIdx, char delim) {
        int endIdx;
        if (!(startIdx < $this$readNextUnquoted.length())) {
            throw new IllegalStateException("Check failed.");
        }
        for (endIdx = startIdx; endIdx < $this$readNextUnquoted.length() && $this$readNextUnquoted.charAt(endIdx) != delim; ++endIdx) {
        }
        String string = $this$readNextUnquoted.substring(startIdx, endIdx);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String next = string;
        if (endIdx < $this$readNextUnquoted.length() && $this$readNextUnquoted.charAt(endIdx) == delim) {
            ++endIdx;
        }
        return new Pair((Object)endIdx, (Object)((Object)StringsKt.trim((CharSequence)next)).toString());
    }

    static /* synthetic */ Pair readNextUnquoted$default(String string, int n, char c, int n2, Object object) {
        if ((n2 & 2) != 0) {
            c = (char)44;
        }
        return HeaderListsKt.readNextUnquoted(string, n, c);
    }

    @InternalApi
    @NotNull
    public static final List<String> splitHttpDateHeaderListValues(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CharSequence $this$count$iv = value;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == ',')) continue;
            ++count$iv;
        }
        int n = count$iv;
        if (n <= 1) {
            return CollectionsKt.listOf((Object)value);
        }
        if (n % 2 == 0) {
            throw new ClientException("invalid timestamp HttpDate header comma separations: `" + value + '`');
        }
        int cnt = 0;
        List splits = new ArrayList();
        int startIdx = 0;
        int n2 = ((CharSequence)value).length();
        for (int i = 0; i < n2; ++i) {
            if (value.charAt(i) == ',') {
                ++cnt;
            }
            if (cnt <= 1) continue;
            String string = value.substring(startIdx, i);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            splits.add(((Object)StringsKt.trim((CharSequence)string)).toString());
            startIdx = i + 1;
            cnt = 0;
        }
        if (startIdx < value.length()) {
            String string = value.substring(startIdx);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            splits.add(((Object)StringsKt.trim((CharSequence)string)).toString());
        }
        return splits;
    }

    /*
     * Enabled aggressive block sorting
     */
    @InternalApi
    @NotNull
    public static final String quoteHeaderValue(@NotNull String value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (((Object)StringsKt.trim((CharSequence)value)).toString().length() == value.length()) {
            boolean bl;
            block3: {
                CharSequence $this$any$iv = QUOTABLE_HEADER_VALUE_CHARS;
                boolean $i$f$any = false;
                for (int i = 0; i < $this$any$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$any$iv.charAt(i);
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)value, (char)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (!bl) {
                string = value;
                return string;
            }
        }
        String formatted = StringsKt.replace$default((String)StringsKt.replace$default((String)value, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null);
        string = '\"' + formatted + '\"';
        return string;
    }
}

