/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http;

import aws.smithy.kotlin.runtime.ClientException;
import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.content.ByteStream;
import aws.smithy.kotlin.runtime.hashing.HashFunction;
import aws.smithy.kotlin.runtime.http.ByteStreamBufferHttpBody;
import aws.smithy.kotlin.runtime.http.ByteStreamChannelHttpBody;
import aws.smithy.kotlin.runtime.http.ByteStreamHttpBody;
import aws.smithy.kotlin.runtime.http.ByteStreamSourceHttpBody;
import aws.smithy.kotlin.runtime.http.CompletingByteReadChannel;
import aws.smithy.kotlin.runtime.http.CompletingSource;
import aws.smithy.kotlin.runtime.http.HttpBody;
import aws.smithy.kotlin.runtime.http.HttpBodyKt;
import aws.smithy.kotlin.runtime.io.HashingByteReadChannel;
import aws.smithy.kotlin.runtime.io.HashingSource;
import aws.smithy.kotlin.runtime.io.SdkBuffer;
import aws.smithy.kotlin.runtime.io.SdkByteChannelKt;
import aws.smithy.kotlin.runtime.io.SdkByteReadChannel;
import aws.smithy.kotlin.runtime.io.SdkByteReadChannelKt;
import aws.smithy.kotlin.runtime.io.SdkSource;
import aws.smithy.kotlin.runtime.io.SdkSourceJVMKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0003\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0004H\u0007\u001a\u001d\u0010\u0000\u001a\u00020\u0001*\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007\u00a2\u0006\u0002\u0010\b\u001a\u001d\u0010\u0000\u001a\u00020\u0001*\u00020\t2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007\u00a2\u0006\u0002\u0010\n\u001a#\u0010\u000b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007\u00a2\u0006\u0002\u0010\u000e\u001a\u001a\u0010\u000f\u001a\u00020\u0001*\u00020\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0007\u001a\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0002*\u00020\u0001H\u0086@\u00a2\u0006\u0002\u0010\u0013\u001a\f\u0010\u0014\u001a\u0004\u0018\u00010\u0004*\u00020\u0001\u001a\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u0005*\u00020\u00012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007\"\u001e\u0010\u0018\u001a\u00020\u0019*\u00020\u00018FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u001c\u00a8\u0006\u001d"}, d2={"toHttpBody", "Laws/smithy/kotlin/runtime/http/HttpBody;", "", "", "Laws/smithy/kotlin/runtime/content/ByteStream;", "Laws/smithy/kotlin/runtime/io/SdkByteReadChannel;", "contentLength", "", "(Laws/smithy/kotlin/runtime/io/SdkByteReadChannel;Ljava/lang/Long;)Laws/smithy/kotlin/runtime/http/HttpBody;", "Laws/smithy/kotlin/runtime/io/SdkSource;", "(Laws/smithy/kotlin/runtime/io/SdkSource;Ljava/lang/Long;)Laws/smithy/kotlin/runtime/http/HttpBody;", "toHashingBody", "hashFunction", "Laws/smithy/kotlin/runtime/hashing/HashFunction;", "(Laws/smithy/kotlin/runtime/http/HttpBody;Laws/smithy/kotlin/runtime/hashing/HashFunction;Ljava/lang/Long;)Laws/smithy/kotlin/runtime/http/HttpBody;", "toCompletingBody", "deferred", "Lkotlinx/coroutines/CompletableDeferred;", "readAll", "(Laws/smithy/kotlin/runtime/http/HttpBody;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toByteStream", "toSdkByteReadChannel", "scope", "Lkotlinx/coroutines/CoroutineScope;", "isEligibleForAwsChunkedStreaming", "", "isEligibleForAwsChunkedStreaming$annotations", "(Laws/smithy/kotlin/runtime/http/HttpBody;)V", "(Laws/smithy/kotlin/runtime/http/HttpBody;)Z", "http"})
public final class HttpBodyKt {
    @NotNull
    public static final HttpBody toHttpBody(@NotNull byte[] $this$toHttpBody) {
        Intrinsics.checkNotNullParameter((Object)$this$toHttpBody, (String)"<this>");
        return HttpBody.Companion.fromBytes($this$toHttpBody);
    }

    @NotNull
    public static final HttpBody toHttpBody(@NotNull String $this$toHttpBody) {
        Intrinsics.checkNotNullParameter((Object)$this$toHttpBody, (String)"<this>");
        return HttpBodyKt.toHttpBody(StringsKt.encodeToByteArray((String)$this$toHttpBody));
    }

    @InternalApi
    @NotNull
    public static final HttpBody toHttpBody(@NotNull ByteStream $this$toHttpBody) {
        HttpBody httpBody;
        Intrinsics.checkNotNullParameter((Object)$this$toHttpBody, (String)"<this>");
        ByteStream byteStream = $this$toHttpBody;
        if (byteStream instanceof ByteStream.Buffer) {
            httpBody = new ByteStreamBufferHttpBody((ByteStream.Buffer)byteStream);
        } else if (byteStream instanceof ByteStream.ChannelStream) {
            httpBody = new ByteStreamChannelHttpBody((ByteStream.ChannelStream)byteStream);
        } else if (byteStream instanceof ByteStream.SourceStream) {
            httpBody = new ByteStreamSourceHttpBody((ByteStream.SourceStream)byteStream);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return httpBody;
    }

    @InternalApi
    @NotNull
    public static final HttpBody toHttpBody(@NotNull SdkByteReadChannel $this$toHttpBody, @Nullable Long contentLength) {
        Intrinsics.checkNotNullParameter((Object)$this$toHttpBody, (String)"<this>");
        SdkByteReadChannel ch = $this$toHttpBody;
        return new HttpBody.ChannelContent(contentLength, ch){
            private final Long contentLength;
            private final boolean isOneShot;
            final /* synthetic */ SdkByteReadChannel $ch;
            {
                this.$ch = $ch;
                this.contentLength = $contentLength;
                this.isOneShot = true;
            }

            public Long getContentLength() {
                return this.contentLength;
            }

            public boolean isOneShot() {
                return this.isOneShot;
            }

            public SdkByteReadChannel readFrom() {
                return this.$ch;
            }
        };
    }

    public static /* synthetic */ HttpBody toHttpBody$default(SdkByteReadChannel sdkByteReadChannel, Long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = null;
        }
        return HttpBodyKt.toHttpBody(sdkByteReadChannel, l);
    }

    @InternalApi
    @NotNull
    public static final HttpBody toHttpBody(@NotNull SdkSource $this$toHttpBody, @Nullable Long contentLength) {
        Intrinsics.checkNotNullParameter((Object)$this$toHttpBody, (String)"<this>");
        return new HttpBody.SourceContent(contentLength, $this$toHttpBody){
            private final Long contentLength;
            private final boolean isOneShot;
            final /* synthetic */ SdkSource $this_toHttpBody;
            {
                this.$this_toHttpBody = $receiver;
                this.contentLength = $contentLength;
                this.isOneShot = true;
            }

            public Long getContentLength() {
                return this.contentLength;
            }

            public boolean isOneShot() {
                return this.isOneShot;
            }

            public SdkSource readFrom() {
                return this.$this_toHttpBody;
            }
        };
    }

    public static /* synthetic */ HttpBody toHttpBody$default(SdkSource sdkSource, Long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = null;
        }
        return HttpBodyKt.toHttpBody(sdkSource, l);
    }

    @InternalApi
    @NotNull
    public static final HttpBody toHashingBody(@NotNull HttpBody $this$toHashingBody, @NotNull HashFunction hashFunction, @Nullable Long contentLength) {
        HttpBody httpBody;
        Intrinsics.checkNotNullParameter((Object)$this$toHashingBody, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hashFunction, (String)"hashFunction");
        HttpBody httpBody2 = $this$toHashingBody;
        if (httpBody2 instanceof HttpBody.SourceContent) {
            httpBody = HttpBodyKt.toHttpBody((SdkSource)new HashingSource(hashFunction, ((HttpBody.SourceContent)$this$toHashingBody).readFrom()), contentLength);
        } else if (httpBody2 instanceof HttpBody.ChannelContent) {
            httpBody = HttpBodyKt.toHttpBody((SdkByteReadChannel)new HashingByteReadChannel(hashFunction, ((HttpBody.ChannelContent)$this$toHashingBody).readFrom()), contentLength);
        } else {
            throw new ClientException("HttpBody type is not supported");
        }
        return httpBody;
    }

    @InternalApi
    @NotNull
    public static final HttpBody toCompletingBody(@NotNull HttpBody $this$toCompletingBody, @NotNull CompletableDeferred<String> deferred) {
        HttpBody httpBody;
        Intrinsics.checkNotNullParameter((Object)$this$toCompletingBody, (String)"<this>");
        Intrinsics.checkNotNullParameter(deferred, (String)"deferred");
        HttpBody httpBody2 = $this$toCompletingBody;
        if (httpBody2 instanceof HttpBody.SourceContent) {
            SdkSource sdkSource = ((HttpBody.SourceContent)$this$toCompletingBody).readFrom();
            Intrinsics.checkNotNull((Object)sdkSource, (String)"null cannot be cast to non-null type aws.smithy.kotlin.runtime.io.HashingSource");
            httpBody = HttpBodyKt.toHttpBody(new CompletingSource(deferred, (HashingSource)sdkSource), $this$toCompletingBody.getContentLength());
        } else if (httpBody2 instanceof HttpBody.ChannelContent) {
            SdkByteReadChannel sdkByteReadChannel = ((HttpBody.ChannelContent)$this$toCompletingBody).readFrom();
            Intrinsics.checkNotNull((Object)sdkByteReadChannel, (String)"null cannot be cast to non-null type aws.smithy.kotlin.runtime.io.HashingByteReadChannel");
            httpBody = HttpBodyKt.toHttpBody(new CompletingByteReadChannel(deferred, (HashingByteReadChannel)sdkByteReadChannel), $this$toCompletingBody.getContentLength());
        } else {
            throw new ClientException("HttpBody type is not supported");
        }
        return httpBody;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object readAll(@NotNull HttpBody var0, @NotNull Continuation<? super byte[]> $completion) {
        block9: {
            block10: {
                if (!($completion instanceof readAll.1)) ** GOTO lbl-1000
                var6_2 = $completion;
                if ((var6_2.label & -2147483648) != 0) {
                    var6_2.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl($completion){
                        /* synthetic */ Object result;
                        int label;

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return HttpBodyKt.readAll(null, (Continuation<? super byte[]>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_5 = $this$readAll;
                        if (!(var2_5 instanceof HttpBody.Empty)) ** GOTO lbl16
                        v0 = null;
                        break block9;
lbl16:
                        // 1 sources

                        if (!(var2_5 instanceof HttpBody.Bytes)) ** GOTO lbl19
                        v0 = ((HttpBody.Bytes)$this$readAll).bytes();
                        break block9;
lbl19:
                        // 1 sources

                        if (!(var2_5 instanceof HttpBody.ChannelContent)) break;
                        readChan = ((HttpBody.ChannelContent)$this$readAll).readFrom();
                        $continuation.label = 1;
                        v1 = SdkByteReadChannelKt.readToBuffer((SdkByteReadChannel)readChan, (Continuation)$continuation);
                        if (v1 == var7_4) {
                            return var7_4;
                        }
                        ** GOTO lbl29
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl29:
                        // 2 sources

                        bytes = ((SdkBuffer)v1).readByteArray();
                        v0 = bytes;
                        break block9;
                    }
                }
                if (!(var2_5 instanceof HttpBody.SourceContent)) break block10;
                $continuation.label = 2;
                v2 = SdkSourceJVMKt.readToByteArray((SdkSource)((HttpBody.SourceContent)$this$readAll).readFrom(), (Continuation)$continuation);
                if (v2 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl41
                {
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl41:
                        // 2 sources

                        v0 = (byte[])v2;
                        break block9;
                    }
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return v0;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public static final ByteStream toByteStream(@NotNull HttpBody $this$toByteStream) {
        ByteStream byteStream;
        Intrinsics.checkNotNullParameter((Object)$this$toByteStream, (String)"<this>");
        if ($this$toByteStream instanceof ByteStreamHttpBody) {
            return ((ByteStreamHttpBody)((Object)$this$toByteStream)).getStream();
        }
        HttpBody body = $this$toByteStream;
        if (body instanceof HttpBody.Empty) {
            byteStream = null;
        } else if (body instanceof HttpBody.Bytes) {
            byteStream = (ByteStream)new ByteStream.Buffer(body){
                private final Long contentLength;
                final /* synthetic */ HttpBody $body;
                {
                    this.$body = $body;
                    this.contentLength = $body.getContentLength();
                }

                public Long getContentLength() {
                    return this.contentLength;
                }

                public byte[] bytes() {
                    return ((HttpBody.Bytes)this.$body).bytes();
                }
            };
        } else if (body instanceof HttpBody.ChannelContent) {
            byteStream = (ByteStream)new ByteStream.ChannelStream(body){
                private final Long contentLength;
                private final boolean isOneShot;
                final /* synthetic */ HttpBody $body;
                {
                    this.$body = $body;
                    this.contentLength = $body.getContentLength();
                    this.isOneShot = $body.isOneShot();
                }

                public Long getContentLength() {
                    return this.contentLength;
                }

                public boolean isOneShot() {
                    return this.isOneShot;
                }

                public SdkByteReadChannel readFrom() {
                    return ((HttpBody.ChannelContent)this.$body).readFrom();
                }
            };
        } else if (body instanceof HttpBody.SourceContent) {
            byteStream = (ByteStream)new ByteStream.SourceStream(body){
                private final Long contentLength;
                private final boolean isOneShot;
                final /* synthetic */ HttpBody $body;
                {
                    this.$body = $body;
                    this.contentLength = $body.getContentLength();
                    this.isOneShot = $body.isOneShot();
                }

                public Long getContentLength() {
                    return this.contentLength;
                }

                public boolean isOneShot() {
                    return this.isOneShot;
                }

                public SdkSource readFrom() {
                    return ((HttpBody.SourceContent)this.$body).readFrom();
                }
            };
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return byteStream;
    }

    @InternalApi
    @Nullable
    public static final SdkByteReadChannel toSdkByteReadChannel(@NotNull HttpBody $this$toSdkByteReadChannel, @Nullable CoroutineScope scope) {
        SdkByteReadChannel sdkByteReadChannel;
        Intrinsics.checkNotNullParameter((Object)$this$toSdkByteReadChannel, (String)"<this>");
        HttpBody body = $this$toSdkByteReadChannel;
        if (body instanceof HttpBody.Empty) {
            sdkByteReadChannel = null;
        } else if (body instanceof HttpBody.Bytes) {
            sdkByteReadChannel = SdkByteChannelKt.SdkByteReadChannel$default((byte[])((HttpBody.Bytes)body).bytes(), (int)0, (int)0, (int)6, null);
        } else if (body instanceof HttpBody.ChannelContent) {
            sdkByteReadChannel = ((HttpBody.ChannelContent)body).readFrom();
        } else if (body instanceof HttpBody.SourceContent) {
            sdkByteReadChannel = SdkSourceJVMKt.toSdkByteReadChannel((SdkSource)((HttpBody.SourceContent)body).readFrom(), (CoroutineScope)scope);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return sdkByteReadChannel;
    }

    public static /* synthetic */ SdkByteReadChannel toSdkByteReadChannel$default(HttpBody httpBody, CoroutineScope coroutineScope, int n, Object object) {
        if ((n & 1) != 0) {
            coroutineScope = null;
        }
        return HttpBodyKt.toSdkByteReadChannel(httpBody, coroutineScope);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEligibleForAwsChunkedStreaming(@NotNull HttpBody $this$isEligibleForAwsChunkedStreaming) {
        Intrinsics.checkNotNullParameter((Object)$this$isEligibleForAwsChunkedStreaming, (String)"<this>");
        if (!($this$isEligibleForAwsChunkedStreaming instanceof HttpBody.SourceContent)) {
            if (!($this$isEligibleForAwsChunkedStreaming instanceof HttpBody.ChannelContent)) return false;
        }
        if ($this$isEligibleForAwsChunkedStreaming.getContentLength() == null) return false;
        if ($this$isEligibleForAwsChunkedStreaming.isOneShot()) return true;
        Long l = $this$isEligibleForAwsChunkedStreaming.getContentLength();
        Intrinsics.checkNotNull((Object)l);
        if (l <= 0x100000L) return false;
        return true;
    }

    @InternalApi
    public static /* synthetic */ void isEligibleForAwsChunkedStreaming$annotations(HttpBody httpBody) {
    }
}

