/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.engine.okhttp;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.http.engine.ProxyConfig;
import aws.smithy.kotlin.runtime.http.engine.ProxySelector;
import aws.smithy.kotlin.runtime.http.engine.okhttp.OkHttpUtilsKt;
import aws.smithy.kotlin.runtime.net.url.Url;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J&\u0010\u000b\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Laws/smithy/kotlin/runtime/http/engine/okhttp/OkHttpProxySelector;", "Ljava/net/ProxySelector;", "sdkSelector", "Laws/smithy/kotlin/runtime/http/engine/ProxySelector;", "<init>", "(Laws/smithy/kotlin/runtime/http/engine/ProxySelector;)V", "select", "", "Ljava/net/Proxy;", "uri", "Ljava/net/URI;", "connectFailed", "", "sa", "Ljava/net/SocketAddress;", "ioe", "Ljava/io/IOException;", "http-client-engine-okhttp"})
public final class OkHttpProxySelector
extends java.net.ProxySelector {
    @NotNull
    private final ProxySelector sdkSelector;

    public OkHttpProxySelector(@NotNull ProxySelector sdkSelector) {
        Intrinsics.checkNotNullParameter((Object)sdkSelector, (String)"sdkSelector");
        this.sdkSelector = sdkSelector;
    }

    @Override
    @NotNull
    public List<Proxy> select(@Nullable URI uri) {
        if (uri == null) {
            return CollectionsKt.emptyList();
        }
        Url url = OkHttpUtilsKt.toUrl(uri);
        ProxyConfig proxyConfig = this.sdkSelector.select(url);
        if (proxyConfig instanceof ProxyConfig.Http) {
            Proxy okProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(((ProxyConfig.Http)proxyConfig).getUrl().getHost().toString(), ((ProxyConfig.Http)proxyConfig).getUrl().getPort()));
            return CollectionsKt.listOf((Object)okProxy);
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public void connectFailed(@Nullable URI uri, @Nullable SocketAddress sa, @Nullable IOException ioe) {
    }
}

