/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.engine.okhttp;

import aws.smithy.kotlin.runtime.collections.Attributes;
import aws.smithy.kotlin.runtime.telemetry.metrics.MonotonicCounter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSink;
import okio.Sink;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\t\u0010\u0011\u001a\u00020\u000bH\u0096\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Laws/smithy/kotlin/runtime/http/engine/okhttp/InstrumentedSink;", "Lokio/Sink;", "delegate", "Lokio/BufferedSink;", "counter", "Laws/smithy/kotlin/runtime/telemetry/metrics/MonotonicCounter;", "attributes", "Laws/smithy/kotlin/runtime/collections/Attributes;", "<init>", "(Lokio/BufferedSink;Laws/smithy/kotlin/runtime/telemetry/metrics/MonotonicCounter;Laws/smithy/kotlin/runtime/collections/Attributes;)V", "write", "", "source", "Lokio/Buffer;", "byteCount", "", "close", "flush", "timeout", "Lokio/Timeout;", "http-client-engine-okhttp"})
public final class InstrumentedSink
implements Sink {
    @NotNull
    private final BufferedSink delegate;
    @NotNull
    private final MonotonicCounter counter;
    @NotNull
    private final Attributes attributes;

    public InstrumentedSink(@NotNull BufferedSink delegate, @NotNull MonotonicCounter counter, @NotNull Attributes attributes) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.delegate = delegate;
        this.counter = counter;
        this.attributes = attributes;
    }

    public void write(@NotNull Buffer source, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.delegate.write(source, byteCount);
        MonotonicCounter.DefaultImpls.add$default((MonotonicCounter)this.counter, (long)byteCount, (Attributes)this.attributes, null, (int)4, null);
    }

    public void close() {
        this.delegate.emit();
        this.delegate.close();
    }

    public void flush() {
        this.delegate.flush();
    }

    @NotNull
    public Timeout timeout() {
        return this.delegate.timeout();
    }
}

