/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.engine.okhttp;

import aws.smithy.kotlin.runtime.http.engine.okhttp.SdkRequestTag;
import aws.smithy.kotlin.runtime.telemetry.logging.CoroutineContextLogExtKt;
import aws.smithy.kotlin.runtime.telemetry.logging.Logger;
import java.io.Closeable;
import java.io.EOFException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.ConnectionListener;
import okhttp3.internal._UtilCommonKt;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000f\u001a\u00020\u0010J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\u001e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010\u001aR\u0013\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Laws/smithy/kotlin/runtime/http/engine/okhttp/ConnectionIdleMonitor;", "Lokhttp3/ConnectionListener;", "pollInterval", "Lkotlin/time/Duration;", "<init>", "(JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getPollInterval-UwyO8pc", "()J", "J", "monitorScope", "Lkotlinx/coroutines/CoroutineScope;", "monitors", "Ljava/util/concurrent/ConcurrentHashMap;", "Lokhttp3/Connection;", "Lkotlinx/coroutines/Job;", "close", "", "callContext", "Lkotlin/coroutines/CoroutineContext;", "Lokhttp3/Call;", "connectionAcquired", "connection", "call", "connectionReleased", "doMonitor", "conn", "(Lokhttp3/Connection;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "http-client-engine-okhttp"})
@SourceDebugExtension(value={"SMAP\nConnectionIdleMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectionIdleMonitor.kt\naws/smithy/kotlin/runtime/http/engine/okhttp/ConnectionIdleMonitor\n+ 2 CoroutineContextLogExt.kt\naws/smithy/kotlin/runtime/telemetry/logging/CoroutineContextLogExtKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,123:1\n258#2:124\n259#2:126\n258#2:131\n259#2:133\n258#2:134\n259#2:136\n1#3:125\n1#3:132\n1#3:135\n24#4:127\n63#4,3:128\n*S KotlinDebug\n*F\n+ 1 ConnectionIdleMonitor.kt\naws/smithy/kotlin/runtime/http/engine/okhttp/ConnectionIdleMonitor\n*L\n49#1:124\n49#1:126\n67#1:131\n67#1:133\n76#1:134\n76#1:136\n49#1:125\n67#1:132\n76#1:135\n53#1:127\n53#1:128,3\n*E\n"})
public final class ConnectionIdleMonitor
extends ConnectionListener {
    private final long pollInterval;
    @NotNull
    private final CoroutineScope monitorScope;
    @NotNull
    private final ConcurrentHashMap<Connection, Job> monitors;

    private ConnectionIdleMonitor(long pollInterval) {
        this.pollInterval = pollInterval;
        this.monitorScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        this.monitors = new ConcurrentHashMap();
    }

    public final long getPollInterval-UwyO8pc() {
        return this.pollInterval;
    }

    public final void close() {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ConnectionIdleMonitor this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                        CoroutineContext.Element element = ConnectionIdleMonitor.access$getMonitorScope$p(this.this$0).getCoroutineContext().get((CoroutineContext.Key)Job.Key);
                        if (element == null) {
                            boolean bl = false;
                            String string = "Connection idle monitor scope cannot be cancelled because it does not have a job: " + $this$runBlocking;
                            throw new IllegalArgumentException(string.toString());
                        }
                        Job monitorJob = (Job)element;
                        this.label = 1;
                        Object object3 = JobKt.cancelAndJoin((Job)monitorJob, (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private final CoroutineContext callContext(Call $this$callContext) {
        CoroutineContext coroutineContext;
        SdkRequestTag sdkRequestTag = (SdkRequestTag)$this$callContext.request().tag(SdkRequestTag.class);
        return sdkRequestTag != null && (coroutineContext = sdkRequestTag.getCallContext()) != null ? coroutineContext : (CoroutineContext)Dispatchers.getIO();
    }

    public void connectionAcquired(@NotNull Connection connection, @NotNull Call call) {
        block1: {
            CoroutineContext context;
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Job job = this.monitors.remove(connection);
            if (job == null) break block1;
            Job monitor2 = job;
            boolean bl = false;
            CoroutineContext $this$logger$iv = context = this.callContext(call);
            boolean $i$f$logger = false;
            String string = Reflection.getOrCreateKotlinClass(ConnectionIdleMonitor.class).getQualifiedName();
            if (string == null) {
                boolean $i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22 = false;
                String $i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22 = "logger<T> cannot be used on an anonymous object";
                throw new IllegalArgumentException($i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22.toString());
            }
            String sourceComponent$iv = string;
            Logger logger = CoroutineContextLogExtKt.logger((CoroutineContext)$this$logger$iv, (String)sourceComponent$iv);
            Logger.DefaultImpls.trace$default((Logger)logger, null, () -> ConnectionIdleMonitor.connectionAcquired$lambda$3$lambda$0(connection), (int)1, null);
            boolean $i$f$measureTime = false;
            TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTime2 = false;
            long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
            boolean bl2 = false;
            BuildersKt.runBlocking((CoroutineContext)context, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(monitor2, null){
                int label;
                final /* synthetic */ Job $monitor;
                {
                    this.$monitor = $monitor;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = JobKt.cancelAndJoin((Job)this.$monitor, (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            long cancelTime2 = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
            Logger.DefaultImpls.trace$default((Logger)logger, null, () -> ConnectionIdleMonitor.connectionAcquired$lambda$3$lambda$2(connection, cancelTime2), (int)1, null);
        }
    }

    public void connectionReleased(@NotNull Connection connection, @NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        int connId = System.identityHashCode(connection);
        CoroutineContext callContext = this.callContext(call);
        Job monitor2 = BuildersKt.launch$default((CoroutineScope)this.monitorScope, (CoroutineContext)((CoroutineContext)new CoroutineName("okhttp-conn-monitor-for-" + connId)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, connection, callContext, null){
            int label;
            final /* synthetic */ ConnectionIdleMonitor this$0;
            final /* synthetic */ Connection $connection;
            final /* synthetic */ CoroutineContext $callContext;
            {
                this.this$0 = $receiver;
                this.$connection = $connection;
                this.$callContext = $callContext;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = ConnectionIdleMonitor.access$doMonitor(this.this$0, this.$connection, this.$callContext, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        CoroutineContext $this$logger$iv = callContext;
        boolean $i$f$logger = false;
        String string = Reflection.getOrCreateKotlinClass(ConnectionIdleMonitor.class).getQualifiedName();
        if (string == null) {
            boolean bl = false;
            String string2 = "logger<T> cannot be used on an anonymous object";
            throw new IllegalArgumentException(string2.toString());
        }
        String sourceComponent$iv = string;
        Logger.DefaultImpls.trace$default((Logger)CoroutineContextLogExtKt.logger((CoroutineContext)$this$logger$iv, (String)sourceComponent$iv), null, () -> ConnectionIdleMonitor.connectionReleased$lambda$4(monitor2, connection), (int)1, null);
        ((Map)this.monitors).put(connection, monitor2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object doMonitor(Connection conn, CoroutineContext callContext, Continuation<? super Unit> $completion) {
        Source $i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22323232322;
        CoroutineContext $this$logger$iv = callContext;
        boolean $i$f$logger = false;
        String string = Reflection.getOrCreateKotlinClass(ConnectionIdleMonitor.class).getQualifiedName();
        if (string == null) {
            boolean $i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22323232322 = false;
            String $i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22323232322 = "logger<T> cannot be used on an anonymous object";
            throw new IllegalArgumentException($i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22323232322.toString());
        }
        String sourceComponent$iv = string;
        Logger logger = CoroutineContextLogExtKt.logger((CoroutineContext)$this$logger$iv, (String)sourceComponent$iv);
        Socket socket = conn.socket();
        try {
            $i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22323232322 = Okio.source((Socket)socket);
        }
        catch (SocketException socketException) {
            Logger.DefaultImpls.trace$default((Logger)logger, null, () -> ConnectionIdleMonitor.doMonitor$lambda$5(conn), (int)1, null);
            return Unit.INSTANCE;
        }
        BufferedSource source = Okio.buffer((Source)$i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22323232322).peek();
        Logger.DefaultImpls.trace$default((Logger)logger, null, () -> ConnectionIdleMonitor.doMonitor$lambda$6(conn), (int)1, null);
        boolean resetTimeout = true;
        int oldTimeout = socket.getSoTimeout();
        socket.setSoTimeout((int)Duration.getInWholeMilliseconds-impl((long)this.pollInterval));
        while (JobKt.isActive((CoroutineContext)$completion.getContext())) {
            try {
                Logger.DefaultImpls.trace$default((Logger)logger, null, () -> ConnectionIdleMonitor.doMonitor$lambda$7(conn), (int)1, null);
                source.readByte();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                Logger.DefaultImpls.trace$default((Logger)logger, null, () -> ConnectionIdleMonitor.doMonitor$lambda$8(conn), (int)1, null);
            }
            catch (EOFException eOFException) {
                Logger.DefaultImpls.trace$default((Logger)logger, null, () -> ConnectionIdleMonitor.doMonitor$lambda$9(conn), (int)1, null);
                _UtilCommonKt.closeQuietly((Closeable)socket);
                resetTimeout = false;
                return Unit.INSTANCE;
            }
        }
        Logger.DefaultImpls.trace$default((Logger)logger, null, ConnectionIdleMonitor::doMonitor$lambda$10, (int)1, null);
        Logger.DefaultImpls.trace$default((Logger)logger, null, ConnectionIdleMonitor::doMonitor$lambda$12, (int)1, null);
        try {
            conn.socket().setSoTimeout(oldTimeout);
            Logger.DefaultImpls.trace$default((Logger)logger, null, ConnectionIdleMonitor::doMonitor$lambda$13, (int)1, null);
            return Unit.INSTANCE;
        }
        catch (Throwable e) {
            logger.warn(e, () -> ConnectionIdleMonitor.doMonitor$lambda$14(conn));
            return Unit.INSTANCE;
        }
        catch (Throwable e) {
            try {
                logger.warn(e, () -> ConnectionIdleMonitor.doMonitor$lambda$11(conn));
                return Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (resetTimeout) {
                    Logger.DefaultImpls.trace$default((Logger)logger, null, ConnectionIdleMonitor::doMonitor$lambda$12, (int)1, null);
                    try {
                        conn.socket().setSoTimeout(oldTimeout);
                        Logger.DefaultImpls.trace$default((Logger)logger, null, ConnectionIdleMonitor::doMonitor$lambda$13, (int)1, null);
                    }
                    catch (Throwable e2) {
                        logger.warn(e2, () -> ConnectionIdleMonitor.doMonitor$lambda$14(conn));
                    }
                }
            }
        }
    }

    private static final String connectionAcquired$lambda$3$lambda$0(Connection $connection) {
        return "Cancel monitoring for " + $connection;
    }

    private static final String connectionAcquired$lambda$3$lambda$2(Connection $connection, long $cancelTime) {
        return "Monitoring canceled for " + $connection + " in " + Duration.toString-impl((long)$cancelTime);
    }

    private static final String connectionReleased$lambda$4(Job $monitor, Connection $connection) {
        return "Launched coroutine " + $monitor + " to monitor " + $connection;
    }

    private static final String doMonitor$lambda$5(Connection $conn) {
        return "Socket for " + $conn + " closed before monitoring started. Skipping polling loop.";
    }

    private static final String doMonitor$lambda$6(Connection $conn) {
        return "Commence socket monitoring for " + $conn;
    }

    private static final String doMonitor$lambda$7(Connection $conn) {
        return "Polling socket for " + $conn;
    }

    private static final String doMonitor$lambda$8(Connection $conn) {
        return "Socket still alive for " + $conn;
    }

    private static final String doMonitor$lambda$9(Connection $conn) {
        return "Socket closed remotely for " + $conn;
    }

    private static final String doMonitor$lambda$10() {
        return "Monitoring coroutine has been cancelled. Ending polling loop.";
    }

    private static final String doMonitor$lambda$11(Connection $conn) {
        return "Failed to poll " + $conn + ". Ending polling loop. Connection may be unstable now.";
    }

    private static final String doMonitor$lambda$12() {
        return "Attempting to reset soTimeout...";
    }

    private static final String doMonitor$lambda$13() {
        return "soTimeout reset.";
    }

    private static final String doMonitor$lambda$14(Connection $conn) {
        return "Failed to reset socket timeout on " + $conn + ". Connection may be unstable now.";
    }

    public /* synthetic */ ConnectionIdleMonitor(long pollInterval, DefaultConstructorMarker $constructor_marker) {
        this(pollInterval);
    }

    public static final /* synthetic */ CoroutineScope access$getMonitorScope$p(ConnectionIdleMonitor $this) {
        return $this.monitorScope;
    }

    public static final /* synthetic */ Object access$doMonitor(ConnectionIdleMonitor $this, Connection conn, CoroutineContext callContext, Continuation $completion) {
        return $this.doMonitor(conn, callContext, (Continuation<? super Unit>)$completion);
    }
}

