/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.engine.okhttp;

import aws.smithy.kotlin.runtime.http.engine.AlpnId;
import aws.smithy.kotlin.runtime.http.engine.TlsContext;
import aws.smithy.kotlin.runtime.http.engine.internal.HttpClientMetrics;
import aws.smithy.kotlin.runtime.http.engine.okhttp.HttpEngineEventListener;
import aws.smithy.kotlin.runtime.http.engine.okhttp.MetricsInterceptor;
import aws.smithy.kotlin.runtime.http.engine.okhttp.OkHttpDns;
import aws.smithy.kotlin.runtime.http.engine.okhttp.OkHttpEngineConfig;
import aws.smithy.kotlin.runtime.http.engine.okhttp.OkHttpProxyAuthenticator;
import aws.smithy.kotlin.runtime.http.engine.okhttp.OkHttpProxySelector;
import java.net.ProxySelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.ConnectionSpec;
import okhttp3.Dispatcher;
import okhttp3.Dns;
import okhttp3.EventListener;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.TlsVersion;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"minTlsConnectionSpec", "Lokhttp3/ConnectionSpec;", "tlsContext", "Laws/smithy/kotlin/runtime/http/engine/TlsContext;", "toOkHttpTlsVersion", "Lokhttp3/TlsVersion;", "sdkTlsVersion", "Laws/smithy/kotlin/runtime/net/TlsVersion;", "buildClient", "Lokhttp3/OkHttpClient;", "Laws/smithy/kotlin/runtime/http/engine/okhttp/OkHttpEngineConfig;", "metrics", "Laws/smithy/kotlin/runtime/http/engine/internal/HttpClientMetrics;", "http-client-engine-okhttp"})
@SourceDebugExtension(value={"SMAP\nOkHttpEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkHttpEngine.kt\naws/smithy/kotlin/runtime/http/engine/okhttp/OkHttpEngineKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,154:1\n1603#2,9:155\n1855#2:164\n1856#2:166\n1612#2:167\n1549#2:171\n1620#2,3:172\n1#3:165\n3792#4:168\n4307#4,2:169\n37#5,2:175\n*S KotlinDebug\n*F\n+ 1 OkHttpEngine.kt\naws/smithy/kotlin/runtime/http/engine/okhttp/OkHttpEngineKt\n*L\n114#1:155,9\n114#1:164\n114#1:166\n114#1:167\n140#1:171\n140#1:172,3\n114#1:165\n138#1:168\n138#1:169,2\n141#1:175,2\n*E\n"})
public final class OkHttpEngineKt {
    /*
     * WARNING - void declaration
     */
    private static final OkHttpClient buildClient(OkHttpEngineConfig $this$buildClient, HttpClientMetrics metrics) {
        Dispatcher dispatcher;
        OkHttpClient.Builder builder;
        OkHttpEngineConfig config = $this$buildClient;
        OkHttpClient.Builder $this$buildClient_u24lambda_u243 = builder = new OkHttpClient.Builder();
        boolean bl = false;
        $this$buildClient_u24lambda_u243.followRedirects(false);
        $this$buildClient_u24lambda_u243.followSslRedirects(false);
        Object[] objectArray = new ConnectionSpec[]{OkHttpEngineKt.minTlsConnectionSpec(config.getTlsContext()), ConnectionSpec.CLEARTEXT};
        $this$buildClient_u24lambda_u243.connectionSpecs(CollectionsKt.listOf((Object[])objectArray));
        $this$buildClient_u24lambda_u243.retryOnConnectionFailure(false);
        long l = config.getConnectTimeout-UwyO8pc();
        int n = Duration.getNanosecondsComponent-impl((long)l);
        long l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
        $this$buildClient_u24lambda_u243.connectTimeout(duration);
        l = config.getSocketReadTimeout-UwyO8pc();
        n = Duration.getNanosecondsComponent-impl((long)l);
        l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration2 = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"toComponents-impl(...)");
        $this$buildClient_u24lambda_u243.readTimeout(duration2);
        l = config.getSocketWriteTimeout-UwyO8pc();
        n = Duration.getNanosecondsComponent-impl((long)l);
        l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration3 = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"toComponents-impl(...)");
        $this$buildClient_u24lambda_u243.writeTimeout(duration3);
        ConnectionPool pool = new ConnectionPool(5, Duration.getInWholeMilliseconds-impl((long)config.getConnectionIdleTimeout-UwyO8pc()), TimeUnit.MILLISECONDS);
        $this$buildClient_u24lambda_u243.connectionPool(pool);
        Dispatcher $this$buildClient_u24lambda_u243_u24lambda_u240 = dispatcher = new Dispatcher();
        boolean bl2 = false;
        $this$buildClient_u24lambda_u243_u24lambda_u240.setMaxRequests(config.getMaxConcurrency-pVg5ArA());
        $this$buildClient_u24lambda_u243_u24lambda_u240.setMaxRequestsPerHost(config.getMaxConcurrencyPerHost-pVg5ArA());
        Dispatcher dispatcher2 = dispatcher;
        $this$buildClient_u24lambda_u243.dispatcher(dispatcher2);
        $this$buildClient_u24lambda_u243.eventListenerFactory(arg_0 -> OkHttpEngineKt.buildClient$lambda$3$lambda$1(pool, config, dispatcher2, metrics, arg_0));
        if (!((Collection)config.getTlsContext().getAlpn()).isEmpty()) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = config.getTlsContext().getAlpn();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Protocol protocol;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl3 = false;
                AlpnId it = (AlpnId)element$iv$iv;
                boolean bl4 = false;
                switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                    case 1: {
                        protocol = Protocol.HTTP_1_1;
                        break;
                    }
                    case 2: {
                        protocol = Protocol.HTTP_2;
                        break;
                    }
                    case 3: {
                        protocol = Protocol.H2_PRIOR_KNOWLEDGE;
                        break;
                    }
                    default: {
                        protocol = null;
                    }
                }
                if (protocol == null) continue;
                Protocol it$iv$iv = protocol;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List protocols = (List)destination$iv$iv;
            $this$buildClient_u24lambda_u243.protocols(protocols);
        }
        $this$buildClient_u24lambda_u243.proxySelector((ProxySelector)new OkHttpProxySelector(config.getProxySelector()));
        $this$buildClient_u24lambda_u243.proxyAuthenticator((Authenticator)new OkHttpProxyAuthenticator(config.getProxySelector()));
        $this$buildClient_u24lambda_u243.dns((Dns)new OkHttpDns(config.getHostResolver()));
        $this$buildClient_u24lambda_u243.addInterceptor((Interceptor)MetricsInterceptor.INSTANCE);
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final ConnectionSpec minTlsConnectionSpec(TlsContext tlsContext) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        aws.smithy.kotlin.runtime.net.TlsVersion tlsVersion = tlsContext.getMinVersion();
        if (tlsVersion == null) {
            tlsVersion = aws.smithy.kotlin.runtime.net.TlsVersion.TLS_1_2;
        }
        aws.smithy.kotlin.runtime.net.TlsVersion minVersion = tlsVersion;
        aws.smithy.kotlin.runtime.net.TlsVersion[] $this$filter$iv = aws.smithy.kotlin.runtime.net.TlsVersion.values();
        boolean $i$f$filter = false;
        aws.smithy.kotlin.runtime.net.TlsVersion[] tlsVersionArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (aws.smithy.kotlin.runtime.net.TlsVersion element$iv$iv : $this$filterTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            if (!(it.compareTo((Enum)minVersion) >= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = CollectionsKt.sortedDescending((Iterable)((List)destination$iv$iv));
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            aws.smithy.kotlin.runtime.net.TlsVersion element$iv$iv;
            element$iv$iv = (aws.smithy.kotlin.runtime.net.TlsVersion)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(OkHttpEngineKt.toOkHttpTlsVersion((aws.smithy.kotlin.runtime.net.TlsVersion)p0));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        TlsVersion[] okHttpTlsVersions = thisCollection$iv.toArray(new TlsVersion[0]);
        return new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(Arrays.copyOf(okHttpTlsVersions, okHttpTlsVersions.length)).build();
    }

    private static final TlsVersion toOkHttpTlsVersion(aws.smithy.kotlin.runtime.net.TlsVersion sdkTlsVersion) {
        TlsVersion tlsVersion;
        switch (WhenMappings.$EnumSwitchMapping$1[sdkTlsVersion.ordinal()]) {
            case 1: {
                tlsVersion = TlsVersion.TLS_1_0;
                break;
            }
            case 2: {
                tlsVersion = TlsVersion.TLS_1_1;
                break;
            }
            case 3: {
                tlsVersion = TlsVersion.TLS_1_2;
                break;
            }
            case 4: {
                tlsVersion = TlsVersion.TLS_1_3;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return tlsVersion;
    }

    private static final EventListener buildClient$lambda$3$lambda$1(ConnectionPool $pool, OkHttpEngineConfig $config, Dispatcher $dispatcher, HttpClientMetrics $metrics, Call call) {
        Intrinsics.checkNotNullParameter((Object)$pool, (String)"$pool");
        Intrinsics.checkNotNullParameter((Object)((Object)$config), (String)"$config");
        Intrinsics.checkNotNullParameter((Object)$dispatcher, (String)"$dispatcher");
        Intrinsics.checkNotNullParameter((Object)$metrics, (String)"$metrics");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        return new HttpEngineEventListener($pool, $config.getHostResolver(), $dispatcher, $metrics, call);
    }

    public static final /* synthetic */ OkHttpClient access$buildClient(OkHttpEngineConfig $receiver, HttpClientMetrics metrics) {
        return OkHttpEngineKt.buildClient($receiver, metrics);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AlpnId.values().length];
            try {
                nArray[AlpnId.HTTP1_1.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlpnId.HTTP2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlpnId.H2_PRIOR_KNOWLEDGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[aws.smithy.kotlin.runtime.net.TlsVersion.values().length];
            try {
                nArray[aws.smithy.kotlin.runtime.net.TlsVersion.TLS_1_0.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[aws.smithy.kotlin.runtime.net.TlsVersion.TLS_1_1.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[aws.smithy.kotlin.runtime.net.TlsVersion.TLS_1_2.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[aws.smithy.kotlin.runtime.net.TlsVersion.TLS_1_3.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

