/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.engine.okhttp;

import aws.smithy.kotlin.runtime.http.Protocol;
import aws.smithy.kotlin.runtime.http.Url;
import aws.smithy.kotlin.runtime.http.UserInfo;
import aws.smithy.kotlin.runtime.http.engine.ProxyConfig;
import aws.smithy.kotlin.runtime.http.engine.ProxySelector;
import aws.smithy.kotlin.runtime.net.Host;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Authenticator;
import okhttp3.Challenge;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Laws/smithy/kotlin/runtime/http/engine/okhttp/OkHttpProxyAuthenticator;", "Lokhttp3/Authenticator;", "selector", "Laws/smithy/kotlin/runtime/http/engine/ProxySelector;", "(Laws/smithy/kotlin/runtime/http/engine/ProxySelector;)V", "authenticate", "Lokhttp3/Request;", "route", "Lokhttp3/Route;", "response", "Lokhttp3/Response;", "http-client-engine-okhttp"})
public final class OkHttpProxyAuthenticator
implements Authenticator {
    @NotNull
    private final ProxySelector selector;

    public OkHttpProxyAuthenticator(@NotNull ProxySelector selector) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        this.selector = selector;
    }

    @Nullable
    public Request authenticate(@Nullable Route route, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (response.request().header("Proxy-Authorization") != null) {
            return null;
        }
        HttpUrl it = response.request().url();
        boolean bl = false;
        Url url = new Url(new Protocol(it.scheme(), it.port()), Host.Companion.parse(it.host()), it.port(), null, null, null, null, false, false, 504, null);
        ProxyConfig proxyConfig = this.selector.select(url);
        UserInfo userInfo = proxyConfig instanceof ProxyConfig.Http ? ((ProxyConfig.Http)proxyConfig).getUrl().getUserInfo() : null;
        if (userInfo == null) {
            return null;
        }
        UserInfo userInfo2 = userInfo;
        for (Challenge challenge : response.challenges()) {
            String string = challenge.scheme().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            if (!Intrinsics.areEqual((Object)string, (Object)"okhttp-preemptive") && !Intrinsics.areEqual((Object)challenge.scheme(), (Object)"Basic")) continue;
            return response.request().newBuilder().header("Proxy-Authorization", Credentials.basic$default((String)userInfo2.getUsername(), (String)userInfo2.getPassword(), null, (int)4, null)).build();
        }
        return null;
    }
}

