/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.repository.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

class HttpController {
    HttpController() {
    }

    public static boolean getFile(String url, File destinationFile, boolean useTimestamp, boolean useChecksum) throws Exception {
        boolean result = HttpController.getFile(url, destinationFile, useTimestamp);
        if (useChecksum) {
            File checksumFile = new File(destinationFile + ".md5");
            try {
                HttpController.getFile(url + ".md5", checksumFile, useTimestamp);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean getFile(String url, File destinationFile, boolean useTimestamp) throws Exception {
        long remoteTimestamp;
        int length;
        String[] s = HttpController.parseUrl(url);
        String username = s[0];
        String password = s[1];
        String parsedUrl = s[2];
        URL source = new URL(parsedUrl);
        long timestamp = 0L;
        boolean hasTimestamp = false;
        if (useTimestamp && destinationFile.exists()) {
            timestamp = destinationFile.lastModified();
            hasTimestamp = true;
        }
        URLConnection connection = source.openConnection();
        if (useTimestamp && hasTimestamp) {
            connection.setIfModifiedSince(timestamp);
        }
        connection.connect();
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            if (httpConnection.getResponseCode() == 304) {
                return false;
            }
            if (httpConnection.getResponseCode() == 401) {
                throw new Exception("Not authorized.");
            }
        }
        InputStream is = null;
        for (int i = 0; i < 3; ++i) {
            try {
                is = connection.getInputStream();
                break;
            }
            catch (IOException ex) {
                continue;
            }
        }
        if (is == null) {
            String error = "Connection returned a null input stream: " + url;
            throw new IOException(error);
        }
        File parent = destinationFile.getParentFile();
        parent.mkdirs();
        FileOutputStream fos = new FileOutputStream(destinationFile);
        byte[] buffer = new byte[102400];
        while ((length = is.read(buffer)) >= 0) {
            fos.write(buffer, 0, length);
        }
        fos.close();
        is.close();
        if (useTimestamp && (remoteTimestamp = connection.getLastModified()) != 0L) {
            HttpController.touchFile(destinationFile, remoteTimestamp);
        }
        return true;
    }

    static String[] parseUrl(String url) {
        String[] parsedUrl = new String[]{null, null, url};
        int i = url.indexOf("@");
        if (i > 0) {
            String s = url.substring(7, i);
            int j = s.indexOf(":");
            parsedUrl[0] = s.substring(0, j);
            parsedUrl[1] = s.substring(j + 1);
            parsedUrl[2] = "http://" + url.substring(i + 1);
        }
        return parsedUrl;
    }

    private static boolean touchFile(File file, long timemillis) throws Exception {
        long modifiedTime = timemillis < 0L ? System.currentTimeMillis() : timemillis;
        file.setLastModified(modifiedTime);
        return true;
    }
}

