/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.repository.impl;

import java.io.File;
import java.net.Authenticator;
import java.net.URL;
import java.util.Hashtable;
import org.apache.avalon.repository.ProxyContext;
import org.apache.avalon.repository.Repository;
import org.apache.avalon.repository.RepositoryException;
import org.apache.avalon.repository.impl.HttpController;

public class DefaultFileRepository
implements Repository {
    private final File m_base;
    private final URL[] m_hosts;

    public DefaultFileRepository(File base) {
        this(base, null, new URL[0]);
    }

    public DefaultFileRepository(File base, URL[] hosts) {
        this(base, null, hosts);
    }

    public DefaultFileRepository(File base, ProxyContext context, URL[] hosts) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        this.m_base = base;
        if (hosts == null) {
            this.m_hosts = new URL[0];
        } else {
            this.m_hosts = new URL[hosts.length];
            for (int i = 0; i < hosts.length; ++i) {
                URL url = hosts[i];
                String path = url.toString();
                if (!path.endsWith("/")) {
                    try {
                        this.m_hosts[i] = new URL(path + "/");
                        continue;
                    }
                    catch (Throwable e) {
                        String error = "Could not coerce supplied URL to a directory reference: " + path;
                        throw new IllegalArgumentException(error);
                    }
                }
                this.m_hosts[i] = hosts[i];
            }
        }
        if (context != null) {
            ((Hashtable)System.getProperties()).put("proxySet", "true");
            ((Hashtable)System.getProperties()).put("proxyHost", context.getHost());
            ((Hashtable)System.getProperties()).put("proxyPort", context.getPort());
            if (context.getAuthenticator() != null) {
                Authenticator.setDefault(context.getAuthenticator());
            }
        }
    }

    public URL getArtifact(String artifact, String version, String type) throws RepositoryException {
        int n = this.verify(artifact);
        String group = this.getGroupName(artifact, n);
        String name = this.getResourceName(artifact, n);
        return this.getArtifact(group, name, version, type);
    }

    public URL getArtifact(String group, String name, String version, String type) throws RepositoryException {
        if (this.m_hosts == null) {
            throw new IllegalStateException("hosts");
        }
        if (group == null) {
            throw new NullPointerException("group");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        String path = group + "/" + type + "s/" + name;
        if (version != null && version.length() != 0) {
            path = path + "-" + version;
        }
        path = path + "." + type;
        RepositoryException repositoryException = null;
        try {
            return this.getLocalArtifact(group, name, version, type);
        }
        catch (RepositoryException e) {
            repositoryException = e;
            for (int i = 0; i < this.m_hosts.length; ++i) {
                URL source = this.m_hosts[i];
                String host = source.toString();
                File local = new File(this.m_base, path);
                String url = host + path;
                try {
                    if (!HttpController.getFile(url, local, true)) continue;
                    return this.getLocalArtifact(group, name, version, type);
                }
                catch (Throwable anything) {
                    // empty catch block
                }
            }
        }
        catch (Throwable e) {
            String error = "Unexpected error while attempting to resolve artifact: " + path;
            throw new RepositoryException(error, e);
        }
        throw repositoryException;
    }

    private URL getLocalArtifact(String group, String name, String version, String type) throws RepositoryException {
        File resource;
        File application = new File(this.m_base, group);
        if (!application.exists()) {
            String error = "Unknown group: '" + group + "' relative to the repository base: '" + this.m_base + "'.";
            throw new RepositoryException(error);
        }
        File types = new File(application, type + "s");
        if (!types.exists()) {
            String error = "No resources of the type: '" + type + "' in the group: '" + group + "'. File: '" + types + "'.";
            throw new RepositoryException(error);
        }
        String resourceName = name;
        if (version != null && version.length() != 0) {
            resourceName = resourceName + "-" + version;
        }
        if (!(resource = new File(types, resourceName + "." + type)).exists()) {
            String error = "No resources of the type: '" + type + "' in the group: '" + group + "' with the name: '" + name + "' and version: '" + version + ". File: '" + resource + "'.";
            throw new RepositoryException(error);
        }
        try {
            return resource.toURL();
        }
        catch (Throwable e) {
            String error = "Unable to resolve URL for resource: " + resource;
            throw new RepositoryException(error);
        }
    }

    private int verify(String artifact) throws RepositoryException {
        int n = artifact.indexOf(":");
        if (n < 1) {
            String error = "Invalid artifact name: " + artifact;
            throw new RepositoryException(error);
        }
        return n;
    }

    private String getGroupName(String artifact, int index) {
        return artifact.substring(0, index);
    }

    private String getResourceName(String artifact, int index) {
        return artifact.substring(index + 1);
    }
}

