/*
 * Decompiled with CFR 0.152.
 */
package ar.com.jmfsg.documentation;

import ar.com.jmfsg.documentation.DocumentationDescriptor;
import ar.com.jmfsg.documentation.annotation.Documentation;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class DocumentationLoader
implements InitializingBean,
ApplicationContextAware {
    private Map<String, JSONArray> docByModule;
    private Map<String, String> dictionary = new HashMap<String, String>();
    private Map<String, JSONObject> tags = new HashMap<String, JSONObject>();
    private Map<String, JSONObject> groupDocs = new HashMap<String, JSONObject>();
    private JSONObject generalDoc = new JSONObject();
    private JSONObject rawDoc;
    private static ApplicationContext ctx = null;
    private static DocumentationLoader instance;

    public JSONArray getDocumentationForModule(String prefix) {
        return this.docByModule.get(prefix);
    }

    public Map<String, JSONArray> getDocumentation() {
        return this.docByModule;
    }

    private static ApplicationContext getApplicationContext() {
        return ctx;
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        DocumentationLoader.ctx = ctx;
    }

    public static void setGeneralProperty(String key, String value) {
        instance.getGeneralDoc().put((Object)key, (Object)value);
    }

    public void afterPropertiesSet() throws Exception {
        instance = this;
        this.docByModule = new HashMap<String, JSONArray>();
        for (DocumentationDescriptor d : DocumentationLoader.getApplicationContext().getBeansOfType(DocumentationDescriptor.class).values()) {
            JSONObject doc = this.readDoc(d.getResource());
            String modulePrefix = StringUtils.isEmpty((String)d.getModulePrefix()) ? "" : d.getModulePrefix();
            this.appendRaw(doc);
            if (doc.has("general")) {
                this.getGeneralDoc().accumulateAll((Map)doc.getJSONObject("general"));
            }
            if (doc.has("dictionary")) {
                this.addToDictionary(doc.getJSONArray("dictionary"));
            }
            if (doc.has("groups")) {
                this.addToGroupDocs(doc.getJSONObject("groups"));
            }
            if (doc.has("tags")) {
                this.addToTags(doc.getJSONArray("tags"));
            }
            if (doc.has("methods")) {
                if (this.docByModule.containsKey(d.getModulePrefix())) {
                    this.docByModule.get(modulePrefix).addAll((Collection)doc.getJSONArray("methods"));
                } else {
                    this.docByModule.put(modulePrefix, doc.getJSONArray("methods"));
                }
            }
            if (d.getPackagesToScan() == null) continue;
            for (String pack : d.getPackagesToScan()) {
                Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls((Collection)ClasspathHelper.forPackage((String)pack, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new MethodAnnotationsScanner()}));
                Set annotated = reflections.getMethodsAnnotatedWith(Documentation.class);
                for (Method m : annotated) {
                    JSONObject o = JSONObject.fromObject((Object)m.getAnnotation(Documentation.class).data());
                    JSONObject original = this.getObjectLoadedFromResource(this.docByModule.get(modulePrefix), m.getName());
                    if (original != null) {
                        original.accumulateAll((Map)o);
                        continue;
                    }
                    this.docByModule.get(modulePrefix).add((Object)o);
                }
            }
        }
    }

    private void appendRaw(JSONObject doc) {
        if (this.rawDoc == null) {
            this.rawDoc = new JSONObject();
        }
        this.mergeJSONObjects(this.rawDoc, doc);
    }

    private void mergeJSONObjects(JSONObject rawDoc, JSONObject doc) {
        Set updateKeys = doc.keySet();
        for (String key : updateKeys) {
            if (rawDoc.containsKey((Object)key)) {
                Object object = rawDoc.get(key);
                if (object instanceof JSONObject && !((JSONObject)object).isNullObject()) {
                    this.mergeJSONObjects((JSONObject)object, doc.getJSONObject(key));
                    continue;
                }
                if (object instanceof JSONArray) {
                    ((JSONArray)object).addAll((Collection)doc.getJSONArray(key));
                    continue;
                }
                rawDoc.put((Object)key, doc.get(key));
                continue;
            }
            rawDoc.put((Object)key, doc.get(key));
        }
    }

    private void addToGroupDocs(JSONObject jsonObject) {
        for (Object group : jsonObject.keySet()) {
            JSONObject doc = (JSONObject)jsonObject.get(group);
            this.groupDocs.put((String)group, doc);
        }
    }

    private void addToDictionary(JSONArray jsonArray) {
        int i = 0;
        while (i < jsonArray.size()) {
            JSONObject o = (JSONObject)jsonArray.get(i);
            if (o.has("key") && o.has("description")) {
                this.getDictionary().put(o.getString("key"), o.getString("description"));
            }
            ++i;
        }
    }

    private void addToTags(JSONArray jsonArray) {
        int i = 0;
        while (i < jsonArray.size()) {
            JSONObject o = (JSONObject)jsonArray.get(i);
            if (o.has("name") && o.has("color")) {
                this.getTags().put(o.getString("name"), o);
            }
            ++i;
        }
    }

    private JSONObject getObjectLoadedFromResource(JSONArray jsonArray, String name) {
        int i = 0;
        while (i < jsonArray.size()) {
            JSONObject o = (JSONObject)jsonArray.get(i);
            if (o.has(name)) {
                return o.getJSONObject(name);
            }
            ++i;
        }
        return null;
    }

    private JSONObject readDoc(Resource r) throws IOException, URISyntaxException {
        return JSONObject.fromObject((Object)DocumentationLoader.readAll(r));
    }

    public static String readAll(Resource res) throws IOException {
        InputStream s = null;
        InputStreamReader r = null;
        StringBuilder content = new StringBuilder();
        try {
            s = res.getInputStream();
            r = new InputStreamReader(s);
            char[] buffer = new char[4096];
            int n = 0;
            while (n >= 0) {
                n = r.read(buffer, 0, buffer.length);
                if (n <= 0) continue;
                content.append(buffer, 0, n);
            }
        }
        finally {
            if (r != null) {
                r.close();
            }
            if (s != null) {
                s.close();
            }
        }
        return content.toString();
    }

    public JSONObject getGeneralDoc() {
        return this.generalDoc;
    }

    public JSONObject getRawDoc() {
        return this.rawDoc;
    }

    public Map<String, String> getDictionary() {
        return this.dictionary;
    }

    public Map<String, JSONObject> getGroupDocs() {
        return this.groupDocs;
    }

    public Map<String, JSONObject> getTags() {
        return this.tags;
    }
}

