/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.servlet;

import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.myfaces.shared_impl.util.NullEnumeration;
import org.apache.myfaces.util.AbstractAttributeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SessionMap
extends AbstractAttributeMap<Object> {
    private final HttpServletRequest _httpRequest;

    SessionMap(HttpServletRequest httpRequest) {
        this._httpRequest = httpRequest;
    }

    @Override
    protected Object getAttribute(String key) {
        HttpSession httpSession = this.getSession();
        return httpSession == null ? null : httpSession.getAttribute(key);
    }

    @Override
    protected void setAttribute(String key, Object value) {
        this._httpRequest.getSession(true).setAttribute(key, value);
    }

    @Override
    protected void removeAttribute(String key) {
        HttpSession httpSession = this.getSession();
        if (httpSession != null) {
            httpSession.removeAttribute(key);
        }
    }

    @Override
    protected Enumeration<String> getAttributeNames() {
        HttpSession httpSession = this.getSession();
        return httpSession == null ? NullEnumeration.instance() : httpSession.getAttributeNames();
    }

    private HttpSession getSession() {
        return this._httpRequest.getSession(false);
    }

    @Override
    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        HttpSession session = this.getSession();
        if (session == null) {
            return;
        }
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            session.removeAttribute(attributeName);
        }
    }
}

