/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.myfaces.config.annotation.NoInjectionAnnotationLifecycleProvider;

public class ResourceAnnotationLifecycleProvider
extends NoInjectionAnnotationLifecycleProvider {
    protected Context context;
    private static final String JAVA_COMP_ENV = "java:comp/env/";

    public ResourceAnnotationLifecycleProvider(Context context) {
        this.context = context;
    }

    protected void processAnnotations(Object instance) throws IllegalAccessException, InvocationTargetException, NamingException {
        if (this.context == null) {
            return;
        }
        this.checkAnnotation(instance.getClass(), instance);
    }

    private void checkAnnotation(Class clazz, Object instance) throws NamingException, IllegalAccessException, InvocationTargetException {
        Method[] methods;
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            this.checkFieldAnnotation(field, instance);
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            this.checkMethodAnnotation(method, instance);
        }
    }

    protected void checkMethodAnnotation(Method method, Object instance) throws NamingException, IllegalAccessException, InvocationTargetException {
        if (method.isAnnotationPresent(Resource.class)) {
            Resource annotation = method.getAnnotation(Resource.class);
            ResourceAnnotationLifecycleProvider.lookupMethodResource(this.context, instance, method, annotation.name());
        }
    }

    protected void checkFieldAnnotation(Field field, Object instance) throws NamingException, IllegalAccessException {
        if (field.isAnnotationPresent(Resource.class)) {
            Resource annotation = field.getAnnotation(Resource.class);
            ResourceAnnotationLifecycleProvider.lookupFieldResource(this.context, instance, field, annotation.name());
        }
    }

    protected static void lookupFieldResource(Context context, Object instance, Field field, String name) throws NamingException, IllegalAccessException {
        Object lookedupResource = name != null && name.length() > 0 ? context.lookup(JAVA_COMP_ENV + name) : context.lookup(JAVA_COMP_ENV + instance.getClass().getName() + "/" + field.getName());
        boolean accessibility = field.isAccessible();
        field.setAccessible(true);
        field.set(instance, lookedupResource);
        field.setAccessible(accessibility);
    }

    protected static void lookupMethodResource(Context context, Object instance, Method method, String name) throws NamingException, IllegalAccessException, InvocationTargetException {
        if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1 || !method.getReturnType().getName().equals("void")) {
            throw new IllegalArgumentException("Invalid method resource injection annotation");
        }
        Object lookedupResource = name != null && name.length() > 0 ? context.lookup(JAVA_COMP_ENV + name) : context.lookup(JAVA_COMP_ENV + instance.getClass().getName() + "/" + method.getName().substring(3));
        boolean accessibility = method.isAccessible();
        method.setAccessible(true);
        method.invoke(instance, lookedupResource);
        method.setAccessible(accessibility);
    }
}

