/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.faces.context.ExternalContext;
import javax.faces.el.PropertyResolver;
import javax.faces.el.VariableResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.config.element.NavigationRule;
import org.apache.myfaces.config.impl.digester.elements.ResourceBundle;
import org.apache.myfaces.el.CompositeELResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeConfig {
    private static final Log log = LogFactory.getLog(RuntimeConfig.class);
    private static final String APPLICATION_MAP_PARAM_NAME = RuntimeConfig.class.getName();
    private final Collection<NavigationRule> _navigationRules = new ArrayList<NavigationRule>();
    private final Map<String, ManagedBean> _managedBeans = new HashMap<String, ManagedBean>();
    private boolean _navigationRulesChanged = false;
    private final Map<String, ResourceBundle> _resourceBundles = new HashMap<String, ResourceBundle>();
    private final Map<String, ManagedBean> _oldManagedBeans = new HashMap<String, ManagedBean>();
    private javax.el.CompositeELResolver facesConfigElResolvers;
    private javax.el.CompositeELResolver applicationElResolvers;
    private VariableResolver _variableResolver;
    private PropertyResolver _propertyResolver;
    private ExpressionFactory _expressionFactory;
    private PropertyResolver _propertyResolverChainHead;
    private VariableResolver _variableResolverChainHead;

    public static RuntimeConfig getCurrentInstance(ExternalContext externalContext) {
        RuntimeConfig runtimeConfig = (RuntimeConfig)externalContext.getApplicationMap().get(APPLICATION_MAP_PARAM_NAME);
        if (runtimeConfig == null) {
            runtimeConfig = new RuntimeConfig();
            externalContext.getApplicationMap().put(APPLICATION_MAP_PARAM_NAME, runtimeConfig);
        }
        return runtimeConfig;
    }

    public void purge() {
        this._navigationRules.clear();
        this._oldManagedBeans.clear();
        this._oldManagedBeans.putAll(this._managedBeans);
        this._managedBeans.clear();
        this._navigationRulesChanged = false;
    }

    public Collection<NavigationRule> getNavigationRules() {
        return Collections.unmodifiableCollection(this._navigationRules);
    }

    public void addNavigationRule(NavigationRule navigationRule) {
        this._navigationRules.add(navigationRule);
        this._navigationRulesChanged = true;
    }

    public boolean isNavigationRulesChanged() {
        return this._navigationRulesChanged;
    }

    public void setNavigationRulesChanged(boolean navigationRulesChanged) {
        this._navigationRulesChanged = navigationRulesChanged;
    }

    public ManagedBean getManagedBean(String name) {
        return this._managedBeans.get(name);
    }

    public Map<String, ManagedBean> getManagedBeans() {
        return Collections.unmodifiableMap(this._managedBeans);
    }

    public void addManagedBean(String name, ManagedBean managedBean) {
        this._managedBeans.put(name, managedBean);
        if (this._oldManagedBeans != null) {
            this._oldManagedBeans.remove(name);
        }
    }

    public ResourceBundle getResourceBundle(String name) {
        return this._resourceBundles.get(name);
    }

    public Map<String, ResourceBundle> getResourceBundles() {
        return this._resourceBundles;
    }

    public void addResourceBundle(ResourceBundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("bundle must not be null");
        }
        String var = bundle.getVar();
        if (this._resourceBundles.containsKey(var) && log.isWarnEnabled()) {
            log.warn((Object)("Another resource bundle for var '" + var + "' with base name '" + this._resourceBundles.get(var).getBaseName() + "' is already registered. '" + this._resourceBundles.get(var).getBaseName() + "' will be replaced with '" + bundle.getBaseName() + "'."));
        }
        this._resourceBundles.put(var, bundle);
    }

    public void addFacesConfigElResolver(ELResolver resolver) {
        if (this.facesConfigElResolvers == null) {
            this.facesConfigElResolvers = new CompositeELResolver();
        }
        this.facesConfigElResolvers.add(resolver);
    }

    public ELResolver getFacesConfigElResolvers() {
        return this.facesConfigElResolvers;
    }

    public void addApplicationElResolver(ELResolver resolver) {
        if (this.applicationElResolvers == null) {
            this.applicationElResolvers = new CompositeELResolver();
        }
        this.applicationElResolvers.add(resolver);
    }

    public ELResolver getApplicationElResolvers() {
        return this.applicationElResolvers;
    }

    public void setVariableResolver(VariableResolver variableResolver) {
        this._variableResolver = variableResolver;
    }

    public VariableResolver getVariableResolver() {
        return this._variableResolver;
    }

    public void setPropertyResolver(PropertyResolver propertyResolver) {
        this._propertyResolver = propertyResolver;
    }

    public PropertyResolver getPropertyResolver() {
        return this._propertyResolver;
    }

    public ExpressionFactory getExpressionFactory() {
        return this._expressionFactory;
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this._expressionFactory = expressionFactory;
    }

    public void setPropertyResolverChainHead(PropertyResolver resolver) {
        this._propertyResolverChainHead = resolver;
    }

    public PropertyResolver getPropertyResolverChainHead() {
        return this._propertyResolverChainHead;
    }

    public void setVariableResolverChainHead(VariableResolver resolver) {
        this._variableResolverChainHead = resolver;
    }

    public VariableResolver getVariableResolverChainHead() {
        return this._variableResolverChainHead;
    }

    public Map getManagedBeansNotReaddedAfterPurge() {
        return this._oldManagedBeans;
    }

    public void resetManagedBeansNotReaddedAfterPurge() {
        this._oldManagedBeans.clear();
    }
}

