/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.dotnet;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;

public class NetCommand {
    protected Task owner;
    protected Execute executable;
    protected Commandline commandLine;
    protected String title;
    protected String program;
    protected boolean traceCommandLine = false;
    protected boolean failOnError;

    public NetCommand(Task owner, String title, String program) {
        this.owner = owner;
        this.title = title;
        this.program = program;
        this.commandLine = new Commandline();
        this.commandLine.setExecutable(program);
        this.prepareExecutor();
    }

    public void setTraceCommandLine(boolean b) {
        this.traceCommandLine = b;
    }

    public void setFailOnError(boolean b) {
        this.failOnError = b;
    }

    public boolean getFailFailOnError() {
        return this.failOnError;
    }

    protected void logVerbose(String msg) {
        this.owner.getProject().log(msg, 3);
    }

    protected void logError(String msg) {
        this.owner.getProject().log(msg, 0);
    }

    public void addArgument(String argument) {
        if (argument != null && argument.length() != 0) {
            this.commandLine.createArgument().setValue(argument);
        }
    }

    public void addArgument(String argument1, String argument2) {
        if (argument2 != null && argument2.length() != 0) {
            this.commandLine.createArgument().setValue(argument1 + argument2);
        }
    }

    protected void prepareExecutor() {
        if (this.owner == null) {
            throw new RuntimeException("no owner");
        }
        if (this.owner.getProject() == null) {
            throw new RuntimeException("Owner has no project");
        }
        File dir = this.owner.getProject().getBaseDir();
        LogStreamHandler handler = new LogStreamHandler(this.owner, 2, 1);
        this.executable = new Execute((ExecuteStreamHandler)handler, null);
        this.executable.setAntRun(this.owner.getProject());
        this.executable.setWorkingDirectory(dir);
    }

    public void runCommand() throws BuildException {
        int err = -1;
        try {
            if (this.traceCommandLine) {
                this.owner.log(this.commandLine.describeCommand());
            } else {
                this.logVerbose(this.commandLine.describeCommand());
            }
            this.executable.setCommandline(this.commandLine.getCommandline());
            err = this.executable.execute();
            if (err != 0) {
                if (this.failOnError) {
                    throw new BuildException(this.title + " returned: " + err, this.owner.getLocation());
                }
                this.owner.log(this.title + "  Result: " + err, 0);
            }
        }
        catch (IOException e) {
            throw new BuildException(this.title + " failed: " + e, (Throwable)e, this.owner.getLocation());
        }
    }
}

