/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPool;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.Utils;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.AttributeInfoList;

public class FieldInfo {
    protected ConstantPool constantPool;
    protected int access_flags;
    protected int name_index;
    protected int descriptor_index;
    protected AttributeInfoList attributes;
    protected boolean synthetic;
    protected boolean deprecated;
    protected boolean constant;

    public FieldInfo(ConstantPool pool) {
        this.constantPool = pool;
    }

    public void read(DataInputStream dis) throws IOException {
        this.access_flags = dis.readShort();
        this.name_index = dis.readShort();
        this.descriptor_index = dis.readShort();
        this.attributes = new AttributeInfoList(this.constantPool);
        this.attributes.read(dis);
        this.constant = this.attributes.getAttribute("ConstantValue") != null;
        this.deprecated = this.attributes.getAttribute("Deprecated") != null;
        this.synthetic = this.attributes.getAttribute("Synthetic") != null;
    }

    public int getAccessFlags() {
        return this.access_flags;
    }

    public String getName() {
        return Utils.getUTF8Value(this.constantPool, this.name_index);
    }

    public String getDescriptor() {
        return Utils.getUTF8Value(this.constantPool, this.descriptor_index);
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public String getAccess() {
        return Utils.getFieldAccess(this.access_flags);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Field: ");
        sb.append(this.getAccess()).append(" ");
        Utils.descriptor2java(this.getDescriptor(), 0, sb);
        sb.append(" ").append(this.getName());
        return sb.toString();
    }
}

