/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.sitraka.ReportFilters;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.ClassFile;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.ClassPathLoader;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.MethodInfo;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.MethodInfoList;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLReport {
    protected Task task;
    protected File file;
    protected File jprobeHome;
    protected Document report;
    protected Hashtable pkgMap;
    protected Hashtable classMap;
    protected ReportFilters filters;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$optional$sitraka$XMLReport;

    public XMLReport(File file) {
        this(null, file);
    }

    public XMLReport(Task task, File file) {
        this.file = file;
        this.task = task;
    }

    public void setJProbehome(File home) {
        this.jprobeHome = home;
    }

    public void setReportFilters(ReportFilters filters) {
        this.filters = filters;
    }

    protected void createNodeMaps() {
        this.pkgMap = new Hashtable();
        this.classMap = new Hashtable();
        NodeList packages = this.report.getElementsByTagName("package");
        int pkglen = packages.getLength();
        this.log("Indexing " + pkglen + " packages");
        int i = pkglen - 1;
        while (i > -1) {
            Element pkg = (Element)packages.item(i);
            String pkgname = pkg.getAttribute("name");
            int nbclasses = 0;
            NodeList classes = pkg.getElementsByTagName("class");
            int classlen = classes.getLength();
            this.log("Indexing " + classlen + " classes in package " + pkgname);
            int j = classlen - 1;
            while (j > -1) {
                Element clazz = (Element)classes.item(j);
                String classname = clazz.getAttribute("name");
                if (pkgname != null && pkgname.length() != 0) {
                    classname = pkgname + "." + classname;
                }
                int nbmethods = 0;
                NodeList methods = clazz.getElementsByTagName("method");
                int methodlen = methods.getLength();
                int k = methodlen - 1;
                while (k > -1) {
                    Element meth = (Element)methods.item(k);
                    StringBuffer methodname = new StringBuffer(meth.getAttribute("name"));
                    methodname.delete(methodname.toString().indexOf("("), methodname.toString().length());
                    String signature = classname + "." + methodname + "()";
                    if (this.filters.accept(signature)) {
                        this.log("keeped method:" + signature);
                        ++nbmethods;
                    } else {
                        clazz.removeChild(meth);
                    }
                    --k;
                }
                if (nbmethods != 0) {
                    this.log("Adding class '" + classname + "'");
                    this.classMap.put(classname, clazz);
                    ++nbclasses;
                } else {
                    pkg.removeChild(clazz);
                }
                --j;
            }
            if (nbclasses != 0) {
                this.log("Adding package '" + pkgname + "'");
                this.pkgMap.put(pkgname, pkg);
            } else {
                pkg.getParentNode().removeChild(pkg);
            }
            --i;
        }
        this.log("Indexed " + this.classMap.size() + " classes in " + this.pkgMap.size() + " packages");
    }

    public Document createDocument(String[] classPath) throws Exception {
        DocumentBuilder dbuilder = XMLReport.newBuilder();
        InputSource is = new InputSource(new FileInputStream(this.file));
        if (this.jprobeHome != null) {
            File dtdDir = new File(this.jprobeHome, "Dtd/snapshot.dtd");
            is.setSystemId("file:///" + dtdDir.getAbsolutePath());
        }
        this.report = dbuilder.parse(is);
        this.report.normalize();
        this.createNodeMaps();
        ClassPathLoader cpl = new ClassPathLoader(classPath);
        Enumeration enumeration = cpl.loaders();
        while (enumeration.hasMoreElements()) {
            ClassPathLoader.FileLoader fl = (ClassPathLoader.FileLoader)enumeration.nextElement();
            ClassFile[] classes = fl.getClasses();
            this.log("Processing " + classes.length + " classes in " + fl.getFile());
            int i = 0;
            while (i < classes.length) {
                this.serializeClass(classes[i]);
                ++i;
            }
        }
        this.update();
        return this.report;
    }

    protected String getMethodSignature(MethodInfo method) {
        StringBuffer buf = new StringBuffer(method.getName());
        buf.append("(");
        String[] params = method.getParametersType();
        int i = 0;
        while (i < params.length) {
            String pkg;
            String type = params[i];
            int pos = type.lastIndexOf(46);
            if (pos != -1 && "java.lang".equals(pkg = type.substring(0, pos))) {
                params[i] = type.substring(pos + 1);
            }
            buf.append(params[i]);
            if (i != params.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }

    protected String getMethodSignature(ClassFile clazz, MethodInfo method) {
        StringBuffer buf = new StringBuffer(clazz.getFullName());
        buf.append(".");
        buf.append(method.getName());
        buf.append("()");
        return buf.toString();
    }

    protected void removeAbstractMethods(ClassFile classFile, Element classNode) {
        MethodInfoList methods = classFile.getMethods();
        Hashtable methodNodeList = this.getMethods(classNode);
        int size = methods.length();
        int i = 0;
        while (i < size) {
            MethodInfo method = methods.getMethod(i);
            String methodSig = this.getMethodSignature(method);
            Element methodNode = (Element)methodNodeList.get(methodSig);
            if (methodNode != null && Utils.isAbstract(method.getAccessFlags())) {
                this.log("\tRemoving method " + methodSig);
                classNode.removeChild(methodNode);
            }
            ++i;
        }
    }

    protected Element createMethodElement(MethodInfo method) {
        String methodsig = this.getMethodSignature(method);
        Element methodElem = this.report.createElement("method");
        methodElem.setAttribute("name", methodsig);
        Element methodData = this.report.createElement("cov.data");
        methodElem.appendChild(methodData);
        methodData.setAttribute("calls", "0");
        methodData.setAttribute("hit_lines", "0");
        methodData.setAttribute("total_lines", String.valueOf(method.getNumberOfLines()));
        return methodElem;
    }

    protected Element createPackageElement(String pkgname) {
        Element pkgElem = this.report.createElement("package");
        pkgElem.setAttribute("name", pkgname);
        Element pkgData = this.report.createElement("cov.data");
        pkgElem.appendChild(pkgData);
        pkgData.setAttribute("calls", "0");
        pkgData.setAttribute("hit_methods", "0");
        pkgData.setAttribute("total_methods", "0");
        pkgData.setAttribute("hit_lines", "0");
        pkgData.setAttribute("total_lines", "0");
        return pkgElem;
    }

    protected Element createClassElement(ClassFile classFile) {
        Element classElem = this.report.createElement("class");
        classElem.setAttribute("name", classFile.getName());
        classElem.setAttribute("source", classFile.getSourceFile());
        Element classData = this.report.createElement("cov.data");
        classElem.appendChild(classData);
        classData.setAttribute("calls", "0");
        classData.setAttribute("hit_methods", "0");
        classData.setAttribute("total_methods", "0");
        classData.setAttribute("hit_lines", "0");
        classData.setAttribute("total_lines", "0");
        return classElem;
    }

    protected void serializeClass(ClassFile classFile) {
        String fullclassname = classFile.getFullName();
        this.log("Looking for '" + fullclassname + "'");
        Element clazz = (Element)this.classMap.get(fullclassname);
        if (clazz != null) {
            this.log("Ignoring " + fullclassname);
            this.removeAbstractMethods(classFile, clazz);
            return;
        }
        if (Utils.isInterface(classFile.getAccess())) {
            return;
        }
        Vector methods = this.getFilteredMethods(classFile);
        if (methods.size() == 0) {
            return;
        }
        String pkgname = classFile.getPackage();
        Element pkgElem = (Element)this.pkgMap.get(pkgname);
        if (pkgElem == null) {
            pkgElem = this.createPackageElement(pkgname);
            this.report.getDocumentElement().appendChild(pkgElem);
            this.pkgMap.put(pkgname, pkgElem);
        }
        Element classElem = this.createClassElement(classFile);
        pkgElem.appendChild(classElem);
        int total_lines = 0;
        int total_methods = 0;
        int i = 0;
        while (i < methods.size()) {
            MethodInfo method = (MethodInfo)methods.elementAt(i);
            if (!Utils.isAbstract(method.getAccessFlags())) {
                Element methodElem = this.createMethodElement(method);
                classElem.appendChild(methodElem);
                total_lines += method.getNumberOfLines();
                ++total_methods;
            }
            ++i;
        }
        Element classData = this.getCovDataChild(classElem);
        classData.setAttribute("total_methods", String.valueOf(total_methods));
        classData.setAttribute("total_lines", String.valueOf(total_lines));
        this.classMap.put(fullclassname, classElem);
    }

    protected Vector getFilteredMethods(ClassFile classFile) {
        Vector<MethodInfo> methods = new Vector<MethodInfo>();
        MethodInfoList methodlist = classFile.getMethods();
        int i = 0;
        while (i < methodlist.length()) {
            MethodInfo method = methodlist.getMethod(i);
            String signature = this.getMethodSignature(classFile, method);
            if (this.filters.accept(signature)) {
                methods.addElement(method);
                this.log("keeping " + signature);
            }
            ++i;
        }
        return methods;
    }

    protected void update() {
        int calls = 0;
        int hit_methods = 0;
        int total_methods = 0;
        int hit_lines = 0;
        int total_lines = 0;
        Enumeration enumeration = this.pkgMap.elements();
        while (enumeration.hasMoreElements()) {
            Element pkgElem = (Element)enumeration.nextElement();
            String pkgname = pkgElem.getAttribute("name");
            Element[] classes = this.getClasses(pkgElem);
            int pkg_calls = 0;
            int pkg_hit_methods = 0;
            int pkg_total_methods = 0;
            int pkg_hit_lines = 0;
            int pkg_total_lines = 0;
            int j = 0;
            while (j < classes.length) {
                Element clazz = classes[j];
                String classname = clazz.getAttribute("name");
                if (pkgname != null && pkgname.length() != 0) {
                    classname = pkgname + "." + classname;
                }
                Element covdata = this.getCovDataChild(clazz);
                try {
                    pkg_calls += Integer.parseInt(covdata.getAttribute("calls"));
                    pkg_hit_methods += Integer.parseInt(covdata.getAttribute("hit_methods"));
                    pkg_total_methods += Integer.parseInt(covdata.getAttribute("total_methods"));
                    pkg_hit_lines += Integer.parseInt(covdata.getAttribute("hit_lines"));
                    pkg_total_lines += Integer.parseInt(covdata.getAttribute("total_lines"));
                }
                catch (NumberFormatException e) {
                    System.err.println("Error parsing '" + classname + "' (" + j + "/" + classes.length + ") in package '" + pkgname + "'");
                    throw e;
                }
                ++j;
            }
            Element covdata = this.getCovDataChild(pkgElem);
            covdata.setAttribute("calls", String.valueOf(pkg_calls));
            covdata.setAttribute("hit_methods", String.valueOf(pkg_hit_methods));
            covdata.setAttribute("total_methods", String.valueOf(pkg_total_methods));
            covdata.setAttribute("hit_lines", String.valueOf(pkg_hit_lines));
            covdata.setAttribute("total_lines", String.valueOf(pkg_total_lines));
            calls += pkg_calls;
            hit_methods += pkg_hit_methods;
            total_methods += pkg_total_methods;
            hit_lines += pkg_hit_lines;
            total_lines += pkg_total_lines;
        }
        Element covdata = this.getCovDataChild(this.report.getDocumentElement());
        covdata.setAttribute("calls", String.valueOf(calls));
        covdata.setAttribute("hit_methods", String.valueOf(hit_methods));
        covdata.setAttribute("total_methods", String.valueOf(total_methods));
        covdata.setAttribute("hit_lines", String.valueOf(hit_lines));
        covdata.setAttribute("total_lines", String.valueOf(total_lines));
    }

    protected Element getCovDataChild(Element parent) {
        NodeList children = parent.getChildNodes();
        int len = children.getLength();
        int i = 0;
        while (i < len) {
            Element elem;
            Node child = children.item(i);
            if (child.getNodeType() == 1 && "cov.data".equals((elem = (Element)child).getNodeName())) {
                return elem;
            }
            ++i;
        }
        throw new NoSuchElementException("Could not find 'cov.data' element in parent '" + parent.getNodeName() + "'");
    }

    protected Hashtable getMethods(Element clazz) {
        Hashtable<String, Element> map = new Hashtable<String, Element>();
        NodeList children = clazz.getChildNodes();
        int len = children.getLength();
        int i = 0;
        while (i < len) {
            Element elem;
            Node child = children.item(i);
            if (child.getNodeType() == 1 && "method".equals((elem = (Element)child).getNodeName())) {
                String name = elem.getAttribute("name");
                map.put(name, elem);
            }
            ++i;
        }
        return map;
    }

    protected Element[] getClasses(Element pkg) {
        Vector<Element> v = new Vector<Element>();
        NodeList children = pkg.getChildNodes();
        int len = children.getLength();
        int i = 0;
        while (i < len) {
            Element elem;
            Node child = children.item(i);
            if (child.getNodeType() == 1 && "class".equals((elem = (Element)child).getNodeName())) {
                v.addElement(elem);
            }
            ++i;
        }
        Object[] elems = new Element[v.size()];
        v.copyInto(elems);
        return elems;
    }

    protected Element[] getPackages(Element snapshot) {
        Vector<Element> v = new Vector<Element>();
        NodeList children = snapshot.getChildNodes();
        int len = children.getLength();
        int i = 0;
        while (i < len) {
            Element elem;
            Node child = children.item(i);
            if (child.getNodeType() == 1 && "package".equals((elem = (Element)child).getNodeName())) {
                v.addElement(elem);
            }
            ++i;
        }
        Object[] elems = new Element[v.size()];
        v.copyInto(elems);
        return elems;
    }

    private static DocumentBuilder newBuilder() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setValidating(false);
            return factory.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public void log(String message) {
        if (this.task != null) {
            this.task.log(message, 4);
        }
    }

    public static void main(String[] args) throws Exception {
        File reportFile = new File((class$org$apache$tools$ant$taskdefs$optional$sitraka$XMLReport == null ? (class$org$apache$tools$ant$taskdefs$optional$sitraka$XMLReport = XMLReport.class$("org.apache.tools.ant.taskdefs.optional.sitraka.XMLReport")) : class$org$apache$tools$ant$taskdefs$optional$sitraka$XMLReport).getResource("covreport-test.xml").getFile());
        XMLReport report = new XMLReport(reportFile);
        report.setJProbehome(new File("d:/Program Files/JProbe"));
        ReportFilters filters = new ReportFilters();
        ReportFilters.Include incl = new ReportFilters.Include();
        incl.setClass("*");
        incl.setMethod("set*");
        filters.addInclude(incl);
        report.setReportFilters(filters);
        Document doc = report.createDocument(new String[]{"Z:/imediation/ichannel/sources/toolkit/lib/imtoolkit.jar"});
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer transformer = tfactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.transform(new DOMSource(doc), new StreamResult(new FileOutputStream("d:/tmp/snapshot_merge.xml")));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

