/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.metamata;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.optional.metamata.AbstractMetamataTask;
import org.apache.tools.ant.taskdefs.optional.metamata.MAuditStreamHandler;
import org.apache.tools.ant.types.Path;

public class MAudit
extends AbstractMetamataTask {
    static final String AUDIT_PATTERN = "(?:file:)?(.+):(\\d+)\\s*:\\s+(.*)";
    protected File outFile = null;
    protected Path searchPath = null;
    protected boolean fix = false;
    protected boolean list = false;
    protected boolean unused = false;

    public MAudit() {
        super("com.metamata.gui.rc.MAudit");
    }

    public void setTofile(File outFile) {
        this.outFile = outFile;
    }

    public void setFix(boolean flag) {
        this.fix = flag;
    }

    public void setList(boolean flag) {
        this.list = flag;
    }

    public void setUnused(boolean flag) {
        this.unused = flag;
    }

    public Path createSearchpath() {
        if (this.searchPath == null) {
            this.searchPath = new Path(((ProjectComponent)this).project);
        }
        return this.searchPath;
    }

    protected Vector getOptions() {
        Vector<String> options = new Vector<String>(512);
        if (this.sourcePath != null) {
            this.sourcePath.append(this.classPath);
            this.classPath = this.sourcePath;
            this.sourcePath = null;
        }
        if (this.classPath != null) {
            options.addElement("-classpath");
            options.addElement(this.classPath.toString());
        }
        if (this.fix) {
            options.addElement("-fix");
        }
        options.addElement("-fullpath");
        if (this.list) {
            options.addElement("-list");
        }
        if (this.sourcePath != null) {
            options.addElement("-sourcepath");
            options.addElement(this.sourcePath.toString());
        }
        if (this.unused) {
            options.addElement("-unused");
            options.addElement(this.searchPath.toString());
        }
        AbstractMetamataTask.addAllVector(options, this.includedFiles.keys());
        return options;
    }

    protected void checkOptions() throws BuildException {
        super.checkOptions();
        if (this.unused && this.searchPath == null) {
            throw new BuildException("'searchpath' element must be set when looking for 'unused' declarations.");
        }
        if (!this.unused && this.searchPath != null) {
            this.log("'searchpath' element ignored. 'unused' attribute is disabled.", 1);
        }
    }

    protected ExecuteStreamHandler createStreamHandler() throws BuildException {
        Object handler = null;
        if (this.outFile == null) {
            handler = new LogStreamHandler((Task)this, 2, 2);
        } else {
            try {
                FileOutputStream out = new FileOutputStream(this.outFile);
                handler = new MAuditStreamHandler(this, out);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        return handler;
    }

    protected void cleanUp() throws BuildException {
        super.cleanUp();
    }

    static final Violation createViolation(int line, String msg) {
        Violation violation = new Violation();
        violation.line = line;
        violation.error = msg;
        return violation;
    }

    static final class Violation {
        int line;
        String error;

        Violation() {
        }
    }
}

