/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.optional.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.optional.image.DrawOperation;
import org.apache.tools.ant.types.optional.image.ImageOperation;
import org.apache.tools.ant.types.optional.image.TransformOperation;

public class Scale
extends TransformOperation
implements DrawOperation {
    private String width_str = "100%";
    private String height_str = "100%";
    private boolean x_percent = true;
    private boolean y_percent = true;
    private String proportions = "ignore";

    public void setProportions(ProportionsAttribute pa) {
        this.proportions = pa.getValue();
    }

    public void setWidth(String width) {
        this.width_str = width;
    }

    public void setHeight(String height) {
        this.height_str = height;
    }

    public float getWidth() {
        float width = 0.0f;
        int perc_index = this.width_str.indexOf(37);
        if (perc_index > 0) {
            width = Float.parseFloat(this.width_str.substring(0, perc_index));
            this.x_percent = true;
            return width / 100.0f;
        }
        this.x_percent = false;
        return Float.parseFloat(this.width_str);
    }

    public float getHeight() {
        int perc_index = this.height_str.indexOf(37);
        if (perc_index > 0) {
            float height = Float.parseFloat(this.height_str.substring(0, perc_index));
            this.y_percent = true;
            return height / 100.0f;
        }
        this.y_percent = false;
        return Float.parseFloat(this.height_str);
    }

    public PlanarImage performScale(PlanarImage image) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        float x_fl = this.getWidth();
        float y_fl = this.getHeight();
        if (!this.x_percent) {
            x_fl /= (float)image.getWidth();
        }
        if (!this.y_percent) {
            y_fl /= (float)image.getHeight();
        }
        if ("width".equals(this.proportions)) {
            y_fl = x_fl;
        } else if ("height".equals(this.proportions)) {
            x_fl = y_fl;
        } else if ("fit".equals(this.proportions)) {
            x_fl = y_fl = Math.min(x_fl, y_fl);
        } else if ("cover".equals(this.proportions)) {
            x_fl = y_fl = Math.max(x_fl, y_fl);
        }
        pb.add(new Float(x_fl));
        pb.add(new Float(y_fl));
        this.log("\tScaling to " + x_fl * 100.0f + "% x " + y_fl * 100.0f + "%");
        return JAI.create((String)"scale", (ParameterBlock)pb);
    }

    public PlanarImage executeTransformOperation(PlanarImage image) {
        BufferedImage bi = null;
        int i = 0;
        while (i < this.instructions.size()) {
            ImageOperation instr = (ImageOperation)((Object)this.instructions.elementAt(i));
            if (instr instanceof DrawOperation) {
                return this.performScale(image);
            }
            if (instr instanceof TransformOperation) {
                bi = image.getAsBufferedImage();
                image = ((TransformOperation)instr).executeTransformOperation(PlanarImage.wrapRenderedImage((RenderedImage)bi));
                bi = image.getAsBufferedImage();
            }
            ++i;
        }
        return this.performScale(image);
    }

    public PlanarImage executeDrawOperation() {
        int i = 0;
        while (i < this.instructions.size()) {
            ImageOperation instr = (ImageOperation)((Object)this.instructions.elementAt(i));
            if (instr instanceof DrawOperation) {
                PlanarImage image = null;
                this.performScale(image);
                return image;
            }
            ++i;
        }
        return null;
    }

    public static class ProportionsAttribute
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"ignore", "width", "height", "cover", "fit"};
        }
    }
}

