/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.wildfly.cli;

import org.uberfire.commons.config.ConfigProperties;

public abstract class BaseWildflyCLIManager {
    protected static final String DEFAULT_HOST = "localhost";
    protected static final int DEFAULT_PORT = 9990;
    protected static final String DEFAULT_ADMIN_USER = null;
    protected static final String DEFAULT_ADMIN_PASSWORD = null;
    protected static final String DEFAULT_REALM = "ApplicationRealm";
    protected String host;
    protected int port;
    protected String adminUser;
    protected String adminPassword;
    protected String realm;

    protected void loadConfig(ConfigProperties config) {
        ConfigProperties.ConfigProperty host = config.get("org.uberfire.ext.security.management.wildfly.cli.host", DEFAULT_HOST);
        ConfigProperties.ConfigProperty port = config.get("org.uberfire.ext.security.management.wildfly.cli.port", Integer.toString(9990));
        ConfigProperties.ConfigProperty user = config.get("org.uberfire.ext.security.management.wildfly.cli.user", DEFAULT_ADMIN_USER);
        ConfigProperties.ConfigProperty password = config.get("org.uberfire.ext.security.management.wildfly.cli.password", DEFAULT_ADMIN_PASSWORD);
        ConfigProperties.ConfigProperty realm = config.get("org.uberfire.ext.security.management.wildfly.cli.realm", DEFAULT_REALM);
        this.host = host.getValue();
        this.port = Integer.decode(port.getValue());
        this.adminUser = user.getValue();
        this.adminPassword = password.getValue();
        this.realm = realm.getValue();
    }

    protected abstract String getPropertiesFilePath(String var1) throws Exception;

    protected static boolean isConfigPropertySet(ConfigProperties.ConfigProperty property) {
        if (property == null) {
            return false;
        }
        String value = property.getValue();
        return !BaseWildflyCLIManager.isEmpty(value);
    }

    protected static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }
}

