/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.client.repositories;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.guvnor.common.services.project.client.repositories.ConflictingRepositoriesPopup;
import org.guvnor.common.services.project.client.repositories.ConflictingRepositoriesPopupView;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.shared.security.AppRoles;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class ConflictingRepositoriesPopupTest {
    @Mock
    ConflictingRepositoriesPopupView view;
    @Mock
    User user;
    private ConflictingRepositoriesPopup presenter;

    @Before
    public void setup() {
        this.presenter = new ConflictingRepositoriesPopup(this.user, this.view);
    }

    @Test
    public void testInitialization() {
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view)).init(Mockito.eq((Object)this.presenter));
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addOKButton();
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addOverrideButton();
    }

    @Test
    public void testSetContent_Administrator() {
        GAV gav = (GAV)Mockito.mock(GAV.class);
        Command command = (Command)Mockito.mock(Command.class);
        HashSet metadata = new HashSet();
        HashSet<Role> roles = new HashSet<Role>(){
            {
                this.add(new RoleImpl(AppRoles.ADMIN.getName()));
            }
        };
        Mockito.when((Object)this.user.getRoles()).thenReturn((Object)roles);
        this.presenter.setContent(gav, metadata, command);
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view)).clear();
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view)).setContent((GAV)Mockito.eq((Object)gav), (Set)Mockito.eq(metadata));
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view)).addOKButton();
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view)).addOverrideButton();
    }

    @Test
    public void testSetContent_NotAdministrator() {
        GAV gav = (GAV)Mockito.mock(GAV.class);
        Command command = (Command)Mockito.mock(Command.class);
        HashSet metadata = new HashSet();
        HashSet roles = new HashSet();
        Mockito.when((Object)this.user.getRoles()).thenReturn(roles);
        this.presenter.setContent(gav, metadata, command);
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view)).clear();
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view)).setContent((GAV)Mockito.eq((Object)gav), (Set)Mockito.eq(metadata));
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view)).addOKButton();
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addOverrideButton();
    }

    @Test
    public void testSetContent_Reuse() {
        GAV gav = (GAV)Mockito.mock(GAV.class);
        Command command = (Command)Mockito.mock(Command.class);
        HashSet metadata = new HashSet();
        HashSet<Role> roles = new HashSet<Role>(){
            {
                this.add(new RoleImpl(AppRoles.ADMIN.getName()));
            }
        };
        Mockito.when((Object)this.user.getRoles()).thenReturn((Object)roles);
        this.presenter.setContent(gav, metadata, command);
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view)).clear();
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view)).setContent((GAV)Mockito.eq((Object)gav), (Set)Mockito.eq(metadata));
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view)).addOKButton();
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view)).addOverrideButton();
        this.presenter.setContent(gav, metadata, command);
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clear();
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setContent((GAV)Mockito.eq((Object)gav), (Set)Mockito.eq(metadata));
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addOKButton();
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addOverrideButton();
    }

    @Test
    public void testShow() {
        this.presenter.show();
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view)).show();
    }

    @Test
    public void testHide() {
        this.presenter.hide();
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testActions() {
        Command okCommand = (Command)Mockito.mock(Command.class);
        Command overrideCommand = (Command)Mockito.mock(Command.class);
        GAV gav = (GAV)Mockito.mock(GAV.class);
        HashSet metadata = new HashSet();
        Set<RoleImpl> roles = Collections.singleton(new RoleImpl(AppRoles.ADMIN.getName()));
        Mockito.when((Object)this.user.getRoles()).thenReturn(roles);
        this.presenter.setContent(gav, metadata, okCommand, overrideCommand);
        this.presenter.override();
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view)).hide();
        ((Command)Mockito.verify((Object)overrideCommand)).execute();
        this.presenter.hide();
        ((ConflictingRepositoriesPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).hide();
        ((Command)Mockito.verify((Object)okCommand)).execute();
    }
}

