/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.client.preferences;

import org.guvnor.common.services.project.client.preferences.ProjectScopedResolutionStrategySupplier;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeEvent;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.shared.preferences.WorkbenchPreferenceScopeResolutionStrategies;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.preferences.shared.impl.PreferenceScopeResolutionStrategyInfo;

@RunWith(value=MockitoJUnitRunner.class)
public class ModuleScopedResolutionStrategySupplierTest {
    @Mock
    private WorkbenchPreferenceScopeResolutionStrategies scopeResolutionStrategies;
    private ProjectScopedResolutionStrategySupplier projectScopedResolutionStrategySupplier;
    private Module module;

    @Before
    public void setup() {
        this.projectScopedResolutionStrategySupplier = (ProjectScopedResolutionStrategySupplier)Mockito.spy((Object)new ProjectScopedResolutionStrategySupplier(this.scopeResolutionStrategies));
        this.module = (Module)Mockito.mock(Module.class);
        ((Module)Mockito.doReturn((Object)"projectIdentifierEncoded").when((Object)this.module)).getEncodedIdentifier();
    }

    @Test
    public void getWithoutProjectTest() {
        PreferenceScopeResolutionStrategyInfo preferenceScopeResolutionStrategyInfo = this.projectScopedResolutionStrategySupplier.get();
        ((WorkbenchPreferenceScopeResolutionStrategies)Mockito.verify((Object)this.scopeResolutionStrategies)).getUserInfoFor(null, null);
    }

    @Test
    public void getWithProjectTest() {
        WorkspaceProjectContextChangeEvent event = (WorkspaceProjectContextChangeEvent)Mockito.mock(WorkspaceProjectContextChangeEvent.class);
        ((WorkspaceProjectContextChangeEvent)Mockito.doReturn((Object)this.module).when((Object)event)).getModule();
        this.projectScopedResolutionStrategySupplier.selectedProjectChanged(event);
        PreferenceScopeResolutionStrategyInfo preferenceScopeResolutionStrategyInfo = this.projectScopedResolutionStrategySupplier.get();
        ((WorkbenchPreferenceScopeResolutionStrategies)Mockito.verify((Object)this.scopeResolutionStrategies)).getUserInfoFor("project", "projectIdentifierEncoded");
    }
}

