/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode;

import java.util.Optional;
import java.util.function.Consumer;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthUtils;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.exception.TokenInvalidatedException;
import org.mule.runtime.oauth.api.AuthorizationCodeOAuthDancer;
import org.mule.runtime.oauth.api.listener.AuthorizationCodeListener;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;

public class UpdatingAuthorizationCodeState
implements AuthorizationCodeState,
org.mule.sdk.api.connectivity.oauth.AuthorizationCodeState {
    private AuthorizationCodeState delegate;
    private boolean invalidated = false;

    public UpdatingAuthorizationCodeState(final AuthorizationCodeConfig config, AuthorizationCodeOAuthDancer dancer, ResourceOwnerOAuthContext initialContext, final Consumer<ResourceOwnerOAuthContext> onUpdate) {
        this.delegate = ExtensionsOAuthUtils.toAuthorizationCodeState(config, initialContext);
        dancer.addListener(initialContext.getResourceOwnerId(), new AuthorizationCodeListener(){

            public void onAuthorizationCompleted(ResourceOwnerOAuthContext context) {
                this.update(context);
            }

            public void onTokenRefreshed(ResourceOwnerOAuthContext context) {
                this.update(context);
            }

            public void onTokenInvalidated() {
                UpdatingAuthorizationCodeState.this.invalidated = true;
            }

            private void update(ResourceOwnerOAuthContext context) {
                UpdatingAuthorizationCodeState.this.delegate = ExtensionsOAuthUtils.toAuthorizationCodeState(config, context);
                UpdatingAuthorizationCodeState.this.invalidated = false;
                onUpdate.accept(context);
            }
        });
    }

    public String getAccessToken() {
        if (this.invalidated) {
            throw new TokenInvalidatedException("OAuth token for resource owner id " + this.delegate.getResourceOwnerId() + " has been invalidated");
        }
        return this.delegate.getAccessToken();
    }

    public Optional<String> getRefreshToken() {
        return this.delegate.getRefreshToken();
    }

    public String getResourceOwnerId() {
        return this.delegate.getResourceOwnerId();
    }

    public Optional<String> getExpiresIn() {
        return this.delegate.getExpiresIn();
    }

    public Optional<String> getState() {
        return this.delegate.getState();
    }

    public String getAuthorizationUrl() {
        return this.delegate.getAuthorizationUrl();
    }

    public String getAccessTokenUrl() {
        return this.delegate.getAccessTokenUrl();
    }

    public String getConsumerKey() {
        return this.delegate.getConsumerKey();
    }

    public String getConsumerSecret() {
        return this.delegate.getConsumerSecret();
    }

    public Optional<String> getExternalCallbackUrl() {
        return this.delegate.getExternalCallbackUrl();
    }
}

