/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.validation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthModelProperty;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthParameterModelProperty;
import org.mule.runtime.extension.api.exception.IllegalConnectionProviderModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.internal.loader.util.JavaParserUtils;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthUtils;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class JavaOAuthConnectionProviderModelValidator
implements ExtensionModelValidator {
    public void validate(ExtensionModel model, final ProblemsReporter problemsReporter) {
        new IdempotentExtensionWalker(){

            protected void onConnectionProvider(ConnectionProviderModel model) {
                Class implementingType = MuleExtensionUtils.getImplementingType((EnrichableModel)model).orElse(null);
                if (implementingType == null) {
                    return;
                }
                boolean supportsAuthCode = JavaOAuthConnectionProviderModelValidator.this.supportsAuthorizationCode(model);
                boolean supportsClientCredentials = JavaOAuthConnectionProviderModelValidator.this.supportsClientCredentials(model);
                if (supportsAuthCode && supportsClientCredentials) {
                    throw new IllegalConnectionProviderModelDefinitionException(String.format("Connection Provider of class '%s' is attempting to support both authorization code and client credentials grant types. Each connection provider can only support one grant type at a time.", implementingType));
                }
                if (supportsAuthCode) {
                    JavaOAuthConnectionProviderModelValidator.this.validateStateField(implementingType, ExtensionsOAuthUtils.AUTHORIZATION_CODE_STATE_INTERFACES, "authorization code");
                }
                if (supportsClientCredentials) {
                    JavaOAuthConnectionProviderModelValidator.this.validateStateField(implementingType, ExtensionsOAuthUtils.CLIENT_CREDENTIALS_STATE_INTERFACES, "client credentials");
                }
                JavaOAuthConnectionProviderModelValidator.this.validateOAuthParameters(model, problemsReporter);
            }
        }.walk(model);
    }

    private void validateOAuthParameters(ConnectionProviderModel connectionProviderModel, ProblemsReporter problemsReporter) {
        connectionProviderModel.getAllParameterModels().stream().filter(parameterModel -> parameterModel.getModelProperty(OAuthParameterModelProperty.class).isPresent()).forEach(parameterModel -> parameterModel.getModelProperty(DeclaringMemberModelProperty.class).map(DeclaringMemberModelProperty::getDeclaringField).ifPresent(field -> this.validateExpressionSupport(connectionProviderModel, (ParameterModel)parameterModel, (Field)field, problemsReporter)));
    }

    private void validateExpressionSupport(ConnectionProviderModel provider, ParameterModel parameter, Field field, ProblemsReporter problemsReporter) {
        if (JavaParserUtils.getExpressionSupport((AnnotatedElement)field).filter(expression -> expression == ExpressionSupport.NOT_SUPPORTED).isPresent()) {
            problemsReporter.addError(new Problem((NamedObject)parameter, String.format("Parameter '%s' in Connection Provider '%s' is marked as supporting expressions. Expressions are not supported in OAuth parameters", parameter.getName(), provider.getName())));
        }
    }

    private void validateStateField(Class<?> implementingType, List<Class<?>> stateFieldTypes, String grantType) {
        List stateFields = IntrospectionUtils.getFields(implementingType).stream().filter(f -> stateFieldTypes.stream().anyMatch(stateFieldType -> f.getType().equals(stateFieldType))).collect(Collectors.toList());
        if (stateFields.size() != 1) {
            throw new IllegalConnectionProviderModelDefinitionException(String.format("Connection Provider of class '%s' uses OAuth2 %s grant type and thus should contain one (and only one) field of type %s. %d were found", implementingType, grantType, stateFieldTypes.get(0).getName(), stateFields.size()));
        }
    }

    private boolean supportsAuthorizationCode(ConnectionProviderModel connectionProviderModel) {
        return connectionProviderModel.getModelProperty(OAuthModelProperty.class).map(oAuthModelProperty -> oAuthModelProperty.getGrantTypes().stream().filter(oAuthGrantType -> oAuthGrantType instanceof AuthorizationCodeGrantType).findFirst().isPresent()).orElse(false);
    }

    private boolean supportsClientCredentials(ConnectionProviderModel connectionProviderModel) {
        return connectionProviderModel.getModelProperty(OAuthModelProperty.class).map(oAuthModelProperty -> oAuthModelProperty.getGrantTypes().stream().filter(oAuthGrantType -> oAuthGrantType instanceof ClientCredentialsGrantType).findFirst().isPresent()).orElse(false);
    }
}

