/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type.runtime;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.extension.api.annotation.ExpressionFunctions;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.module.extension.api.loader.java.type.ComponentElement;
import org.mule.runtime.module.extension.api.loader.java.type.ConnectionProviderElement;
import org.mule.runtime.module.extension.api.loader.java.type.FunctionContainerElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationContainerElement;
import org.mule.runtime.module.extension.api.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ConnectionProviderTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.FunctionContainerWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.OperationContainerWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.SourceTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.sdk.api.annotation.Sources;

abstract class ComponentWrapper
extends TypeWrapper
implements ComponentElement {
    ComponentWrapper(Class<?> aClass, ClassTypeLoader typeLoader) {
        super(aClass, typeLoader);
    }

    @Override
    public List<SourceElement> getSources() {
        return Stream.concat(this.collectElements(org.mule.runtime.extension.api.annotation.Sources.class, org.mule.runtime.extension.api.annotation.Sources::value), this.collectElements(Sources.class, Sources::value)).map(s -> new SourceTypeWrapper(s, this.typeLoader)).collect(Collectors.toList());
    }

    @Override
    public List<OperationContainerElement> getOperationContainers() {
        return this.getOperationClassStream().map(aClass -> new OperationContainerWrapper((Class)aClass, this.typeLoader)).collect(Collectors.toList());
    }

    @Override
    public List<FunctionContainerElement> getFunctionContainers() {
        return this.getExpressionFunctionClassStream().map(c -> new FunctionContainerWrapper((Class)c, this.typeLoader)).collect(Collectors.toList());
    }

    @Override
    public List<ConnectionProviderElement> getConnectionProviders() {
        return Stream.concat(this.collectElements(ConnectionProviders.class, ConnectionProviders::value), this.collectElements(org.mule.sdk.api.annotation.connectivity.ConnectionProviders.class, org.mule.sdk.api.annotation.connectivity.ConnectionProviders::value)).map(c -> new ConnectionProviderTypeWrapper(c, this.typeLoader)).collect(Collectors.toList());
    }

    protected <A extends Annotation> Stream<Class> collectElements(Class<A> annotationClass, Function<A, Class[]> extractTypeFunction) {
        return this.getAnnotation(annotationClass).map(a -> Stream.of((Object[])extractTypeFunction.apply(a))).orElse(Stream.empty());
    }

    protected Stream<Class> getOperationClassStream() {
        return Stream.concat(this.collectElements(Operations.class, Operations::value), this.collectElements(org.mule.sdk.api.annotation.Operations.class, org.mule.sdk.api.annotation.Operations::value));
    }

    protected Stream<Class> getExpressionFunctionClassStream() {
        return Stream.concat(this.collectElements(ExpressionFunctions.class, ExpressionFunctions::value), this.collectElements(org.mule.sdk.api.annotation.ExpressionFunctions.class, org.mule.sdk.api.annotation.ExpressionFunctions::value));
    }
}

