/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.validation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.StringType;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.Typed;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.FieldValueProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.loader.java.property.FieldsValueProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.InjectableParameterInfo;
import org.mule.runtime.module.extension.internal.loader.java.property.ValueProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.extension.internal.value.ValueProviderUtils;

public final class JavaValueProviderModelValidator
implements ExtensionModelValidator {
    public void validate(ExtensionModel model, final ProblemsReporter problemsReporter) {
        final ReflectionCache reflectionCache = new ReflectionCache();
        final ValueProvidersIdValidator valueProvidersIdValidator = new ValueProvidersIdValidator(problemsReporter);
        new IdempotentExtensionWalker(){

            protected void onConfiguration(ConfigurationModel model) {
                JavaValueProviderModelValidator.this.validateModel((ParameterizedModel)model, problemsReporter, false, valueProvidersIdValidator, reflectionCache);
            }

            protected void onConnectionProvider(ConnectionProviderModel model) {
                JavaValueProviderModelValidator.this.validateModel((ParameterizedModel)model, problemsReporter, false, valueProvidersIdValidator, reflectionCache);
            }

            protected void onSource(SourceModel model) {
                JavaValueProviderModelValidator.this.validateModel((ParameterizedModel)model, problemsReporter, true, valueProvidersIdValidator, reflectionCache);
            }

            protected void onOperation(OperationModel model) {
                JavaValueProviderModelValidator.this.validateModel((ParameterizedModel)model, problemsReporter, true, valueProvidersIdValidator, reflectionCache);
            }
        }.walk(model);
        valueProvidersIdValidator.validateIdsAreUnique();
    }

    private void validateModel(ParameterizedModel model, ProblemsReporter problemsReporter, boolean supportsConnectionsAndConfigs, ValueProvidersIdValidator valueProvidersIdValidator, ReflectionCache reflectionCache) {
        model.getAllParameterModels().forEach(param -> {
            Optional valueProviderFactoryModelProperty = param.getModelProperty(ValueProviderFactoryModelProperty.class);
            Optional fieldValueProviderFactoryModelProperty = param.getModelProperty(FieldsValueProviderFactoryModelProperty.class);
            if (valueProviderFactoryModelProperty.isPresent() && fieldValueProviderFactoryModelProperty.isPresent()) {
                problemsReporter.addError(new Problem((NamedObject)model, String.format("Parameter [%s] from %s with name %s has both a Value Provider and a Field Value Provider", param.getName(), NameUtils.getComponentModelTypeName((ParameterizedModel)model), NameUtils.getModelName((Object)model))));
            } else if (valueProviderFactoryModelProperty.isPresent()) {
                this.validateOptionsResolver((ParameterModel)param, true, null, (ValueProviderFactoryModelProperty)valueProviderFactoryModelProperty.get(), model, problemsReporter, supportsConnectionsAndConfigs, reflectionCache, valueProvidersIdValidator);
            } else if (fieldValueProviderFactoryModelProperty.isPresent()) {
                ((FieldsValueProviderFactoryModelProperty)fieldValueProviderFactoryModelProperty.get()).getFieldsValueProviderFactories().forEach((targetSelector, fieldsValueProviderFactoryModelProperty) -> this.validateOptionsResolver((ParameterModel)param, false, (String)targetSelector, (ValueProviderFactoryModelProperty)fieldsValueProviderFactoryModelProperty, model, problemsReporter, supportsConnectionsAndConfigs, reflectionCache, valueProvidersIdValidator));
            }
        });
    }

    private void validateOptionsResolver(ParameterModel param, boolean mustBeStringType, String targetSelector, ValueProviderFactoryModelProperty modelProperty, ParameterizedModel model, ProblemsReporter problemsReporter, boolean supportsConnectionsAndConfigs, ReflectionCache reflectionCache, ValueProvidersIdValidator valueProvidersIdValidator) {
        boolean requiresConnection;
        Class<?> valueProvider = modelProperty.getValueProvider();
        String providerName = valueProvider.getSimpleName();
        Optional<FieldValueProviderModel> valueProviderModel = targetSelector != null ? param.getFieldValueProviderModels().stream().filter(fieldValueProviderModel -> fieldValueProviderModel.getTargetSelector().equals(targetSelector)).findAny() : param.getValueProviderModel();
        if (!valueProviderModel.isPresent()) {
            throw new IllegalStateException(String.format("Parameter %s from %s with name %s has should have a ValueProviderModel associated.", param.getName(), NameUtils.getComponentModelTypeName((ParameterizedModel)model), NameUtils.getModelName((Object)model)));
        }
        valueProvidersIdValidator.addValueProviderInformation(new ValueProviderInformation((ValueProviderModel)valueProviderModel.get(), model, valueProvider.getName()));
        Map<String, MetadataType> allParameters = model.getAllParameterModels().stream().collect(Collectors.toMap(NamedObject::getName, Typed::getType));
        String modelName = NameUtils.getModelName((Object)model);
        String modelTypeName = NameUtils.getComponentModelTypeName((ParameterizedModel)model);
        if (!IntrospectionUtils.isInstantiable(valueProvider, reflectionCache)) {
            problemsReporter.addError(new Problem((NamedObject)model, String.format("The Value Provider [%s] is not instantiable but it should", providerName)));
        }
        if (mustBeStringType && !(param.getType() instanceof StringType)) {
            problemsReporter.addError(new Problem((NamedObject)model, String.format("The parameter [%s] of the %s '%s' is not of String type. Parameters that provides Values should be of String type.", param.getName(), modelTypeName, modelName)));
        }
        for (InjectableParameterInfo parameterInfo : modelProperty.getInjectableParameters()) {
            Class gotType;
            MetadataType metadataType;
            Class expectedType;
            String parameterName = ValueProviderUtils.getParameterNameFromExtractionExpression(parameterInfo.getExtractionExpression());
            if (!allParameters.containsKey(parameterName)) {
                problemsReporter.addError(new Problem((NamedObject)model, String.format("The Value Provider [%s] declares to use a parameter '%s' which doesn't exist in the %s '%s'", providerName, parameterName, modelTypeName, modelName)));
                continue;
            }
            if (!parameterInfo.getExtractionExpression().equals(parameterInfo.getParameterName()) || (expectedType = (Class)ExtensionMetadataTypeUtils.getType((MetadataType)(metadataType = allParameters.get(parameterInfo.getParameterName()))).orElseThrow(() -> new IllegalStateException(String.format("Unable to get Class for parameter: %s", parameterInfo.getParameterName())))).equals(gotType = (Class)ExtensionMetadataTypeUtils.getType((MetadataType)parameterInfo.getType()).orElseThrow(() -> new IllegalStateException(String.format("Unable to get Class for parameter: %s", parameterInfo.getParameterName()))))) continue;
            problemsReporter.addError(new Problem((NamedObject)model, String.format("The Value Provider [%s] defines a parameter '%s' of type '%s' but in the %s '%s' is of type '%s'", providerName, parameterInfo.getParameterName(), gotType, modelTypeName, modelName, expectedType)));
        }
        if (supportsConnectionsAndConfigs && modelProperty.usesConnection() && model instanceof ConnectableComponentModel && (requiresConnection = ((ConnectableComponentModel)model).requiresConnection()) != modelProperty.usesConnection()) {
            problemsReporter.addError(new Problem((NamedObject)model, String.format("The Value Provider [%s] defines that requires a connection, but is used in the %s '%s' which is connection less", providerName, modelTypeName, modelName)));
        }
        if (!supportsConnectionsAndConfigs) {
            if (modelProperty.usesConnection()) {
                problemsReporter.addError(new Problem((NamedObject)model, String.format("The Value Provider [%s] defines that requires a connection which is not allowed for a Value Provider of a %s's parameter [%s]", providerName, modelTypeName, modelName)));
            }
            if (modelProperty.usesConfig()) {
                problemsReporter.addError(new Problem((NamedObject)model, String.format("The Value Provider [%s] defines that requires a configuration which is not allowed for a Value Provider of a %s's parameter [%s]", providerName, modelTypeName, modelName)));
            }
        }
    }

    private static final class ValueProvidersIdValidator {
        private Map<String, ValueProviderInformation> valueProvidersImplementationToInformation = new HashMap<String, ValueProviderInformation>();
        private MultiMap<String, String> valueProvidersIdToImplementations = new MultiMap();
        private ProblemsReporter problemsReporter;

        public ValueProvidersIdValidator(ProblemsReporter problemsReporter) {
            this.problemsReporter = problemsReporter;
        }

        public void addValueProviderInformation(ValueProviderInformation valueProviderInformation) {
            String valueProviderImplementation = valueProviderInformation.getImplementationClassName();
            if (!this.valueProvidersImplementationToInformation.containsKey(valueProviderImplementation)) {
                this.valueProvidersImplementationToInformation.put(valueProviderImplementation, valueProviderInformation);
                this.valueProvidersIdToImplementations.put((Object)valueProviderInformation.getValueProviderModel().getProviderId(), (Object)valueProviderImplementation);
            }
        }

        public void validateIdsAreUnique() {
            this.valueProvidersIdToImplementations.keySet().forEach(valueProviderId -> {
                List valueProviderImplementations = this.valueProvidersIdToImplementations.getAll(valueProviderId);
                if (valueProviderImplementations.size() > 1) {
                    String firstValueProviderImplementation = (String)valueProviderImplementations.get(0);
                    ValueProviderInformation valueProviderInformation = this.valueProvidersImplementationToInformation.get(firstValueProviderImplementation);
                    this.problemsReporter.addError(new Problem((NamedObject)valueProviderInformation.getOwnerModel(), String.format("The following ValueProvider implementations [%s] use the same id [%s]. ValueProvider ids must be unique.", String.join((CharSequence)", ", valueProviderImplementations), valueProviderId)));
                }
            });
        }
    }

    private static final class ValueProviderInformation {
        private ValueProviderModel valueProviderModel;
        private ParameterizedModel ownerModel;
        private String implementationClassName;

        public ValueProviderInformation(ValueProviderModel valueProviderModel, ParameterizedModel ownerModel, String implementationClassName) {
            this.valueProviderModel = valueProviderModel;
            this.ownerModel = ownerModel;
            this.implementationClassName = implementationClassName;
        }

        public ValueProviderModel getValueProviderModel() {
            return this.valueProviderModel;
        }

        public ParameterizedModel getOwnerModel() {
            return this.ownerModel;
        }

        public String getImplementationClassName() {
            return this.implementationClassName;
        }
    }
}

