/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.validation;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.property.SyntheticModelModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.CompileTimeModelProperty;

public final class ModelValidationUtils {
    private ModelValidationUtils() {
    }

    public static boolean isCompiletime(ExtensionModel model) {
        return model.getModelProperty(CompileTimeModelProperty.class).isPresent();
    }

    public static void validateConfigOverrideParametersNotAllowed(ParameterizedModel model, ProblemsReporter reporter, String kind) {
        List configOverrideParameters = model.getAllParameterModels().stream().filter(ParameterModel::isOverrideFromConfig).map(NamedObject::getName).collect(Collectors.toList());
        if (!configOverrideParameters.isEmpty()) {
            reporter.addError(new Problem((NamedObject)model, String.format("%s '%s' declares the parameters %s as '%s', which is not allowed for this component parameters", kind, model.getName(), configOverrideParameters.toString(), ConfigOverride.class.getSimpleName())));
        }
    }

    public static void validateConfigParametersNamesNotAllowed(ParameterizedModel model, ProblemsReporter reporter, String kind) {
        model.getAllParameterModels().stream().filter(parameterModel -> parameterModel.getName().equals("name") && !parameterModel.getModelProperty(SyntheticModelModelProperty.class).isPresent()).findAny().ifPresent(parameterModel -> reporter.addError(new Problem((NamedObject)model, String.format("%s '%s' declares a parameter whose name is '%s', which is not allowed.", kind, model.getName(), "name"))));
    }
}

