/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.validation;

import java.util.List;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.validation.ModelValidationUtils;

public class IgnoredExtensionParameterModelValidator
implements ExtensionModelValidator {
    private static final String IGNORED_EXTENSION_PARAMETERS_MESSAGE = "On extension '%s' the %s will be ignored given that the extension has defined a list of configurations";
    private static final String EXTENSION_PARAMETER = "parameter(s)";
    private static final String EXTENSION_PARAMETER_GROUP = "parameter group(s)";

    public void validate(ExtensionModel extensionModel, ProblemsReporter problemsReporter) {
        if (!ModelValidationUtils.isCompiletime(extensionModel)) {
            return;
        }
        extensionModel.getModelProperty(ExtensionTypeDescriptorModelProperty.class).map(descriptor -> descriptor.getType()).ifPresent(type -> {
            if (type instanceof ExtensionElement) {
                this.checkIgnoredParameters(extensionModel, (ExtensionElement)type, problemsReporter);
            }
        });
    }

    private void checkIgnoredParameters(ExtensionModel extensionModel, ExtensionElement extensionElement, ProblemsReporter problemsReporter) {
        if (!extensionElement.getConfigurations().isEmpty()) {
            this.checkIgnoredParameters(extensionModel, extensionElement.getParameters(), EXTENSION_PARAMETER, problemsReporter);
            this.checkIgnoredParameters(extensionModel, extensionElement.getParameterGroups(), EXTENSION_PARAMETER_GROUP, problemsReporter);
        }
    }

    private void checkIgnoredParameters(ExtensionModel extensionModel, List<ExtensionParameter> parameters, String parameterType, ProblemsReporter problemsReporter) {
        if (!parameters.isEmpty()) {
            problemsReporter.addWarning(new Problem((NamedObject)extensionModel, String.format(IGNORED_EXTENSION_PARAMETERS_MESSAGE, extensionModel.getName(), parameterType)));
        }
    }
}

