/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.value;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.module.extension.internal.loader.java.property.FieldsValueProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ValueProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.utils.FieldValueProviderNameUtils;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.extension.internal.value.MuleValueAdapter;
import org.mule.runtime.module.extension.internal.value.ValueProviderUtils;
import org.mule.sdk.api.values.ValueBuilder;
import org.mule.sdk.api.values.ValueProvider;
import org.mule.sdk.api.values.ValueResolvingException;

public final class ValueProviderMediator<T extends ParameterizedModel & EnrichableModel> {
    private final T containerModel;
    private final Supplier<MuleContext> muleContext;
    private final Supplier<ReflectionCache> reflectionCache;
    private final Supplier<Object> nullSupplier = () -> null;

    public ValueProviderMediator(T containerModel, Supplier<MuleContext> muleContext, Supplier<ReflectionCache> reflectionCache) {
        this.containerModel = containerModel;
        this.muleContext = muleContext;
        this.reflectionCache = reflectionCache;
    }

    public Set<Value> getValues(String parameterName, ParameterValueResolver parameterValueResolver) throws org.mule.runtime.extension.api.values.ValueResolvingException {
        return this.getValues(parameterName, parameterValueResolver, this.nullSupplier, this.nullSupplier);
    }

    public Set<Value> getValues(String parameterName, String targetSelector, ParameterValueResolver parameterValueResolver) throws org.mule.runtime.extension.api.values.ValueResolvingException {
        return this.getValues(parameterName, parameterValueResolver, targetSelector, this.nullSupplier, this.nullSupplier);
    }

    public Set<Value> getValues(String parameterName, ParameterValueResolver parameterValueResolver, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier) throws org.mule.runtime.extension.api.values.ValueResolvingException {
        return this.getValues(parameterName, parameterValueResolver, connectionSupplier, configurationSupplier, null);
    }

    public Set<Value> getValues(String parameterName, ParameterValueResolver parameterValueResolver, String targetSelector, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier) throws org.mule.runtime.extension.api.values.ValueResolvingException {
        return this.getValues(parameterName, parameterValueResolver, targetSelector, connectionSupplier, configurationSupplier, null);
    }

    public Set<Value> getValues(String parameterName, ParameterValueResolver parameterValueResolver, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier, ConnectionProvider connectionProvider) throws org.mule.runtime.extension.api.values.ValueResolvingException {
        return this.getValues(parameterName, parameterValueResolver, null, connectionSupplier, configurationSupplier, connectionProvider);
    }

    public Set<Value> getValues(String parameterName, ParameterValueResolver parameterValueResolver, String targetSelector, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier, ConnectionProvider connectionProvider) throws org.mule.runtime.extension.api.values.ValueResolvingException {
        List<ParameterModel> parameters = this.getParameters(parameterName);
        if (parameters.isEmpty()) {
            throw new org.mule.runtime.extension.api.values.ValueResolvingException(String.format("Unable to find model for parameter or parameter group with name '%s'.", parameterName), "INVALID_VALUE_RESOLVER_NAME");
        }
        ParameterModel parameterModel = parameters.get(0);
        ValueProviderFactoryModelProperty factoryModelProperty = targetSelector != null ? parameterModel.getModelProperty(FieldsValueProviderFactoryModelProperty.class).map(fieldsValueProvider -> fieldsValueProvider.getFieldsValueProviderFactories().get(targetSelector)).orElseThrow(() -> new org.mule.runtime.extension.api.values.ValueResolvingException(String.format("The parameter with name '%s' does not have a Value Provider associated with the targetSelector '%s'", parameterName, targetSelector), "INVALID_VALUE_RESOLVER_NAME")) : (ValueProviderFactoryModelProperty)parameterModel.getModelProperty(ValueProviderFactoryModelProperty.class).orElseThrow(() -> new org.mule.runtime.extension.api.values.ValueResolvingException(String.format("The parameter with name '%s' is not an Values Provider", parameterName), "INVALID_VALUE_RESOLVER_NAME"));
        try {
            return (Set)ExtensionsOAuthUtils.withRefreshToken(connectionProvider, () -> this.resolveValues(parameters, factoryModelProperty, parameterValueResolver, connectionSupplier, configurationSupplier, targetSelector));
        }
        catch (org.mule.runtime.extension.api.values.ValueResolvingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new org.mule.runtime.extension.api.values.ValueResolvingException(String.format("An error occurred trying to resolve the Values for parameter '%s' of component '%s'. Cause: %s", parameterName, this.containerModel.getName(), e.getMessage()), "UNKNOWN", (Throwable)e);
        }
    }

    private Set<Value> resolveValues(List<ParameterModel> parameters, ValueProviderFactoryModelProperty factoryModelProperty, ParameterValueResolver parameterValueResolver, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier) throws org.mule.runtime.extension.api.values.ValueResolvingException {
        return this.resolveValues(parameters, factoryModelProperty, parameterValueResolver, connectionSupplier, configurationSupplier, null);
    }

    private Set<Value> resolveValues(List<ParameterModel> parameters, ValueProviderFactoryModelProperty factoryModelProperty, ParameterValueResolver parameterValueResolver, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier, String targerSelector) throws org.mule.runtime.extension.api.values.ValueResolvingException {
        try {
            ValueProvider valueProvider = factoryModelProperty.createFactory(parameterValueResolver, connectionSupplier, configurationSupplier, this.reflectionCache.get(), this.muleContext.get(), (ParameterizedModel)this.containerModel).createValueProvider();
            Set valueSet = valueProvider.resolve();
            return valueSet.stream().map(option -> ValueProviderUtils.cloneAndEnrichValue(option, parameters, valueProvider.getId(), targerSelector)).map(ValueBuilder::build).map(MuleValueAdapter::new).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        catch (ValueResolvingException e) {
            throw new org.mule.runtime.extension.api.values.ValueResolvingException(e.getMessage(), e.getFailureCode(), e.getCause());
        }
    }

    private List<ParameterModel> getParameters(String valueName) {
        ArrayList<ParameterModel> parameterModels = new ArrayList<ParameterModel>();
        for (ParameterModel parameterModel : this.containerModel.getAllParameterModels()) {
            if (parameterModel.getValueProviderModel().isPresent() && ((ValueProviderModel)parameterModel.getValueProviderModel().get()).getProviderName().equals(valueName)) {
                parameterModels.add(parameterModel);
                continue;
            }
            if (!parameterModel.getFieldValueProviderModels().stream().anyMatch(fieldValueProviderModel -> FieldValueProviderNameUtils.getParameterName(fieldValueProviderModel).equals(valueName))) continue;
            parameterModels.add(parameterModel);
        }
        return parameterModels;
    }
}

