/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java.lib;

import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.ExternalLib;
import org.mule.runtime.extension.internal.loader.util.JavaParserUtils;
import org.mule.runtime.module.extension.api.loader.java.type.WithAnnotations;
import org.mule.sdk.api.annotation.ExternalLibs;
import org.mule.sdk.api.meta.ExternalLibraryType;

public final class JavaExternalLibModelParserUtils {
    public static List<ExternalLibraryModel> parseExternalLibraryModels(WithAnnotations element) {
        LinkedList<ExternalLibraryModel> libraries = new LinkedList<ExternalLibraryModel>();
        JavaExternalLibModelParserUtils.parseExternalLibs(element, org.mule.runtime.extension.api.annotation.ExternalLibs.class, libs -> Stream.of(libs.value()).map(lib -> JavaExternalLibModelParserUtils.parseExternalLib(lib)).collect(Collectors.toList()), libraries);
        JavaExternalLibModelParserUtils.parseExternalLibs(element, ExternalLibs.class, libs -> Stream.of(libs.value()).map(lib -> JavaExternalLibModelParserUtils.parseExternalLib(lib)).collect(Collectors.toList()), libraries);
        element.getAnnotation(ExternalLib.class).map(lib -> JavaExternalLibModelParserUtils.parseExternalLib(lib)).ifPresent(libraries::add);
        element.getAnnotation(org.mule.sdk.api.annotation.ExternalLib.class).map(lib -> JavaExternalLibModelParserUtils.parseExternalLib(lib)).ifPresent(libraries::add);
        return libraries;
    }

    private static ExternalLibraryModel parseExternalLib(ExternalLib externalLibAnnotation) {
        ExternalLibraryModel.ExternalLibraryModelBuilder builder = ExternalLibraryModel.builder().withName(externalLibAnnotation.name()).withDescription(externalLibAnnotation.description()).withType(externalLibAnnotation.type()).isOptional(externalLibAnnotation.optional());
        StringUtils.ifNotBlank((String)externalLibAnnotation.nameRegexpMatcher(), arg_0 -> ((ExternalLibraryModel.ExternalLibraryModelBuilder)builder).withRegexpMatcher(arg_0));
        StringUtils.ifNotBlank((String)externalLibAnnotation.requiredClassName(), arg_0 -> ((ExternalLibraryModel.ExternalLibraryModelBuilder)builder).withRequiredClassName(arg_0));
        StringUtils.ifNotBlank((String)externalLibAnnotation.coordinates(), arg_0 -> ((ExternalLibraryModel.ExternalLibraryModelBuilder)builder).withCoordinates(arg_0));
        return builder.build();
    }

    private static ExternalLibraryModel parseExternalLib(org.mule.sdk.api.annotation.ExternalLib externalLibAnnotation) {
        ExternalLibraryModel.ExternalLibraryModelBuilder builder = ExternalLibraryModel.builder().withName(externalLibAnnotation.name()).withDescription(externalLibAnnotation.description()).withType(JavaParserUtils.toMuleApi((ExternalLibraryType)externalLibAnnotation.type())).isOptional(externalLibAnnotation.optional());
        StringUtils.ifNotBlank((String)externalLibAnnotation.nameRegexpMatcher(), arg_0 -> ((ExternalLibraryModel.ExternalLibraryModelBuilder)builder).withRegexpMatcher(arg_0));
        StringUtils.ifNotBlank((String)externalLibAnnotation.requiredClassName(), arg_0 -> ((ExternalLibraryModel.ExternalLibraryModelBuilder)builder).withRequiredClassName(arg_0));
        StringUtils.ifNotBlank((String)externalLibAnnotation.coordinates(), arg_0 -> ((ExternalLibraryModel.ExternalLibraryModelBuilder)builder).withCoordinates(arg_0));
        return builder.build();
    }

    private static <A extends Annotation> void parseExternalLibs(WithAnnotations element, Class<A> annotationClass, Function<A, List<ExternalLibraryModel>> mapper, List<ExternalLibraryModel> accumulator) {
        element.getAnnotation(annotationClass).map(mapper).ifPresent(accumulator::addAll);
    }

    private JavaExternalLibModelParserUtils() {
    }
}

