/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.BasicTypeMetadataVisitor;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ExclusiveParametersModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.connectivity.internal.platform.schema.SemanticTermsHelper;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.stereotype.AllowedStereotypes;
import org.mule.runtime.extension.api.annotation.param.stereotype.ComponentId;
import org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.model.parameter.ImmutableExclusiveParametersModel;
import org.mule.runtime.extension.api.property.DefaultImplementingTypeModelProperty;
import org.mule.runtime.extension.api.property.InfrastructureParameterModelProperty;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.internal.loader.util.InfrastructureTypeMapping;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.java.contributor.InfrastructureTypeResolver;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ExclusiveOptionalModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.NullSafeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionParameterDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ParameterModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.StereotypeModelFactory;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.loader.parser.java.semantics.SemanticTermsParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.stereotypes.SdkStereotypeDefinitionAdapter;
import org.mule.runtime.module.extension.internal.loader.parser.java.type.CustomStaticTypeUtils;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.sdk.api.annotation.ConfigReferences;
import org.mule.sdk.api.annotation.dsl.xml.ParameterDsl;
import org.mule.sdk.api.annotation.param.ConfigOverride;
import org.mule.sdk.api.annotation.param.reference.ConfigReference;
import org.mule.sdk.api.annotation.param.reference.FlowReference;
import org.mule.sdk.api.annotation.param.reference.ObjectStoreReference;
import org.mule.sdk.api.annotation.semantics.connectivity.ExcludeFromConnectivitySchema;
import org.mule.sdk.api.stereotype.StereotypeDefinition;

public class JavaParameterModelParser
implements ParameterModelParser {
    private final ExtensionParameter parameter;
    private final MetadataType type;
    private final Optional<ParameterGroupModelParser.ExclusiveOptionalDescriptor> exclusiveOptionals;
    private final List<ModelProperty> additionalModelProperties = new LinkedList<ModelProperty>();
    private final ParameterDeclarationContext context;
    private Optional<ParameterDslConfiguration> dslConfiguration;
    private ExpressionSupport expressionSupport;

    public JavaParameterModelParser(ExtensionParameter parameter, Optional<ParameterGroupModelParser.ExclusiveOptionalDescriptor> exclusiveOptionals, ParameterDeclarationContext context) {
        this.parameter = parameter;
        this.context = context;
        this.exclusiveOptionals = exclusiveOptionals;
        this.type = CustomStaticTypeUtils.getParameterType(parameter);
        this.parserStructure();
        this.collectAdditionalModelProperties();
    }

    private void parserStructure() {
        this.parseExpressionSupport();
        this.parseExclusiveOptionals();
    }

    @Override
    public String getName() {
        return this.parameter.getAlias();
    }

    @Override
    public String getDescription() {
        return this.parameter.getDescription();
    }

    @Override
    public MetadataType getType() {
        return this.type;
    }

    @Override
    public boolean isRequired() {
        return this.parameter.isRequired();
    }

    @Override
    public Object getDefaultValue() {
        return this.parameter.defaultValue().orElse(null);
    }

    @Override
    public ParameterRole getRole() {
        return ExtensionModelUtils.roleOf(this.parameter.getAnnotation(Content.class));
    }

    @Override
    public ExpressionSupport getExpressionSupport() {
        return this.expressionSupport;
    }

    @Override
    public Optional<LayoutModel> getLayoutModel() {
        return MuleExtensionAnnotationParser.parseLayoutAnnotations(this.parameter, LayoutModel.builder(), this.parameter.getName());
    }

    @Override
    public Optional<ParameterDslConfiguration> getDslConfiguration() {
        if (this.dslConfiguration == null) {
            Optional<org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl> legacyAnnotation = this.parameter.getAnnotation(org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl.class);
            Optional<ParameterDsl> sdkAnnotation = this.parameter.getAnnotation(ParameterDsl.class);
            if (legacyAnnotation.isPresent() && sdkAnnotation.isPresent()) {
                throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' and '@%s' at the same time", this.parameter.getName(), org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl.class.getName(), ParameterDsl.class.getName()));
            }
            this.dslConfiguration = legacyAnnotation.isPresent() ? legacyAnnotation.map(parameterDsl -> ParameterDslConfiguration.builder().allowsInlineDefinition(parameterDsl.allowInlineDefinition()).allowsReferences(parameterDsl.allowReferences()).build()) : (sdkAnnotation.isPresent() ? sdkAnnotation.map(parameterDsl -> ParameterDslConfiguration.builder().allowsInlineDefinition(parameterDsl.allowInlineDefinition()).allowsReferences(parameterDsl.allowReferences()).build()) : Optional.empty());
        }
        return this.dslConfiguration;
    }

    @Override
    public Optional<DeprecationModel> getDeprecationModel() {
        return JavaExtensionModelParserUtils.getDeprecationModel(this.parameter);
    }

    @Override
    public Optional<DisplayModel> getDisplayModel() {
        return JavaExtensionModelParserUtils.getDisplayModel(this.parameter, "parameter", this.parameter.getName());
    }

    @Override
    public boolean isConfigOverride() {
        return this.parameter.isAnnotatedWith(org.mule.runtime.extension.api.annotation.param.ConfigOverride.class) || this.parameter.isAnnotatedWith(ConfigOverride.class);
    }

    @Override
    public boolean isComponentId() {
        return this.parameter.getAnnotation(ComponentId.class).isPresent();
    }

    @Override
    public List<StereotypeModel> getAllowedStereotypes(StereotypeModelFactory factory) {
        if (this.parameter.isAnnotatedWith(org.mule.runtime.extension.api.annotation.param.reference.FlowReference.class) || this.parameter.isAnnotatedWith(FlowReference.class)) {
            return Collections.singletonList(MuleStereotypes.FLOW);
        }
        if (this.parameter.isAnnotatedWith(org.mule.runtime.extension.api.annotation.param.reference.ObjectStoreReference.class) || this.parameter.isAnnotatedWith(ObjectStoreReference.class)) {
            return Collections.singletonList(MuleStereotypes.OBJECT_STORE);
        }
        List stereotypes = MuleExtensionAnnotationParser.mapReduceRepeatableAnnotation(this.parameter, org.mule.runtime.extension.api.annotation.param.reference.ConfigReference.class, ConfigReference.class, container -> ((org.mule.runtime.extension.api.annotation.ConfigReferences)container).value(), container -> ((ConfigReferences)container).value(), value -> factory.createStereotype(value.getStringValue(org.mule.runtime.extension.api.annotation.param.reference.ConfigReference::name), value.getStringValue(org.mule.runtime.extension.api.annotation.param.reference.ConfigReference::namespace), org.mule.sdk.api.stereotype.MuleStereotypes.CONFIG), value -> factory.createStereotype(value.getStringValue(ConfigReference::name), value.getStringValue(ConfigReference::namespace), org.mule.sdk.api.stereotype.MuleStereotypes.CONFIG)).collect(Collectors.toList());
        if (stereotypes.isEmpty()) {
            stereotypes = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(this.parameter, "parameter", this.parameter.getName(), AllowedStereotypes.class, org.mule.sdk.api.annotation.param.stereotype.AllowedStereotypes.class, value -> value.getClassArrayValue(AllowedStereotypes::value).stream().filter(type -> type.getDeclaringClass().isPresent()).map(type -> SdkStereotypeDefinitionAdapter.from(type.getDeclaringClass().get())), value -> value.getClassArrayValue(org.mule.sdk.api.annotation.param.stereotype.AllowedStereotypes::value).stream().filter(type -> type.getDeclaringClass().isPresent()).map(type -> SdkStereotypeDefinitionAdapter.from(type.getDeclaringClass().get()))).map(stream -> stream.map(def -> factory.createStereotype((StereotypeDefinition)def)).collect(Collectors.toList())).orElse(new LinkedList());
        }
        stereotypes.addAll(this.type.getAnnotation(StereotypeTypeAnnotation.class).map(StereotypeTypeAnnotation::getAllowedStereotypes).orElse(Collections.emptyList()));
        return stereotypes;
    }

    @Override
    public List<ModelProperty> getAdditionalModelProperties() {
        return this.additionalModelProperties;
    }

    @Override
    public boolean isExcludedFromConnectivitySchema() {
        return this.parameter.getAnnotation(ExcludeFromConnectivitySchema.class).isPresent();
    }

    @Override
    public Set<String> getSemanticTerms() {
        LinkedHashSet<String> terms = new LinkedHashSet<String>();
        terms.addAll(SemanticTermsHelper.getParameterTermsFromAnnotations(this.parameter::isAnnotatedWith));
        final LinkedHashSet<String> typeTerms = new LinkedHashSet<String>(ExtensionMetadataTypeUtils.getSemanticTerms((MetadataType)this.getType()));
        SemanticTermsParserUtils.addTermIfPresent(typeTerms, "connectivity.ProxyConfiguration", "connectivity.proxyConfiguration", terms);
        SemanticTermsParserUtils.addTermIfPresent(typeTerms, "connectivity.NtlmProxyConfiguration", "connectivity.ntlmProxyConfiguration", terms);
        if (typeTerms.contains("connectivity.secret")) {
            this.getType().accept((MetadataTypeVisitor)new BasicTypeMetadataVisitor(){

                protected void visitBasicType(MetadataType metadataType) {
                    typeTerms.remove("connectivity.secret");
                    typeTerms.add("connectivity.scalarSecret");
                }
            });
        }
        SemanticTermsParserUtils.addCustomTerms(this.parameter, terms);
        return terms;
    }

    private void collectAdditionalModelProperties() {
        this.additionalModelProperties.add(new ExtensionParameterDescriptorModelProperty(this.parameter));
        this.collectImplementingTypeProperties();
        this.collectNullSafeProperties();
        this.collectInfrastructureModelProperties();
        this.collectStackableTypesModelProperty();
    }

    private void collectStackableTypesModelProperty() {
        this.additionalModelProperties.addAll(this.context.resolveStackableTypes(this.parameter));
    }

    private void collectInfrastructureModelProperties() {
        if (this.parameter instanceof FieldElement) {
            InfrastructureTypeResolver.getInfrastructureType(this.parameter.getType()).ifPresent(infrastructureType -> {
                if (!StringUtils.isBlank((String)infrastructureType.getName())) {
                    this.additionalModelProperties.add((ModelProperty)new InfrastructureParameterModelProperty(infrastructureType.getSequence()));
                    this.expressionSupport = ExpressionSupport.NOT_SUPPORTED;
                    InfrastructureTypeMapping.getQName((String)infrastructureType.getName()).ifPresent(this.additionalModelProperties::add);
                    InfrastructureTypeMapping.getDslConfiguration((String)infrastructureType.getName()).ifPresent(dsl -> {
                        this.dslConfiguration = Optional.of(dsl);
                    });
                }
            });
        }
    }

    private void collectImplementingTypeProperties() {
        this.parameter.getDeclaringElement().ifPresent(element -> {
            if (element instanceof Field) {
                this.additionalModelProperties.add(new DeclaringMemberModelProperty((Field)element));
            } else {
                this.additionalModelProperties.add(new ImplementingParameterModelProperty((Parameter)element));
            }
        });
    }

    private void parseExpressionSupport() {
        this.expressionSupport = IntrospectionUtils.getExpressionSupport(this.parameter, "parameter", this.getName()).orElse(ExpressionSupport.SUPPORTED);
    }

    private void parseExclusiveOptionals() {
        this.exclusiveOptionals.ifPresent(exclusive -> {
            ImmutableExclusiveParametersModel exclusiveParametersModel = new ImmutableExclusiveParametersModel(exclusive.getExclusiveOptionals(), exclusive.isOneRequired());
            this.additionalModelProperties.add(new ExclusiveOptionalModelProperty((ExclusiveParametersModel)exclusiveParametersModel));
        });
    }

    private void collectNullSafeProperties() {
        final Optional<Type> nullSafeAnnotationType = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(this.parameter, "parameter", this.parameter.getName(), NullSafe.class, org.mule.sdk.api.annotation.param.NullSafe.class, value -> value.getClassValue(NullSafe::defaultImplementingType), value -> value.getClassValue(org.mule.sdk.api.annotation.param.NullSafe::defaultImplementingType));
        if (nullSafeAnnotationType.isPresent()) {
            if (this.isConfigOverride()) {
                throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' and also marked as a config override, which is redundant. The default value for this parameter will come from the configuration parameter", this.parameter.getName(), NullSafe.class.getSimpleName()));
            }
            if (this.parameter.isRequired() && !this.parameter.isAnnotatedWith(ParameterGroup.class)) {
                throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is required but annotated with '@%s', which is redundant", this.parameter.getName(), NullSafe.class.getSimpleName()));
            }
            final boolean hasDefaultOverride = !nullSafeAnnotationType.get().isSameType(Object.class);
            final MetadataType nullSafeType = hasDefaultOverride ? nullSafeAnnotationType.get().asMetadataType() : this.type;
            final boolean isInstantiable = hasDefaultOverride ? nullSafeAnnotationType.get().isInstantiable() : this.parameter.getType().isInstantiable();
            this.type.accept((MetadataTypeVisitor)new BasicTypeMetadataVisitor(){

                protected void visitBasicType(MetadataType metadataType) {
                    throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' but is of type '%s'. That annotation can only be used with complex types (Pojos, Lists, Maps)", JavaParameterModelParser.this.parameter.getName(), NullSafe.class.getSimpleName(), JavaParameterModelParser.this.parameter.getType().getName()));
                }

                public void visitArrayType(ArrayType arrayType) {
                    if (hasDefaultOverride) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' is of type '%s' but a 'defaultImplementingType' was provided. Type override is not allowed for Collections", JavaParameterModelParser.this.parameter.getName(), NullSafe.class.getSimpleName(), JavaParameterModelParser.this.parameter.getType().getName()));
                    }
                }

                public void visitObject(ObjectType objectType) {
                    if (hasDefaultOverride && ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' is of type '%s' but a 'defaultImplementingType' was provided. Type override is not allowed for Maps", JavaParameterModelParser.this.parameter.getName(), NullSafe.class.getSimpleName(), JavaParameterModelParser.this.parameter.getType().getName()));
                    }
                    if (hasDefaultOverride && JavaParameterModelParser.this.parameter.getType().isInstantiable()) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' is of concrete type '%s', but a 'defaultImplementingType' was provided. Type override is not allowed for concrete types", JavaParameterModelParser.this.parameter.getName(), NullSafe.class.getSimpleName(), JavaParameterModelParser.this.parameter.getType().getName()));
                    }
                    if (!isInstantiable && !ExtensionMetadataTypeUtils.isMap((MetadataType)nullSafeType)) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' but is of type '%s'. That annotation can only be used with complex instantiable types (Pojos, Lists, Maps)", JavaParameterModelParser.this.parameter.getName(), NullSafe.class.getSimpleName(), JavaParameterModelParser.this.parameter.getType().getName()));
                    }
                    if (hasDefaultOverride && !JavaParameterModelParser.this.parameter.getType().isAssignableFrom((Type)nullSafeAnnotationType.get())) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' of type '%s', but provided type '%s is not a subtype of the parameter's type", JavaParameterModelParser.this.parameter.getName(), NullSafe.class.getSimpleName(), JavaParameterModelParser.this.parameter.getType().getName(), JavaTypeUtils.getType((MetadataType)nullSafeType).getName()));
                    }
                }
            });
            this.additionalModelProperties.add(new NullSafeModelProperty(nullSafeType));
            if (hasDefaultOverride) {
                this.additionalModelProperties.add((ModelProperty)new DefaultImplementingTypeModelProperty(nullSafeType));
            }
        }
    }
}

