/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials;

import java.lang.reflect.Field;
import java.util.Map;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsGrantType;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.BaseOAuthConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthUtils;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.ClientCredentialsConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.ClientCredentialsConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.ClientCredentialsOAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class ClientCredentialsConnectionProviderObjectBuilder<C>
extends BaseOAuthConnectionProviderObjectBuilder<C> {
    private final ClientCredentialsOAuthHandler clientCredentialsHandler;
    private final ClientCredentialsGrantType grantType;
    private final Map<Field, String> callbackValues;

    public ClientCredentialsConnectionProviderObjectBuilder(ConnectionProviderModel providerModel, ResolverSet resolverSet, PoolingProfile poolingProfile, ReconnectionConfig reconnectionConfig, ClientCredentialsGrantType grantType, ClientCredentialsOAuthHandler clientCredentialsHandler, ExtensionModel extensionModel, ExpressionManager expressionManager, MuleContext muleContext) {
        super(providerModel, resolverSet, poolingProfile, reconnectionConfig, extensionModel, expressionManager, muleContext);
        this.clientCredentialsHandler = clientCredentialsHandler;
        this.grantType = grantType;
        this.callbackValues = ExtensionsOAuthUtils.getCallbackValuesExtractors(providerModel);
    }

    @Override
    protected ConnectionProvider<C> doBuild(ResolverSetResult result) throws MuleException {
        ConnectionProvider provider = super.doBuild(result);
        provider = this.wrapProvider(result, provider, this.getClientCredentialsParams(result));
        return provider;
    }

    @Override
    public Pair<ConnectionProvider<C>, ResolverSetResult> build(ValueResolvingContext context) throws MuleException {
        ResolverSetResult result = this.resolverSet.resolve(context);
        ConnectionProvider provider = super.doBuild(result);
        provider = this.wrapProvider(result, provider, this.getClientCredentialsParams(context.getEvent()));
        return new Pair(provider, (Object)result);
    }

    private ConnectionProvider<C> wrapProvider(ResolverSetResult result, ConnectionProvider<C> provider, Map<String, String> clientCredentialsParams) {
        BaseOAuthConnectionProviderObjectBuilder.CustomOAuthParameters customParameters = this.getCustomParameters(result);
        ClientCredentialsConfig config = new ClientCredentialsConfig(this.ownerConfigName, this.buildOAuthObjectStoreConfig(result), customParameters.getQueryParams(), customParameters.getHeaders(), this.callbackValues, clientCredentialsParams.get("clientId"), clientCredentialsParams.get("clientSecret"), clientCredentialsParams.get("tokenUrl"), clientCredentialsParams.get("scopes"), this.grantType.getCredentialsPlacement(), this.grantType);
        provider = new ClientCredentialsConnectionProviderWrapper<C>(provider, config, this.callbackValues, this.clientCredentialsHandler, this.reconnectionConfig);
        return provider;
    }

    private Map<String, String> getClientCredentialsParams(ResolverSetResult result) {
        return (Map)result.get("oauthClientCredentials");
    }

    private Map<String, String> getClientCredentialsParams(CoreEvent event) throws MuleException {
        ValueResolver<?> valueResolver = this.resolverSet.getResolvers().get("oauthClientCredentials");
        try (ValueResolvingContext context = this.getResolvingContextFor(event);){
            Map map = (Map)valueResolver.resolve(context);
            return map;
        }
    }
}

