/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type.runtime;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.extension.api.annotation.ExpressionFunctions;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.module.extension.api.loader.java.type.ComponentElement;
import org.mule.runtime.module.extension.api.loader.java.type.ConnectionProviderElement;
import org.mule.runtime.module.extension.api.loader.java.type.FunctionContainerElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationContainerElement;
import org.mule.runtime.module.extension.api.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ConnectionProviderTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.FunctionContainerWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.OperationContainerWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.SourceTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.sdk.api.annotation.Sources;

abstract class ComponentWrapper
extends TypeWrapper
implements ComponentElement {
    ComponentWrapper(Class<?> aClass, ClassTypeLoader typeLoader) {
        super(aClass, typeLoader);
    }

    @Override
    public List<SourceElement> getSources() {
        ArrayList<SourceElement> elements = new ArrayList<SourceElement>();
        this.collectSources(elements, org.mule.runtime.extension.api.annotation.Sources.class, org.mule.runtime.extension.api.annotation.Sources::value);
        this.collectSources(elements, Sources.class, Sources::value);
        return elements;
    }

    private <A extends Annotation> void collectSources(List<SourceElement> accumulator, Class<A> annotationClass, Function<A, Class[]> extractionFunction) {
        this.getAnnotation(annotationClass).map(a -> Arrays.stream((Object[])extractionFunction.apply(a))).ifPresent(stream -> stream.forEach(s -> accumulator.add(new SourceTypeWrapper(s, this.typeLoader))));
    }

    @Override
    public List<OperationContainerElement> getOperationContainers() {
        Optional<Operations> optionalOperations = this.getAnnotation(Operations.class);
        if (optionalOperations.isPresent()) {
            return Arrays.stream(optionalOperations.get().value()).map(aClass -> new OperationContainerWrapper((Class)aClass, this.typeLoader)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public List<FunctionContainerElement> getFunctionContainers() {
        Optional<ExpressionFunctions> functions = this.getAnnotation(ExpressionFunctions.class);
        if (functions.isPresent()) {
            return Arrays.stream(functions.get().value()).map(aClass -> new FunctionContainerWrapper((Class)aClass, this.typeLoader)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ConnectionProviderElement> getConnectionProviders() {
        Optional<ConnectionProviders> optionalProviders = this.getAnnotation(ConnectionProviders.class);
        if (optionalProviders.isPresent()) {
            return Arrays.stream(optionalProviders.get().value()).map(c -> new ConnectionProviderTypeWrapper(c, this.typeLoader)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

