/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.Declarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasModelProperties;
import org.mule.runtime.api.meta.model.declaration.fluent.HasParametersDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasSourceDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclarer;
import org.mule.runtime.extension.api.annotation.Streaming;
import org.mule.runtime.extension.api.annotation.source.EmitsResponse;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalSourceModelDefinitionException;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.WithMessageSources;
import org.mule.runtime.module.extension.internal.loader.java.AbstractModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.ParameterModelsLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.SourceCallbackModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.SourceFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;
import org.mule.runtime.module.extension.internal.loader.utils.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.runtime.source.DefaultSourceFactory;

final class SourceModelLoaderDelegate
extends AbstractModelLoaderDelegate {
    private static final String SOURCE = "Source";
    private final Map<SourceElement, SourceDeclarer> sourceDeclarers = new HashMap<SourceElement, SourceDeclarer>();

    SourceModelLoaderDelegate(DefaultJavaModelLoaderDelegate delegate) {
        super(delegate);
    }

    void declareMessageSources(ExtensionDeclarer extensionDeclarer, HasSourceDeclarer declarer, WithMessageSources typeComponent) {
        typeComponent.getSources().forEach(source -> this.declareMessageSource(extensionDeclarer, declarer, (SourceElement)source, true));
    }

    void declareMessageSource(ExtensionDeclarer extensionDeclarer, HasSourceDeclarer declarer, SourceElement sourceType, boolean supportsConfig) {
        this.validateLifecycle(sourceType, Startable.class);
        this.validateLifecycle(sourceType, Stoppable.class);
        Optional<ExtensionParameter> configParameter = this.loader.getConfigParameter(sourceType);
        Optional<ExtensionParameter> connectionParameter = this.loader.getConnectionParameter(sourceType);
        if (this.loader.isInvalidConfigSupport(supportsConfig, configParameter, connectionParameter)) {
            throw new IllegalSourceModelDefinitionException(String.format("Source '%s' is defined at the extension level but it requires a config parameter. Remove such parameter or move the source to the proper config", sourceType.getName()));
        }
        HasSourceDeclarer actualDeclarer = (HasSourceDeclarer)this.loader.selectDeclarerBasedOnConfig(extensionDeclarer, (Declarer)declarer, configParameter, connectionParameter);
        SourceDeclarer existingDeclarer = this.sourceDeclarers.get(sourceType);
        if (existingDeclarer != null) {
            actualDeclarer.withMessageSource(existingDeclarer);
            return;
        }
        SourceDeclarer sourceDeclarer = actualDeclarer.withMessageSource(sourceType.getAlias());
        sourceDeclarer.withModelProperty((ModelProperty)new ExtensionTypeDescriptorModelProperty(sourceType));
        List<Type> sourceGenerics = sourceType.getSuperClassGenerics();
        if (sourceGenerics.size() != 2) {
            throw new IllegalModelDefinitionException(String.format("Message source class '%s' was expected to have 2 generic types (one for the Payload type and another for the Attributes type) but %d were found", sourceType.getName(), sourceGenerics.size()));
        }
        sourceDeclarer.hasResponse(sourceType.isAnnotatedWith(EmitsResponse.class)).requiresConnection(connectionParameter.isPresent());
        sourceType.getDeclaringClass().ifPresent(clazz -> {
            SourceDeclarer cfr_ignored_0 = (SourceDeclarer)((SourceDeclarer)sourceDeclarer.withModelProperty((ModelProperty)new SourceFactoryModelProperty(new DefaultSourceFactory((Class<? extends Source>)clazz)))).withModelProperty((ModelProperty)new ImplementingTypeModelProperty((Class<?>)clazz));
        });
        this.processMimeType((HasModelProperties)sourceDeclarer, sourceType);
        this.processComponentConnectivity((ExecutableComponentDeclarer)sourceDeclarer, sourceType, sourceType);
        this.resolveOutputTypes(sourceDeclarer, sourceType);
        this.loader.addExceptionEnricher(sourceType, (HasModelProperties)sourceDeclarer);
        this.declareSourceParameters(sourceType, sourceDeclarer);
        this.declareSourceCallback(sourceType, sourceDeclarer);
        this.sourceDeclarers.put(sourceType, sourceDeclarer);
    }

    private void validateLifecycle(SourceElement sourceType, Class<?> lifecycleType) {
        if (sourceType.isAssignableTo(lifecycleType)) {
            throw new IllegalSourceModelDefinitionException(String.format("Source class '%s' implements lifecycle interface '%s'. Sources are only not allowed to implement '%s' and '%s'", sourceType.getName(), lifecycleType, Initialisable.class.getSimpleName(), Disposable.class.getSimpleName()));
        }
    }

    private void resolveOutputTypes(SourceDeclarer source, SourceElement sourceType) {
        MetadataType returnMetadataType = sourceType.getReturnMetadataType();
        source.withOutput().ofType(returnMetadataType);
        source.withOutputAttributes().ofType(sourceType.getAttributesMetadataType());
        source.supportsStreaming(ModelLoaderUtils.isInputStream(returnMetadataType) || sourceType.getAnnotation(Streaming.class).isPresent());
    }

    private void declareSourceParameters(SourceElement sourceType, SourceDeclarer source) {
        ParameterModelsLoaderDelegate parametersLoader = this.loader.getFieldParametersLoader();
        ParameterDeclarationContext declarationContext = new ParameterDeclarationContext(SOURCE, (NamedDeclaration)source.getDeclaration());
        List<ParameterDeclarer> parameters = parametersLoader.declare((HasParametersDeclarer)source, sourceType.getParameters(), declarationContext);
        parameters.forEach(p -> p.withExpressionSupport(ExpressionSupport.NOT_SUPPORTED));
    }

    private void declareSourceCallback(SourceElement sourceType, SourceDeclarer source) {
        Optional<MethodElement> onResponseMethod = sourceType.getOnResponseMethod();
        Optional<MethodElement> onErrorMethod = sourceType.getOnErrorMethod();
        Optional<MethodElement> onTerminateMethod = sourceType.getOnTerminateMethod();
        Optional<MethodElement> onBackPressureMethod = sourceType.getOnBackPressureMethod();
        this.declareSourceCallbackParameters(source, onResponseMethod, () -> ((SourceDeclarer)source).onSuccess());
        this.declareSourceCallbackParameters(source, onErrorMethod, () -> ((SourceDeclarer)source).onError());
        this.declareSourceCallbackParameters(source, onTerminateMethod, () -> ((SourceDeclarer)source).onTerminate());
        this.declareSourceCallbackParameters(source, onBackPressureMethod, () -> ((SourceDeclarer)source).onBackPressure());
        source.withModelProperty((ModelProperty)new SourceCallbackModelProperty(this.getMethod(onResponseMethod), this.getMethod(onErrorMethod), this.getMethod(onTerminateMethod), this.getMethod(onBackPressureMethod)));
    }

    private void declareSourceCallbackParameters(SourceDeclarer source, Optional<MethodElement> sourceCallback, Supplier<ParameterizedDeclarer> callback) {
        sourceCallback.ifPresent(method -> {
            ParameterDeclarationContext declarationContext = new ParameterDeclarationContext(SOURCE, (NamedDeclaration)source.getDeclaration());
            this.loader.getMethodParametersLoader().declare((HasParametersDeclarer)callback.get(), method.getParameters(), declarationContext);
        });
    }

    private Optional<Method> getMethod(Optional<MethodElement> method) {
        return method.flatMap(MethodElement::getMethod);
    }
}

