/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.scorecard.compiler.executor;

import java.util.Map;
import org.dmg.pmml.scorecard.Scorecard;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.api.provider.ModelImplementationProvider;
import org.kie.pmml.models.scorecard.compiler.ScorecardCompilationDTO;
import org.kie.pmml.models.scorecard.compiler.factories.KiePMMLScorecardModelFactory;
import org.kie.pmml.models.scorecard.model.KiePMMLScorecardModel;
import org.kie.pmml.models.scorecard.model.KiePMMLScorecardModelWithSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScorecardModelImplementationProvider
implements ModelImplementationProvider<Scorecard, KiePMMLScorecardModel> {
    private static final Logger logger = LoggerFactory.getLogger((String)ScorecardModelImplementationProvider.class.getName());

    public PMML_MODEL getPMMLModelType() {
        logger.trace("getPMMLModelType");
        return PMML_MODEL.SCORECARD_MODEL;
    }

    public KiePMMLScorecardModel getKiePMMLModel(CompilationDTO<Scorecard> compilationDTO) {
        logger.trace("getKiePMMLModel {} {} {} {}", new Object[]{compilationDTO.getPackageName(), compilationDTO.getFields(), compilationDTO.getModel(), compilationDTO.getHasClassloader()});
        return KiePMMLScorecardModelFactory.getKiePMMLScorecardModel(ScorecardCompilationDTO.fromCompilationDTO(compilationDTO));
    }

    public KiePMMLScorecardModel getKiePMMLModelWithSources(CompilationDTO<Scorecard> compilationDTO) {
        logger.trace("getKiePMMLModelWithSources {} {} {} {}", new Object[]{compilationDTO.getPackageName(), compilationDTO.getFields(), compilationDTO.getModel(), compilationDTO.getHasClassloader()});
        try {
            ScorecardCompilationDTO scorecardCompilationDTO = ScorecardCompilationDTO.fromCompilationDTO(compilationDTO);
            Map<String, String> sourcesMap = KiePMMLScorecardModelFactory.getKiePMMLScorecardModelSourcesMap(scorecardCompilationDTO);
            return new KiePMMLScorecardModelWithSources(scorecardCompilationDTO.getModelName(), scorecardCompilationDTO.getPackageName(), sourcesMap);
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }
}

