package org.infinispan.server.hotrod;
import java.util.List;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.MediaTypeIds;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.util.EncodeUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.server.hotrod.tx.ControlByte;

public class HotRodDecoder extends BaseDecoder {
	private int state;
	private int requestBytes;

	private byte hr2x_timeUnits;
	private int hr2x_numEntries;
	private String hr2x_iterationId;
	private byte hr2x_controlByte;
	private int hr2x_bloomBits;
	private byte[] hr2x_otherParamValue;
	private byte[] hr2x_fixedArray;
	private byte[] hr2x_queryBytes;
	private byte hr2x_counterFlags;
	private long hr2x_expectValue;
	private ByteBuf hr2x_readable;
	private boolean hr2x_includeCurrentState;
	private String hr2x_taskParam;
	private String hr2x_otherParamName;
	private String hr2x_cacheName;
	private int hr2x_vInt;
	private MediaType hr2x_valueType;
	private long hr2x_initialValue;
	private int hr2x_numModifications;
	private byte[] hr2x_param;
	private String hr2x_authMech;
	private byte[] hr2x_authResponse;
	private int hr2x_otherParamsNum;
	private int hr2x_listenerInterests;
	private byte hr2x_numParams;
	private int hr2x_xidFormat;
	private String hr2x_filterFactory;
	private long hr2x_maxIdleLong;
	private HotRodOperation hr2x_operation;
	private Map< String, byte[]> hr2x_otherParams;
	private long hr2x_upperBound;
	private byte hr2x_version;
	private String hr2x_converterFactory;
	private int hr2x_signedVInt;
	private boolean hr2x_supportsDuplicates;
	private MediaType hr2x_keyType;
	private String hr2x_filterConverterFactory;
	private Map< String, String> hr2x_mediaTypeParams;
	private long hr2x_versionRead;
	private int hr2x_lifespanInt;
	private String hr2x_mediaParamValue;
	private byte hr2x_intelligence;
	private long hr2x_long;
	private String hr2x_mediaParamName;
	private List< byte[]> hr2x_converterParams;
	private boolean hr2x_recoverable;
	private byte[] hr2x_bloomArray;
	private byte[] hr2x_value;
	private byte hr2x_branchLength;
	private String hr2x_optionalString;
	private byte[] hr2x_optionalArray;
	private boolean hr2x_bool;
	private byte hr2x_xidLength;
	private byte hr2x_mediaTypeDefinition;
	private Metadata.Builder hr2x_expiration;
	private List< byte[]> hr2x_filterParams;
	private int hr2x_offset;
	private ByteBuf hr2x_chunkBytes;
	private long hr2x_updateValue;
	private byte hr2x_txMarker;
	private boolean hr2x_useRawEvents;
	private int hr2x_chunkLength;
	private long hr2x_timeout;
	private String hr2x_taskName;
	private String hr2x_mediaTypeName;
	private long hr2x_lowerBound;
	private byte[] hr2x_taskParamValue;
	private ByteBuf hr2x_chunkedValue;
	private byte[] hr2x_key;
	private int hr2x_batchSize;
	private HotRodHeader hr2x_header;
	private int hr2x_scope;
	private long hr2x_lifespanLong;
	private Map< String, byte[]> hr2x_taskParams;
	private byte[] hr2x_array;
	private int hr2x_flags;
	private byte[] hr2x_listenerId;
	private byte[] hr2x_segmentMask;
	private byte hr2x_magic;
	private int hr2x_maxIdleInt;
	private boolean hr2x_onePhaseCommit;
	private long hr2x_entryVersion;
	private int hr2x_mediaTypeId;
	private boolean hr2x_includeMetadata;
	private byte hr2x_opCode;
	private Map< byte[], byte[]> hr2x_entryMap;
	private int hr2x_mediaTypeParamsNum;
	private long hr2x_messageId;
	private long hr2x_vLong;
	private List< byte[]> hr2x_filterConverterParams;
	private int hr2x_numKeys;
	private Map< String, byte[]> hr2x_otherParamsRev;
	private MediaType hr2x_mediaType;
	private byte[] hr2x_branchId;
	private String hr2x_string;
	private byte hr2x_byte;
	private byte[] hr2x_transactionId;
	private MediaType hr2x_mediaTypeDescription;
	private String hr2x_counterName;
	private TransactionWrite hr2x_modification;
	private CounterConfiguration.Builder hr2x_counterConfiguration;
	private int hr2x_topologyId;
	private Set< byte[]> hr2x_keys;
	private XidImpl hr2x_xid;
	private List< TransactionWrite> hr2x_modifications;

	private final boolean accessLogging;
	private Temporal requestStart;
	private boolean deadEnd = false;
	public HotRodDecoder(EmbeddedCacheManager cacheManager, Executor executor, HotRodServer server) {
		super(cacheManager, executor, server);
		accessLogging = server.accessLogging().isEnabled();
	}

	@Override
	protected HotRodHeader getHeader() {
		if (accessLogging && hr2x_header != null) {
			return new AccessLoggingHeader(hr2x_header, null, hr2x_key != null ? hr2x_key : hr2x_taskName, requestBytes, requestStart);
		} else {
			return hr2x_header;
		}
	}

	@Override
	public void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
		int pos = buf.readerIndex();
		try {
			while (switch1_0(buf));
		} catch (Throwable t) {
			exceptionally(t);
		} finally {
			requestBytes += buf.readerIndex() - pos;
		}
	}

	private boolean switch1_0(ByteBuf buf) throws Exception {
		switch (state >> 6) {
		case 0: return switch0(buf);
		case 1: return switch1(buf);
		case 2: return switch2(buf);
		case 3: return switch3(buf);
		case 4: return switch4(buf);
		case 5: return switch5(buf);
		case 6: return switch6(buf);
		case 7: return switch7(buf);
		default: throw new IllegalStateException();
		}
	}

	private boolean switch0(ByteBuf buf) throws Exception {
		byte b;
		int pos;
		switch (state) {
		case 0: 
			// 
			reset(); 
			state = 1;
			// fallthrough
		case 1: 
			// 
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_magic = hr2x_byte;
			state = 2;
			// fallthrough
		case 2: 
			// hr2x.request
			if (accessLogging) {
			requestStart = Instant.now();
			}
			;
			
			state = 3;
			// fallthrough
		case 3: 
			// hr2x.request
			if (hr2x_magic != org.infinispan.server.hotrod.Constants.MAGIC_REQ) {
				state = 5;
				return true;
			}
			deadEnd = false;
			
			state = 6;
			return true;
		case 4: 
			// hr2x.request
			if (log.isTraceEnabled()) log.tracef("Parsed header: %s", hr2x_header);
			
			state = 63;
			return true;
		case 5: 
			// hr2x.request/hr2x.header
			throw new InvalidMagicIdException("Error reading magic byte or message id: " + hr2x_magic);
			
		case 6: 
			// hr2x.request/hr2x.header
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_messageId = hr2x_vLong;
			state = 7;
			// fallthrough
		case 7: 
			// hr2x.request/hr2x.header
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_version = hr2x_byte;
			state = 8;
			// fallthrough
		case 8: 
			// hr2x.request/hr2x.header
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_opCode = hr2x_byte;
			hr2x_operation = HotRodOperation.fromRequestOpCode(hr2x_byte);
			state = 9;
			// fallthrough
		case 9: 
			// hr2x.request/hr2x.header
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_cacheName = hr2x_string;
			state = 10;
			// fallthrough
		case 10: 
			// hr2x.request/hr2x.header
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_flags = hr2x_vInt;
			state = 11;
			// fallthrough
		case 11: 
			// hr2x.request/hr2x.header
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_intelligence = hr2x_byte;
			state = 12;
			// fallthrough
		case 12: 
			// hr2x.request/hr2x.header
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_topologyId = hr2x_vInt;
			state = 13;
			// fallthrough
		case 13: 
			// hr2x.request/hr2x.header
			if (hr2x_version < org.infinispan.server.hotrod.HotRodConstants.VERSION_20) {
				state = 15;
				return true;
			}
			hr2x_txMarker = 0;
			state = 14;
			// fallthrough
		case 14: 
			// hr2x.request/hr2x.header
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_28) {
				state = 17;
				return true;
			}
			hr2x_mediaType = null;
			hr2x_keyType = hr2x_mediaType;
			state = 16;
			return true;
		case 15: 
			// hr2x.request/hr2x.header/hr2x.txMarker
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_txMarker = hr2x_byte;
			state = 14;
			return true;
		case 16: 
			// hr2x.request/hr2x.header
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_28) {
				state = 37;
				return true;
			}
			hr2x_mediaType = null;
			hr2x_valueType = hr2x_mediaType;
			state = 36;
			return true;
		case 17: 
			// hr2x.request/hr2x.header/hr2x.keyType/hr2x.mediaType
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_mediaTypeDefinition = hr2x_byte;
			state = 18;
			// fallthrough
		case 18: 
			// hr2x.request/hr2x.header/hr2x.keyType/hr2x.mediaType
			switch (hr2x_mediaTypeDefinition) {
			case 0: 
				state = 19;
				return true;
			case 1: 
				state = 20;
				return true;
			case 2: 
				state = 28;
				return true;
			default: 
				throw new RequestParsingException("Unknown MediaType definition: " + hr2x_mediaTypeDefinition, hr2x_version, hr2x_messageId);
				
			}
		case 19: 
			// hr2x.request/hr2x.header/hr2x.keyType/hr2x.mediaType/hr2x.mediaTypeDescription
			hr2x_mediaTypeDescription = MediaType.APPLICATION_UNKNOWN;
			hr2x_mediaType = hr2x_mediaTypeDescription;
			hr2x_keyType = hr2x_mediaType;
			state = 16;
			return true;
		case 20: 
			// hr2x.request/hr2x.header/hr2x.keyType/hr2x.mediaType/hr2x.mediaTypeDescription
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_mediaTypeId = hr2x_vInt;
			state = 21;
			// fallthrough
		case 21: 
			// hr2x.request/hr2x.header/hr2x.keyType/hr2x.mediaType/hr2x.mediaTypeDescription
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_mediaTypeParamsNum = hr2x_vInt;
			state = 23;
			return true;
		case 22: 
			// hr2x.request/hr2x.header/hr2x.keyType/hr2x.mediaType/hr2x.mediaTypeDescription
			hr2x_mediaTypeDescription = MediaTypeIds.getMediaType((short) hr2x_mediaTypeId).withParameters(hr2x_mediaTypeParams);
			hr2x_mediaType = hr2x_mediaTypeDescription;
			hr2x_keyType = hr2x_mediaType;
			state = 16;
			return true;
		case 23: 
			// hr2x.request/hr2x.header/hr2x.keyType/hr2x.mediaType/hr2x.mediaTypeDescription/hr2x.mediaTypeParams
			hr2x_mediaTypeParams = allocMap(hr2x_mediaTypeParamsNum);
			
			state = 24;
			// fallthrough
		case 24: 
			// hr2x.request/hr2x.header/hr2x.keyType/hr2x.mediaType/hr2x.mediaTypeDescription/hr2x.mediaTypeParams
			if (hr2x_mediaTypeParamsNum == 0) {
				state = 22;
				return true;
			}
			hr2x_mediaTypeParamsNum--;
			state = 25;
			// fallthrough
		case 25: 
			// hr2x.request/hr2x.header/hr2x.keyType/hr2x.mediaType/hr2x.mediaTypeDescription/hr2x.mediaTypeParams
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_mediaParamName = hr2x_string;
			state = 26;
			// fallthrough
		case 26: 
			// hr2x.request/hr2x.header/hr2x.keyType/hr2x.mediaType/hr2x.mediaTypeDescription/hr2x.mediaTypeParams
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_mediaParamValue = hr2x_string;
			state = 27;
			// fallthrough
		case 27: 
			// hr2x.request/hr2x.header/hr2x.keyType/hr2x.mediaType/hr2x.mediaTypeDescription/hr2x.mediaTypeParams
			hr2x_mediaTypeParams.put(hr2x_mediaParamName, hr2x_mediaParamValue);
			
			state = 24;
			return true;
		case 28: 
			// hr2x.request/hr2x.header/hr2x.keyType/hr2x.mediaType/hr2x.mediaTypeDescription
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_mediaTypeName = hr2x_string;
			state = 29;
			// fallthrough
		case 29: 
			// hr2x.request/hr2x.header/hr2x.keyType/hr2x.mediaType/hr2x.mediaTypeDescription
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_mediaTypeParamsNum = hr2x_vInt;
			state = 31;
			return true;
		case 30: 
			// hr2x.request/hr2x.header/hr2x.keyType/hr2x.mediaType/hr2x.mediaTypeDescription
			hr2x_mediaTypeDescription = MediaType.fromString(hr2x_mediaTypeName).withParameters(hr2x_mediaTypeParams);
			hr2x_mediaType = hr2x_mediaTypeDescription;
			hr2x_keyType = hr2x_mediaType;
			state = 16;
			return true;
		case 31: 
			// hr2x.request/hr2x.header/hr2x.keyType/hr2x.mediaType/hr2x.mediaTypeDescription/hr2x.mediaTypeParams
			hr2x_mediaTypeParams = allocMap(hr2x_mediaTypeParamsNum);
			
			state = 32;
			// fallthrough
		case 32: 
			// hr2x.request/hr2x.header/hr2x.keyType/hr2x.mediaType/hr2x.mediaTypeDescription/hr2x.mediaTypeParams
			if (hr2x_mediaTypeParamsNum == 0) {
				state = 30;
				return true;
			}
			hr2x_mediaTypeParamsNum--;
			state = 33;
			// fallthrough
		case 33: 
			// hr2x.request/hr2x.header/hr2x.keyType/hr2x.mediaType/hr2x.mediaTypeDescription/hr2x.mediaTypeParams
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_mediaParamName = hr2x_string;
			state = 34;
			// fallthrough
		case 34: 
			// hr2x.request/hr2x.header/hr2x.keyType/hr2x.mediaType/hr2x.mediaTypeDescription/hr2x.mediaTypeParams
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_mediaParamValue = hr2x_string;
			state = 35;
			// fallthrough
		case 35: 
			// hr2x.request/hr2x.header/hr2x.keyType/hr2x.mediaType/hr2x.mediaTypeDescription/hr2x.mediaTypeParams
			hr2x_mediaTypeParams.put(hr2x_mediaParamName, hr2x_mediaParamValue);
			
			state = 32;
			return true;
		case 36: 
			// hr2x.request/hr2x.header
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_40) {
				state = 56;
				return true;
			}
			hr2x_otherParams = null;
			hr2x_header = new HotRodHeader(hr2x_operation, hr2x_version, hr2x_messageId, hr2x_cacheName, hr2x_flags, hr2x_intelligence, hr2x_topologyId, hr2x_keyType, hr2x_valueType, hr2x_otherParams);
			state = 4;
			return true;
		case 37: 
			// hr2x.request/hr2x.header/hr2x.valueType/hr2x.mediaType
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_mediaTypeDefinition = hr2x_byte;
			state = 38;
			// fallthrough
		case 38: 
			// hr2x.request/hr2x.header/hr2x.valueType/hr2x.mediaType
			switch (hr2x_mediaTypeDefinition) {
			case 0: 
				state = 39;
				return true;
			case 1: 
				state = 40;
				return true;
			case 2: 
				state = 48;
				return true;
			default: 
				throw new RequestParsingException("Unknown MediaType definition: " + hr2x_mediaTypeDefinition, hr2x_version, hr2x_messageId);
				
			}
		case 39: 
			// hr2x.request/hr2x.header/hr2x.valueType/hr2x.mediaType/hr2x.mediaTypeDescription
			hr2x_mediaTypeDescription = MediaType.APPLICATION_UNKNOWN;
			hr2x_mediaType = hr2x_mediaTypeDescription;
			hr2x_valueType = hr2x_mediaType;
			state = 36;
			return true;
		case 40: 
			// hr2x.request/hr2x.header/hr2x.valueType/hr2x.mediaType/hr2x.mediaTypeDescription
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_mediaTypeId = hr2x_vInt;
			state = 41;
			// fallthrough
		case 41: 
			// hr2x.request/hr2x.header/hr2x.valueType/hr2x.mediaType/hr2x.mediaTypeDescription
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_mediaTypeParamsNum = hr2x_vInt;
			state = 43;
			return true;
		case 42: 
			// hr2x.request/hr2x.header/hr2x.valueType/hr2x.mediaType/hr2x.mediaTypeDescription
			hr2x_mediaTypeDescription = MediaTypeIds.getMediaType((short) hr2x_mediaTypeId).withParameters(hr2x_mediaTypeParams);
			hr2x_mediaType = hr2x_mediaTypeDescription;
			hr2x_valueType = hr2x_mediaType;
			state = 36;
			return true;
		case 43: 
			// hr2x.request/hr2x.header/hr2x.valueType/hr2x.mediaType/hr2x.mediaTypeDescription/hr2x.mediaTypeParams
			hr2x_mediaTypeParams = allocMap(hr2x_mediaTypeParamsNum);
			
			state = 44;
			// fallthrough
		case 44: 
			// hr2x.request/hr2x.header/hr2x.valueType/hr2x.mediaType/hr2x.mediaTypeDescription/hr2x.mediaTypeParams
			if (hr2x_mediaTypeParamsNum == 0) {
				state = 42;
				return true;
			}
			hr2x_mediaTypeParamsNum--;
			state = 45;
			// fallthrough
		case 45: 
			// hr2x.request/hr2x.header/hr2x.valueType/hr2x.mediaType/hr2x.mediaTypeDescription/hr2x.mediaTypeParams
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_mediaParamName = hr2x_string;
			state = 46;
			// fallthrough
		case 46: 
			// hr2x.request/hr2x.header/hr2x.valueType/hr2x.mediaType/hr2x.mediaTypeDescription/hr2x.mediaTypeParams
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_mediaParamValue = hr2x_string;
			state = 47;
			// fallthrough
		case 47: 
			// hr2x.request/hr2x.header/hr2x.valueType/hr2x.mediaType/hr2x.mediaTypeDescription/hr2x.mediaTypeParams
			hr2x_mediaTypeParams.put(hr2x_mediaParamName, hr2x_mediaParamValue);
			
			state = 44;
			return true;
		case 48: 
			// hr2x.request/hr2x.header/hr2x.valueType/hr2x.mediaType/hr2x.mediaTypeDescription
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_mediaTypeName = hr2x_string;
			state = 49;
			// fallthrough
		case 49: 
			// hr2x.request/hr2x.header/hr2x.valueType/hr2x.mediaType/hr2x.mediaTypeDescription
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_mediaTypeParamsNum = hr2x_vInt;
			state = 51;
			return true;
		case 50: 
			// hr2x.request/hr2x.header/hr2x.valueType/hr2x.mediaType/hr2x.mediaTypeDescription
			hr2x_mediaTypeDescription = MediaType.fromString(hr2x_mediaTypeName).withParameters(hr2x_mediaTypeParams);
			hr2x_mediaType = hr2x_mediaTypeDescription;
			hr2x_valueType = hr2x_mediaType;
			state = 36;
			return true;
		case 51: 
			// hr2x.request/hr2x.header/hr2x.valueType/hr2x.mediaType/hr2x.mediaTypeDescription/hr2x.mediaTypeParams
			hr2x_mediaTypeParams = allocMap(hr2x_mediaTypeParamsNum);
			
			state = 52;
			// fallthrough
		case 52: 
			// hr2x.request/hr2x.header/hr2x.valueType/hr2x.mediaType/hr2x.mediaTypeDescription/hr2x.mediaTypeParams
			if (hr2x_mediaTypeParamsNum == 0) {
				state = 50;
				return true;
			}
			hr2x_mediaTypeParamsNum--;
			state = 53;
			// fallthrough
		case 53: 
			// hr2x.request/hr2x.header/hr2x.valueType/hr2x.mediaType/hr2x.mediaTypeDescription/hr2x.mediaTypeParams
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_mediaParamName = hr2x_string;
			state = 54;
			// fallthrough
		case 54: 
			// hr2x.request/hr2x.header/hr2x.valueType/hr2x.mediaType/hr2x.mediaTypeDescription/hr2x.mediaTypeParams
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_mediaParamValue = hr2x_string;
			state = 55;
			// fallthrough
		case 55: 
			// hr2x.request/hr2x.header/hr2x.valueType/hr2x.mediaType/hr2x.mediaTypeDescription/hr2x.mediaTypeParams
			hr2x_mediaTypeParams.put(hr2x_mediaParamName, hr2x_mediaParamValue);
			
			state = 52;
			return true;
		case 56: 
			// hr2x.request/hr2x.header/hr2x.otherParams
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_otherParamsNum = hr2x_vInt;
			state = 58;
			return true;
		case 57: 
			// hr2x.request/hr2x.header/hr2x.otherParams
			hr2x_otherParams = hr2x_otherParamsRev;
			hr2x_header = new HotRodHeader(hr2x_operation, hr2x_version, hr2x_messageId, hr2x_cacheName, hr2x_flags, hr2x_intelligence, hr2x_topologyId, hr2x_keyType, hr2x_valueType, hr2x_otherParams);
			state = 4;
			return true;
		case 58: 
			// hr2x.request/hr2x.header/hr2x.otherParams/hr2x.otherParamsRev
			hr2x_otherParamsRev = allocMap(hr2x_otherParamsNum);
			
			state = 59;
			// fallthrough
		case 59: 
			// hr2x.request/hr2x.header/hr2x.otherParams/hr2x.otherParamsRev
			if (hr2x_otherParamsNum == 0) {
				state = 57;
				return true;
			}
			hr2x_otherParamsNum--;
			state = 60;
			// fallthrough
		case 60: 
			// hr2x.request/hr2x.header/hr2x.otherParams/hr2x.otherParamsRev
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_otherParamName = hr2x_string;
			state = 61;
			// fallthrough
		case 61: 
			// hr2x.request/hr2x.header/hr2x.otherParams/hr2x.otherParamsRev
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_otherParamValue = hr2x_array;
			state = 62;
			// fallthrough
		case 62: 
			// hr2x.request/hr2x.header/hr2x.otherParams/hr2x.otherParamsRev
			hr2x_otherParamsRev.put(hr2x_otherParamName, hr2x_otherParamValue);
			
			state = 59;
			return true;
		case 63: 
			// hr2x.request
			return userSwitch63();
		}
		return true;
	}

	private boolean switch1(ByteBuf buf) throws Exception {
		byte b;
		int pos;
		switch (state) {
		case 64: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_key = hr2x_array;
			state = 65;
			// fallthrough
		case 65: 
			// hr2x.request/hr2x.parameters
			if (hr2x_version < org.infinispan.server.hotrod.HotRodConstants.VERSION_22) {
				state = 67;
				return true;
			}
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_30) {
				state = 69;
				return true;
			}
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeUnits = hr2x_byte;
			state = 74;
			return true;
		case 66: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_value = hr2x_array;
			state = 78;
			return true;
		case 67: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanInt = hr2x_vInt;
			state = 68;
			// fallthrough
		case 68: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleInt = hr2x_vInt;
			hr2x_expiration = server.buildMetadata2x(defaultExpiration(hr2x_lifespanInt, hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, defaultExpiration(hr2x_maxIdleInt, hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
			state = 66;
			return true;
		case 69: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeUnits = hr2x_byte;
			state = 70;
			// fallthrough
		case 70: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0xF0) != 0x70 &&(hr2x_timeUnits & 0xF0) != 0x80) {
				state = 72;
				return true;
			}
			hr2x_lifespanLong = 0L;
			state = 71;
			// fallthrough
		case 71: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0x0F) != 0x07 &&(hr2x_timeUnits & 0x0F) != 0x08) {
				state = 73;
				return true;
			}
			hr2x_maxIdleLong = 0L;
			hr2x_expiration = server.buildMetadata(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 66;
			return true;
		case 72: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.lifespanLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanLong = hr2x_vLong;
			state = 71;
			return true;
		case 73: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.maxIdleLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleLong = hr2x_vLong;
			hr2x_expiration = server.buildMetadata(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 66;
			return true;
		case 74: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0xF0) != 0x70 &&(hr2x_timeUnits & 0xF0) != 0x80) {
				state = 76;
				return true;
			}
			hr2x_lifespanLong = 0L;
			state = 75;
			// fallthrough
		case 75: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0x0F) != 0x07 &&(hr2x_timeUnits & 0x0F) != 0x08) {
				state = 77;
				return true;
			}
			hr2x_maxIdleLong = 0L;
			hr2x_expiration = server.buildMetadata2x(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 66;
			return true;
		case 76: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.lifespanLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanLong = hr2x_vLong;
			state = 75;
			return true;
		case 77: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.maxIdleLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleLong = hr2x_vLong;
			hr2x_expiration = server.buildMetadata2x(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 66;
			return true;
		case 78: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.put(getHeader(), auth.getSubject(hr2x_operation), hr2x_key, hr2x_value, hr2x_expiration);
			
			state = 0;
			return true;
		case 79: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_key = hr2x_array;
			state = 80;
			// fallthrough
		case 80: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.get(getHeader(), auth.getSubject(hr2x_operation), hr2x_key);
			
			state = 0;
			return true;
		case 81: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_key = hr2x_array;
			state = 82;
			// fallthrough
		case 82: 
			// hr2x.request/hr2x.parameters
			if (hr2x_version < org.infinispan.server.hotrod.HotRodConstants.VERSION_22) {
				state = 84;
				return true;
			}
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_30) {
				state = 86;
				return true;
			}
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeUnits = hr2x_byte;
			state = 91;
			return true;
		case 83: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_value = hr2x_array;
			state = 95;
			return true;
		case 84: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanInt = hr2x_vInt;
			state = 85;
			// fallthrough
		case 85: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleInt = hr2x_vInt;
			hr2x_expiration = server.buildMetadata2x(defaultExpiration(hr2x_lifespanInt, hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, defaultExpiration(hr2x_maxIdleInt, hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
			state = 83;
			return true;
		case 86: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeUnits = hr2x_byte;
			state = 87;
			// fallthrough
		case 87: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0xF0) != 0x70 &&(hr2x_timeUnits & 0xF0) != 0x80) {
				state = 89;
				return true;
			}
			hr2x_lifespanLong = 0L;
			state = 88;
			// fallthrough
		case 88: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0x0F) != 0x07 &&(hr2x_timeUnits & 0x0F) != 0x08) {
				state = 90;
				return true;
			}
			hr2x_maxIdleLong = 0L;
			hr2x_expiration = server.buildMetadata(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 83;
			return true;
		case 89: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.lifespanLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanLong = hr2x_vLong;
			state = 88;
			return true;
		case 90: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.maxIdleLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleLong = hr2x_vLong;
			hr2x_expiration = server.buildMetadata(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 83;
			return true;
		case 91: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0xF0) != 0x70 &&(hr2x_timeUnits & 0xF0) != 0x80) {
				state = 93;
				return true;
			}
			hr2x_lifespanLong = 0L;
			state = 92;
			// fallthrough
		case 92: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0x0F) != 0x07 &&(hr2x_timeUnits & 0x0F) != 0x08) {
				state = 94;
				return true;
			}
			hr2x_maxIdleLong = 0L;
			hr2x_expiration = server.buildMetadata2x(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 83;
			return true;
		case 93: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.lifespanLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanLong = hr2x_vLong;
			state = 92;
			return true;
		case 94: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.maxIdleLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleLong = hr2x_vLong;
			hr2x_expiration = server.buildMetadata2x(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 83;
			return true;
		case 95: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.putIfAbsent(getHeader(), auth.getSubject(hr2x_operation), hr2x_key, hr2x_value, hr2x_expiration);
			
			state = 0;
			return true;
		case 96: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_key = hr2x_array;
			state = 97;
			// fallthrough
		case 97: 
			// hr2x.request/hr2x.parameters
			if (hr2x_version < org.infinispan.server.hotrod.HotRodConstants.VERSION_22) {
				state = 99;
				return true;
			}
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_30) {
				state = 101;
				return true;
			}
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeUnits = hr2x_byte;
			state = 106;
			return true;
		case 98: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_value = hr2x_array;
			state = 110;
			return true;
		case 99: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanInt = hr2x_vInt;
			state = 100;
			// fallthrough
		case 100: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleInt = hr2x_vInt;
			hr2x_expiration = server.buildMetadata2x(defaultExpiration(hr2x_lifespanInt, hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, defaultExpiration(hr2x_maxIdleInt, hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
			state = 98;
			return true;
		case 101: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeUnits = hr2x_byte;
			state = 102;
			// fallthrough
		case 102: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0xF0) != 0x70 &&(hr2x_timeUnits & 0xF0) != 0x80) {
				state = 104;
				return true;
			}
			hr2x_lifespanLong = 0L;
			state = 103;
			// fallthrough
		case 103: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0x0F) != 0x07 &&(hr2x_timeUnits & 0x0F) != 0x08) {
				state = 105;
				return true;
			}
			hr2x_maxIdleLong = 0L;
			hr2x_expiration = server.buildMetadata(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 98;
			return true;
		case 104: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.lifespanLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanLong = hr2x_vLong;
			state = 103;
			return true;
		case 105: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.maxIdleLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleLong = hr2x_vLong;
			hr2x_expiration = server.buildMetadata(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 98;
			return true;
		case 106: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0xF0) != 0x70 &&(hr2x_timeUnits & 0xF0) != 0x80) {
				state = 108;
				return true;
			}
			hr2x_lifespanLong = 0L;
			state = 107;
			// fallthrough
		case 107: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0x0F) != 0x07 &&(hr2x_timeUnits & 0x0F) != 0x08) {
				state = 109;
				return true;
			}
			hr2x_maxIdleLong = 0L;
			hr2x_expiration = server.buildMetadata2x(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 98;
			return true;
		case 108: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.lifespanLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanLong = hr2x_vLong;
			state = 107;
			return true;
		case 109: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.maxIdleLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleLong = hr2x_vLong;
			hr2x_expiration = server.buildMetadata2x(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 98;
			return true;
		case 110: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.replace(getHeader(), auth.getSubject(hr2x_operation), hr2x_key, hr2x_value, hr2x_expiration);
			
			state = 0;
			return true;
		case 111: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_key = hr2x_array;
			state = 112;
			// fallthrough
		case 112: 
			// hr2x.request/hr2x.parameters
			if (hr2x_version < org.infinispan.server.hotrod.HotRodConstants.VERSION_22) {
				state = 114;
				return true;
			}
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_30) {
				state = 116;
				return true;
			}
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeUnits = hr2x_byte;
			state = 121;
			return true;
		case 113: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_long = org.infinispan.server.hotrod.Intrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_entryVersion = hr2x_long;
			state = 125;
			return true;
		case 114: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanInt = hr2x_vInt;
			state = 115;
			// fallthrough
		case 115: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleInt = hr2x_vInt;
			hr2x_expiration = server.buildMetadata2x(defaultExpiration(hr2x_lifespanInt, hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, defaultExpiration(hr2x_maxIdleInt, hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
			state = 113;
			return true;
		case 116: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeUnits = hr2x_byte;
			state = 117;
			// fallthrough
		case 117: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0xF0) != 0x70 &&(hr2x_timeUnits & 0xF0) != 0x80) {
				state = 119;
				return true;
			}
			hr2x_lifespanLong = 0L;
			state = 118;
			// fallthrough
		case 118: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0x0F) != 0x07 &&(hr2x_timeUnits & 0x0F) != 0x08) {
				state = 120;
				return true;
			}
			hr2x_maxIdleLong = 0L;
			hr2x_expiration = server.buildMetadata(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 113;
			return true;
		case 119: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.lifespanLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanLong = hr2x_vLong;
			state = 118;
			return true;
		case 120: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.maxIdleLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleLong = hr2x_vLong;
			hr2x_expiration = server.buildMetadata(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 113;
			return true;
		case 121: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0xF0) != 0x70 &&(hr2x_timeUnits & 0xF0) != 0x80) {
				state = 123;
				return true;
			}
			hr2x_lifespanLong = 0L;
			state = 122;
			// fallthrough
		case 122: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0x0F) != 0x07 &&(hr2x_timeUnits & 0x0F) != 0x08) {
				state = 124;
				return true;
			}
			hr2x_maxIdleLong = 0L;
			hr2x_expiration = server.buildMetadata2x(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 113;
			return true;
		case 123: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.lifespanLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanLong = hr2x_vLong;
			state = 122;
			return true;
		case 124: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.maxIdleLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleLong = hr2x_vLong;
			hr2x_expiration = server.buildMetadata2x(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 113;
			return true;
		case 125: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_value = hr2x_array;
			state = 126;
			// fallthrough
		case 126: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.replaceIfUnmodified(getHeader(), auth.getSubject(hr2x_operation), hr2x_key, hr2x_entryVersion, hr2x_value, hr2x_expiration);
			
			state = 0;
			return true;
		case 127: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_key = hr2x_array;
			state = 128;
			// fallthrough
		}
		return true;
	}

	private boolean switch2(ByteBuf buf) throws Exception {
		byte b;
		int pos;
		switch (state) {
		case 128: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.remove(getHeader(), auth.getSubject(hr2x_operation), hr2x_key);
			
			state = 0;
			return true;
		case 129: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_key = hr2x_array;
			state = 130;
			// fallthrough
		case 130: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_long = org.infinispan.server.hotrod.Intrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_entryVersion = hr2x_long;
			state = 131;
			// fallthrough
		case 131: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.removeIfUnmodified(getHeader(), auth.getSubject(hr2x_operation), hr2x_key, hr2x_entryVersion);
			
			state = 0;
			return true;
		case 132: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_key = hr2x_array;
			state = 133;
			// fallthrough
		case 133: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.containsKey(getHeader(), auth.getSubject(hr2x_operation), hr2x_key);
			
			state = 0;
			return true;
		case 134: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_key = hr2x_array;
			state = 135;
			// fallthrough
		case 135: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.get(getHeader(), auth.getSubject(hr2x_operation), hr2x_key);
			
			state = 0;
			return true;
		case 136: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.clear(getHeader(), auth.getSubject(hr2x_operation));
			
			state = 0;
			return true;
		case 137: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.stats(getHeader(), auth.getSubject(hr2x_operation));
			
			state = 0;
			return true;
		case 138: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.ping(getHeader(), auth.getSubject(hr2x_operation));
			
			state = 0;
			return true;
		case 139: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_numKeys = hr2x_vInt;
			state = 140;
			// fallthrough
		case 140: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.bulkGet(getHeader(), auth.getSubject(hr2x_operation), hr2x_numKeys);
			
			state = 0;
			return true;
		case 141: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_key = hr2x_array;
			state = 142;
			// fallthrough
		case 142: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.getWithMetadata(getHeader(), auth.getSubject(hr2x_operation), hr2x_key, 0);
			
			state = 0;
			return true;
		case 143: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_scope = hr2x_vInt;
			state = 144;
			// fallthrough
		case 144: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.bulkGetKeys(getHeader(), auth.getSubject(hr2x_operation), hr2x_scope);
			
			state = 0;
			return true;
		case 145: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_queryBytes = hr2x_array;
			state = 146;
			// fallthrough
		case 146: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.query(getHeader(), auth.getSubject(hr2x_operation), hr2x_queryBytes);
			
			state = 0;
			return true;
		case 147: 
			// hr2x.request/hr2x.parameters
			auth.authMechList(hr2x_header);
			
			state = 0;
			return true;
		case 148: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_authMech = hr2x_string;
			state = 149;
			// fallthrough
		case 149: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_authResponse = hr2x_array;
			state = 150;
			// fallthrough
		case 150: 
			// hr2x.request/hr2x.parameters
			auth.auth(hr2x_header, hr2x_authMech, hr2x_authResponse);
			
			state = 0;
			return true;
		case 151: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_listenerId = hr2x_array;
			state = 152;
			// fallthrough
		case 152: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_bool = org.infinispan.server.hotrod.Intrinsics.bool(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_includeCurrentState = hr2x_bool;
			state = 153;
			// fallthrough
		case 153: 
			// hr2x.request/hr2x.parameters
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_26) {
				state = 155;
				return true;
			}
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_21) {
				state = 171;
				return true;
			}
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_filterFactory = hr2x_string;
			state = 186;
			return true;
		case 154: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.addClientListener(getHeader(), auth.getSubject(hr2x_operation), hr2x_listenerId, hr2x_includeCurrentState, hr2x_filterFactory, hr2x_filterParams, hr2x_converterFactory, hr2x_converterParams, hr2x_useRawEvents, hr2x_listenerInterests, 0);
			
			state = 0;
			return true;
		case 155: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_filterFactory = hr2x_string;
			state = 156;
			// fallthrough
		case 156: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams
			if (! hr2x_filterFactory.isEmpty()) {
				state = 158;
				return true;
			}
			hr2x_filterParams = null;
			state = 157;
			// fallthrough
		case 157: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_converterFactory = hr2x_string;
			state = 163;
			return true;
		case 158: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.filterParams
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_numParams = hr2x_byte;
			state = 159;
			// fallthrough
		case 159: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.filterParams
			hr2x_filterParams = allocList(hr2x_numParams);
			
			state = 160;
			// fallthrough
		case 160: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.filterParams
			if (hr2x_numParams == 0) {
				state = 157;
				return true;
			}
			hr2x_numParams--;
			state = 161;
			// fallthrough
		case 161: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.filterParams
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_param = hr2x_array;
			state = 162;
			// fallthrough
		case 162: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.filterParams
			hr2x_filterParams.add(hr2x_param);
			
			state = 160;
			return true;
		case 163: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams
			if (! hr2x_converterFactory.isEmpty()) {
				state = 165;
				return true;
			}
			hr2x_converterParams = null;
			;
			state = 164;
			// fallthrough
		case 164: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams
			pos = buf.readerIndex();
			hr2x_bool = org.infinispan.server.hotrod.Intrinsics.bool(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_useRawEvents = hr2x_bool;
			state = 170;
			return true;
		case 165: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.converterParams
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_numParams = hr2x_byte;
			state = 166;
			// fallthrough
		case 166: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.converterParams
			hr2x_converterParams = allocList(hr2x_numParams);
			
			state = 167;
			// fallthrough
		case 167: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.converterParams
			if (hr2x_numParams == 0) {
				state = 164;
				return true;
			}
			hr2x_numParams--;
			state = 168;
			// fallthrough
		case 168: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.converterParams
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_param = hr2x_array;
			state = 169;
			// fallthrough
		case 169: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.converterParams
			hr2x_converterParams.add(hr2x_param);
			
			state = 167;
			return true;
		case 170: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_listenerInterests = hr2x_vInt;
			state = 154;
			return true;
		case 171: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_filterFactory = hr2x_string;
			state = 172;
			// fallthrough
		case 172: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams
			if (! hr2x_filterFactory.isEmpty()) {
				state = 174;
				return true;
			}
			hr2x_filterParams = null;
			state = 173;
			// fallthrough
		case 173: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_converterFactory = hr2x_string;
			state = 179;
			return true;
		case 174: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.filterParams
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_numParams = hr2x_byte;
			state = 175;
			// fallthrough
		case 175: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.filterParams
			hr2x_filterParams = allocList(hr2x_numParams);
			
			state = 176;
			// fallthrough
		case 176: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.filterParams
			if (hr2x_numParams == 0) {
				state = 173;
				return true;
			}
			hr2x_numParams--;
			state = 177;
			// fallthrough
		case 177: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.filterParams
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_param = hr2x_array;
			state = 178;
			// fallthrough
		case 178: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.filterParams
			hr2x_filterParams.add(hr2x_param);
			
			state = 176;
			return true;
		case 179: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams
			if (! hr2x_converterFactory.isEmpty()) {
				state = 181;
				return true;
			}
			hr2x_converterParams = null;
			;
			state = 180;
			// fallthrough
		case 180: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams
			pos = buf.readerIndex();
			hr2x_bool = org.infinispan.server.hotrod.Intrinsics.bool(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_useRawEvents = hr2x_bool;
			state = 154;
			return true;
		case 181: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.converterParams
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_numParams = hr2x_byte;
			state = 182;
			// fallthrough
		case 182: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.converterParams
			hr2x_converterParams = allocList(hr2x_numParams);
			
			state = 183;
			// fallthrough
		case 183: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.converterParams
			if (hr2x_numParams == 0) {
				state = 180;
				return true;
			}
			hr2x_numParams--;
			state = 184;
			// fallthrough
		case 184: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.converterParams
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_param = hr2x_array;
			state = 185;
			// fallthrough
		case 185: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.converterParams
			hr2x_converterParams.add(hr2x_param);
			
			state = 183;
			return true;
		case 186: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams
			if (! hr2x_filterFactory.isEmpty()) {
				state = 188;
				return true;
			}
			hr2x_filterParams = null;
			state = 187;
			// fallthrough
		case 187: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_converterFactory = hr2x_string;
			state = 193;
			return true;
		case 188: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.filterParams
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_numParams = hr2x_byte;
			state = 189;
			// fallthrough
		case 189: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.filterParams
			hr2x_filterParams = allocList(hr2x_numParams);
			
			state = 190;
			// fallthrough
		case 190: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.filterParams
			if (hr2x_numParams == 0) {
				state = 187;
				return true;
			}
			hr2x_numParams--;
			state = 191;
			// fallthrough
		case 191: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.filterParams
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_param = hr2x_array;
			state = 192;
			// fallthrough
		}
		return true;
	}

	private boolean switch3(ByteBuf buf) throws Exception {
		byte b;
		int pos;
		switch (state) {
		case 192: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.filterParams
			hr2x_filterParams.add(hr2x_param);
			
			state = 190;
			return true;
		case 193: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams
			if (! hr2x_converterFactory.isEmpty()) {
				state = 194;
				return true;
			}
			hr2x_converterParams = null;
			;
			state = 154;
			return true;
		case 194: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.converterParams
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_numParams = hr2x_byte;
			state = 195;
			// fallthrough
		case 195: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.converterParams
			hr2x_converterParams = allocList(hr2x_numParams);
			
			state = 196;
			// fallthrough
		case 196: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.converterParams
			if (hr2x_numParams == 0) {
				state = 154;
				return true;
			}
			hr2x_numParams--;
			state = 197;
			// fallthrough
		case 197: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.converterParams
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_param = hr2x_array;
			state = 198;
			// fallthrough
		case 198: 
			// hr2x.request/hr2x.parameters/hr2x.listenerParams/hr2x.converterParams
			hr2x_converterParams.add(hr2x_param);
			
			state = 196;
			return true;
		case 199: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_listenerId = hr2x_array;
			state = 200;
			// fallthrough
		case 200: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_bloomBits = hr2x_vInt;
			state = 201;
			// fallthrough
		case 201: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.addClientListener(getHeader(), auth.getSubject(hr2x_operation), hr2x_listenerId, false, null, null, null, null, false, 14, hr2x_bloomBits);
			
			state = 0;
			return true;
		case 202: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_listenerId = hr2x_array;
			state = 203;
			// fallthrough
		case 203: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.removeClientListener(getHeader(), auth.getSubject(hr2x_operation), hr2x_listenerId);
			
			state = 0;
			return true;
		case 204: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.size(getHeader(), auth.getSubject(hr2x_operation));
			
			state = 0;
			return true;
		case 205: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_taskName = hr2x_string;
			state = 206;
			// fallthrough
		case 206: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_numParams = hr2x_byte;
			state = 208;
			return true;
		case 207: 
			// hr2x.request/hr2x.parameters
			taskProcessor.exec(getHeader(), auth.getSubject(hr2x_operation), hr2x_taskName, hr2x_taskParams);
			
			state = 0;
			return true;
		case 208: 
			// hr2x.request/hr2x.parameters/hr2x.taskParams
			hr2x_taskParams = allocMap(hr2x_numParams);
			
			state = 209;
			// fallthrough
		case 209: 
			// hr2x.request/hr2x.parameters/hr2x.taskParams
			if (hr2x_numParams == 0) {
				state = 207;
				return true;
			}
			hr2x_numParams--;
			state = 210;
			// fallthrough
		case 210: 
			// hr2x.request/hr2x.parameters/hr2x.taskParams
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_taskParam = hr2x_string;
			state = 211;
			// fallthrough
		case 211: 
			// hr2x.request/hr2x.parameters/hr2x.taskParams
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_taskParamValue = hr2x_array;
			state = 212;
			// fallthrough
		case 212: 
			// hr2x.request/hr2x.parameters/hr2x.taskParams
			hr2x_taskParams.put(hr2x_taskParam, hr2x_taskParamValue);
			
			state = 209;
			return true;
		case 213: 
			// hr2x.request/hr2x.parameters
			if (hr2x_version < org.infinispan.server.hotrod.HotRodConstants.VERSION_22) {
				state = 215;
				return true;
			}
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_30) {
				state = 217;
				return true;
			}
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeUnits = hr2x_byte;
			state = 222;
			return true;
		case 214: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_numEntries = hr2x_vInt;
			state = 227;
			return true;
		case 215: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanInt = hr2x_vInt;
			state = 216;
			// fallthrough
		case 216: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleInt = hr2x_vInt;
			hr2x_expiration = server.buildMetadata2x(defaultExpiration(hr2x_lifespanInt, hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, defaultExpiration(hr2x_maxIdleInt, hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
			state = 214;
			return true;
		case 217: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeUnits = hr2x_byte;
			state = 218;
			// fallthrough
		case 218: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0xF0) != 0x70 &&(hr2x_timeUnits & 0xF0) != 0x80) {
				state = 220;
				return true;
			}
			hr2x_lifespanLong = 0L;
			state = 219;
			// fallthrough
		case 219: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0x0F) != 0x07 &&(hr2x_timeUnits & 0x0F) != 0x08) {
				state = 221;
				return true;
			}
			hr2x_maxIdleLong = 0L;
			hr2x_expiration = server.buildMetadata(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 214;
			return true;
		case 220: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.lifespanLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanLong = hr2x_vLong;
			state = 219;
			return true;
		case 221: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.maxIdleLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleLong = hr2x_vLong;
			hr2x_expiration = server.buildMetadata(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 214;
			return true;
		case 222: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0xF0) != 0x70 &&(hr2x_timeUnits & 0xF0) != 0x80) {
				state = 224;
				return true;
			}
			hr2x_lifespanLong = 0L;
			state = 223;
			// fallthrough
		case 223: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0x0F) != 0x07 &&(hr2x_timeUnits & 0x0F) != 0x08) {
				state = 225;
				return true;
			}
			hr2x_maxIdleLong = 0L;
			hr2x_expiration = server.buildMetadata2x(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 214;
			return true;
		case 224: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.lifespanLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanLong = hr2x_vLong;
			state = 223;
			return true;
		case 225: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.maxIdleLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleLong = hr2x_vLong;
			hr2x_expiration = server.buildMetadata2x(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 214;
			return true;
		case 226: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.putAll(getHeader(), auth.getSubject(hr2x_operation), hr2x_entryMap, hr2x_expiration);
			
			state = 0;
			return true;
		case 227: 
			// hr2x.request/hr2x.parameters/hr2x.entryMap
			hr2x_entryMap = allocMap(hr2x_numEntries);
			
			state = 228;
			// fallthrough
		case 228: 
			// hr2x.request/hr2x.parameters/hr2x.entryMap
			if (hr2x_numEntries == 0) {
				state = 226;
				return true;
			}
			hr2x_numEntries--;
			state = 229;
			// fallthrough
		case 229: 
			// hr2x.request/hr2x.parameters/hr2x.entryMap
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_key = hr2x_array;
			state = 230;
			// fallthrough
		case 230: 
			// hr2x.request/hr2x.parameters/hr2x.entryMap
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_value = hr2x_array;
			state = 231;
			// fallthrough
		case 231: 
			// hr2x.request/hr2x.parameters/hr2x.entryMap
			hr2x_entryMap.put(hr2x_key, hr2x_value);
			
			state = 228;
			return true;
		case 232: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_numKeys = hr2x_vInt;
			state = 234;
			return true;
		case 233: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.getAll(getHeader(), auth.getSubject(hr2x_operation), hr2x_keys);
			
			state = 0;
			return true;
		case 234: 
			// hr2x.request/hr2x.parameters/hr2x.keys
			hr2x_keys = allocSet(hr2x_numKeys);
			
			state = 235;
			// fallthrough
		case 235: 
			// hr2x.request/hr2x.parameters/hr2x.keys
			if (hr2x_numKeys == 0) {
				state = 233;
				return true;
			}
			hr2x_numKeys--;
			state = 236;
			// fallthrough
		case 236: 
			// hr2x.request/hr2x.parameters/hr2x.keys
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_key = hr2x_array;
			state = 237;
			// fallthrough
		case 237: 
			// hr2x.request/hr2x.parameters/hr2x.keys
			hr2x_keys.add(hr2x_key);
			
			state = 235;
			return true;
		case 238: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_optionalArray = org.infinispan.server.hotrod.Intrinsics.optionalArray(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_segmentMask = hr2x_optionalArray;
			state = 239;
			// fallthrough
		case 239: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_optionalString = org.infinispan.server.hotrod.Intrinsics.optionalString(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_filterConverterFactory = hr2x_optionalString;
			state = 240;
			// fallthrough
		case 240: 
			// hr2x.request/hr2x.parameters
			if (hr2x_filterConverterFactory != null) {
				state = 242;
				return true;
			}
			hr2x_filterConverterParams = null;
			state = 241;
			// fallthrough
		case 241: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_batchSize = hr2x_vInt;
			state = 247;
			return true;
		case 242: 
			// hr2x.request/hr2x.parameters/hr2x.filterConverterParams
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_numParams = hr2x_byte;
			state = 243;
			// fallthrough
		case 243: 
			// hr2x.request/hr2x.parameters/hr2x.filterConverterParams
			hr2x_filterConverterParams = allocList(hr2x_numParams);
			
			state = 244;
			// fallthrough
		case 244: 
			// hr2x.request/hr2x.parameters/hr2x.filterConverterParams
			if (hr2x_numParams == 0) {
				state = 241;
				return true;
			}
			hr2x_numParams--;
			state = 245;
			// fallthrough
		case 245: 
			// hr2x.request/hr2x.parameters/hr2x.filterConverterParams
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_param = hr2x_array;
			state = 246;
			// fallthrough
		case 246: 
			// hr2x.request/hr2x.parameters/hr2x.filterConverterParams
			hr2x_filterConverterParams.add(hr2x_param);
			
			state = 244;
			return true;
		case 247: 
			// hr2x.request/hr2x.parameters
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_24) {
				state = 249;
				return true;
			}
			hr2x_includeMetadata = false;
			state = 248;
			// fallthrough
		case 248: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.iterationStart(getHeader(), auth.getSubject(hr2x_operation), hr2x_segmentMask, hr2x_filterConverterFactory, hr2x_filterConverterParams, hr2x_batchSize, hr2x_includeMetadata);
			
			state = 0;
			return true;
		case 249: 
			// hr2x.request/hr2x.parameters/hr2x.includeMetadata
			pos = buf.readerIndex();
			hr2x_bool = org.infinispan.server.hotrod.Intrinsics.bool(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_includeMetadata = hr2x_bool;
			state = 248;
			return true;
		case 250: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_iterationId = hr2x_string;
			state = 251;
			// fallthrough
		case 251: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.iterationNext(getHeader(), auth.getSubject(hr2x_operation), hr2x_iterationId);
			
			state = 0;
			return true;
		case 252: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_iterationId = hr2x_string;
			state = 253;
			// fallthrough
		case 253: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.iterationEnd(getHeader(), auth.getSubject(hr2x_operation), hr2x_iterationId);
			
			state = 0;
			return true;
		case 254: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_key = hr2x_array;
			state = 255;
			// fallthrough
		case 255: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_offset = hr2x_vInt;
			state = 256;
			// fallthrough
		}
		return true;
	}

	private boolean switch4(ByteBuf buf) throws Exception {
		byte b;
		int pos;
		switch (state) {
		case 256: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.getWithMetadata(getHeader(), auth.getSubject(hr2x_operation), hr2x_key, hr2x_offset);
			
			state = 0;
			return true;
		case 257: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_key = hr2x_array;
			state = 258;
			// fallthrough
		case 258: 
			// hr2x.request/hr2x.parameters
			if (hr2x_version < org.infinispan.server.hotrod.HotRodConstants.VERSION_22) {
				state = 260;
				return true;
			}
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_30) {
				state = 262;
				return true;
			}
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeUnits = hr2x_byte;
			state = 267;
			return true;
		case 259: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_long = org.infinispan.server.hotrod.Intrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_entryVersion = hr2x_long;
			state = 271;
			return true;
		case 260: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanInt = hr2x_vInt;
			state = 261;
			// fallthrough
		case 261: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleInt = hr2x_vInt;
			hr2x_expiration = server.buildMetadata2x(defaultExpiration(hr2x_lifespanInt, hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, defaultExpiration(hr2x_maxIdleInt, hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
			state = 259;
			return true;
		case 262: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeUnits = hr2x_byte;
			state = 263;
			// fallthrough
		case 263: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0xF0) != 0x70 &&(hr2x_timeUnits & 0xF0) != 0x80) {
				state = 265;
				return true;
			}
			hr2x_lifespanLong = 0L;
			state = 264;
			// fallthrough
		case 264: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0x0F) != 0x07 &&(hr2x_timeUnits & 0x0F) != 0x08) {
				state = 266;
				return true;
			}
			hr2x_maxIdleLong = 0L;
			hr2x_expiration = server.buildMetadata(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 259;
			return true;
		case 265: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.lifespanLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanLong = hr2x_vLong;
			state = 264;
			return true;
		case 266: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.maxIdleLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleLong = hr2x_vLong;
			hr2x_expiration = server.buildMetadata(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 259;
			return true;
		case 267: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0xF0) != 0x70 &&(hr2x_timeUnits & 0xF0) != 0x80) {
				state = 269;
				return true;
			}
			hr2x_lifespanLong = 0L;
			state = 268;
			// fallthrough
		case 268: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0x0F) != 0x07 &&(hr2x_timeUnits & 0x0F) != 0x08) {
				state = 270;
				return true;
			}
			hr2x_maxIdleLong = 0L;
			hr2x_expiration = server.buildMetadata2x(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 259;
			return true;
		case 269: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.lifespanLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanLong = hr2x_vLong;
			state = 268;
			return true;
		case 270: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.maxIdleLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleLong = hr2x_vLong;
			hr2x_expiration = server.buildMetadata2x(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 259;
			return true;
		case 271: 
			// hr2x.request/hr2x.parameters
			hr2x_chunkedValue = cacheProcessor.channel().alloc().buffer();
			hr2x_chunkLength = 1;
			
			state = 273;
			return true;
		case 272: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.putStream(getHeader(), auth.getSubject(hr2x_operation), hr2x_key, hr2x_chunkedValue, hr2x_entryVersion, hr2x_expiration);
			
			state = 0;
			return true;
		case 273: 
			// hr2x.request/hr2x.parameters/hr2x.chunkedValue
			if (hr2x_chunkLength == 0) {
				state = 272;
				return true;
			}
			hr2x_chunkLength--;
			state = 274;
			// fallthrough
		case 274: 
			// hr2x.request/hr2x.parameters/hr2x.chunkedValue
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_chunkLength = hr2x_vInt;
			state = 275;
			// fallthrough
		case 275: 
			// hr2x.request/hr2x.parameters/hr2x.chunkedValue/hr2x.chunk
			if (hr2x_chunkLength > 0) {
				state = 277;
				return true;
			}
			hr2x_chunkBytes = cacheProcessor.channel().alloc().buffer(0, 0);
			;
			state = 276;
			// fallthrough
		case 276: 
			// hr2x.request/hr2x.parameters/hr2x.chunkedValue/hr2x.chunk
			hr2x_chunkedValue.writeBytes(hr2x_chunkBytes, hr2x_chunkBytes.readerIndex() - hr2x_chunkLength, hr2x_chunkLength);
			
			state = 273;
			return true;
		case 277: 
			// hr2x.request/hr2x.parameters/hr2x.chunkedValue/hr2x.chunk/hr2x.chunkBytes
			pos = buf.readerIndex();
			hr2x_readable = org.infinispan.server.hotrod.Intrinsics.readable(buf, hr2x_chunkLength);
			if (buf.readerIndex() == pos) return false;
			hr2x_chunkBytes = hr2x_readable;
			state = 276;
			return true;
		case 278: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_bloomArray = hr2x_array;
			state = 279;
			// fallthrough
		case 279: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.updateBloomFilter(getHeader(), auth.getSubject(hr2x_operation), hr2x_bloomArray);
			
			state = 0;
			return true;
		case 280: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_signedVInt = org.infinispan.server.hotrod.Intrinsics.signedVInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_xidFormat = hr2x_signedVInt;
			state = 282;
			return true;
		case 281: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_bool = org.infinispan.server.hotrod.Intrinsics.bool(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_onePhaseCommit = hr2x_bool;
			state = 288;
			return true;
		case 282: 
			// hr2x.request/hr2x.parameters/hr2x.xid
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_xidLength = hr2x_byte;
			state = 283;
			// fallthrough
		case 283: 
			// hr2x.request/hr2x.parameters/hr2x.xid
			if (hr2x_xidLength > 0) {
				state = 285;
				return true;
			}
			hr2x_transactionId = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 284;
			// fallthrough
		case 284: 
			// hr2x.request/hr2x.parameters/hr2x.xid
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_branchLength = hr2x_byte;
			state = 286;
			return true;
		case 285: 
			// hr2x.request/hr2x.parameters/hr2x.xid/hr2x.transactionId
			pos = buf.readerIndex();
			hr2x_fixedArray = org.infinispan.server.hotrod.Intrinsics.fixedArray(buf, hr2x_xidLength);
			if (buf.readerIndex() == pos) return false;
			hr2x_transactionId = hr2x_fixedArray;
			state = 284;
			return true;
		case 286: 
			// hr2x.request/hr2x.parameters/hr2x.xid
			if (hr2x_branchLength > 0) {
				state = 287;
				return true;
			}
			hr2x_branchId = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			hr2x_xid = XidImpl.create(hr2x_xidFormat, hr2x_transactionId, hr2x_branchId);
			state = 281;
			return true;
		case 287: 
			// hr2x.request/hr2x.parameters/hr2x.xid/hr2x.branchId
			pos = buf.readerIndex();
			hr2x_fixedArray = org.infinispan.server.hotrod.Intrinsics.fixedArray(buf, hr2x_branchLength);
			if (buf.readerIndex() == pos) return false;
			hr2x_branchId = hr2x_fixedArray;
			hr2x_xid = XidImpl.create(hr2x_xidFormat, hr2x_transactionId, hr2x_branchId);
			state = 281;
			return true;
		case 288: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_numModifications = hr2x_vInt;
			state = 290;
			return true;
		case 289: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.prepareTransaction(getHeader(), auth.getSubject(hr2x_operation), hr2x_xid, hr2x_onePhaseCommit, hr2x_modifications, false, 60000);
			
			state = 0;
			return true;
		case 290: 
			// hr2x.request/hr2x.parameters/hr2x.modifications
			hr2x_modifications = allocList(hr2x_numModifications);
			
			state = 291;
			// fallthrough
		case 291: 
			// hr2x.request/hr2x.parameters/hr2x.modifications
			if (hr2x_numModifications == 0) {
				state = 289;
				return true;
			}
			hr2x_numModifications--;
			state = 292;
			// fallthrough
		case 292: 
			// hr2x.request/hr2x.parameters/hr2x.modifications
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_key = hr2x_array;
			state = 294;
			return true;
		case 293: 
			// hr2x.request/hr2x.parameters/hr2x.modifications
			hr2x_modifications.add(hr2x_modification);
			
			state = 291;
			return true;
		case 294: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_controlByte = hr2x_byte;
			state = 295;
			// fallthrough
		case 295: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification
			if (! ControlByte.NOT_READ.hasFlag(hr2x_controlByte) && ! ControlByte.NON_EXISTING.hasFlag(hr2x_controlByte)) {
				state = 297;
				return true;
			}
			hr2x_versionRead = 0L;
			state = 296;
			// fallthrough
		case 296: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification
			if (! ControlByte.REMOVE_OP.hasFlag(hr2x_controlByte)) {
				state = 298;
				return true;
			}
			;
			
			hr2x_modification = new TransactionWrite(hr2x_key, hr2x_versionRead, hr2x_controlByte, hr2x_value, hr2x_expiration);
			state = 293;
			return true;
		case 297: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.versionRead
			pos = buf.readerIndex();
			hr2x_long = org.infinispan.server.hotrod.Intrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_entryVersion = hr2x_long;
			hr2x_versionRead = hr2x_entryVersion;
			state = 296;
			return true;
		case 298: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData
			if (hr2x_version < org.infinispan.server.hotrod.HotRodConstants.VERSION_22) {
				state = 300;
				return true;
			}
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_30) {
				state = 302;
				return true;
			}
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeUnits = hr2x_byte;
			state = 307;
			return true;
		case 299: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_value = hr2x_array;
			hr2x_modification = new TransactionWrite(hr2x_key, hr2x_versionRead, hr2x_controlByte, hr2x_value, hr2x_expiration);
			state = 293;
			return true;
		case 300: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanInt = hr2x_vInt;
			state = 301;
			// fallthrough
		case 301: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleInt = hr2x_vInt;
			hr2x_expiration = server.buildMetadata2x(defaultExpiration(hr2x_lifespanInt, hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, defaultExpiration(hr2x_maxIdleInt, hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
			state = 299;
			return true;
		case 302: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeUnits = hr2x_byte;
			state = 303;
			// fallthrough
		case 303: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData/hr2x.expiration
			if ((hr2x_timeUnits & 0xF0) != 0x70 &&(hr2x_timeUnits & 0xF0) != 0x80) {
				state = 305;
				return true;
			}
			hr2x_lifespanLong = 0L;
			state = 304;
			// fallthrough
		case 304: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData/hr2x.expiration
			if ((hr2x_timeUnits & 0x0F) != 0x07 &&(hr2x_timeUnits & 0x0F) != 0x08) {
				state = 306;
				return true;
			}
			hr2x_maxIdleLong = 0L;
			hr2x_expiration = server.buildMetadata(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 299;
			return true;
		case 305: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData/hr2x.expiration/hr2x.lifespanLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanLong = hr2x_vLong;
			state = 304;
			return true;
		case 306: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData/hr2x.expiration/hr2x.maxIdleLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleLong = hr2x_vLong;
			hr2x_expiration = server.buildMetadata(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 299;
			return true;
		case 307: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData/hr2x.expiration
			if ((hr2x_timeUnits & 0xF0) != 0x70 &&(hr2x_timeUnits & 0xF0) != 0x80) {
				state = 309;
				return true;
			}
			hr2x_lifespanLong = 0L;
			state = 308;
			// fallthrough
		case 308: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData/hr2x.expiration
			if ((hr2x_timeUnits & 0x0F) != 0x07 &&(hr2x_timeUnits & 0x0F) != 0x08) {
				state = 310;
				return true;
			}
			hr2x_maxIdleLong = 0L;
			hr2x_expiration = server.buildMetadata2x(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 299;
			return true;
		case 309: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData/hr2x.expiration/hr2x.lifespanLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanLong = hr2x_vLong;
			state = 308;
			return true;
		case 310: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData/hr2x.expiration/hr2x.maxIdleLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleLong = hr2x_vLong;
			hr2x_expiration = server.buildMetadata2x(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 299;
			return true;
		case 311: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_signedVInt = org.infinispan.server.hotrod.Intrinsics.signedVInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_xidFormat = hr2x_signedVInt;
			state = 313;
			return true;
		case 312: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.commitTransaction(getHeader(), auth.getSubject(hr2x_operation), hr2x_xid);
			
			state = 0;
			return true;
		case 313: 
			// hr2x.request/hr2x.parameters/hr2x.xid
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_xidLength = hr2x_byte;
			state = 314;
			// fallthrough
		case 314: 
			// hr2x.request/hr2x.parameters/hr2x.xid
			if (hr2x_xidLength > 0) {
				state = 316;
				return true;
			}
			hr2x_transactionId = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 315;
			// fallthrough
		case 315: 
			// hr2x.request/hr2x.parameters/hr2x.xid
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_branchLength = hr2x_byte;
			state = 317;
			return true;
		case 316: 
			// hr2x.request/hr2x.parameters/hr2x.xid/hr2x.transactionId
			pos = buf.readerIndex();
			hr2x_fixedArray = org.infinispan.server.hotrod.Intrinsics.fixedArray(buf, hr2x_xidLength);
			if (buf.readerIndex() == pos) return false;
			hr2x_transactionId = hr2x_fixedArray;
			state = 315;
			return true;
		case 317: 
			// hr2x.request/hr2x.parameters/hr2x.xid
			if (hr2x_branchLength > 0) {
				state = 318;
				return true;
			}
			hr2x_branchId = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			hr2x_xid = XidImpl.create(hr2x_xidFormat, hr2x_transactionId, hr2x_branchId);
			state = 312;
			return true;
		case 318: 
			// hr2x.request/hr2x.parameters/hr2x.xid/hr2x.branchId
			pos = buf.readerIndex();
			hr2x_fixedArray = org.infinispan.server.hotrod.Intrinsics.fixedArray(buf, hr2x_branchLength);
			if (buf.readerIndex() == pos) return false;
			hr2x_branchId = hr2x_fixedArray;
			hr2x_xid = XidImpl.create(hr2x_xidFormat, hr2x_transactionId, hr2x_branchId);
			state = 312;
			return true;
		case 319: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_signedVInt = org.infinispan.server.hotrod.Intrinsics.signedVInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_xidFormat = hr2x_signedVInt;
			state = 321;
			return true;
		}
		return true;
	}

	private boolean switch5(ByteBuf buf) throws Exception {
		byte b;
		int pos;
		switch (state) {
		case 320: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.rollbackTransaction(getHeader(), auth.getSubject(hr2x_operation), hr2x_xid);
			
			state = 0;
			return true;
		case 321: 
			// hr2x.request/hr2x.parameters/hr2x.xid
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_xidLength = hr2x_byte;
			state = 322;
			// fallthrough
		case 322: 
			// hr2x.request/hr2x.parameters/hr2x.xid
			if (hr2x_xidLength > 0) {
				state = 324;
				return true;
			}
			hr2x_transactionId = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 323;
			// fallthrough
		case 323: 
			// hr2x.request/hr2x.parameters/hr2x.xid
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_branchLength = hr2x_byte;
			state = 325;
			return true;
		case 324: 
			// hr2x.request/hr2x.parameters/hr2x.xid/hr2x.transactionId
			pos = buf.readerIndex();
			hr2x_fixedArray = org.infinispan.server.hotrod.Intrinsics.fixedArray(buf, hr2x_xidLength);
			if (buf.readerIndex() == pos) return false;
			hr2x_transactionId = hr2x_fixedArray;
			state = 323;
			return true;
		case 325: 
			// hr2x.request/hr2x.parameters/hr2x.xid
			if (hr2x_branchLength > 0) {
				state = 326;
				return true;
			}
			hr2x_branchId = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			hr2x_xid = XidImpl.create(hr2x_xidFormat, hr2x_transactionId, hr2x_branchId);
			state = 320;
			return true;
		case 326: 
			// hr2x.request/hr2x.parameters/hr2x.xid/hr2x.branchId
			pos = buf.readerIndex();
			hr2x_fixedArray = org.infinispan.server.hotrod.Intrinsics.fixedArray(buf, hr2x_branchLength);
			if (buf.readerIndex() == pos) return false;
			hr2x_branchId = hr2x_fixedArray;
			hr2x_xid = XidImpl.create(hr2x_xidFormat, hr2x_transactionId, hr2x_branchId);
			state = 320;
			return true;
		case 327: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_signedVInt = org.infinispan.server.hotrod.Intrinsics.signedVInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_xidFormat = hr2x_signedVInt;
			state = 329;
			return true;
		case 328: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.forgetTransaction(getHeader(), auth.getSubject(hr2x_operation), hr2x_xid);
			
			state = 0;
			return true;
		case 329: 
			// hr2x.request/hr2x.parameters/hr2x.xid
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_xidLength = hr2x_byte;
			state = 330;
			// fallthrough
		case 330: 
			// hr2x.request/hr2x.parameters/hr2x.xid
			if (hr2x_xidLength > 0) {
				state = 332;
				return true;
			}
			hr2x_transactionId = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 331;
			// fallthrough
		case 331: 
			// hr2x.request/hr2x.parameters/hr2x.xid
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_branchLength = hr2x_byte;
			state = 333;
			return true;
		case 332: 
			// hr2x.request/hr2x.parameters/hr2x.xid/hr2x.transactionId
			pos = buf.readerIndex();
			hr2x_fixedArray = org.infinispan.server.hotrod.Intrinsics.fixedArray(buf, hr2x_xidLength);
			if (buf.readerIndex() == pos) return false;
			hr2x_transactionId = hr2x_fixedArray;
			state = 331;
			return true;
		case 333: 
			// hr2x.request/hr2x.parameters/hr2x.xid
			if (hr2x_branchLength > 0) {
				state = 334;
				return true;
			}
			hr2x_branchId = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			hr2x_xid = XidImpl.create(hr2x_xidFormat, hr2x_transactionId, hr2x_branchId);
			state = 328;
			return true;
		case 334: 
			// hr2x.request/hr2x.parameters/hr2x.xid/hr2x.branchId
			pos = buf.readerIndex();
			hr2x_fixedArray = org.infinispan.server.hotrod.Intrinsics.fixedArray(buf, hr2x_branchLength);
			if (buf.readerIndex() == pos) return false;
			hr2x_branchId = hr2x_fixedArray;
			hr2x_xid = XidImpl.create(hr2x_xidFormat, hr2x_transactionId, hr2x_branchId);
			state = 328;
			return true;
		case 335: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.getPreparedTransactions(getHeader(), auth.getSubject(hr2x_operation));
			
			state = 0;
			return true;
		case 336: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_signedVInt = org.infinispan.server.hotrod.Intrinsics.signedVInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_xidFormat = hr2x_signedVInt;
			state = 338;
			return true;
		case 337: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_bool = org.infinispan.server.hotrod.Intrinsics.bool(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_onePhaseCommit = hr2x_bool;
			state = 344;
			return true;
		case 338: 
			// hr2x.request/hr2x.parameters/hr2x.xid
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_xidLength = hr2x_byte;
			state = 339;
			// fallthrough
		case 339: 
			// hr2x.request/hr2x.parameters/hr2x.xid
			if (hr2x_xidLength > 0) {
				state = 341;
				return true;
			}
			hr2x_transactionId = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 340;
			// fallthrough
		case 340: 
			// hr2x.request/hr2x.parameters/hr2x.xid
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_branchLength = hr2x_byte;
			state = 342;
			return true;
		case 341: 
			// hr2x.request/hr2x.parameters/hr2x.xid/hr2x.transactionId
			pos = buf.readerIndex();
			hr2x_fixedArray = org.infinispan.server.hotrod.Intrinsics.fixedArray(buf, hr2x_xidLength);
			if (buf.readerIndex() == pos) return false;
			hr2x_transactionId = hr2x_fixedArray;
			state = 340;
			return true;
		case 342: 
			// hr2x.request/hr2x.parameters/hr2x.xid
			if (hr2x_branchLength > 0) {
				state = 343;
				return true;
			}
			hr2x_branchId = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			hr2x_xid = XidImpl.create(hr2x_xidFormat, hr2x_transactionId, hr2x_branchId);
			state = 337;
			return true;
		case 343: 
			// hr2x.request/hr2x.parameters/hr2x.xid/hr2x.branchId
			pos = buf.readerIndex();
			hr2x_fixedArray = org.infinispan.server.hotrod.Intrinsics.fixedArray(buf, hr2x_branchLength);
			if (buf.readerIndex() == pos) return false;
			hr2x_branchId = hr2x_fixedArray;
			hr2x_xid = XidImpl.create(hr2x_xidFormat, hr2x_transactionId, hr2x_branchId);
			state = 337;
			return true;
		case 344: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_bool = org.infinispan.server.hotrod.Intrinsics.bool(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_recoverable = hr2x_bool;
			state = 345;
			// fallthrough
		case 345: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_long = org.infinispan.server.hotrod.Intrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeout = hr2x_long;
			state = 346;
			// fallthrough
		case 346: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_numModifications = hr2x_vInt;
			state = 348;
			return true;
		case 347: 
			// hr2x.request/hr2x.parameters
			cacheProcessor.prepareTransaction(getHeader(), auth.getSubject(hr2x_operation), hr2x_xid, hr2x_onePhaseCommit, hr2x_modifications, hr2x_recoverable, hr2x_timeout);
			
			state = 0;
			return true;
		case 348: 
			// hr2x.request/hr2x.parameters/hr2x.modifications
			hr2x_modifications = allocList(hr2x_numModifications);
			
			state = 349;
			// fallthrough
		case 349: 
			// hr2x.request/hr2x.parameters/hr2x.modifications
			if (hr2x_numModifications == 0) {
				state = 347;
				return true;
			}
			hr2x_numModifications--;
			state = 350;
			// fallthrough
		case 350: 
			// hr2x.request/hr2x.parameters/hr2x.modifications
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_key = hr2x_array;
			state = 352;
			return true;
		case 351: 
			// hr2x.request/hr2x.parameters/hr2x.modifications
			hr2x_modifications.add(hr2x_modification);
			
			state = 349;
			return true;
		case 352: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_controlByte = hr2x_byte;
			state = 353;
			// fallthrough
		case 353: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification
			if (! ControlByte.NOT_READ.hasFlag(hr2x_controlByte) && ! ControlByte.NON_EXISTING.hasFlag(hr2x_controlByte)) {
				state = 355;
				return true;
			}
			hr2x_versionRead = 0L;
			state = 354;
			// fallthrough
		case 354: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification
			if (! ControlByte.REMOVE_OP.hasFlag(hr2x_controlByte)) {
				state = 356;
				return true;
			}
			;
			
			hr2x_modification = new TransactionWrite(hr2x_key, hr2x_versionRead, hr2x_controlByte, hr2x_value, hr2x_expiration);
			state = 351;
			return true;
		case 355: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.versionRead
			pos = buf.readerIndex();
			hr2x_long = org.infinispan.server.hotrod.Intrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_entryVersion = hr2x_long;
			hr2x_versionRead = hr2x_entryVersion;
			state = 354;
			return true;
		case 356: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData
			if (hr2x_version < org.infinispan.server.hotrod.HotRodConstants.VERSION_22) {
				state = 358;
				return true;
			}
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_30) {
				state = 360;
				return true;
			}
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeUnits = hr2x_byte;
			state = 365;
			return true;
		case 357: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_value = hr2x_array;
			hr2x_modification = new TransactionWrite(hr2x_key, hr2x_versionRead, hr2x_controlByte, hr2x_value, hr2x_expiration);
			state = 351;
			return true;
		case 358: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanInt = hr2x_vInt;
			state = 359;
			// fallthrough
		case 359: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleInt = hr2x_vInt;
			hr2x_expiration = server.buildMetadata2x(defaultExpiration(hr2x_lifespanInt, hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, defaultExpiration(hr2x_maxIdleInt, hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
			state = 357;
			return true;
		case 360: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeUnits = hr2x_byte;
			state = 361;
			// fallthrough
		case 361: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData/hr2x.expiration
			if ((hr2x_timeUnits & 0xF0) != 0x70 &&(hr2x_timeUnits & 0xF0) != 0x80) {
				state = 363;
				return true;
			}
			hr2x_lifespanLong = 0L;
			state = 362;
			// fallthrough
		case 362: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData/hr2x.expiration
			if ((hr2x_timeUnits & 0x0F) != 0x07 &&(hr2x_timeUnits & 0x0F) != 0x08) {
				state = 364;
				return true;
			}
			hr2x_maxIdleLong = 0L;
			hr2x_expiration = server.buildMetadata(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 357;
			return true;
		case 363: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData/hr2x.expiration/hr2x.lifespanLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanLong = hr2x_vLong;
			state = 362;
			return true;
		case 364: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData/hr2x.expiration/hr2x.maxIdleLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleLong = hr2x_vLong;
			hr2x_expiration = server.buildMetadata(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 357;
			return true;
		case 365: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData/hr2x.expiration
			if ((hr2x_timeUnits & 0xF0) != 0x70 &&(hr2x_timeUnits & 0xF0) != 0x80) {
				state = 367;
				return true;
			}
			hr2x_lifespanLong = 0L;
			state = 366;
			// fallthrough
		case 366: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData/hr2x.expiration
			if ((hr2x_timeUnits & 0x0F) != 0x07 &&(hr2x_timeUnits & 0x0F) != 0x08) {
				state = 368;
				return true;
			}
			hr2x_maxIdleLong = 0L;
			hr2x_expiration = server.buildMetadata2x(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 357;
			return true;
		case 367: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData/hr2x.expiration/hr2x.lifespanLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanLong = hr2x_vLong;
			state = 366;
			return true;
		case 368: 
			// hr2x.request/hr2x.parameters/hr2x.modifications/hr2x.modification/hr2x.modificationData/hr2x.expiration/hr2x.maxIdleLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleLong = hr2x_vLong;
			hr2x_expiration = server.buildMetadata2x(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 357;
			return true;
		case 369: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_counterName = hr2x_string;
			state = 370;
			// fallthrough
		case 370: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_counterFlags = hr2x_byte;
			state = 372;
			return true;
		case 371: 
			// hr2x.request/hr2x.parameters
			counterProcessor.createCounter(getHeader(), auth.getSubject(hr2x_operation), hr2x_counterName, hr2x_counterConfiguration.build());
			
			state = 0;
			return true;
		case 372: 
			// hr2x.request/hr2x.parameters/hr2x.counterConfiguration
			hr2x_counterConfiguration = CounterConfiguration.builder(EncodeUtil.decodeType(hr2x_counterFlags)).storage(EncodeUtil.decodeStorage(hr2x_counterFlags));
			
			state = 373;
			// fallthrough
		case 373: 
			// hr2x.request/hr2x.parameters/hr2x.counterConfiguration
			if ((hr2x_counterFlags & 1) == 1) {
				state = 375;
				return true;
			}
			;
			
			state = 374;
			// fallthrough
		case 374: 
			// hr2x.request/hr2x.parameters/hr2x.counterConfiguration
			if ((hr2x_counterFlags & 2) == 2) {
				state = 378;
				return true;
			}
			;
			
			state = 377;
			return true;
		case 375: 
			// hr2x.request/hr2x.parameters/hr2x.counterConfiguration/hr2x.counterConcurrency
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			state = 376;
			// fallthrough
		case 376: 
			// hr2x.request/hr2x.parameters/hr2x.counterConfiguration/hr2x.counterConcurrency
			hr2x_counterConfiguration.concurrencyLevel(hr2x_vInt);
			
			state = 374;
			return true;
		case 377: 
			// hr2x.request/hr2x.parameters/hr2x.counterConfiguration
			pos = buf.readerIndex();
			hr2x_long = org.infinispan.server.hotrod.Intrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_initialValue = hr2x_long;
			hr2x_counterConfiguration = hr2x_counterConfiguration.initialValue(hr2x_initialValue);
			;
			state = 371;
			return true;
		case 378: 
			// hr2x.request/hr2x.parameters/hr2x.counterConfiguration/hr2x.counterBounds
			pos = buf.readerIndex();
			hr2x_long = org.infinispan.server.hotrod.Intrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lowerBound = hr2x_long;
			state = 379;
			// fallthrough
		case 379: 
			// hr2x.request/hr2x.parameters/hr2x.counterConfiguration/hr2x.counterBounds
			pos = buf.readerIndex();
			hr2x_long = org.infinispan.server.hotrod.Intrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_upperBound = hr2x_long;
			state = 380;
			// fallthrough
		case 380: 
			// hr2x.request/hr2x.parameters/hr2x.counterConfiguration/hr2x.counterBounds
			hr2x_counterConfiguration.lowerBound(hr2x_lowerBound).upperBound(hr2x_upperBound);
			
			state = 377;
			return true;
		case 381: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_counterName = hr2x_string;
			state = 382;
			// fallthrough
		case 382: 
			// hr2x.request/hr2x.parameters
			counterProcessor.getCounterConfiguration(getHeader(), auth.getSubject(hr2x_operation), hr2x_counterName);
			
			state = 0;
			return true;
		case 383: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_counterName = hr2x_string;
			state = 384;
			// fallthrough
		}
		return true;
	}

	private boolean switch6(ByteBuf buf) throws Exception {
		byte b;
		int pos;
		switch (state) {
		case 384: 
			// hr2x.request/hr2x.parameters
			counterProcessor.isCounterDefined(getHeader(), auth.getSubject(hr2x_operation), hr2x_counterName);
			
			state = 0;
			return true;
		case 385: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_counterName = hr2x_string;
			state = 386;
			// fallthrough
		case 386: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_long = org.infinispan.server.hotrod.Intrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_updateValue = hr2x_long;
			state = 387;
			// fallthrough
		case 387: 
			// hr2x.request/hr2x.parameters
			counterProcessor.counterAddAndGet(getHeader(), auth.getSubject(hr2x_operation), hr2x_counterName, hr2x_updateValue);
			
			state = 0;
			return true;
		case 388: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_counterName = hr2x_string;
			state = 389;
			// fallthrough
		case 389: 
			// hr2x.request/hr2x.parameters
			counterProcessor.counterReset(getHeader(), auth.getSubject(hr2x_operation), hr2x_counterName);
			
			state = 0;
			return true;
		case 390: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_counterName = hr2x_string;
			state = 391;
			// fallthrough
		case 391: 
			// hr2x.request/hr2x.parameters
			counterProcessor.counterGet(getHeader(), auth.getSubject(hr2x_operation), hr2x_counterName);
			
			state = 0;
			return true;
		case 392: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_counterName = hr2x_string;
			state = 393;
			// fallthrough
		case 393: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_long = org.infinispan.server.hotrod.Intrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_expectValue = hr2x_long;
			state = 394;
			// fallthrough
		case 394: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_long = org.infinispan.server.hotrod.Intrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_updateValue = hr2x_long;
			state = 395;
			// fallthrough
		case 395: 
			// hr2x.request/hr2x.parameters
			counterProcessor.counterCompareAndSwap(getHeader(), auth.getSubject(hr2x_operation), hr2x_counterName, hr2x_expectValue, hr2x_updateValue);
			
			state = 0;
			return true;
		case 396: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_counterName = hr2x_string;
			state = 397;
			// fallthrough
		case 397: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_listenerId = hr2x_array;
			state = 398;
			// fallthrough
		case 398: 
			// hr2x.request/hr2x.parameters
			counterProcessor.addCounterListener(getHeader(), auth.getSubject(hr2x_operation), hr2x_counterName, hr2x_listenerId);
			
			state = 0;
			return true;
		case 399: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_counterName = hr2x_string;
			state = 400;
			// fallthrough
		case 400: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_listenerId = hr2x_array;
			state = 401;
			// fallthrough
		case 401: 
			// hr2x.request/hr2x.parameters
			counterProcessor.removeCounterListener(getHeader(), auth.getSubject(hr2x_operation), hr2x_counterName, hr2x_listenerId);
			
			state = 0;
			return true;
		case 402: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_string = org.infinispan.server.hotrod.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_counterName = hr2x_string;
			state = 403;
			// fallthrough
		case 403: 
			// hr2x.request/hr2x.parameters
			counterProcessor.counterRemove(getHeader(), auth.getSubject(hr2x_operation), hr2x_counterName);
			
			state = 0;
			return true;
		case 404: 
			// hr2x.request/hr2x.parameters
			counterProcessor.getCounterNames(getHeader(), auth.getSubject(hr2x_operation));
			
			state = 0;
			return true;
		case 405: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_key = hr2x_array;
			state = 406;
			// fallthrough
		case 406: 
			// hr2x.request/hr2x.parameters
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_40) {
				state = 408;
				return true;
			}
			hr2x_supportsDuplicates = false;
			state = 407;
			// fallthrough
		case 407: 
			// hr2x.request/hr2x.parameters
			multimapProcessor.get(getHeader(), auth.getSubject(hr2x_operation), hr2x_key, hr2x_supportsDuplicates);
			
			state = 0;
			return true;
		case 408: 
			// hr2x.request/hr2x.parameters/hr2x.supportsDuplicates
			pos = buf.readerIndex();
			hr2x_bool = org.infinispan.server.hotrod.Intrinsics.bool(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_supportsDuplicates = hr2x_bool;
			state = 407;
			return true;
		case 409: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_key = hr2x_array;
			state = 410;
			// fallthrough
		case 410: 
			// hr2x.request/hr2x.parameters
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_40) {
				state = 412;
				return true;
			}
			hr2x_supportsDuplicates = false;
			state = 411;
			// fallthrough
		case 411: 
			// hr2x.request/hr2x.parameters
			multimapProcessor.getWithMetadata(getHeader(), auth.getSubject(hr2x_operation), hr2x_key, hr2x_supportsDuplicates);
			
			state = 0;
			return true;
		case 412: 
			// hr2x.request/hr2x.parameters/hr2x.supportsDuplicates
			pos = buf.readerIndex();
			hr2x_bool = org.infinispan.server.hotrod.Intrinsics.bool(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_supportsDuplicates = hr2x_bool;
			state = 411;
			return true;
		case 413: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_key = hr2x_array;
			state = 414;
			// fallthrough
		case 414: 
			// hr2x.request/hr2x.parameters
			if (hr2x_version < org.infinispan.server.hotrod.HotRodConstants.VERSION_22) {
				state = 416;
				return true;
			}
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_30) {
				state = 418;
				return true;
			}
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeUnits = hr2x_byte;
			state = 423;
			return true;
		case 415: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_value = hr2x_array;
			state = 427;
			return true;
		case 416: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanInt = hr2x_vInt;
			state = 417;
			// fallthrough
		case 417: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleInt = hr2x_vInt;
			hr2x_expiration = server.buildMetadata2x(defaultExpiration(hr2x_lifespanInt, hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, defaultExpiration(hr2x_maxIdleInt, hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
			state = 415;
			return true;
		case 418: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeUnits = hr2x_byte;
			state = 419;
			// fallthrough
		case 419: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0xF0) != 0x70 &&(hr2x_timeUnits & 0xF0) != 0x80) {
				state = 421;
				return true;
			}
			hr2x_lifespanLong = 0L;
			state = 420;
			// fallthrough
		case 420: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0x0F) != 0x07 &&(hr2x_timeUnits & 0x0F) != 0x08) {
				state = 422;
				return true;
			}
			hr2x_maxIdleLong = 0L;
			hr2x_expiration = server.buildMetadata(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 415;
			return true;
		case 421: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.lifespanLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanLong = hr2x_vLong;
			state = 420;
			return true;
		case 422: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.maxIdleLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleLong = hr2x_vLong;
			hr2x_expiration = server.buildMetadata(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 415;
			return true;
		case 423: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0xF0) != 0x70 &&(hr2x_timeUnits & 0xF0) != 0x80) {
				state = 425;
				return true;
			}
			hr2x_lifespanLong = 0L;
			state = 424;
			// fallthrough
		case 424: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0x0F) != 0x07 &&(hr2x_timeUnits & 0x0F) != 0x08) {
				state = 426;
				return true;
			}
			hr2x_maxIdleLong = 0L;
			hr2x_expiration = server.buildMetadata2x(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 415;
			return true;
		case 425: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.lifespanLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanLong = hr2x_vLong;
			state = 424;
			return true;
		case 426: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.maxIdleLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleLong = hr2x_vLong;
			hr2x_expiration = server.buildMetadata2x(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 415;
			return true;
		case 427: 
			// hr2x.request/hr2x.parameters
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_40) {
				state = 429;
				return true;
			}
			hr2x_supportsDuplicates = false;
			state = 428;
			// fallthrough
		case 428: 
			// hr2x.request/hr2x.parameters
			multimapProcessor.put(getHeader(), auth.getSubject(hr2x_operation), hr2x_key, hr2x_value, hr2x_supportsDuplicates);
			
			state = 0;
			return true;
		case 429: 
			// hr2x.request/hr2x.parameters/hr2x.supportsDuplicates
			pos = buf.readerIndex();
			hr2x_bool = org.infinispan.server.hotrod.Intrinsics.bool(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_supportsDuplicates = hr2x_bool;
			state = 428;
			return true;
		case 430: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_key = hr2x_array;
			state = 431;
			// fallthrough
		case 431: 
			// hr2x.request/hr2x.parameters
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_40) {
				state = 433;
				return true;
			}
			hr2x_supportsDuplicates = false;
			state = 432;
			// fallthrough
		case 432: 
			// hr2x.request/hr2x.parameters
			multimapProcessor.removeKey(getHeader(), auth.getSubject(hr2x_operation), hr2x_key, hr2x_supportsDuplicates);
			
			state = 0;
			return true;
		case 433: 
			// hr2x.request/hr2x.parameters/hr2x.supportsDuplicates
			pos = buf.readerIndex();
			hr2x_bool = org.infinispan.server.hotrod.Intrinsics.bool(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_supportsDuplicates = hr2x_bool;
			state = 432;
			return true;
		case 434: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_key = hr2x_array;
			state = 435;
			// fallthrough
		case 435: 
			// hr2x.request/hr2x.parameters
			if (hr2x_version < org.infinispan.server.hotrod.HotRodConstants.VERSION_22) {
				state = 437;
				return true;
			}
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_30) {
				state = 439;
				return true;
			}
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeUnits = hr2x_byte;
			state = 444;
			return true;
		case 436: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_value = hr2x_array;
			state = 448;
			return true;
		case 437: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanInt = hr2x_vInt;
			state = 438;
			// fallthrough
		case 438: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleInt = hr2x_vInt;
			hr2x_expiration = server.buildMetadata2x(defaultExpiration(hr2x_lifespanInt, hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, defaultExpiration(hr2x_maxIdleInt, hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
			state = 436;
			return true;
		case 439: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeUnits = hr2x_byte;
			state = 440;
			// fallthrough
		case 440: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0xF0) != 0x70 &&(hr2x_timeUnits & 0xF0) != 0x80) {
				state = 442;
				return true;
			}
			hr2x_lifespanLong = 0L;
			state = 441;
			// fallthrough
		case 441: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0x0F) != 0x07 &&(hr2x_timeUnits & 0x0F) != 0x08) {
				state = 443;
				return true;
			}
			hr2x_maxIdleLong = 0L;
			hr2x_expiration = server.buildMetadata(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 436;
			return true;
		case 442: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.lifespanLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanLong = hr2x_vLong;
			state = 441;
			return true;
		case 443: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.maxIdleLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleLong = hr2x_vLong;
			hr2x_expiration = server.buildMetadata(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 436;
			return true;
		case 444: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0xF0) != 0x70 &&(hr2x_timeUnits & 0xF0) != 0x80) {
				state = 446;
				return true;
			}
			hr2x_lifespanLong = 0L;
			state = 445;
			// fallthrough
		case 445: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0x0F) != 0x07 &&(hr2x_timeUnits & 0x0F) != 0x08) {
				state = 447;
				return true;
			}
			hr2x_maxIdleLong = 0L;
			hr2x_expiration = server.buildMetadata2x(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 436;
			return true;
		case 446: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.lifespanLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanLong = hr2x_vLong;
			state = 445;
			return true;
		case 447: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.maxIdleLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleLong = hr2x_vLong;
			hr2x_expiration = server.buildMetadata2x(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 436;
			return true;
		}
		return true;
	}

	private boolean switch7(ByteBuf buf) throws Exception {
		byte b;
		int pos;
		switch (state) {
		case 448: 
			// hr2x.request/hr2x.parameters
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_40) {
				state = 450;
				return true;
			}
			hr2x_supportsDuplicates = false;
			state = 449;
			// fallthrough
		case 449: 
			// hr2x.request/hr2x.parameters
			multimapProcessor.removeEntry(getHeader(), auth.getSubject(hr2x_operation), hr2x_key, hr2x_value, hr2x_supportsDuplicates);
			
			state = 0;
			return true;
		case 450: 
			// hr2x.request/hr2x.parameters/hr2x.supportsDuplicates
			pos = buf.readerIndex();
			hr2x_bool = org.infinispan.server.hotrod.Intrinsics.bool(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_supportsDuplicates = hr2x_bool;
			state = 449;
			return true;
		case 451: 
			// hr2x.request/hr2x.parameters
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_40) {
				state = 453;
				return true;
			}
			hr2x_supportsDuplicates = false;
			state = 452;
			// fallthrough
		case 452: 
			// hr2x.request/hr2x.parameters
			multimapProcessor.size(getHeader(), auth.getSubject(hr2x_operation), hr2x_supportsDuplicates);
			
			state = 0;
			return true;
		case 453: 
			// hr2x.request/hr2x.parameters/hr2x.supportsDuplicates
			pos = buf.readerIndex();
			hr2x_bool = org.infinispan.server.hotrod.Intrinsics.bool(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_supportsDuplicates = hr2x_bool;
			state = 452;
			return true;
		case 454: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_key = hr2x_array;
			state = 455;
			// fallthrough
		case 455: 
			// hr2x.request/hr2x.parameters
			if (hr2x_version < org.infinispan.server.hotrod.HotRodConstants.VERSION_22) {
				state = 457;
				return true;
			}
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_30) {
				state = 459;
				return true;
			}
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeUnits = hr2x_byte;
			state = 464;
			return true;
		case 456: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_value = hr2x_array;
			state = 468;
			return true;
		case 457: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanInt = hr2x_vInt;
			state = 458;
			// fallthrough
		case 458: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleInt = hr2x_vInt;
			hr2x_expiration = server.buildMetadata2x(defaultExpiration(hr2x_lifespanInt, hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, defaultExpiration(hr2x_maxIdleInt, hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
			state = 456;
			return true;
		case 459: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeUnits = hr2x_byte;
			state = 460;
			// fallthrough
		case 460: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0xF0) != 0x70 &&(hr2x_timeUnits & 0xF0) != 0x80) {
				state = 462;
				return true;
			}
			hr2x_lifespanLong = 0L;
			state = 461;
			// fallthrough
		case 461: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0x0F) != 0x07 &&(hr2x_timeUnits & 0x0F) != 0x08) {
				state = 463;
				return true;
			}
			hr2x_maxIdleLong = 0L;
			hr2x_expiration = server.buildMetadata(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 456;
			return true;
		case 462: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.lifespanLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanLong = hr2x_vLong;
			state = 461;
			return true;
		case 463: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.maxIdleLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleLong = hr2x_vLong;
			hr2x_expiration = server.buildMetadata(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 456;
			return true;
		case 464: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0xF0) != 0x70 &&(hr2x_timeUnits & 0xF0) != 0x80) {
				state = 466;
				return true;
			}
			hr2x_lifespanLong = 0L;
			state = 465;
			// fallthrough
		case 465: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0x0F) != 0x07 &&(hr2x_timeUnits & 0x0F) != 0x08) {
				state = 467;
				return true;
			}
			hr2x_maxIdleLong = 0L;
			hr2x_expiration = server.buildMetadata2x(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 456;
			return true;
		case 466: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.lifespanLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanLong = hr2x_vLong;
			state = 465;
			return true;
		case 467: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.maxIdleLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleLong = hr2x_vLong;
			hr2x_expiration = server.buildMetadata2x(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 456;
			return true;
		case 468: 
			// hr2x.request/hr2x.parameters
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_40) {
				state = 470;
				return true;
			}
			hr2x_supportsDuplicates = false;
			state = 469;
			// fallthrough
		case 469: 
			// hr2x.request/hr2x.parameters
			multimapProcessor.containsEntry(getHeader(), auth.getSubject(hr2x_operation), hr2x_key, hr2x_value, hr2x_supportsDuplicates);
			
			state = 0;
			return true;
		case 470: 
			// hr2x.request/hr2x.parameters/hr2x.supportsDuplicates
			pos = buf.readerIndex();
			hr2x_bool = org.infinispan.server.hotrod.Intrinsics.bool(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_supportsDuplicates = hr2x_bool;
			state = 469;
			return true;
		case 471: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_key = hr2x_array;
			state = 472;
			// fallthrough
		case 472: 
			// hr2x.request/hr2x.parameters
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_40) {
				state = 474;
				return true;
			}
			hr2x_supportsDuplicates = false;
			state = 473;
			// fallthrough
		case 473: 
			// hr2x.request/hr2x.parameters
			multimapProcessor.containsKey(getHeader(), auth.getSubject(hr2x_operation), hr2x_key, hr2x_supportsDuplicates);
			
			state = 0;
			return true;
		case 474: 
			// hr2x.request/hr2x.parameters/hr2x.supportsDuplicates
			pos = buf.readerIndex();
			hr2x_bool = org.infinispan.server.hotrod.Intrinsics.bool(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_supportsDuplicates = hr2x_bool;
			state = 473;
			return true;
		case 475: 
			// hr2x.request/hr2x.parameters
			if (hr2x_version < org.infinispan.server.hotrod.HotRodConstants.VERSION_22) {
				state = 477;
				return true;
			}
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_30) {
				state = 479;
				return true;
			}
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeUnits = hr2x_byte;
			state = 484;
			return true;
		case 476: 
			// hr2x.request/hr2x.parameters
			pos = buf.readerIndex();
			hr2x_array = org.infinispan.server.hotrod.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_value = hr2x_array;
			state = 488;
			return true;
		case 477: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanInt = hr2x_vInt;
			state = 478;
			// fallthrough
		case 478: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_vInt = org.infinispan.server.hotrod.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleInt = hr2x_vInt;
			hr2x_expiration = server.buildMetadata2x(defaultExpiration(hr2x_lifespanInt, hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, defaultExpiration(hr2x_maxIdleInt, hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
			state = 476;
			return true;
		case 479: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			pos = buf.readerIndex();
			hr2x_byte = org.infinispan.server.hotrod.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_timeUnits = hr2x_byte;
			state = 480;
			// fallthrough
		case 480: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0xF0) != 0x70 &&(hr2x_timeUnits & 0xF0) != 0x80) {
				state = 482;
				return true;
			}
			hr2x_lifespanLong = 0L;
			state = 481;
			// fallthrough
		case 481: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0x0F) != 0x07 &&(hr2x_timeUnits & 0x0F) != 0x08) {
				state = 483;
				return true;
			}
			hr2x_maxIdleLong = 0L;
			hr2x_expiration = server.buildMetadata(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 476;
			return true;
		case 482: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.lifespanLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanLong = hr2x_vLong;
			state = 481;
			return true;
		case 483: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.maxIdleLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleLong = hr2x_vLong;
			hr2x_expiration = server.buildMetadata(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 476;
			return true;
		case 484: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0xF0) != 0x70 &&(hr2x_timeUnits & 0xF0) != 0x80) {
				state = 486;
				return true;
			}
			hr2x_lifespanLong = 0L;
			state = 485;
			// fallthrough
		case 485: 
			// hr2x.request/hr2x.parameters/hr2x.expiration
			if ((hr2x_timeUnits & 0x0F) != 0x07 &&(hr2x_timeUnits & 0x0F) != 0x08) {
				state = 487;
				return true;
			}
			hr2x_maxIdleLong = 0L;
			hr2x_expiration = server.buildMetadata2x(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 476;
			return true;
		case 486: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.lifespanLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_lifespanLong = hr2x_vLong;
			state = 485;
			return true;
		case 487: 
			// hr2x.request/hr2x.parameters/hr2x.expiration/hr2x.maxIdleLong
			pos = buf.readerIndex();
			hr2x_vLong = org.infinispan.server.hotrod.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_maxIdleLong = hr2x_vLong;
			hr2x_expiration = server.buildMetadata2x(hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(hr2x_timeUnits, 4)), hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(hr2x_timeUnits, 0x0F)));
			state = 476;
			return true;
		case 488: 
			// hr2x.request/hr2x.parameters
			if (hr2x_version >= org.infinispan.server.hotrod.HotRodConstants.VERSION_40) {
				state = 490;
				return true;
			}
			hr2x_supportsDuplicates = false;
			state = 489;
			// fallthrough
		case 489: 
			// hr2x.request/hr2x.parameters
			multimapProcessor.containsValue(getHeader(), auth.getSubject(hr2x_operation), hr2x_value, hr2x_supportsDuplicates);
			
			state = 0;
			return true;
		case 490: 
			// hr2x.request/hr2x.parameters/hr2x.supportsDuplicates
			pos = buf.readerIndex();
			hr2x_bool = org.infinispan.server.hotrod.Intrinsics.bool(buf);
			if (buf.readerIndex() == pos) return false;
			hr2x_supportsDuplicates = hr2x_bool;
			state = 489;
			return true;
		}
		return true;
	}

	private void deadEnd() {
		if (! deadEnd) {
			cacheProcessor.writeException(getHeader(), new RequestParsingException("Invalid state of parsing", hr2x_version, hr2x_messageId));
			deadEnd = true;
		}
		state = 0;
	}

	private void exceptionally(Throwable t) throws Exception {
		log.trace("Parsing error", t);
		cacheProcessor.writeException(getHeader(), t);
		state = 0;
	}

	private void reset() {
		requestBytes = 0;		hr2x_timeUnits = 0;
		hr2x_numEntries = 0;
		hr2x_iterationId = null;
		hr2x_controlByte = 0;
		hr2x_bloomBits = 0;
		hr2x_otherParamValue = null;
		hr2x_fixedArray = null;
		hr2x_queryBytes = null;
		hr2x_counterFlags = 0;
		hr2x_expectValue = 0;
		hr2x_readable = null;
		hr2x_includeCurrentState = false;
		hr2x_taskParam = null;
		hr2x_otherParamName = null;
		hr2x_cacheName = null;
		hr2x_vInt = 0;
		hr2x_valueType = null;
		hr2x_initialValue = 0;
		hr2x_numModifications = 0;
		hr2x_param = null;
		hr2x_authMech = null;
		hr2x_authResponse = null;
		hr2x_otherParamsNum = 0;
		hr2x_listenerInterests = 0;
		hr2x_numParams = 0;
		hr2x_xidFormat = 0;
		hr2x_filterFactory = null;
		hr2x_maxIdleLong = 0;
		hr2x_operation = null;
		hr2x_otherParams = null;
		hr2x_upperBound = 0;
		hr2x_version = 0;
		hr2x_converterFactory = null;
		hr2x_signedVInt = 0;
		hr2x_supportsDuplicates = false;
		hr2x_keyType = null;
		hr2x_filterConverterFactory = null;
		hr2x_mediaTypeParams = null;
		hr2x_versionRead = 0;
		hr2x_lifespanInt = 0;
		hr2x_mediaParamValue = null;
		hr2x_intelligence = 0;
		hr2x_long = 0;
		hr2x_mediaParamName = null;
		hr2x_converterParams = null;
		hr2x_recoverable = false;
		hr2x_bloomArray = null;
		hr2x_value = null;
		hr2x_branchLength = 0;
		hr2x_optionalString = null;
		hr2x_optionalArray = null;
		hr2x_bool = false;
		hr2x_xidLength = 0;
		hr2x_mediaTypeDefinition = 0;
		hr2x_expiration = null;
		hr2x_filterParams = null;
		hr2x_offset = 0;
		hr2x_chunkBytes = null;
		hr2x_updateValue = 0;
		hr2x_txMarker = 0;
		hr2x_useRawEvents = false;
		hr2x_chunkLength = 0;
		hr2x_timeout = 0;
		hr2x_taskName = null;
		hr2x_mediaTypeName = null;
		hr2x_lowerBound = 0;
		hr2x_taskParamValue = null;
		hr2x_chunkedValue = null;
		hr2x_key = null;
		hr2x_batchSize = 0;
		hr2x_header = null;
		hr2x_scope = 0;
		hr2x_lifespanLong = 0;
		hr2x_taskParams = null;
		hr2x_array = null;
		hr2x_flags = 0;
		hr2x_listenerId = null;
		hr2x_segmentMask = null;
		hr2x_magic = 0;
		hr2x_maxIdleInt = 0;
		hr2x_onePhaseCommit = false;
		hr2x_entryVersion = 0;
		hr2x_mediaTypeId = 0;
		hr2x_includeMetadata = false;
		hr2x_opCode = 0;
		hr2x_entryMap = null;
		hr2x_mediaTypeParamsNum = 0;
		hr2x_messageId = 0;
		hr2x_vLong = 0;
		hr2x_filterConverterParams = null;
		hr2x_numKeys = 0;
		hr2x_otherParamsRev = null;
		hr2x_mediaType = null;
		hr2x_branchId = null;
		hr2x_string = null;
		hr2x_byte = 0;
		hr2x_transactionId = null;
		hr2x_mediaTypeDescription = null;
		hr2x_counterName = null;
		hr2x_modification = null;
		hr2x_counterConfiguration = null;
		hr2x_topologyId = 0;
		hr2x_keys = null;
		hr2x_xid = null;
		hr2x_modifications = null;
	}

	public int requestBytes() {
		return requestBytes;
	}

	private boolean userSwitch63() throws Exception {
		switch (hr2x_opCode) {
		case org.infinispan.server.hotrod.HotRodConstants.PUT_REQUEST: 
			state = 64;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.GET_REQUEST: 
			state = 79;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.PUT_IF_ABSENT_REQUEST: 
			state = 81;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.REPLACE_REQUEST: 
			state = 96;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.REPLACE_IF_UNMODIFIED_REQUEST: 
			state = 111;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.REMOVE_REQUEST: 
			state = 127;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.REMOVE_IF_UNMODIFIED_REQUEST: 
			state = 129;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.CONTAINS_KEY_REQUEST: 
			state = 132;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.GET_WITH_VERSION: 
			state = 134;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.CLEAR_REQUEST: 
			state = 136;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.STATS_REQUEST: 
			state = 137;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.PING_REQUEST: 
			state = 138;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.BULK_GET_REQUEST: 
			state = 139;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.GET_WITH_METADATA: 
			state = 141;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.BULK_GET_KEYS_REQUEST: 
			state = 143;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.QUERY_REQUEST: 
			state = 145;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.AUTH_MECH_LIST_REQUEST: 
			state = 147;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.AUTH_REQUEST: 
			state = 148;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.ADD_CLIENT_LISTENER_REQUEST: 
			state = 151;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.ADD_BLOOM_FILTER_NEAR_CACHE_LISTENER_REQUEST: 
			state = 199;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.REMOVE_CLIENT_LISTENER_REQUEST: 
			state = 202;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.SIZE_REQUEST: 
			state = 204;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.EXEC_REQUEST: 
			state = 205;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.PUT_ALL_REQUEST: 
			state = 213;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.GET_ALL_REQUEST: 
			state = 232;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.ITERATION_START_REQUEST: 
			state = 238;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.ITERATION_NEXT_REQUEST: 
			state = 250;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.ITERATION_END_REQUEST: 
			state = 252;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.GET_STREAM_REQUEST: 
			state = 254;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.PUT_STREAM_REQUEST: 
			state = 257;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.UPDATE_BLOOM_FILTER_REQUEST: 
			state = 278;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.PREPARE_TX: 
			state = 280;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.COMMIT_TX: 
			state = 311;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.ROLLBACK_TX: 
			state = 319;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.FORGET_TX: 
			state = 327;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.FETCH_TX_RECOVERY: 
			state = 335;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.PREPARE_TX_2: 
			state = 336;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.COUNTER_CREATE_REQUEST: 
			state = 369;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.COUNTER_GET_CONFIGURATION_REQUEST: 
			state = 381;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.COUNTER_IS_DEFINED_REQUEST: 
			state = 383;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.COUNTER_ADD_AND_GET_REQUEST: 
			state = 385;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.COUNTER_RESET_REQUEST: 
			state = 388;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.COUNTER_GET_REQUEST: 
			state = 390;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.COUNTER_CAS_REQUEST: 
			state = 392;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.COUNTER_ADD_LISTENER_REQUEST: 
			state = 396;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.COUNTER_REMOVE_LISTENER_REQUEST: 
			state = 399;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.COUNTER_REMOVE_REQUEST: 
			state = 402;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.COUNTER_GET_NAMES_REQUEST: 
			state = 404;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.GET_MULTIMAP_REQUEST: 
			state = 405;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.GET_MULTIMAP_WITH_METADATA_REQUEST: 
			state = 409;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.PUT_MULTIMAP_REQUEST: 
			state = 413;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.REMOVE_KEY_MULTIMAP_REQUEST: 
			state = 430;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.REMOVE_ENTRY_MULTIMAP_REQUEST: 
			state = 434;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.SIZE_MULTIMAP_REQUEST: 
			state = 451;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.CONTAINS_ENTRY_REQUEST: 
			state = 454;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.CONTAINS_KEY_MULTIMAP_REQUEST: 
			state = 471;
			return true;
		case org.infinispan.server.hotrod.HotRodConstants.CONTAINS_VALUE_MULTIMAP_REQUEST: 
			state = 475;
			return true;
		default: 
			throw new HotRodUnknownOperationException("Unknown operation " + hr2x_opCode, hr2x_version, hr2x_messageId);
			
		}
	}

}
